<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
if(!defined('IN_DZZ')) {
	exit('Access Denied');
}
function checkmoderator($uid,$orgid) {
	global $_G;
	if(!$_G['cache']['organization']){
		loadcache('organization');
	}
	$moderators=$_G['cache']['organization']['orgid'];
	if(in_array($uid,$moderators)){
		return true;
	}else{
		return false;
	}
}
//获取机构树
function getDepartmentOption($orgid,$url='',$i=0){
	$html='';
	//$data[$orgid]['i']=$i;
	$i++;
	if($count=C::t('organization')->fetch_all_by_forgid($orgid,true)){
		$k=1;
		foreach(C::t('organization')->fetch_all_by_forgid($orgid) as $key=> $value){
		
			$html.='<li role="presentation">';
			$html.='<a href="'.($url?($url.'&depid='.$value['orgid']):'javascript:;').'" tabindex="-1" role="menuitem" _orgid="'.$value['orgid'].'" '.(!$url?'onclick="selDepart(this)"':'').'>';
			$html.='<div class="child-org">';
			for($j=0;$j<$i-1;$j++){
				$html.='<span class="child-tree tree-su">&nbsp;</span>';
			}
			$html.='<span class="child-tree '.($k<$count?'tree-heng':'tree-heng1').'">&nbsp;</span>'.$value['orgname'];
			$html.='</div>';
			$html.='</a></li>';
			$html.=getDepartmentOption($value['orgid'],$url,$i);
			$k++;
		}
		//$html.='</tbody>';
	}
	return $html;
}
//获取用户所在的部门
function getDepartmentByUid($uid){
	$data=array();
	//获取用户所加入的所有部门
	$orgids=C::t('organization_user')->fetch_orgids_by_uid($uid);
	foreach($orgids as $orgid){
		if($tree=getTreeByOrgid($orgid)){
			$data[$orgid]=$tree;
		}
	}
	return $data;	
}

//获取用户部门及所属机构
function getOrgByUid($uid){
	$orglist=array();
	$arr=getDepartmentByUid($uid);
	foreach($arr as $key => $value){
		$orglist[$value[0]['orgid']]=$value[0];
	}
	foreach($arr as $key => $value){
		if(count($value)>1) $orglist[$value[0]['orgid']]['sublist'][$value[count($value)-1]['orgid']]=$value[count($value)-1];
	}
	return $orglist;
}
//获取应用可以使用的部门
function getDepartmentByAppid($appid){
	$data=array();
	//获取用户所加入的所有部门
	$orgids=C::t('app_organization')->fetch_orgids_by_appid($appid);
	foreach($orgids as $orgid){
		if($tree=getTreeByOrgid($orgid)){
			$data[$orgid]=$tree;
		}
	}
	return $data;	
}
function getTreeByOrgid($orgid){
	$orgarr=array_reverse(getUpOrgidTree($orgid,false));
	//if(count($orgarr)<2) return false;
	return $orgarr;
}
//获取机构或部门的用户列表
//$dep: ==0 只获取此机构的用户；
//		>0  获取全部下级机构的成员
// $notin   排除的用户列表;
//返回 user列表数组;
function getUserByOrgid($orgid,$dep=0,$notin=array(),$count){
	ini_set("memory_limit","100M");
	$orgids=array();
	if($dep){
		$orgids=getOrgidTree($orgid);
	}else{
		$orgids[]=$orgid;
	}
	$uids=C::t('organization_user')->fetch_uids_by_orgid($orgids);
	if($notin){
		$arr=array();
		foreach($uids as $uid){
			if(!in_array($uid ,$notin)) $arr[]=$uid;
		}
		$uids=$arr;
	}
	return C::t('user')->fetch_all($uids);
}
//获取此机构和所有下属机构的id
function getOrgidTree($orgid,$oids=array()){
	
	$oids[]=$orgid;
	foreach(C::t('organization')->fetch_all_by_forgid($orgid) as $value){
		if($value['orgid']>0) $oids=getOrgidTree($value['orgid'],$oids);
	}
	return $oids;
}
//获取此机构和所有上级机构的id
function getUpOrgidTree($orgid,$onlyid=true,$pids=array()){
	
	if($org=C::t('organization')->fetch($orgid)){
		if($onlyid){
			$pids[]=$orgid;
		}else{
			$pids[$orgid]=$org;
		}
		$pids=getUpOrgidTree($org['forgid'],$onlyid,$pids);
	}
	
	return ($pids);
}
?>
