<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
if(!defined('IN_DZZ')) {
	exit('Access Denied');
}
$path=rawurldecode($_GET['path']);	

if($_GET['do']=='autosave'){
	$msg=array();
	$message=$_GET['message'];
	try{
	if($icoarr=IO::setFileContent($path,$message)){
			if($icoarr['error']){
				echo json_encode(array('msg'=>$icoarr['error']));
				exit();
			}else{
				echo json_encode(array('msg'=>'success'));
				exit();
			}
	 }else{
		echo json_encode(array('msg'=>'auto save failure!'));
		exit();
	 }
	}catch(Exception $e){
			//var_dump($e);
			echo json_encode(array('msg'=>$e->getMessage()));
			exit();
	}
}else{
	
	$error='';
	$table='';
	$refer=$_SERVER['HTTP_REFERER'];
	//if(strpos($refer,$_G['siteurl'])===false) exit(lang('message','no_privilege'));
	$icoarr=IO::getMeta($path);
	if($icoarr['error']){
		include template('header_ajax');
		echo "<script type=\"text/javascript\">";
		echo "top.showDialog('".$icoarr['error']."');";
		echo "win.Close();";
		echo "</script>";	
		include template('footer_ajax');
		exit();
	}
	//根据ext获取加载codemirror的mode；
	$ext=$icoarr['ext'];
	require_once DZZ_ROOT.'./dzz/document/codemirror/exttomodes.php';
	$mode=$modes[$ext]?$modes[$ext]:'';
	//获取文件地址，如果文件可以执行的话（如php,html,js等) 必须使用绝对地址，否则会得到运行后的内容；
	
	//判断有无编辑权限
	$isadmin=0;
	if(perm_check::checkperm('admin',$icoarr)){
		$isadmin=1;
	}
	
	$str=IO::getFileContent($path);
	
	require_once DZZ_ROOT.'./dzz/class/class_encode.php';
	$p=new Encode_Core();
	$code=$p->get_encoding($str);
		//echo $code;
		
	//echo 'wwwwwwwww='.$code;
	//$haha= mb_detect_encoding($str);echo 'vvvvvv='.$haha.'<br>';
		 if($code) $str=diconv($str,$code, CHARSET); 
		 $str=htmlspecialchars($str);
	include template('textviewer');
}
function getUrlMimeType($url) {
	if (function_exists ('mime_content_type ') ){
		return mime_content_type($url);
	}else if(extension_loaded('fileinfo')){
		$buffer = file_get_contents($url);
		$finfo = new finfo(FILEINFO_MIME_TYPE);
		return $finfo->buffer($buffer);
	}else{
		return false;
	}
}
function textsaveattach($icoid,$message){
	global $_G,$space;
	
	if(!$icoarr=C::t('icos')->fetch_by_icoid($icoid)){
		return array('error' => lang('message','file_not_exist'));
	}
	$gid=DB::result_first("select fid from %t where fid=%d",array('folder',$icoarr['pfid']));
	if(!perm_check::checkperm('admin',$icoarr)){
		return array('error' => lang('message','no_privilege'));
	}
	if(!$attach=getAttachByMd5($message,$icoarr['name'])){
		return array('error' => lang('message','file_save_failure'));
	}
	
	//计算用户新的空间大小
	$csize=$attach['filesize']-$icoarr['size'];
	
	//重新计算用户空间
	if($csize){
		if($space['maxspacesize']>0 && !SpaceSize($csize,$gid)){
			return array('error' => lang('message','inadequate_capacity_space'));
		}
		SpaceSize($csize,$gid ,1);
	}
	
	$oldaid=$icoarr['aid'];
	
	//更新附件数量
	if($oldaid !=$attach['aid']){
		if($icoarr['type']=='document'){
			C::t('source_document')->update($icoarr['did'],array('aid'=>$attach['aid']));
		}else{
			C::t('source_attach')->update($icoarr['qid'],array('aid'=>$attach['aid']));
		}
		C::t('attachment')->update($attach['aid'],array('copys'=>$attach['copys']+1));
		C::t('attachment')->delete_by_aid($oldaid);
	}
	
	
	return $icoarr;
}
?>
