/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function toggleFullScreen(videoElement) {
	if (!document.fullscreen && !document.mozFullScreen && !document.webkitFullScreen) {
	  if (videoElement.requestFullScreen) {
			videoElement.requestFullScreen();
	  }else if (videoElement.mozRequestFullScreen) {
			videoElement.mozRequestFullScreen();
	  } else {
			videoElement.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT);
	  }
	} else {
		if (document.exitFullscreen) {
			document.exitFullscreen();
		}else if (document.mozCancelFullScreen) {
			document.mozCancelFullScreen();
		} else {
			document.webkitCancelFullScreen();
		}
	}
};
var onousermove=onmouseup=onselectstart=null;
var DetachEvent=function(e,el){
	try{
		document.body.style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
		document.onmousemove=onmousemove;
		document.onmouseup=onmouseup;
		document.onselectstart=onselectstart;
		if(el.releaseCapture)el.releaseCapture();
	}catch(e){}
};
var AttachEvent=function(e,el){ 
	try{
		onmousemove=document.onmousemove;
		onmouseup=document.onmouseup;
		onselectstart=document.onselectstart;
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else{
			if(el.setCapture)el.setCapture();
		}
	}catch(e){};
};
function dfire(e){
	jQuery(document).trigger(e);
}

//提示信息
var messageTimer=null;
function showmessage(msg,type,timeout,haveclose,position){
	var maxheight=100;
	var maxwidth=300;
	var delay=500;
	if(!document.getElementById('message_tip_box')){
		var el=jQuery('<div id="message_tip_box" class="message_tip_box" style="margin:0;"><div id="message_tip_alert" class="alert"></div></div>').appendTo(document.body);
		var isnew=true;
	}else var el=jQuery('#message_tip_box');
	 el.attr('style','');
	 el.css({'position':'absolute','height':'auto','opacity':1,'z-index':99999999,width:maxwidth,margin:'0,auto'}).show();
	
	//设置消息框的类型（不同类型背景颜色不同）；
	var types=['error','info','success'];
	if(jQuery.inArray(type,types)<0) type='';
	if(type) jQuery('#message_tip_alert').attr('class','alert alert-'+type);
	else  jQuery('#message_tip_alert').attr('class','alert');
	//处理关闭按钮
	if(haveclose){
		msg='<button type="button" class="close" onclick="jQuery(\'#message_tip_box\').remove()">&times;</button>'+msg
	};
	jQuery('#message_tip_alert').html(msg);
	//获取宽度和高度
	var width=el.width();
	var height=el.height();
	width=width>maxwidth?maxwidth:width;
	height=height>maxheight?maxheight:height;
	el.css({position:'absolute',width:width,overflow:'hidden'});
	//处理位置
	switch(position){
		case 'left-top':
			el.css({left:10,top:10,width:0,height:0,overflow:'hidden'}).animate({width:width,height:height,opacity:1},delay);
			el.find('.close').on('click',function(){
				jQuery('#message_tip_box').animate({width:0,height:0,opacity:0});
			});
			if(messageTimer) window.clearTimeout(messageTimer);
			if(timeout>0) messageTimer=window.setTimeout(function(){jQuery('#message_tip_box').animate({width:0,height:0,opacity:0},timeout)});
			break;
		case 'right-top':
			el.css({right:10,top:10,position:'absolute',width:0,height:0,overflow:'hidden'}).animate({width:width,height:height,opacity:1},delay);
			el.find('.close').on('click',function(){
				jQuery('#message_tip_box').animate({width:0,height:0,opacity:0});
			});
			if(messageTimer) window.clearTimeout(messageTimer);
			if(timeout) messageTimer=window.setTimeout(function(){jQuery('#message_tip_box').animate({width:0,height:0,opacity:0},timeout)});
			break;
		case 'right-bottom':
		   
			el.css({right:10,bottom:10,height:'auto',position:'absolute',overflow:'hidden'}).animate({width:width,height:'auto',opacity:1},delay);
			el.find('.close').on('click',function(){
				jQuery('#message_tip_box').animate({width:0,height:0,opacity:0},delay);
			});
			if(messageTimer) window.clearTimeout(messageTimer);
			if(timeout>0) messageTimer=window.setTimeout(function(){jQuery('#message_tip_box').animate({width:0,height:0,opacity:0},delay)},timeout);
			break;
		case 'left-bottom':
			
			el.css({left:10,bottom:10,position:'absolute',width:0,height:0,overflow:'hidden'}).animate({width:width,height:height,opacity:1},delay);
			el.find('.close').on('click',function(){
				jQuery('#message_tip_box').animate({width:0,height:0,opacity:0});
			});
			if(messageTimer) window.clearTimeout(messageTimer);
			if(timeout>0) messageTimer=window.setTimeout(function(){jQuery('#message_tip_box').animate({width:0,height:0,opacity:0},delay)},timeout);
			break;
		default:
			jQuery('#message_tip_box').css({left:'50%','marginLeft':-width/2,top:10,position:'absolute',width:width,height:height,overflow:'hidden'});
			el.find('.close').on('click',function(){
				jQuery('#message_tip_box').animate({height:height},delay);
			});
			if(messageTimer) window.clearTimeout(messageTimer);
			if(timeout>0) messageTimer=window.setTimeout(function(){jQuery('#message_tip_box').animate({height:-height},delay)},timeout);
			break;
	}
};

//重写common.js的函数
function showDialog(msg, mode, t, func, cover, funccancel, leftmsg, confirmtxt, canceltxt, closetime, locationtime) {
	clearTimeout(showDialogST);
	
	cover = isUndefined(cover) ? (mode == 'info' || mode == 'icon' ? 0 : 1) : cover;
	leftmsg = isUndefined(leftmsg) ? '' : leftmsg;
	//mode = in_array(mode, ['confirm', 'notice', 'info', 'right']) ? mode : 'alert';
	if(!mode) mode='alert';
	var menuid = 'fwin_dialog';
	var menuObj = document.getElementById(menuid);
	var showconfirm = 1;
	confirmtxtdefault = '确定';
	closetime = isUndefined(closetime) ? '' : closetime;
	closefunc = function () {
		if(typeof func == 'function') func();
		else eval(func);
		hideMenu(menuid, 'dialog');
	};
	if(closetime) {
		leftmsg = closetime + ' 秒后窗口关闭';
		showDialogST = setTimeout(closefunc, closetime * 1000);
		//showconfirm = 0;
	}
	locationtime = isUndefined(locationtime) ? '' : locationtime;
	if(locationtime) {
		leftmsg = locationtime + ' 秒后页面跳转';
		showDialogST = setTimeout(closefunc, locationtime * 1000);
		//showconfirm = 0;
	}
	confirmtxt = confirmtxt ? confirmtxt : confirmtxtdefault;
	canceltxt = canceltxt ? canceltxt : '取消';

	if(menuObj) hideMenu('fwin_dialog', 'dialog');
	menuObj = document.createElement('div');
	menuObj.style.display = 'none';
	menuObj.className = 'fwinmask';
	menuObj.id = menuid;
	document.getElementById('append_parent').appendChild(menuObj);
	var hidedom = '';
	if(!BROWSER.ie) {
		hidedom = '<style type="text/css">object{visibility:hidden;}</style>';
	}
	var shadow='';//'<div class="LEFT_TOP ROUND" ></div><div class="TOP ROUND"></div><div class="RIGHT_TOP ROUND" ></div><div class="RIGHT ROUND" ></div><div class="RIGHT_BOTTOM ROUND"></div><div class="BOTTOM ROUND" ></div><div class="LEFT_BOTTOM ROUND" ></div><div class="LEFT ROUND"></div>';
	var s = hidedom + shadow+ '<table cellpadding="0" cellspacing="0" class="fwin"><tr><td class="t_l"></td><td class="t_c"></td><td class="t_r"></td></tr><tr><td class="m_l"></td><td class="m_c"><h3 class="flb" id="drag_fwin_dialog"><em>';
	s += t ? t : '提示信息';
	s += '</em><button id="fwin_dialog_close" type="button" class="close" onclick="hideMenu(\'fwin_dialog\', \'dialog\')" style="margin:10px 10px 0;">&times;</button></h3>';
	 if(mode.indexOf('alert_icon_' )!== -1){
		var icon=decodeURIComponent(mode.replace('alert_icon_' ,''));
		if(icon){
			s += '<div class="c altw"><div class="alert_icon"><img class="alert_icon_img" src="'+icon+'"><p>' + msg + '</p></div></div>';
		}else{
			s += '<div class="c altw"><div class="' + ('alert_info') + '"><p>' + msg + '</p></div></div>';
		}
		s += '<p class="o pns">' + (leftmsg ? '<span class=" muted pull-left">' + leftmsg + '</span>' : '') + (showconfirm ? '<button id="fwin_dialog_submit" value="true" class="btn btn-primary"><strong>'+confirmtxt+'</strong></button>' : '');
		
		s += '</p>';
	}else if(mode=='message'){
		if(leftmsg){
			s += '<div class="c altw"><div class="alert_info"><p>' + msg + '</p></div></div>';
			s +='<p class="o pns"><span class="muted pull-left">' + leftmsg + '</span></p>' ;
		}else{
			s += '<div class="c altw last"><div class="alert_info"><p>' + msg + '</p></div></div>';
		}
	} else {
		s += '<div class="c altw"><div class="' + (mode == 'alert' ? 'alert_error' : (mode == 'right' ? 'alert_right' : (mode == 'info' ? 'alert_info':''))) + '"><p>' + msg + '</p></div></div>';
		s += '<p class="o pns">' + (leftmsg ? '<span class="muted pull-left">' + leftmsg + '</span>' : '') + (showconfirm ? '<button id="fwin_dialog_submit" value="true" class="btn btn-primary">'+confirmtxt+'</button>&nbsp;&nbsp;&nbsp;' : '');
		s += mode == 'confirm' ? '<button id="fwin_dialog_cancel" value="true" class="btn" onclick="hideMenu(\'fwin_dialog\', \'dialog\')">'+canceltxt+'</button>' : '';
		s += '</p>';
	}
	s += '</td><td class="m_r"></td></tr><tr><td class="b_l"></td><td class="b_c"></td><td class="b_r"></td></tr></table>';
	menuObj.innerHTML = s;
	if(document.getElementById('fwin_dialog_submit')) document.getElementById('fwin_dialog_submit').onclick = function() {
		if(typeof func == 'function') func();
		else eval(func);
		hideMenu(menuid, 'dialog');
	};
	if(document.getElementById('fwin_dialog_cancel')) {
		document.getElementById('fwin_dialog_cancel').onclick = function() {
			if(typeof funccancel == 'function') funccancel();
			else eval(funccancel);
			hideMenu(menuid, 'dialog');
		};
		document.getElementById('fwin_dialog_close').onclick = document.getElementById('fwin_dialog_cancel').onclick;
	}
	showMenu({'mtype':'dialog','menuid':menuid,'duration':3,'pos':'00','zindex':JSMENU['zIndex']['dialog'],'drag':'drag_'+menuid,'cache':0,'cover':cover});
	try {
		if(document.getElementById('fwin_dialog_submit')) document.getElementById('fwin_dialog_submit').focus();
	} catch(e) {}
}
function showWindow(k, url, mode, cache, menuv) {
	mode = isUndefined(mode) ? 'get' : mode;
	cache = isUndefined(cache) ? 1 : cache;
	var menuid = 'fwin_' + k;
	var menuObj = document.getElementById(menuid);
	var drag = null;
	var loadingst = null;
	var hidedom = '';

	if(disallowfloat && disallowfloat.indexOf(k) != -1) {
		if(BROWSER.ie) url += (url.indexOf('?') != -1 ?  '&' : '?') + 'referer=' + escape(location.href);
		location.href = url;
		doane();
		return;
	}

	var fetchContent = function() {
		if(mode == 'get') {
			menuObj.url = url;
			url += (url.search(/\?/) > 0 ? '&' : '?') + 'infloat=yes&handlekey=' + k;
			url += cache == -1 ? '&t='+(+ new Date()) : '';
			if(BROWSER.ie &&  url.indexOf('referer=') < 0) {
				url = url + '&referer=' + encodeURIComponent(location);
			}
			ajaxget(url, 'fwin_content_' + k, null, '', '', function() {initMenu();show();});
		} else if(mode == 'post') {
			menuObj.act = document.getElementById(url).action;
			ajaxpost(url, 'fwin_content_' + k, '', '', '', function() {initMenu();show();});
		}
		if(parseInt(BROWSER.ie) != 6) {
			loadingst = setTimeout(function() {showDialog('', 'info', '<img src="' + IMGDIR + '/loading.gif"> 请稍候...')}, 500);
		}
	};
	var initMenu = function() {
		clearTimeout(loadingst);
		var objs = menuObj.getElementsByTagName('*');
		var fctrlidinit = false;
		for(var i = 0; i < objs.length; i++) {
			if(objs[i].id) {
				objs[i].setAttribute('fwin', k);
			}
			if(objs[i].className == 'flb' && !fctrlidinit) {
				if(!objs[i].id) objs[i].id = 'fctrl_' + k;
				drag = objs[i].id;
				fctrlidinit = true;
			}
		}
	};
	var show = function() {
		hideMenu('fwin_dialog', 'dialog');
		v = {'mtype':'win','menuid':menuid,'duration':3,'pos':'00','zindex':JSMENU['zIndex']['win'],'drag':typeof drag == null ? '' : drag,'cache':cache};
		for(k in menuv) {
			v[k] = menuv[k];
		}
		showMenu(v);
	};

	if(!menuObj) {
		menuObj = document.createElement('div');
		menuObj.id = menuid;
		menuObj.className = 'fwinmask';
		menuObj.style.display = 'none';
		document.getElementById('append_parent').appendChild(menuObj);
		evt = ' style="cursor:move" onmousedown="dragMenu(document.getElementById(\'' + menuid + '\'), event, 1)" ondblclick="hideWindow(\'' + k + '\')"';
		if(!BROWSER.ie) {
			hidedom = '<style type="text/css">object{visibility:hidden;}</style>';
		}
		var shadow='';//'<div class="LEFT_TOP ROUND" ></div><div class="TOP ROUND"></div><div class="RIGHT_TOP ROUND" ></div><div class="RIGHT ROUND" ></div><div class="RIGHT_BOTTOM ROUND"></div><div class="BOTTOM ROUND" ></div><div class="LEFT_BOTTOM ROUND" ></div><div class="LEFT ROUND"></div>';
		menuObj.innerHTML = hidedom + shadow+ '<table cellpadding="0" cellspacing="0" class="fwin"><tr><td class="t_l"></td><td class="t_c"' + evt + '></td><td class="t_r"></td></tr><tr><td class="m_l"' + evt + ')"></td><td class="m_c" id="fwin_content_' + k + '">'
			+ '</td><td class="m_r"' + evt + '"></td></tr><tr><td class="b_l"></td><td class="b_c"' + evt + '></td><td class="b_r"></td></tr></table>';
			
		if(mode == 'html') {
			document.getElementById('fwin_content_' + k).innerHTML = url;
			initMenu();
			show();
		} else {
			fetchContent();
		}
	} else if((mode == 'get' && (url != menuObj.url || cache != 1)) || (mode == 'post' && document.getElementById(url).action != menuObj.act)) {
		fetchContent();
	} else {
		show();
	}
	doane();
};
/*function showPrompt(ctrlid, evt, msg, timeout) {
	var menuid = ctrlid ? ctrlid + '_pmenu' : 'ntcwin';
	var duration = timeout ? 0 : 3;
	if($(menuid)) {
		$(menuid).parentNode.removeChild($(menuid));
	}
	var div = document.createElement('div');
	div.id = menuid;
	div.className = ctrlid ? 'tip tip_js' : 'popup-hint';
	div.style.display = 'none';
	document.getElementById('append_parent').appendChild(div);
	if(ctrlid) {
		msg = '<div id="' + ctrlid + '_prompt"><div class="tip_horn"></div><div class="tip_c">' + msg + '</div>';
	} else {
		msg = '<table cellspacing="0" cellpadding="0" class="popupcredit"><tr><td class="pc_l">&nbsp;</td><td class="pc_c"><div class="pc_inner">' + msg +
			'</td><td class="pc_r">&nbsp;</td></tr></table>';
		//msg='<i rel="type" class="hint-icon hint-inf-m"></i>	<em class="sl"><b></b></em>	<span rel="con">'+msg+'</span>	<em class="sr"><b></b></em>'
	}
	div.innerHTML = msg;
	if(ctrlid) {
		if(!timeout) {
			evt = 'click';
		}
		if(document.getElementById(ctrlid)) {
			if(document.getElementById(ctrlid).evt !== false) {
				var prompting = function() {
					showMenu({'mtype':'prompt','ctrlid':ctrlid,'evt':evt,'menuid':menuid,'pos':'210'});
				};
				if(evt == 'click') {
					document.getElementById(ctrlid).onclick = prompting;
				} else {
					document.getElementById(ctrlid).onmouseover = prompting;
				}
			}
			showMenu({'mtype':'prompt','ctrlid':ctrlid,'evt':evt,'menuid':menuid,'pos':'210','duration':duration,'timeout':timeout,'zindex':JSMENU['zIndex']['prompt']});
			document.getElementById(ctrlid).unselectable = false;
		}
	} else {
		showMenu({'mtype':'prompt','pos':'00','menuid':menuid,'duration':duration,'timeout':timeout,'zindex':JSMENU['zIndex']['prompt']});
		document.getElementById(menuid).style.top = (parseInt(document.getElementById(menuid).style.top) - 100) + 'px';
	}
}*/
function addFavorite(url, title) {
	try {
		window.external.addFavorite(url, title);
	} catch (e){
		try {
			window.sidebar.addPanel(title, url, '');
        	} catch (e) {
			alert(_lang.prompt1.ctrlD);
		}
	}
}

function setHomepage(sURL) {
	if(BROWSER.ie){
		document.body.style.behavior = 'url(#default#homepage)';
		document.body.setHomePage(sURL);
	} else {
		alert(_lang.prompt1.sethome, 'notice');
		
	}
};
function copyToClipboard(copyText) {  
       if (window.clipboardData){
            window.clipboardData.setData("Text", copyText)
        }else{
            var flashcopier = 'flashcopier';
            if(!document.getElementById(flashcopier)) 
            {
              var divholder = document.createElement('div');
              divholder.id = flashcopier;
              document.body.appendChild(divholder);
            }
            document.getElementById(flashcopier).innerHTML = '';
            var divinfo = '<embed width="0" height="0" allownetworking="internal" allowscriptaccess="never" src="./dzz/scripts/clipboard/_clipboard.swf" flashvars="clipboard='+encodeURIComponent(copyText)+'" quality="high" wmode="transparent" allowfullscreen="false" type="application/x-shockwave-flash">'
            document.getElementById(flashcopier).innerHTML = divinfo;
        }
      alert(copyText+'====='+_lang.prompt1.copyok);
} ;

function dbind(id,ev){
/*
 * 此函数在document上绑定鼠标按下事件，用于按任意键（不再对象元素上）触发元素事件
 × id为绑定的domid
 * ev为触发此元素的某个事件名称
*/
	jQuery(document).on('mousedown.'+id,function(e){
			e=e?e:window.event;
			var obj = e.srcElement ? e.srcElement :e.target;
			if(checkInDom(obj,id)==false){
				jQuery(document).off('.'+id);
				jQuery('#'+id).trigger(ev);
			}
	});
}

function checkInDom(obj,id){
	if(!obj) return false;
	if(obj.id==id) return true;
	else if(obj.tagName=='BODY'){
		return false;
	}else{
		return checkInDom(obj.parentNode,id);
	}
};
function contains(parentNode, childNode) { 
	if (parentNode.contains) { return parentNode != childNode && parentNode.contains(childNode); 
	} else { return !!(parentNode.compareDocumentPosition(childNode) & 16); } 
};
function checkHover(e,target){
    if (getEvent(e).type=="mouseover")  {
        return !contains(target,getEvent(e).relatedTarget||getEvent(e).fromElement) && !((getEvent(e).relatedTarget||getEvent(e).fromElement)===target);
    } else {
        return !contains(target,getEvent(e).relatedTarget||getEvent(e).toElement) && !((getEvent(e).relatedTarget||getEvent(e).toElement)===target);
    }
};
function htmlspecialchars_decode (string, quote_style) {
  // http://kevin.vanzonneveld.net
  // + original by: Mirek Slugen
  // + improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // + bugfixed by: Mateusz "loonquawl" Zalega
  // + input by: ReverseSyntax
  // + input by: Slawomir Kaniecki
  // + input by: Scott Cariss
  // + input by: Francois
  // + bugfixed by: Onno Marsman
  // + revised by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // + bugfixed by: Brett Zamir (http://brett-zamir.me)
  // + input by: Ratheous
  // + input by: Mailfaker (http://www.weedem.fr/)
  // + reimplemented by: Brett Zamir (http://brett-zamir.me)
  // + bugfixed by: Brett Zamir (http://brett-zamir.me)
  // * example 1: htmlspecialchars_decode("<p>this -&gt; &quot;</p>", 'ENT_NOQUOTES');
  // * returns 1: '<p>this -> &quot;</p>'
  // * example 2: htmlspecialchars_decode("&amp;quot;");
  // * returns 2: '&quot;'
  var optTemp = 0,
    i = 0,
    noquotes = false;
  if (typeof quote_style === 'undefined') {
    quote_style = 2;
  }
  string = string.toString().replace(/&lt;/g, '<').replace(/&gt;/g, '>');
  var OPTS = {
    'ENT_NOQUOTES': 0,
    'ENT_HTML_QUOTE_SINGLE': 1,
    'ENT_HTML_QUOTE_DOUBLE': 2,
    'ENT_COMPAT': 2,
    'ENT_QUOTES': 3,
    'ENT_IGNORE': 4
  };
  if (quote_style === 0) {
    noquotes = true;
  }
  if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
    quote_style = [].concat(quote_style);
    for (i = 0; i < quote_style.length; i++) {
      // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
      if (OPTS[quote_style[i]] === 0) {
        noquotes = true;
      } else if (OPTS[quote_style[i]]) {
        optTemp = optTemp | OPTS[quote_style[i]];
      }
    }
    quote_style = optTemp;
  }
  if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
    string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
    // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
  }
  if (!noquotes) {
    string = string.replace(/&quot;/g, '"');
  }
  // Put this in last place to avoid escape being double-decoded
  string = string.replace(/&amp;/g, '&');

  return string;
};
function array_merge () {
    // Merges elements from passed arrays into one array  
    // 
    // version: 1109.2015
    // discuss at: http://phpjs.org/functions/array_merge    // +   original by: Brett Zamir (http://brett-zamir.me)
    // +   bugfixed by: Nate
    // +   input by: josh
    // +   bugfixed by: Brett Zamir (http://brett-zamir.me)
    // *     example 1: arr1 = {"color": "red", 0: 2, 1: 4}    // *     example 1: arr2 = {0: "a", 1: "b", "color": "green", "shape": "trapezoid", 2: 4}
    // *     example 1: array_merge(arr1, arr2)
    // *     returns 1: {"color": "green", 0: 2, 1: 4, 2: "a", 3: "b", "shape": "trapezoid", 4: 4}
    // *     example 2: arr1 = []
    // *     example 2: arr2 = {1: "data"}    // *     example 2: array_merge(arr1, arr2)
    // *     returns 2: {0: "data"}
    var args = Array.prototype.slice.call(arguments),
        argl = args.length,
        arg,        retObj = {},
        k = '', 
        argil = 0,
        j = 0,
        i = 0,        ct = 0,
        toStr = Object.prototype.toString,
        retArr = true;
 
    for (i = 0; i < argl; i++) {        if (toStr.call(args[i]) !== '[object Array]') {
            retArr = false;
            break;
        }
    } 
    if (retArr) {
        retArr = [];
        for (i = 0; i < argl; i++) {
            retArr = retArr.concat(args[i]);        }
        return retArr;
    }
 
    for (i = 0, ct = 0; i < argl; i++) {        arg = args[i];
        if (toStr.call(arg) === '[object Array]') {
            for (j = 0, argil = arg.length; j < argil; j++) {
                retObj[ct++] = arg[j];
            }        }
        else {
            for (k in arg) {
                if (arg.hasOwnProperty(k)) {
                    if (parseInt(k, 10) + '' === k) {                        retObj[ct++] = arg[k];
                    }
                    else {
                        retObj[k] = arg[k];
                    }                }
            }
        }
    }
    return retObj;
};

function serialize (mixed_value) {
    // Returns a string representation of variable (which can later be unserialized)  
    // 
    // version: 1109.2015
    // discuss at: http://phpjs.org/functions/serialize    // +   original by: Arpad Ray (mailto:arpad@php.net)
    // +   improved by: Dino
    // +   bugfixed by: Andrej Pavlovic
    // +   bugfixed by: Garagoth
    // +      input by: DtTvB (http://dt.in.th/2008-09-16.string-length-in-bytes.html)    // +   bugfixed by: Russell Walker (http://www.nbill.co.uk/)
    // +   bugfixed by: Jamie Beck (http://www.terabit.ca/)
    // +      input by: Martin (http://www.erlenwiese.de/)
    // +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net/)
    // +   improved by: Le Torbi (http://www.letorbi.de/)    // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net/)
    // +   bugfixed by: Ben (http://benblume.co.uk/)
    // -    depends on: utf8_encode
    // %          note: We feel the main purpose of this function should be to ease the transport of data between php & js
    // %          note: Aiming for PHP-compatibility, we have to translate objects to arrays    // *     example 1: serialize(['Kevin', 'van', 'Zonneveld']);
    // *     returns 1: 'a:3:{i:0;s:5:"Kevin";i:1;s:3:"van";i:2;s:9:"Zonneveld";}'
    // *     example 2: serialize({firstName: 'Kevin', midName: 'van', surName: 'Zonneveld'});
    // *     returns 2: 'a:3:{s:9:"firstName";s:5:"Kevin";s:7:"midName";s:3:"van";s:7:"surName";s:9:"Zonneveld";}'
    var _utf8Size = function (str) {        var size = 0,
            i = 0,
            l = str.length,
            code = '';
        for (i = 0; i < l; i++) {            code = str.charCodeAt(i);
            if (code < 0x0080) {
                size += 1;
            } else if (code < 0x0800) {
                size += 2;            } else {
                size += 3;
            }
        }
        return size;    };
    var _getType = function (inp) {
        var type = typeof inp,
            match;
        var key; 
        if (type === 'object' && !inp) {
            return 'null';
        }
        if (type === "object") {            if (!inp.constructor) {
                return 'object';
            }
            var cons = inp.constructor.toString();
            match = cons.match(/(\w+)\(/);            if (match) {
                cons = match[1].toLowerCase();
            }
            var types = ["boolean", "number", "string", "array"];
            for (key in types) {                if (cons == types[key]) {
                    type = types[key];
                    break;
                }
            }        }
        return type;
    };
    var type = _getType(mixed_value);
    var val, ktype = ''; 
    switch (type) {
    case "function":
        val = "";
        break;    case "boolean":
        val = "b:" + (mixed_value ? "1" : "0");
        break;
    case "number":
        val = (Math.round(mixed_value) == mixed_value ? "i" : "d") + ":" + mixed_value;        break;
    case "string":
        val = "s:" + _utf8Size(mixed_value) + ":\"" + mixed_value + "\"";
        break;
    case "array":    case "object":
        val = "a";
/*
            if (type == "object") {
                var objname = mixed_value.constructor.toString().match(/(\w+)\(\)/);                if (objname == undefined) {
                    return;
                }
                objname[1] = this.serialize(objname[1]);
                val = "O" + objname[1].substring(1, objname[1].length - 1);            }
            */
        var count = 0;
        var vals = "";
        var okey;        var key;
        for (key in mixed_value) {
            if (mixed_value.hasOwnProperty(key)) {
                ktype = _getType(mixed_value[key]);
                if (ktype === "function") {                    continue;
                }
 
                okey = (key.match(/^[0-9]+$/) ? parseInt(key, 10) : key);
                vals += this.serialize(okey) + this.serialize(mixed_value[key]);                count++;
            }
        }
        val += ":" + count + ":{" + vals + "}";
        break;    case "undefined":
        // Fall-through
    default:
        // if the JS object has a property which contains a null value, the string cannot be unserialized by PHP
        val = "N";        break;
    }
    if (type !== "object" && type !== "array") {
        val += ";";
    }    return val;
};
 
function formatSize(bytes){
        var i = -1; 
        do {
            bytes = bytes / 1024;
            i++;  
        } while (bytes > 99);
       
        return Math.max(bytes, 0).toFixed(1) + ['kB', 'MB', 'GB', 'TB', 'PB', 'EB'][i];          
};
function mb_cutstr_nohtml(str, maxlen,dot) {
	
	var len = 0;
	var ret = '';
	if(!dot) dot='';
	if(!str) return;
	str = str.replace(/(\<[^\<]*\>|\r|\n|\s|\[.+?\])/ig, ' ');
	maxlen = maxlen - dot.length;
	for(var i = 0; i < str.length; i++) {
		len += str.charCodeAt(i) < 0 || str.charCodeAt(i) > 255 ?3 : 1;
		if(len > maxlen) {
			ret += dot;
			break;
		}
		ret += str.substr(i, 1);
	}
	return ret;
};


fixPNG = function (el, emptyGIF) {
		var images = el.find('img');
		images.each( function() {
			png = this.src;	
			this.src = emptyGIF;
			this.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + png + "',sizingMethod='scale')";
		});
	};
fixpng = function (obj) {
			if(BROWSER.ie && BROWSER.ie<7 ){
				var png = obj.src;
				obj.onload=null;
				if(png.substr(png.lastIndexOf('.')).toLowerCase()=='.png'){
					obj.src = 'dzz/images/b.gif';
					obj.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + png + "',sizingMethod='scale')";
				}
			}
	};
