/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
_config=function(json){
	_config.appList=json.applist || []; //开始菜单应用列表;
	_config.dockList=json.docklist ||[];  //dock条icoid列表；
	_config.screenList=json.screenlist||[];//各个桌面信息（基本参数、icoid列表、winlist窗体列表）；
	_config.sourceids=json.sourceids||[];//源id列表；
	_config.sourcedata=json.sourcedata||[]; //所有安装的应用的数据；
	_config.dockTaskList=[];
	_config.iconview=json.iconview||{};
	
	//_config.tempfid=json.tempfid;
	//_config.recyclefid=json.recyclefid;
	_config.space=json.space;
	_config.myspace=json.myspace;
	_config.imconfig=json.imconfig;
	_config.extopen=json.extopen||{};

};
_config.dockWidth=40;
_config.dockHeight=40;
_config.filearr=[];
_config.siteid='zyx';
if(BROWSER.ie){ _config.titleButtons=["CLOSE","MAX","RESTORE","MIN","REFRESH"];}else{_config.titleButtons=["CLOSE","MAX","RESTORE","MIN","FULLSCREEN","REFRESH"];}
_config.documentexts=['DZZDOC','HTM','HTML','SHTM','SHTML','HTA','HTC','XHTML','STM','SSI','JS','JSON','AS','ASC','ASR','XML','XSL','XSD','DTD','XSLT','RSS','RDF','LBI','DWT','ASP','ASA','ASPX','ASCX','ASMX','CONFIG','CS','CSS','CFM','CFML','CFC','TLD','TXT','PHP','PHP3','PHP4','PHP5','PHP-DIST','PHTML','JSP','WML','TPL','LASSO','JSF','VB','VBS','VTM','VTML','INC','SQL','JAVA','EDML','MASTER','INFO','INSTALL','THEME','CONFIG','MODULE','PROFILE','ENGINE','log','DOC','DOCX','XLS','XLSX','PPT','PPTX','ODT','ODS','ODG','RTF','ET','DPX','WPS'];
_config.txtexts=['DZZDOC','HTM','HTML','SHTM','SHTML','HTA','HTC','XHTML','STM','SSI','JS','JSON','AS','ASC','ASR','XML','XSL','XSD','DTD','XSLT','RSS','RDF','LBI','DWT','ASP','ASA','ASPX','ASCX','ASMX','CONFIG','CS','CSS','CFM','CFML','CFC','TLD','TXT','PHP','PHP3','PHP4','PHP5','PHP-DIST','PHTML','JSP','WML','TPL','LASSO','JSF','VB','VBS','VTM','VTML','INC','SQL','JAVA','EDML','MASTER','INFO','INSTALL','THEME','CONFIG','MODULE','PROFILE','ENGINE','log'];
_config.docexts=['DOC','DOCX','XLS','XLSX','PPT','PPTX','ODT','ODS','ODG','RTF','ET','DPX','WPS','PDF'];
/*_config.polltype='short';//拉取数据的方式："long" or "short",long方式要使用聊天服务器，如果聊天服务器不能使用，请切换为short方式;
_config.polllisten='http://dzz.cc/api/chat/api/listen';
_config.pollsend='http://dzz.cc/api/chat/api/send';
_config.shortTime=8000; //短链接发送时间间隔(毫秒)，越长消息延迟越大，越短服务器负载越高。
_config.DimOff=false; //是否关闭聊天和消息推送功能，关闭后，将不能收到互动的实时消息，需要刷新页面才可以；*/
_config.poll={total_num:0,error_num:0,data_num:0};//统计发送长链接的数量;
_config.uploader={};
_config.Droper={};_config.group={};
_config.taskOpen={};
_config.taskWidget={};
_config.icosTips={};
_config.indzz=true;
_config.saveItem={};
_config.selectall={position:{},container:'',icos:[]};
_config.cut={iscut:0,icos:[]};

_config.savetime=10000;
_config.saveTimer=null;
_config.delay=500;
_config.titleBars={};
//_config.folderList=[];//各个目录内icoid列表；
_config.sendDataTo=function(iframe,data){
	if(window.frames[iframe])	window.frames[iframe].window.acceptdata(data);
}

   
_config.getConfig=function(url,openid){
	jQuery.getJSON(url+'&openid='+openid+'&t='+new Date().getTime(),function(json){
		try{
			_sound.play('global');
			if(json.needlogin){ _login.Clogin();return;}
			_config(json);
			jQuery('#loading_info').fadeOut('slow');
			_layout.init();
			_start.init();
			_dock.init();
			_ico.CIcolist();
			_login.OpenWindows();
			
			if(ieVersion>0 && ieVersion<7) Alert(_lang.sayByeToIE6);
		}catch(e){};
		
	});
};

_config.sendConfig=function(async){
	if(!async) async=false;
	if(_config.myuid>0){
		var data={}
		if(_config.saveItem.imstyle){
			 data.imstyle=_config.imconfig.style;
			// alert(data.imstyle);
		}
		if(_config.saveItem.imstate){
			 data.imstate=_config.imconfig.state;
			// alert(data.imstate);
		}
		if(_config.saveItem.imsound){
			 data.imsound=_config.imconfig.sound;
			 //alert(data.imsound);
		}
		if(_config.saveItem.appList){
			 data.applist=_config.appList;
		}
			
		if(_config.saveItem.thame){
			data.thame=_config.thame.system.id;
			data.custom_backimg=_config.thame.custom.custom_backimg;
			data.custom_url=_config.thame.custom.custom_url?_config.thame.custom.custom_url:'';
			data.custom_color=_config.thame.custom.custom_color?_config.thame.custom.custom_color:'';
			data.custom_btype=_config.thame.custom.custom_btype>0?_config.thame.custom.custom_btype:0;
		}
		
		if(!jQuery.isEmptyObject(data)){
			jQuery.ajax({
				 type:'post',
				 async: async,
				 url:_config.dataurl+'&do=save&t='+new Date().getTime(),
				 data:data,
				 dataType:"json",
				 success:function(json){
					 if(json.msg=='success'){
						_config.saveItem={};
					 }
				 },
				 error:function(){
					 Alert(_lang.save_error);
				 }
			 });
		}
	}
};
_config.initthame=function(flag){
	//调用相关风格的css；
	if(flag){
		for(var key in _config.thame.system.modules){
			_config.loadcss('dzz/styles/'+key+'/' + _config.thame.system.modules[key] + '/style.css','modules_'+key);
		}
		 if(_config.thame.system.folder){
			_config.loadcss('dzz/styles/thame/' + _config.thame.system.folder + '/style.css','thame_'+_config.thame.system.folder);
		}
	}
	 //设置背景
	 if(_config.thame.custom.custom_url){
		  _config.setback('',0,_config.thame.custom.custom_url,1);
	 }else if(_config.thame.custom.custom_backimg){
		 if(_config.thame.custom.custom_btype==0) _config.thame.custom.custom_btype=1;
		_config.setback(_config.thame.custom.custom_backimg,_config.thame.custom.custom_btype,'',1);
	}else if(_config.thame.custom.custom_color){
		_config.setColor(_config.thame.custom.custom_color,1);
	 }else if( _config.thame.system.url){
		 _config.setback('',0,_config.thame.system.url,1);
	 }else if( _config.thame.system.backimg){
		 if(_config.thame.system.btype==0) _config.thame.system.btype=1;
		 _config.setback(_config.thame.system.backimg,_config.thame.system.btype,'',1);
	 }else if(_config.thame.system.commoncolor){
		_config.setColor(_config.thame.system.commoncolor,1);
	 }
};
_config.setthame=function(json){
	_config.thame.system=json;
	_config.thame.custom={custom_backimg:'',custom_url:'',custom_color:'',custom_btype:''};
	_config.initthame(true);
	_config.saveItem.thame=1;
	if(_config.saveTimer) window.clearTimeout(_config.saveTimer);
	_config.saveTimer=setTimeout(function(){_config.sendConfig();},_config.savetime);
	showmessage('更换主题需要重新加载，<a href="#" onclick="window.location.reload()">立即重新加载</a>','warning',8000,true);
};

_config.loadcss=function(css,type) { //type: css_thame ;css_dock;css_window
	if(ieVersion<7 && ieVersion>0) jQuery('#css_'+type).remove();
	if(css){
		jcLoader().load({type:"css",url:css,ids:'css_'+type},function(){
			
		});  
	}
	return false;
};

_config.setColor=function(color,update){
	if(_config.thame.system.enable_color<1){
		showmessage('当前主题不允许更换偏好色','error',3000,true,'right-bottom');
		return;
	}
	_config.thame.custom.custom_color=color;
	var type='css_color';
	var css=_config.systemurl+'&op=ajax&do=getColorCss&color='+encodeURIComponent(color)+'&css='+_config.thame.system.folder;
	_config.loadcss(css,type);
	if(!update){
		_config.saveItem.thame=1;
		if(_config.saveTimer) window.clearTimeout(_config.saveTimer);
		_config.saveTimer=setTimeout(function(){_config.sendConfig();},_config.savetime);
	}
};


_config.deleteback=function(backimg){
	if(_config.thame.custom.custom_backimg==backimg){
		 _config.thame.custom.custom_backimg='';
		 _config.setback(_config.thame.system.backimg,_config.thame.system.btype,_config.thame.system.url,1);
		_config.saveItem.thame=1;
		if(_config.saveTimer) window.clearTimeout(_config.saveTimer);
		_config.saveTimer=setTimeout(function(){_config.sendConfig();},_config.savetime);
	}
};

_config.setback=function(backimg,btype,url,update){
	//如果是自定义背景的话，设置_config.thame.custom 的值；
	if(update=='backimg'){
		 if(backimg=='transparent'){
			  backimg=_config.thame.system.backimg ||'./dzz/images/b.gif';
		 }else  if(backimg){
			_config.thame.custom.custom_backimg=backimg;
			_config.thame.custom.custom_url='';
		 }else{
			 backimg=_config.thame.custom.custom_backimg ||_config.thame.system.backimg ||'./dzz/images/b.gif';
		 }
		if(btype){
			_config.thame.custom.custom_btype=btype;
		}else{
			btype=_config.thame.custom.custom_btype ||_config.thame.system.btype || 1;
		}
		
		 if(parseInt(btype)==0) btype=1;
	}else if(update=='btype'){
			_config.thame.custom.custom_btype=btype;
		 	 if(_config.thame.custom.custom_url){
				  _config.setback('',btype,_config.thame.custom.custom_url,'url');
			 }else if(_config.thame.custom.custom_backimg){
				 _config.setback(_config.thame.custom.custom_backimg,btype,'','backimg');
			 }else if( _config.thame.system.url){
				 _config.setback('',btype,_config.thame.system.url,'url');
			  }else if( _config.thame.system.backimg){
				 _config.setback(_config.thame.system.backimg,btype,'','backimg');
			 }
			 return;
	}else if(update=='url'){
		 _config.thame.custom.custom_url=url;
		 if(!url){
			 if(_config.thame.custom.custom_url){
				  _config.setback('',btype,_config.thame.custom.custom_url,'url');
			 }else if(_config.thame.custom.custom_backimg){
				 _config.setback(_config.thame.custom.custom_backimg,btype,'','backimg');
			 }else if( _config.thame.system.url){
				 _config.setback('',btype,_config.thame.system.url,'url');
			 }else if( _config.thame.system.backimg){
				 _config.setback(_config.thame.system.backimg,btype,'','backimg');
			 }
			 return; 
		 }
	}

	if(update!=1) {
		_config.saveItem.thame=1;
		if(_config.saveTimer) window.clearTimeout(_config.saveTimer);
		_config.saveTimer=setTimeout(function(){_config.sendConfig();},_config.savetime);
	}
	
	//判断url的后缀名
	if(url){
		if(url.lastIndexOf('.')!==-1){
			var ext=url.substr(url.lastIndexOf('.')).toLowerCase();
			if(ext=='.jpg' || ext=='.png' || ext=='.jpeg' || ext=='.gif' ){
				//btype='1';
				backimg=url;
			}else{
				btype=0;
			}
		}else btype=0;
	}
	switch(parseInt(btype)){
		case 0: //html类型背景；
			document.getElementById('wrapper_frame').src=url;
			document.getElementById('wrapper_frame').width='100%';
			document.getElementById('wrapper_frame').height='100%';
			document.getElementById('imgbg').src='dzz/images/b.gif';
			break;
		case 1: //拉伸背景图片；
			document.getElementById('wrapper_frame').src='about:blank';
			if(backimg.indexOf('#')===0){
				document.getElementById('wrapper_div').style.background=backimg;
				document.getElementById('imgbg').src='dzz/images/b.gif';
			}else{
				document.getElementById('imgbg').src=backimg;
			}
			document.getElementById('wrapper_frame').width='0';
			document.getElementById('wrapper_frame').height='0';
			break;
		case 2: //平铺类型背景；
			document.getElementById('imgbg').src='dzz/images/b.gif';
			document.getElementById('wrapper_frame').src='about:blank';
			document.getElementById('wrapper_frame').width='0';
			document.getElementById('wrapper_frame').height='0';
			if(backimg.indexOf('#')===0){
				document.getElementById('wrapper_div').style.background=backimg;
			}else{
				document.getElementById('wrapper_div').style.background='url('+backimg+')';
			}
			break;
		case 3: //居中类型背景；
			document.getElementById('imgbg').src='dzz/images/b.gif';
			document.getElementById('wrapper_frame').src='about:blank';
			document.getElementById('wrapper_frame').width='0';
			document.getElementById('wrapper_frame').height='0';
			
			if(backimg.indexOf('#')===0){
				document.getElementById('wrapper_div').style.background=backimg;
			}else{
				document.getElementById('wrapper_div').style.background='url('+backimg+') 50% 50% no-repeat';
			}
			break;
	}
}

//打开保持的上次打开的窗体；
_config.setTaskOpen=function(){
	for(var i in _config.sourcedata.icos){
		if(_config.sourcedata.icos[i].defaultopen>0){
			var deskp=_config.sourcedata.icos[i].desktop;
			if(deskp=='d:-1'){
				var navid=_config.currentDesktop;
			}else if(deskp.indexOf('d:')!==-1){
				var navid=deskp.replace('d:','');
			}else{
				var navid=_config.currentDesktop;
			}
			if(!_config.taskOpen[navid]) _config.taskOpen[navid]=[];
			 _config.taskOpen[navid].push({icoid:i,navid:navid});
		}
	}
}

_config.taskOpen_run=function(){
	if(_config.taskOpen[_config.currentDesktop]){
		for(var i=0;i<_config.taskOpen[_config.currentDesktop].length;i++){
			_ico.OpenWin(_config.taskOpen[_config.currentDesktop][i].icoid,_config.taskOpen[_config.currentDesktop][i].navid,_config.taskOpen[_config.currentDesktop][i].tab,_config.taskOpen[_config.currentDesktop][i].left,_config.taskOpen[_config.currentDesktop][i].top);
		}
		delete 	_config.taskOpen[_config.currentDesktop];
	}
};

 _config.dock_up_down=function(flag){
	if(flag=='up'){
		jQuery('#dock_bottom').show();
		jQuery('#dock_bottom_back').show();
		if(!_window.dockhide) return;
		jQuery('#dock_bottom').animate({bottom:'0px'},_config.delay);
		jQuery('#dock_bottom_back').animate({bottom:'0px'},_config.delay);
			_window.dockhide=0;
			document.getElementById('dock_opbar').className='dock_opbar_d';
	}else if(flag=='down'){
		//jQuery('#dock_bottom').hide();
		if(_window.dockhide) return;
		jQuery('#dock_bottom').animate({bottom:(-_config.dockHeight)+'px'},_config.delay);
		jQuery('#dock_bottom_back').animate({bottom:(-jQuery('#dock_bottom_back').height())+'px'},_config.delay);
			_window.dockhide=1;
			document.getElementById('dock_opbar').className='dock_opbar_u';
	}else{
		if(_window.dockhide) {
			jQuery('#dock_bottom').show();jQuery('#dock_bottom_back').show();
			jQuery('#dock_bottom').animate({bottom:'0px'},_config.delay);
			jQuery('#dock_bottom_back').animate({bottom:'0px'},_config.delay);
			_window.dockhide=0;
			document.getElementById('dock_opbar').className='dock_opbar_d';
		}else{
			//jQuery('#dock_bottom').hide();
			jQuery('#dock_bottom').animate({bottom:(-_config.dockHeight)+'px'},_config.delay);
			jQuery('#dock_bottom_back').animate({bottom:(-jQuery('#dock_bottom_back').height())+'px'},_config.delay);
			_window.dockhide=1;
			document.getElementById('dock_opbar').className='dock_opbar_u';
		}
	}
};

_config.init=function(openid){
	
	_config.initthame();
	_sound.create();
	window.onbeforeunload=function(){
			/*if(!ieVersion || ieVersion>6){
				if(!jQuery.isEmptyObject(_dim.message)) jQuery.jStorage.set('_dim_Msg_'+VERHASH+'_'+_config.myuid,encodeURIComponent(jQuery.toJSON(_dim.message)));
				else jQuery.jStorage.set('_dim_Msg_'+VERHASH+'_'+_config.myuid,'');
			}
			_dim.setUserLoginState('logout');*/
			if(!jQuery.isEmptyObject(_config.saveItem)){_config.sendConfig();}
			if(_config.leavealert>0 && _config.self>0) return _lang.confirmexit+_config.sitename+_lang.ma;
		}
	document.oncontextmenu=function(e){
		e=e?e:window.event;
		var tag = e.srcElement ? e.srcElement :e.target;
		if(tag.type=="text"||tag.type=="textarea"){
			return true;
		}else{
			return false;
		}
	}

	document.onselectstart=function(e){
		e=e?e:window.event;
		var tag = e.srcElement ? e.srcElement :e.target;
		if(tag.type=="text"||tag.type=="textarea"){
			return true;
		}else{
			return false;
		}
	};
	window.onresize=function(){
		_window.clientWidth=_config.screenWidth=document.documentElement.clientWidth;
		_window.clientHeight=_config.screenHeight=document.documentElement.clientHeight;
		//alert(_config.screenWidth+'==='+_config.screenHeight);
		_layout.resize();
		
		//_panel.setHeight();
		
		//_message.resize();
		
	//	_config.init_appmarket_add();
		
	};
	_config.getConfig(_config.dataurl,openid);
	
};

_config.setMouseDownHide=function(id){
	jQuery(document).bind('mousedown.'+id,function(e){
		e=e?e:window.event;
		var obj = e.srcElement ? e.srcElement :e.target;
		if(checkInDom(obj,id)==false){
			jQuery('#'+id).hide();
			jQuery(document).unbind('mousedown.'+id);
		}
	});
};

fixPNG = function (el, emptyGIF) {
		var images = el.find('img');
		images.each( function() {
			png = this.src;	
			this.src = emptyGIF;
			this.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + png + "',sizingMethod='scale')";
		});
	
	};
fixpng = function (obj) {
			if(ieVersion>0 && ieVersion<7 ){
				var png = obj.src;
				obj.onload=null;
				if(png.substr(png.lastIndexOf('.')).toLowerCase()=='.png'){
					obj.src = 'dzz/images/b.gif';
					obj.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + png + "',sizingMethod='scale')";
				}
			}
	};
function GetIeVersion()
{
    var reg = new RegExp("MSIE ([^;]*);", "i");
    if (reg.test(navigator.appVersion)) return parseInt(RegExp.$1);
    return 0;
};
var ieVersion = GetIeVersion();
var windows = new Array();
windows["sys_addApp"]         = { object:null,type:0, title:_lang.WinTitle['addApp'], features:"width=500,height=400,titlebutton=close", x:170, y:50 };
windows["sys_browser"]         = { object:null,type:0, title:_lang.WinTitle['browser'], features:"width=800,height=500,titlebutton=fullscreen|close|max|min", x:170, y:50 };
windows["sys_market"]         = { object:null,type:0, title:_lang.WinTitle['market'], features:"width=800,height=500,titlebutton=fullscreen|close|max|min", x:170, y:50 };
windows["sys_theme"]         = { object:null,type:0, title:_lang.WinTitle['theme'], features:"width=800,height=500,titlebutton=fullscreen|close|max|min", x:170, y:50 };
windows["sys_widget"]         = { object:null,type:0, title:_lang.WinTitle['widget'], features:"width=800,height=500,titlebutton=fullscreen|close|max|min", x:170, y:50 };
windows["profile"]         = { object:null,type:0, title:_lang.WinTitle['userprofile'], features:"width=540,height=380,titlebutton=close", x:170, y:50 };

windows["ControlPanel"]     = { object:null,type:0, title:_lang.WinTitle['ControlPanel'], features:"resize=no,titlebutton=close,width=345,height=-1", x:335, y:parseInt(Math.random() * 300) };
windows["sys_hotkey"]     = { object:null,type:0, title:_lang.WinTitle['hotkey'], features:"resize=no,titlebutton=close,width=380,height=-1", x:335, y:parseInt(Math.random() * 300) };
windows["sys_restore"]     = { object:null, type:0,title:_lang.WinTitle['restore'], features:"resize=no,width=380,height=-1,button=OK|CANCEL,titlebutton=close", x:335, y:parseInt(Math.random() * 300) };
windows["sys_deskconfig"]     = { object:null,type:0, title:_lang.WinTitle['deskconfig'], features:"resize=no,width=380,height=-1,button=OK|CANCEL,titlebutton=close", x:335, y:parseInt(Math.random() * 300) };
windows["sys_findfriend"]     = { object:null,type:0, title:_lang.WinTitle['findfriend'], features:"resize=no,width=810,height=460,titlebutton=close", x:335, y:parseInt(Math.random() * 300) };
windows["sys_config"]         = { object:null,type:0, title:_lang.WinTitle['config'], features:"width=800,height=500,titlebutton=fullscreen|close|max|min", x:170, y:50 };

windows["Alert"]     = { object:null,type:1, title:_lang.WinTitle['notice'], features:"resize=no,titlebutton=close,width=400,height=-1,button=OK,isModal=yes"};
windows["confirm"]     = { object:null, type:2,title:_lang.WinTitle['message'], features:"resize=no,titlebutton=close,width=400,height=-1,button=OK|CANCEL,isModal=yes"};
windows["sys_login"]     = { object:null, title:_lang.WinTitle['login'], features:"class=sys_login,titlebutton=close,width=400,height=300", x:335, y:200 };

windows["App"] = { object:null, title:"", features:"titlebutton=fullscreen|close|max|min,width=800,height=500",width:800,height:500 };
windows["url"] = { object:null,type:0, title:_lang.browser, features:"titlebutton=fullscreen|close|max|min,width=800,height=500",width:800,height:500 };
windows["sys_filemanage"] = { object:null, title:_lang.WinTitle['filemanage'], features:"titlebutton=fullscreen|close|max|min,width=800,height=500",width:800,height:500 };
windows["OpenFile"]  = { object:null, title:'', features:"class=window_jd,titlebutton=close,width=500,height=400,button=OK|CANCEL,isModal=yes",width:500,height:400 };
//windows["Dim_pannel"]         = { object:null, title:_lang.WinTitle['Dim_panel'], features:"class=dim_pannel,titlebutton=close,width=500,height=400",width:500,height:400 };

windows["sys_pic"] = { object:null, title:_lang.WinTitle['pic'], features:"titlebutton=close|max|min,width=800,height=500",width:800,height:500 };

windows["Folder"]         = { object:null, title:"", features:"titlebutton=close|max|min,width=800,height=500",width:800,height:500 };

windows["Message"]     = { object:null,type:1, title:_lang.WinTitle['notice'], features:"resize=no,titlebutton=close,width=300,height=200"};


