/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function _dock(appid,winid,data,pined,pos)
{
	this.id=this.name=appid;
	this.string="_dock.icos."+this.id;
	this.zIndex=++_ico.zIndex;
	this.ispng=false;
	this.data=_dock.getdata(appid,data);
	this.text=this.data.text;
	this.img=this.data.img;
	
	this.type=this.data.type;
	this.ispng=this.data.ispng;
	
	if(this.data.icoid>0){
		 this.icoid=this.data.icoid;
		 if(_config.sourcedata.icos[ this.icoid].flag){
				this.data.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/'+_config.sourcedata.icos[ this.icoid].flag+'.png';
				this.data.error='dzz/images/default/system/'+_config.sourcedata.icos[ this.icoid].flag+'.png';
			}else if(_config.sourcedata.icos[ this.icoid].type=='folder'){
				this.data.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/folder.png';
				this.data.error='dzz/images/default/system/folder.png';
			}else{
				this.data.error='dzz/images/default/icodefault.png';
			}
	}
	this.error=this.data.error||'dzz/images/taskicon/unknown.png';
	this.className=_dock.className+' middleicon'
	this.container='taskbar_dock';
	
	this.width=_dock.width;
	this.height=_dock.height;
	this.divwidth=_dock.divwidth;
	this.divheight=_dock.divheight;
	this.pos=pos;
	/*if(_config.sourcedata.icos[appid] && _config.sourcedata.icos[appid].type=='folder'){
		var topfid=_ico.getTopFid(_config.sourcedata.icos[appid].oid);
		this.winid='_W_'+topfid[topfid.length-1];
	}else{
		this.winid='_W_'+appid;
	}*/
	this.winid=winid;
	if(pined) this.pined=pined;
	else this.pined=null;
	_dock.icos[this.id]=this;
};
_dock.icos={};
_dock.className='task_Icoblock';
/*_dock.indocksum=5;
_dock.istaskup=0;*/
_dock.divwidth=42;
_dock.divheight=42;
_dock.width=32;
_dock.height=32;
_dock.padding=10;
_dock.jumps=[];//跳动中的任务栏
 _dock.getdata=function(appid,data){
	var arr={
		'config':			{img:'dzz/images/taskicon/config.png',			type:''	,		text:_lang.WinTitle['config'],		ispng:1},
		'sys_theme':		{img:'dzz/images/taskicon/thame.png',			type:''	,		text:_lang.WinTitle['theme'],		ispng:1},
		'sys_hotkey':		{img:'dzz/images/taskicon/hotkey.png',			type:''	,		text:_lang.WinTitle['hotkey'],		ispng:1},	
		'profile':			{img:'dzz/images/taskicon/profile.png',			type:''	,		text:_lang.WinTitle['profile'],		ispng:1},
		'sys_pic':		    {img:'dzz/images/taskicon/image.png',		    type:'image',	text:_lang.WinTitle['pic'],			ispng:1},
		'dim':		    	{img:'dzz/images/taskicon/dim.png',		    	type:'',		text:'DIM',							ispng:1},
		'appmarket':		{img:'dzz/images/taskicon/appmarket.png',		type:'app',		text:_lang.WinTitle['market'],		ispng:1}
	}
	if(arr[appid]){
		 return arr[appid];
	}else{
		arr[appid]={};
	}
	try{
		if(data){
			data.text=data.name;
			return data;
		}else if( _config.sourcedata.icos[appid]){
			 var data=_config.sourcedata.icos[appid];
			 data.text=data.name;
			 data.img=data.img;
			
			 data.type=data.type ||'';
			 if(data.img.substr(data.img.length-4)=='.png' ) data.ispng=true;
			 return data;
		}
		
	}catch(e){};
	if(appid.indexOf('uid_')===0){
		var uid=appid.replace('uid_','');
		arr[appid].text=_config.sourcedata.user[uid].username;
		arr[appid].img=_config.ucenterurl+'/avatar.php?uid='+uid+'&size=small';
		arr[appid].ispng=false;
		arr[appid].type='user';
	
	}else{
		arr[appid].text=data.name;
		arr[appid].img=data.img;
		arr[appid].error='dzz/images/taskicon/unknown.png';
		arr[appid].type=data.type ||'';
		if(arr[appid].img.substr(arr[appid].img.length-4)=='.png' ) arr[appid].ispng=true;
	}
	return arr[appid]
}
_dock.init=function(){
	//创建dockico
	var dockList=_config.dockList;
	for(var j=0;j<dockList.length;j++){
		var ico=_config.sourcedata.icos[dockList[j]];
		if(ico.type=='app') var taskid='app_'+ico.oid;
		else var taskid=ico.icoid;
		var pos=_config.dockTaskList.push(taskid)-1;
		var obj=_dock.Ctask(taskid,null,ico,1,pos);
	}
	_dock.setDockSize();
	
};
_dock.Ctask=function(id,winid,data,pined,pos){
	
	if(winid){
		 if(_window.windows[winid] && _window.windows[winid].titleButton=='') return;
	}
	if(_dock.icos[id]){
		pined=_dock.icos[id].pined;
		pos=_dock.icos[id].pos;
		if(data) _dock.icos[id].data=data;
		if(_dock.icos[id].icoid) var icoid=_dock.icos[id].icoid;
		else var icoid=null;
		if(!winid) winid=_dock.icos[id].winid;
		var obj= new _dock(id,winid,data,pined,pos);
		if(icoid) obj.icoid=icoid;
		jQuery('#task_'+id).remove();
	}else{
		if(!jQuery.isNumeric(pos)) pos=_config.dockTaskList.push(id)-1;
		var obj= new _dock(id,winid,data,pined,pos);
	}
	
	obj.create();
	return obj;
};
_dock.prototype.create=function(){
	this.board=document.createElement("div");
	this.board.className=this.className;
	this.board.setAttribute('icoid',this.id);
	if(this.pined>0) this.board.setAttribute('pined',1);
	this.board.id='task_'+this.id;
	this.board.style.position="absolute";

		/*if(ieVersion > 0 && ieVersion < 7 && this.ispng )	{
			var html="<img  src='dzz/images/b.gif' width="+(this.width)+" height="+(this.height)+"  style=\"_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+this.img+"', sizingMethod='scale');\" title=\""+this.text+"\">";
		}else {
			var html='<img class="radius" src="'+this.img+'" style="width:'+(this.width)+'px;height:'+(this.height)+'px;" title="'+this.text+'">';
		}*/
	
	var imgclass='';
	switch(this.type){
		case 'user':
			document.getElementById('usercss_loaded').className='userclass'+this.width+'_'+this.height;
			if(parseInt(jQuery('#usercss_loaded').css('width'))>1){
				imgclass='userclass'+this.width+'_'+this.height;
				var html='<img class="'+imgclass+'" src="'+this.img+'"  title="'+this.text+'" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')">';
			}else{
				var html='<img  class="userclass radius" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			}
			break;
		case 'image':
			imgclass='imageclass';
			var html='<img  class="'+imgclass+'" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			break;
		case 'app':
			imgclass='radius';
			var html='<img  class="'+imgclass+'" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			break;
		case 'video':
			document.getElementById('videocss_loaded').className='videoclass'+this.width+'_'+this.height;
			if(parseInt(jQuery('#videocss_loaded').css('width'))>1){
				imgclass='videoclass'+this.width+'_'+this.height;
				var html='<img class="'+imgclass+'" src="'+this.img+'"  title="'+this.text+'" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			}else{
				var html='<img  class="videoclass radius" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			}
			break;
		default:
			imgclass='radius';
			var html='<img  class="'+imgclass+'" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
	}
	
	//添加图片背景和前景层
		
	var typeclass='icoimgContainer_'+this.type;
	 var html1='';
		html1+='<div class="icoimgContainer '+typeclass+'" style="position:relative;width:'+this.width+'px;height:'+this.height+'px">';
		html1+=   '<table width="100%" height="100%" cellpadding="0" cellspacing="0"><tr><td align="center" valign="middle">'+html+'</td></tr></table>';
		html1+=   '<div class="icoimgCover_up" style="position:absolute;left:0px;top:0px;width:'+this.width+'px;height:'+this.height+'px;z-index:1"></div>';
		html1+=   '<div class="icoimgtips" style="position:absolute;left:0px;top:0px;width:'+this.width+'px;height:'+this.height+'px;z-index:2"></div>';
		html1+=   '<div class="icoimgCover_down" style="position:absolute;left:0px;top:0px;width:'+this.width+'px;height:'+this.height+'px;z-index:-1"></div>';
		html1+='</div>';

	var text='';
		this.board.innerHTML="<table width='"+(this.divwidth)+"' height='"+(this.divheight)+"' style=\"table-layout:fixed;\" ><tr><td align='center' valign='middle' style=\"overflow:hidden;\" id='html_"+this.id+"'>"+html1+"</td>"+text+"</tr></table>";
	
	
	var self=this;
	//创建空层
	
		this.icoblank=document.createElement("div");
		this.icoblank.style.position="absolute";
		this.icoblank.className='task_Icoblank';
		this.icoblank.title=this.text;
		
		this.board.appendChild(this.icoblank);
		this.icoblank.style.cssText="position:absolute;;left:0px;top:0px; background:url('dzz/images/b.gif');width:"+this.divwidth+"px; height:"+this.divheight+"px;z-index:"+(this.zIndex+1);
		
		//jQuery(this.icoblank).attr('data-toggle',"tooltip").attr('data-original-title',this.text);
		/*switch(_config.space.taskbar){
			case 'top':
				jQuery(this.icoblank).tooltip('destroy').tooltip({placement:'bottom',container:'body'});
				break;
			case 'bottom':
				jQuery(this.icoblank).tooltip('destroy').tooltip({placement:'top'});
				break;
			case 'left':
				jQuery(this.icoblank).tooltip('destroy').tooltip({placement:'right'});
				break;
			case 'right':
				jQuery(this.icoblank).tooltip('destroy').tooltip({placement:'left'});
				break;
		}*/
	//创建背景层
	
		this.board_background=document.createElement("div");
		this.board_background.className='backgound_radius';
		this.board.appendChild(this.board_background);
		this.board_background.style.cssText="position:absolute;left:2px;top:2px;z-index:-5;width:"+(this.divwidth-6)+"px;height:"+(this.divheight-6)+"px;";
	//事件处理	
		var el=jQuery(this.icoblank);
		
		el.on('mouseenter',function(){jQuery(self.board).addClass('hover');});
		el.on('mouseleave',function(){jQuery(self.board).removeClass('hover');});
		el.on('click',function(){ 
			if(self.winid){
				if(jQuery('#'+self.winid).hasClass('window_current')){
					_dock.Min(self.id);
				}else{
					_window.windows[self.winid].Focus();
				}
			}else{
				if(self.icoid) _ico.Open(self.icoid);
				else OpenApp(self.id.replace('app_',''));
			}
		});
		
		if(this.winid){
			jQuery(this.board).off();
		 	el.on('contextmenu',function(e){ _contextmenu.task_right_Ico(e?e:window.event,self.id); return false;});
		}else{
			if(this.icoid>0) _Drag.init(this.icoid,this.board,'','taskbar_dock');
			el.on('contextmenu',function(e){ _contextmenu.right_ico(e?e:window.event,self.icoid?self.icoid:self.id,'',self.container); return false;});
		}
		
		
		
		//if(this.Parent=='Recycle')	jQuery(this.icoblank).bind('contextmenu',function(e){ self.Icomenu(e?e:window.event); return false;});
		//jQuery(this.icoblank).bind('click',function(e){ _config.OpenApp(self.id);return false;});
		
		document.getElementById('taskbar_dock_inner').appendChild(this.board);
		var p=this.getpos();
		this.left=p[0];
		this.top=p[1];
		this.board.style.left=this.left+'px';
		this.board.style.top=this.top+'px';
		this.board.style.width=(this.divwidth)+'px';
		this.board.style.height=(this.divheight)+'px';
		this.board.style.zIndex=this.zIndex;
		//this.board.style.overflow="hidden";
		this.board.style.position='absolute';
		_dock.setDockSize();
		if(this.winid) _dock.setCurrent(this.id);
};
_dock.prototype.getpos=function(){
	
	var pos=[];
	if(_layout.taskbar_direction<2){
		pos[0]=this.pos*(this.divwidth+_dock.padding);
		pos[1]=0;
	}else{
		pos[1]=this.pos*(this.divheight+_dock.padding);
		pos[0]=0;
	}
	return pos;
};

_dock.getIndex=function(id){
	
	var index=0;
	for(var i=0 ;i<_config.dockTaskList.length;i++){
		var task=_dock.icos[_config.dockTaskList[i]];
		if(task.pined) index=task.icoid;
		if(_config.dockTaskList[i]==id) break;
	}
	if(index<1){
		for(var i=0 ;i<_config.dockTaskList.length;i++){
			var task=_dock.icos[_config.dockTaskList[i]];
			if(task.pined){
				 index=task.icoid;break;
			}
		}
	}
	return index;
}
_dock.setDockList=function(){
	var docklist=[];
	
}
_dock.Change=function(taskid,img,title,error){
	var task=_dock.icos[taskid];
	if(!task) return;
	task.img=img;
	task.text=title;
	jQuery(task.icoblank).attr('title',title);
	jQuery(task.board).find('img').attr('onload','_ico.image_resize(this,'+task.width+','+task.height+','+task.ispng+')').attr('onerror','_ico.icoimgError(this,'+task.width+','+task.height+')').attr('src',img).attr('error',error);
}
_dock.cancelCurrent=function(taskid){
	jQuery('#task_'+taskid).removeClass('task-current');
}
_dock.setCurrent=function(taskid){
	jQuery('#taskbar_dock .'+_dock.className).removeClass('task-current');
	var el=jQuery('#task_'+taskid);
	el.addClass('task-current');
	var obj=_dock.icos[taskid];
	if(!obj) return;
	var el1=jQuery('#taskbar_dock_inner');
	
	//判断位置如果不可见，设置其可见
	var pos_dock=jQuery('#taskbar_dock').offset();
	if(jQuery('#taskbar').hasClass('taskbar-bottom') || jQuery('#taskbar').hasClass('taskbar-top')){  //水平时
		var left=parseInt(jQuery('#taskbar_dock_inner').css('left'));
		
		if((left+obj.left)<0){
			el1.animate({'left':left+obj.left},500,function(){
				_dock.setDockScroller();
			});
		}else if((left+obj.left)>jQuery('#taskbar_dock').width()){
			el1.animate({'left':jQuery('#taskbar_dock').width()-obj.left-el.width()},500,function(){
				_dock.setDockScroller();
			});
		}
	}else{
		var top=parseInt(jQuery('#taskbar_dock_inner').css('top'));
		if((top+obj.top)<0){
			el1.animate({'top':-obj.top+'px'},500,function(){
				_dock.setDockScroller();
			});
		}else if((top+obj.top)>jQuery('#taskbar_dock').height()){
			el1.animate({'top':jQuery('#taskbar_dock').height()-obj.top-el.height()},500,function(){
				_dock.setDockScroller();
			});
		}
	}
	
}



_dock.refreshlist=function(){
	var tasklist=_config.dockTaskList;
	for(var i=0;i<tasklist.length;i++){
		if(!_dock.icos[tasklist[i]]) continue;
		_dock.icos[tasklist[i]].pos=i;
		if(_layout.taskbar_direction>1){
			
			_dock.icos[tasklist[i]].top=i*(_dock.divheight+_dock.padding);
			_dock.icos[tasklist[i]].left=0;
			jQuery('#task_'+tasklist[i]).css('top',i*(_dock.divheight+_dock.padding)).css('left',0);
		}else{
			jQuery(_dock.icos[tasklist[i]]).tooltip({placement:'top'});
			_dock.icos[tasklist[i]].left=i*(_dock.divwidth+_dock.padding);
			_dock.icos[tasklist[i]].top=0;
			jQuery('#task_'+tasklist[i]).css('left',i*(_dock.divwidth+_dock.padding)).css('top',0);
		}
		_dock.setDockSize();
	}
	//修正窗口打开的没有任务栏的问题
	
}
_dock.Dtask=function(taskid){
	//删除_config.dockTaskList;
	if(_dock.icos[taskid] && _dock.icos[taskid].pined>0){
		var self = _dock.icos[taskid];
		self.winid=null;
		var el=jQuery(self.icoblank);
		el.on('click',function(){ 
			if(self.winid){
				if(jQuery('#'+self.winid).hasClass('window_current')){
					_window.windows[self.winid].Min();
				}else{
					_window.windows[self.winid].Focus();
				}
			}else{
				if(self.icoid) _ico.Open(self.icoid);
				else OpenApp(self.id.replace('app_',''));
			}
		});
		if(self.icoid) _Drag.init(self.icoid,self.board,'','taskbar_dock');
		if(self.winid){
		 	el.on('contextmenu',function(e){ _contextmenu.task_right_Ico(e?e:window.event,self.id); return false;});
		}else{
			el.on('contextmenu',function(e){ _contextmenu.right_ico(e?e:window.event,self.icoid?self.icoid:self.id,'',self.container); return false;});
		}
		
		_dock.Change(taskid,self.data.img,self.data.name);
	}else{
		jQuery(_dock.icos[taskid].board).remove();
		for(var key in _dock.icos[taskid] ) delete _dock.icos[taskid][key];
		delete _dock.icos[taskid];
		var arr=new Array();
		for(var i=0;i<_config.dockTaskList.length;i++){
			if((_config.dockTaskList[i]+'')!=(taskid+'')){
				arr.push(_config.dockTaskList[i]);
			}
		}
		_config.dockTaskList=arr;
		_dock.refreshlist();
	}
	_dock.cancelCurrent(taskid);
};
_dock.reCtask=function(oid,id,winid,data,pos){
	//删除原任务
	jQuery(_dock.icos[oid].board).remove();
	for(var key in _dock.icos[oid] ) delete _dock.icos[oid][key];
	delete _dock.icos[oid];
	//新建任务
	var obj= new _dock(id,winid,data);
	obj.pos=pos;
	obj.create();
}
_dock.resetTask=function(oid,tid){
	//删除_config.dockTaskList;
	var arr=new Array();
	var oldtask=_dock.icos[oid];
	var pos=_config.dockTaskList.length-1;
	var odata={winid:oldtask.winid,data:oldtask.data}
	for(var i=0;i<_config.dockTaskList.length;i++){
		if(_config.dockTaskList[i]==oid){
			_config.dockTaskList[i]=tid;
			pos=i;
			break;
		}
	}

	_dock.reCtask(oid,tid,odata.winid,'',pos);
	//_dock.Ctasklist();
};

_dock.prototype.jump=function(start){
	var self=this;
	if(start){
		if(jQuery.inArray(this.id,_dock.jumps)>-1) return ;
		if(this.jumpTimer) window.clearInterval(this.jumpTimer);
		_dock.jumps.push(this.id);
		var flag=_dock.check_dock_up_ico_jump();
		this.jumpTimer=window.setInterval(function(){
			if(flag){
				jQuery('#dock_dock_up_ico').toggleClass('hover');
			}
			jQuery(self.board).toggleClass('hover');
		},300);
		
	}else{
		_dock.jumps.splice(jQuery.inArray(this.id,_dock.jumps),1);
		var flag=_dock.check_dock_up_ico_jump();
		window.clearInterval(this.jumpTimer);
		jQuery(self.board).removeClass('hover');
		if(flag) jQuery('#dock_dock_up_ico').removeClass('hover');
	}
};


_dock.Focus=function(id){
	jQuery('#shadow').hide();
	var obj=_dock.icos[id];
	if(_window.windows[obj.winid].MAX) jQuery('#titleBar_'+obj.winid).find('.RESTORE:visible').trigger('click');
	else  _window.windows[obj.winid].Focus();
};
_dock.Max=function(id){
	jQuery('#shadow').hide();
	var obj=_dock.icos[id];
	if(_window.windows[obj.winid].MAX!=1) jQuery('#titleBar_'+obj.winid).find('.MAX:visible').trigger('click');
	else _window.windows[obj.winid].Focus();
	
};
_dock.Min=function(id){
	jQuery('#shadow').hide();
	var obj=_dock.icos[id];
	jQuery('#titleBar_'+obj.winid).find('.MIN:visible').trigger('click');
};
_dock.Close=function(id){
	jQuery('#shadow').hide();
	var obj=_dock.icos[id];
	_dock.Change(id,obj.data.img,obj.data.name);
	//_window.windows[obj.winid].Close();
	jQuery('#titleBar_'+obj.winid).find('.CLOSE:visible').trigger('click');
};
_dock.setDockSize=function(){
	//if(_layout.navbars[_config.currentDesktop] && _layout.navbars[_config.currentDesktop].dockshow==2) return;
	//if(_config.gid>0) return;
	if(jQuery('#taskbar').hasClass('taskbar-bottom') || jQuery('#taskbar').hasClass('taskbar-top')){ 
		var widths={};
		var spacerWidth=0;
		widths['start']=_config.dockWidth;
		spacerWidth+=jQuery('#taskbar_spacer_start').outerWidth(true);
		jQuery('#taskbar_start').css('width',widths['start']);
		widths['tray']=jQuery('#taskbar_tray .Icoblock').size()*_config.dockWidth;
		jQuery('#taskbar_tray').css('width',widths['tray']);
		 spacerWidth+=jQuery('#taskbar_spacer_tray').outerWidth(true);
		
		jQuery('#taskbar_spacer_tray').show();
		widths['dock']=_config.screenWidth-widths['start']-widths['tray']-spacerWidth;
		jQuery('#taskbar_dock').css('width',widths['dock']).css('height',_config.dockHeight);
		jQuery('#taskbar_dock_inner').css('width',(_dock.divwidth+_dock.padding)*_config.dockTaskList.length-_dock.padding).css('height',_config.dockHeight);
	}else{
		var heights={};
		var spacerHeight=0;
		heights['start']=_config.dockHeight;
		spacerHeight+=jQuery('#taskbar_spacer_start').outerHeight(true);
		jQuery('#taskbar_start').css('height',heights['start']);
		
		heights['tray']=jQuery('#taskbar_tray .Icoblock').size()*_config.dockHeight;
		jQuery('#taskbar_tray').css('height',heights['tray']);
			 spacerHeight+=jQuery('#taskbar_spacer_tray').outerHeight(true);
		jQuery('#taskbar_spacer_tray').show();

		heights['dock']=_config.screenHeight-heights['start']-heights['tray']-spacerHeight;
		jQuery('#taskbar_dock').css('height',heights['dock']).css('width',_config.dockWidth);
		jQuery('#taskbar_dock_inner').css('height',(_dock.divheight+_dock.padding)*_config.dockTaskList.length-_dock.padding).css('width',_config.dockHeight);
	}
	_dock.setDockScroller();
};
_dock.setDockScroller=function(){//显示dock条的滚动条
	if(jQuery('#taskbar').hasClass('taskbar-bottom') || jQuery('#taskbar').hasClass('taskbar-top')){  //水平时
		//纠正left
		if(jQuery('#taskbar_dock_inner').width()<jQuery('#taskbar_dock').width()){
			jQuery('#taskbar_dock_inner').css({'left':0,'top':0});
		}else if(jQuery('#taskbar_dock_inner').width()+parseInt(jQuery('#taskbar_dock_inner').css('left'))<jQuery('#taskbar_dock').width()){
			jQuery('#taskbar_dock_inner').css({'left':jQuery('#taskbar_dock').width()-jQuery('#taskbar_dock_inner').width(),'top':0})
		}
		//判断左边滚动按钮
		if(parseInt(jQuery('#taskbar_dock_inner').css('left'))<0){ //dock_inner 层的left<0时出现左侧滚动按钮；
			jQuery('#taskbar_spacer_start').addClass('taskbar-spacer-left').off()
			.mousedown(function(){
				jQuery('#taskbar_dock_inner').animate({'left':'0px'},Math.abs(parseInt(jQuery('#taskbar_dock_inner').css('left'))));
				return false;
			})
			.mouseup(function(){
				jQuery('#taskbar_dock_inner').stop();
				_dock.setDockScroller();
				return false;
			});
		}else{
			jQuery('#taskbar_spacer_start').removeClass('taskbar-spacer-left').off();
		}
		//判断右侧滚动条
		if(jQuery('#taskbar_dock_inner').width()+parseInt(jQuery('#taskbar_dock_inner').css('left'))>jQuery('#taskbar_dock').width()){
			 var runwidth=jQuery('#taskbar_dock_inner').width()-jQuery('#taskbar_dock').width();
			jQuery('#taskbar_spacer_tray').addClass('taskbar-spacer-right').off()
			.mousedown(function(){
				jQuery('#taskbar_dock_inner').animate({'left':'-'+runwidth+'px'},runwidth);
				return false;
			})
			.mouseup(function(){
				jQuery('#taskbar_dock_inner').stop();
				_dock.setDockScroller();
				return false;
			});
		}else{
			jQuery('#taskbar_spacer_tray').removeClass('taskbar-spacer-right').off();
		}
	
	}else{ //垂直时
		if(jQuery('#taskbar_dock_inner').height()<jQuery('#taskbar_dock').height()){
			jQuery('#taskbar_dock_inner').css({'top':'0px','left':'0px'});
		}else if(jQuery('#taskbar_dock_inner').height()+parseInt(jQuery('#taskbar_dock_inner').css('top'))<jQuery('#taskbar_dock').height()){
			jQuery('#taskbar_dock_inner').css({'top':jQuery('#taskbar_dock').height()-jQuery('#taskbar_dock_inner').height(),'left':0})
		}
		//判断左边滚动按钮
		if(parseInt(jQuery('#taskbar_dock_inner').css('top'))<0){ //dock_inner 层的left<0时出现左侧滚动按钮；
		    var runwidth=jQuery('#taskbar_dock_inner').height()-jQuery('#taskbar_dock').height();
			jQuery('#taskbar_spacer_start').addClass('taskbar-spacer-left').off()
			.mousedown(function(){
				jQuery('#taskbar_dock_inner').animate({'top':'0px'},Math.abs(parseInt(jQuery('#taskbar_dock_inner').css('top'))));
				return false;
			})
			.mouseup(function(){
				jQuery('#taskbar_dock_inner').stop();
				_dock.setDockScroller();
				return false;
			});
		}else{
			jQuery('#taskbar_spacer_start').removeClass('taskbar-spacer-left').off();
			
		}
		//判断右侧滚动条
		if(jQuery('#taskbar_dock_inner').height()+parseInt(jQuery('#taskbar_dock_inner').css('top'))>jQuery('#taskbar_dock').height()){
			 var runwidth=jQuery('#taskbar_dock_inner').height()-jQuery('#taskbar_dock').height();
			
			jQuery('#taskbar_spacer_tray').addClass('taskbar-spacer-right').off()
			.mousedown(function(){
				jQuery('#taskbar_dock_inner').animate({'top':'-'+runwidth+'px'},runwidth);
				return false;
			})
			.mouseup(function(){
				jQuery('#taskbar_dock_inner').stop();
				_dock.setDockScroller();
				return false;
			});
		}else{
			jQuery('#taskbar_spacer_tray').removeClass('taskbar-spacer-right').off();
		}
	}
}
