﻿/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function _Drag(icoid,container)
{
	this.id=this.name=icoid+'_'+container;
	this.string="_Drag.icos."+this.id;
	this.icoid=String(icoid);
	this.width=_Drag.width;
	this.height=_Drag.height;
	this.top=0;
	this.left=0;
	this.text='title';
	this.img='dzz/images/b.gid';
	this.url='#';
	this.container=container;
	if(container=='icosContainer_dim'){
		this.uid=icoid.replace('uid_','');
		this.data={icoid:0,type:'user',oid:this.uid};
	}else if(container=='chatbox'){
		this.data=_config.sourcedata.icos[icoid];
	/*}else if(container=='taskbar_dock'|| container=='_dock'){
		this.data=_dock.icos[icoid].data;*/
	}else{
		this.data=_config.sourcedata.icos[icoid];
	}
	this.icos=[];
	this.copy_data={}
	//this.className=_window.ClassName
	_Drag.icos[this.id]=this;
};
_Drag.delay=500;
_Drag.width=120;
_Drag.height=120;
_Drag.icos={};
_Drag.Version="dzz.cc js 1.0";
_Drag.onmousemove=null;
_Drag.onmouseup=null;
_Drag.tach=null;
_Drag.onselectstart=1;
_Drag.init=function(icoid,ele,filemanageid,container,type){
	if(!type) type='';
	var obj= new _Drag(icoid,container,type);
	obj.board=ele;
	obj.width=jQuery(ele).outerWidth(true);
	obj.height=jQuery(ele).outerHeight(true);
	jQuery(obj.board).on('mousedown.drag',function(e){
		e=e?e:window.event;
		var tag = e.srcElement ? e.srcElement :e.target;
		
		if(tag.type=="text"||tag.type=="textarea"){
			return true;
		}		
		obj.Mousedown(e?e:window.event);
		dfire('mousedown');
		return false;
	});
	jQuery(obj.board).on('mouseup.drag',function(e){
		e=e?e:window.event;
		var tag = e.srcElement ? e.srcElement :e.target;
		
		if(tag.type=="text"||tag.type=="textarea"){
			return true;
		}		
		obj.Mouseup(e?e:window.event);
		dfire('mouseup');
		return false;
	});
	
	return obj;
	
}

_Drag.prototype.DetachEvent=function(e)
{
	if(!_Drag.tach) return;
	document.body.style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	document.onmousemove=_Drag.onmousemove;
	document.onmouseup=_Drag.onmouseup;
	document.onselectstart=_Drag.onselectstart;
	
	if(this.board.releaseCapture) this.board.releaseCapture();
	
	_Drag.tach=0;
	_Drag.finishblank=0;
	
};
_Drag.prototype.AttachEvent=function(e)
{ 
	  
	if(_Drag.tach) return
	
	_Drag.onmousemove=document.onmousemove;
	_Drag.onmouseup=document.onmouseup;
	_Drag.onselectstart=document.onselectstart;
	try{
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else{
			if(this.board.setCapture) this.board.setCapture();
		}
	}catch(e){};
	_Drag.tach=1;
};
_Drag.prototype.Duplicate=function()
{
	this.copy=document.createElement('div');
	this.copy.className='DragCopy';
	document.body.appendChild(this.copy);
	if(this.container=='icosContainer_dim'){
		this.copy.className=jQuery('#DIM_buddyListPanel').attr('class');
	};
	
	
	if(this.icos.length>0){
		this.copy.style.cssText="position:absolute;left:0px;top:0px;width:"+_config.screenWidth+"px;height:"+_config.screenHeight+"px;z-index:5000;overflow:visible;";
		for(var i in this.icos){
			var obj=_Drag.icos[this.icos[i]+'_'+this.container];
			this.copy_data[this.icos[i]]={};
			var div=document.createElement('div');
			div.className="icocopy";
			div.setAttribute('icoid',this.icos[i]);
			div.innerHTML=jQuery(obj.board).html(); 
			var p=jQuery(obj.board).offset();
			this.copy_data[this.icos[i]].left=p.left;
			this.copy_data[this.icos[i]].top=p.top;
			div.style.cssText="position:absolute;left:"+(p.left)+"px;top:"+(p.top)+"px;width:"+(obj.width)+"px;height:"+(obj.height)+"px;filter:Alpha(opacity=50);opacity:0.5;z-index:5000;overflow:hidden";
			this.copy.appendChild(div);
		}
	}else{
		var p=jQuery(this.board).offset();
		this.copy.innerHTML=jQuery(this.board).html(); 
		this.copy.style.cssText="position:absolute;left:"+(p.left)+"px;top:"+(p.top)+"px;width:"+(this.width)+"px;height:"+(this.height)+"px;filter:Alpha(opacity=50);opacity:0.5;z-index:5000;";
	}
	//jQuery(this.copy).find('#text'+this.id).html('&nbsp;');
	jQuery(this.copy).find('.backgound_radius,.icoblank').remove();
	
};
_Drag.prototype.Createblank=function()
{
	jQuery('#_blank').empty();
	var self=this;
	var frage=document.createDocumentFragment();
	//生成桌面层
	var _shadow_bodys=document.createElement('div');
	_shadow_bodys.id="_shadow_icosContainer_body_"+_layout.fid;
	_shadow_bodys.style.position='absolute';
	var el=jQuery('#icosContainer_body_'+_layout.fid);
	_shadow_bodys.style.width=el.width()+'px';
	_shadow_bodys.style.height=el.height()+'px';
	_shadow_bodys.style.left=(parseInt(el.css('left'))+_layout._body_marginleft)+'px';
	_shadow_bodys.style.top=(_layout.margintop+_layout._body_margintop)+'px';
	_shadow_bodys.style.oveflow='visible';
	//_shadow_bodys.style.border='1px solid blue';
	frage.appendChild(_shadow_bodys);
	//生成桌面分页导航层
	jQuery('#page_nav_'+_layout.fid+' .page_nav_item').each(function(){
		var page=jQuery(this).attr('page');
		var pos=jQuery(this).offset();
		var div=document.createElement('div');
		div.id='_shadow_page_nav_item_'+page;
		div.style.cssText='position:absolute;height:'+jQuery(this).outerHeight(true)+'px;width:'+(jQuery(this).outerWidth(true))+'px;left:'+pos.left+'px;top:'+pos.top+'px;';
		jQuery(div).mouseenter(function(){
			if(_Drag.page_nav_delay_timer) window.clearTimeout(_Drag.page_nav_delay_timer);
			_Drag.page_nav_delay_timer=window.setTimeout(function(){_layout.setPage(page)},500);
		}).mouseleave(function(){
			if(_Drag.page_nav_delay_timer) window.clearTimeout(_Drag.page_nav_delay_timer);
		});
		frage.appendChild(div);
	});
	
	//生成taskbar层
	var taskbar=jQuery('#taskbar');
	var p=taskbar.offset();
	var _shadow_taskbar=document.createElement('div');
	_shadow_taskbar.id="_shadow_taskbar";
	_shadow_taskbar.style.cssText='position:absolute;height:'+taskbar.height()+'px;width:'+(taskbar.width())+'px;left:'+p.left+'px;top:'+p.top+'px;z-index:10001;';
	frage.appendChild(_shadow_taskbar);
	//生成dock容器层
	var el_dock=jQuery('#taskbar_dock');
	var _shadow_dock=document.createElement('div');
	var pos=el_dock.position();
	_shadow_dock.id="_shadow__dock";
	_shadow_dock.style.cssText='position:absolute;height:'+el_dock.height()+'px;width:'+(el_dock.width())+'px;left:'+pos.left+'px;top:'+pos.top+'px;overflow:hidden;';
	var scale=_dock.divwidth/this.divwidth;
	jQuery(_shadow_dock).mouseenter(function(){
		jQuery(self.copy).css({ '-moz-transform':'scale('+scale+')','-webkit-transform':'scale('+scale+')','-o-transform':'scale('+scale+')','transform':'scale('+scale+')'});
	}).mouseleave(function(){
		jQuery(this.copy).css({ '-moz-transform':'scale(1)','-webkit-transform':'scale(1)','-o-transform':'scale(1)','transform':'scale(1)'});
	});
	_shadow_taskbar.appendChild(_shadow_dock);
	

//生成当前桌面图标层
	jQuery('#icosContainer_body_'+_layout.fid).find('.Icoblock').each(function(){
		var obj=_ico.icos[this.id.replace('icon_','')];
		var div=document.createElement('div');
		div.id='_shadow_icon_'+obj.id;
		div.style.cssText='position:absolute;width:'+obj.divwidth+'px;height:'+obj.divheight+'px;left:'+(obj.left)+'px;top:'+(obj.top)+'px;z-index:'+obj.zIndex+';background: url(dzz/images/b.gif)';
		if(self.icoid!=obj.id && _config.sourcedata.icos[obj.id].type=='folder'){
			if(_config.sourcedata.icos[obj.id].flag=='recycle'){
				jQuery(div).css('cursor',"url('dzz/images/cur/aero_shan.cur'),auto");
			}else{
				jQuery(div).css('cursor',"url('dzz/images/cur/aero_ru.cur'),auto");
			}
			jQuery(div).mouseenter(function(e){
				var id=this.id.replace('_shadow_icon_','');
				jQuery(_ico.icos[id].board).addClass('hover');
			})
			.mouseleave(function(e){
				var id=this.id.replace('_shadow_icon_','');
				jQuery(_ico.icos[id].board).removeClass('hover');
			});
		}
		_shadow_bodys.appendChild(div);
		
	});
	//生成dock图标
	jQuery('#taskbar_dock').find('.task_Icoblock').each(function(){
		var obj=_dock.icos[this.id.replace('task_','')];
		var div=document.createElement('div');
		div.id='_shadow_task_'+obj.id;
		   if(_layout.taskbar_direction>1){
			   var top=parseInt(jQuery('#taskbar_dock_inner').css('top'));
			 	div.style.cssText='position:absolute;width:'+(obj.divwidth)+'px;height:'+(obj.divheight+_dock.padding)+'px;left:'+(obj.left)+'px;top:'+(obj.top+top)+'px;z-index:'+obj.zIndex+';background: url(dzz/images/b.gif);'; 
		   }else{
			     var left=parseInt(jQuery('#taskbar_dock_inner').css('left')); 
			   div.style.cssText='position:absolute;width:'+(obj.divwidth+_dock.padding)+'px;height:'+(obj.divheight)+'px;left:'+(obj.left+left)+'px;top:'+(obj.top)+'px;z-index:'+obj.zIndex+';background: url(dzz/images/b.gif);';
		   }
			
			if(self.icoid!=obj.icoid){
				if(obj.data.type=='folder'){
					 jQuery(div).css('cursor',"url('dzz/images/cur/aero_ru.cur'),auto");
				}
				jQuery(div).mouseenter(function(e){
					var id=this.id.replace('_shadow_task_','');
					if(_dock.icos[id].data.type=='folder'){
						jQuery(_dock.icos[id].board).addClass('hover');
					}
					
					if(_layout.taskbar_direction<2){
						for(var id1 in _dock.icos){
							if(_dock.icos[id].data.type=='folder') return; 
							if(_dock.icos[id1].left>=_dock.icos[id].left ) _dock.icos[id1].board.style.left=(_dock.icos[id1].left+_dock.icos[id1].divwidth+_dock.padding)+'px';
						}
					}else{		
							for(var id1 in _dock.icos){
								if(_dock.icos[id].data.type=='folder') return; 
								if(_dock.icos[id1].top>=_dock.icos[id].top ) _dock.icos[id1].board.style.top=(_dock.icos[id1].top+_dock.icos[id1].divheight+_dock.padding)+'px';
							}
					}
					
				}).mouseleave(function(e){
					var id=this.id.replace('_shadow_task_','');
					if(_dock.icos[id].data.type=='folder'){
						jQuery(_dock.icos[id].board).removeClass('hover');
					}
					for(var id1 in _dock.icos){
						 _dock.icos[id1].board.style.left=_dock.icos[id1].left+'px';
						 _dock.icos[id1].board.style.top=_dock.icos[id1].top+'px';
					}
					
				});
			}
			_shadow_dock.appendChild(div);
	});
	//生成挂件层
	/*jQuery('#_body_'+_config.currentDesktop).find('.widget_blank').each(function(){
		var wid=this.id.replace('_widget_blank','');
		var widget=_widget.widgets[wid];
		
			var blank=document.createElement('div');
			blank.style.position='absolute';
			blank.style.zIndex=widget.zIndex;
			var p=jQuery(this).offset();
			blank.style.left=p.left+'px';
			blank.style.top=p.top+'px';
			blank.style.overflow='hidden';
			blank.style.background='url(dzz/images/b.gif)';
			if(_config.Permission_Container('admin','icosContainer_body_'+_config.currentDesktop) && widget.data.idtype=='pluginid' && _config.sourcedata.plugin[widget.data.typeid] && _config.sourcedata.plugin[widget.data.typeid].acceptdata>0 && _config.sourcedata.icos[self.icoid] && jQuery.inArray(_config.sourcedata.icos[self.icoid].ext,_config.sourcedata.plugin[widget.data.typeid].datatype)>-1 ){
				
				blank.style.cursor="url('dzz/images/cur/aero_ru.cur'),auto";
			}else{
				blank.style.cursor="url('dzz/images/cur/aero_no.cur'),auto";	
			}
			blank.style.width=jQuery(this).width()+'px';
			blank.style.height=jQuery(this).height()+'px';
			blank.id='_widget_plugin_'+widget.id;
			frage.appendChild(blank);
		
	});*/
	//生成窗体层
	jQuery('.window_blank').each(function(){
		var winid=this.id.replace('_blank_','');
	
		var win=_window.windows[winid];
		
		//if(win.desktop!=_config.currentDesktop && win.desktop!='top') return ;
		var blank=document.createElement('div');
		blank.style.position='absolute';
		blank.style.zIndex=win.zIndex;
		var p=jQuery(this).offset();
		blank.style.left=p.left+'px';
		blank.style.top=p.top+'px';
		blank.style.overflow='hidden';
		blank.style.background='url(dzz/images/b.gif)';
		blank.style.width=jQuery(this).width()+'px';
		blank.style.height=jQuery(this).height()+'px';
		frage.appendChild(blank);
		if(win.id.indexOf('app_')!==-1 && this.selectall && _config.sourcedata.icos[this.icoid] && jQuery.inArray(_config.sourcedata.icos[this.icoid].ext,win.fileext)>-1){
			blank.id='_window_'+win.id;
			blank.style.cursor="url('dzz/images/cur/aero_ru.cur'),auto";
		}else if(win.type=='folder' ){
			blank.id='_window_'+win.id;
			if(win.treeshow){
				//创建左侧jstree层；
				var left=document.createElement('div');
				left.style.position='absolute';
				left.style.left='0px';
				left.style.top='0px';
				left.style.width=jQuery('#jstree_area_'+win.id).width()+'px';
				left.style.height='100%';
				left.style.overflow='hidden';
				left.style.zIndex=win.zIndex+1;
				left.id='_shadow_jstree_'+win.id;
				blank.appendChild(left);
				//创建jstree数内节点
				jQuery('#jstree_area_'+win.id+' li:visible').each(function(){
					var arr=this.id.split('-');
					var a=jQuery(this).find('a:first');
					
					var p1=a.offset();
					var div=document.createElement('div');
					div.id='_window_icosContainer_folder_'+arr[1];
					div.style.cssText='position:absolute;left:'+(p1.left-p.left)+'px;top:'+(p1.top-p.top)+'px;width:'+a.width()+'px;height:'+a.height()+'px;cursor:url("dzz/images/cur/aero_ru.cur"),auto;';
					jQuery(div).bind('mouseover',function(e){
						a.addClass('jstree-hovered');
					});
					jQuery(div).bind('mouseout',function(e){
							a.removeClass('jstree-hovered');
					});
					left.appendChild(div);
				});
			}
			
			//创建右侧层；
			var flag=0;
			if(win.filemanageid){
				var filemanage=_filemanage.cons[win.filemanageid];
				if(filemanage.bz){
					var arr=['f',filemanage.fid];
				}else{
					var arr=win.filemanageid.split('-');
				}
				var right=document.createElement('div');
				right.style.position='absolute';
				if(win.treeshow) right.style.left=jQuery('#jstree_area_'+win.id).width()+'px';
				else right.style.left='0px';
				right.style.top='0px';
				if(win.treeshow)  right.style.width=(win.bodyWidth-jQuery('#jstree_area_'+win.id).width())+'px';
				else right.style.width='100%';
				right.style.height='100%';
				right.style.overflow='hidden';
				right.id='_window_icosContainer_folder_'+arr[1];
				blank.appendChild(right);
				flag=1;
			}
			if(flag){//处理资源管理器右侧图标
			  if(win.treeshow) var jstree_width=jQuery('#jstree_area_'+win.id).width();
			  else var jstree_width=0;
			   if(parseInt(filemanage.view)==5){
					
					//生成目录内图标
					jQuery(win.contentCase).find('.detail_item_name').each(function(){
						var self1=this;
						
							var icoid=(jQuery(this).attr('icoid'));
						
						if(_config.sourcedata.icos[icoid].type!='folder') return;
						var div=document.createElement('div');
						div.id='_window_icosContainer_folder_'+_config.sourcedata.icos[icoid].oid;
						var p1=jQuery(this).offset();
						div.style.cssText='position:absolute;width:'+jQuery(this).width()+'px;height:'+jQuery(this).height()+'px;left:'+(p1.left-p.left-jstree_width)+'px;top:'+(p1.top-p.top)+'px;z-index:'+win.zIndex+';background: url(dzz/images/b.gif);cursor:url("dzz/images/cur/aero_ru.cur"),auto';
						jQuery(div).bind('mouseover',function(e){
							var id=this.id.replace('_shadow_icon_','');
							if(self.icoid==id) return;
							jQuery(self1).addClass('hover');
						});
						jQuery(div).bind('mouseout',function(e){
								
								jQuery(self1).removeClass('hover');
						});
						right.appendChild(div);
					});
			   }else if(parseInt(filemanage.view)==4){
					
					//生成目录内图标
					jQuery(win.contentCase).find('.detail_item_td_name').each(function(){
						var self1=this;
						
							var icoid=(jQuery(this).attr('icoid'));
						
						if(_config.sourcedata.icos[icoid].type!='folder') return;
						var div=document.createElement('div');
						div.id='_window_icosContainer_folder_'+_config.sourcedata.icos[icoid].oid;
						var p1=jQuery(this).offset();
						div.style.cssText='position:absolute;width:'+jQuery(this).width()+'px;height:'+jQuery(this).height()+'px;left:'+(p1.left-p.left-jstree_width)+'px;top:'+(p1.top-p.top)+'px;z-index:'+win.zIndex+';background: url(dzz/images/b.gif);cursor:url("dzz/images/cur/aero_ru.cur"),auto';
						jQuery(div).bind('mouseover',function(e){
							var id=this.id.replace('_shadow_icon_','');
							if(self.icoid==id) return;
							jQuery(self1).addClass('hover');
						});
						jQuery(div).bind('mouseout',function(e){
								
								jQuery(self1).removeClass('hover');
						});
						right.appendChild(div);
					});
				}else{
					//生成目录内图标
					jQuery(win.contentCase).find('.file-icoitem').each(function(){
						var self1=this;
						var icoid=(jQuery(this).attr('icoid'));
						if(_config.sourcedata.icos[icoid].type!='folder') return;
						var div=document.createElement('div');
						div.id='_window_icosContainer_folder_'+_config.sourcedata.icos[icoid].oid;
						var p1=jQuery(this).offset();
						
						div.style.cssText='position:absolute;width:'+jQuery(this).width()+'px;height:'+jQuery(this).height()+'px;left:'+(p1.left-p.left-jstree_width)+'px;top:'+(p1.top-p.top)+'px;z-index:'+win.zIndex+';background: url(dzz/images/b.gif);cursor:url("dzz/images/cur/aero_ru.cur"),auto;';
						jQuery(div).bind('mouseover',function(e){
							var id=this.id.replace('_shadow_icon_','');
							if(self.icoid==id) return;
							jQuery(self1).addClass('hover');
						});
						jQuery(div).bind('mouseout',function(e){
								jQuery(self1).removeClass('hover');
						});
						right.appendChild(div);
					});
				}	
			}
		}else{
			blank.id='_window_'+winid;
		}
	});
	
	
	
	document.getElementById('_blank').appendChild(frage);
	//_panel.Createblank();
	
	document.getElementById('_blank').style.display='block';
	//jQuery('#navbar').css('z-index',6000);
	_Drag.finishblank=1;
};


_Drag.prototype.Mousedown=function(e)
{
	e=e?e:window.event;
	if(e.button==2) return ;
	this.mousedowndoing=false;
	var XX=e.clientX;
	var YY=e.clientY;
	//alert('down');
	if(!_Drag.tach) this.AttachEvent(e);
	_Drag.even=e;
	var self=this;
	this.mousedownTimer=setTimeout(function(){self.PreMove(XX,YY);},200);
};
_Drag.prototype.Mouseup=function(e)
{
	if(_Drag.tach) this.DetachEvent(e);
	if(!this.mousedowndoing) {
		clearTimeout(this.mousedownTimer);
	}else this.Moved(e);
};

_Drag.prototype.PreMove=function(XX,YY)
{
	jQuery(this.board).removeClass('hover');
	this.width=jQuery(this.board).outerWidth(true);
	this.height=jQuery(this.board).outerHeight(true);
	//判断是否为多选拖动
	if(_config.selectall.icos.length>0 && this.container!='chatbox' && this.container!='taskbar_dock' && jQuery.inArray(this.icoid,_config.selectall.icos)>-1){
		this.icos=_config.selectall.icos;
		this.selectall=true;
	}else{
		this.icos=[this.icoid];
		this.selectall=false;
	}
	this.Duplicate();
	
	var self=this;
	this.Createblank();
	this.mousedowndoing=true;
	if (this.MoveTimer) clearTimeout(this.MoveTimer);
	
    if(this.icos.length>0){
		this.tl=XX;
		this.tt=YY;
	}else{
		var p=jQuery(this.board).offset();
		this.tl=XX-p.left;
		this.tt=YY-p.top;
	}
	
	if(!_Drag.tach) this.AttachEvent(_Drag.even);
	document.onmousemove=function(e){self.Move(e?e:window.event);return false;};
	document.onmouseup=function(e){self.Moved(e?e:window.event);return false;};
	 return false;
};
_Drag.prototype.Move=function(e)
{
	if(!_Drag.tach) return;
	var XX=e.clientX;
	var YY=e.clientY;
	if(XX<0) XX=0;
	if(YY<0) YY=0;
	if (XX>=_config.screenWidth-10) XX=_config.screenWidth;
	if (YY>_config.screenHeight) YY=_config.screenHeight;
	if (XX>=_config.screenWidth-10 && _layout.currentPage<_layout.page) _layout.setPageNext();
	if (XX<=10 && _layout.currentPage>1) _layout.setPagePrev();
	this.copy.style.left=(XX-this.tl)+"px";
	this.copy.style.top=(YY-this.tt)+"px";
	
};
_Drag.prototype.Moved=function(e)
{
	var self=this;
	if(_Drag.finishblank){
		jQuery('#_blank').empty().hide();
		//jQuery('#navbar').css('z-index',4000);
	}
	if(!e) e=getEvent();
	var XX=e.clientX;
	var YY=e.clientY;
	if(XX<0) XX=0;
	if(YY<0) YY=0;
	if (XX>_config.screenWidth) XX=_config.screenWidth;
	if (YY>_config.screenHeight) YY=_config.screenHeight;
	if(_Drag.tach)	this.DetachEvent(e);
	
	var obj = e.srcElement ? e.srcElement :e.target;
	var oid=this.id;
	var tid=obj.id;
	//alert(tid);
	if(!tid){
		this.reject();
		return;
	}else if(tid.indexOf('_window__W_app_')!==-1){
		var winid=tid.replace('_window_','');
		var win=_window.windows[winid];
		var targetname=document.getElementById('ifm_'+winid).name;
		var flag=0;
		if(this.icos.length>0){
			for(var i in this.icos){
				if(jQuery.inArray(_config.sourcedata.icos[this.icos[i]].ext,win.fileext)>-1){
					var data={};
					data.icodata=_config.sourcedata.icos[this.icos[i]];
					data.params={};
					data.params.multiple=false;
					_config.sendDataTo(targetname,data);
					flag++;
				}
			}
		}else{
			if(jQuery.inArray(this.data.ext,win.fileext)>-1){
				var data={};
				data.icodata=this.data;
				data.params={};
				data.params.multiple=false;
				_config.sendDataTo(targetname,data);
				flag++;
			}
		}
		if(flag>0){
			jQuery(this.copy).remove();
			jQuery('#_blank').empty().hide();
			return;
		}else{
			this.reject();
			return;
		}
	
	}
	
	
	if(this.checkMoveTo(tid,XX,YY)){
		this.IcoMoveSave(tid,XX,YY);
	}else{
		this.reject();
		return;
	}
	
};
_Drag.prototype.checkMoveTo=function(tid,XX,YY){
	/*if(this.data.notdelete>0){ //不容许删除的应用不允许移动
		return false;
	}*/
	/*if(this.data.flag!='' && this.data.type=='folder'){
		return false;
	}*/
	if(tid.indexOf('_shadow_icon_')!==-1){//是应用图标；
		var targetid=tid.replace('_shadow_icon_','');
		if(!_ico.icos[targetid]){
			return false;
		}
		
		var target=_ico.icos[targetid];
		
		//判断是否是移动到自己身上
		if(jQuery.inArray(targetid,this.icos)>-1 ){//移动到自己身
			if(_layout.autolist){//自动排列时弹回；
				return false;
			}
		}
		
		if(this.data.isdelete>0) return true; //回收站的允许移动到桌面
		
		for(var i in this.icos){
			var data=_config.sourcedata.icos[this.icos[i]];
			//没有删除权限的弹回;
			 if(!_config.Permission('admin',data) && this.data.pfid!=_config.space.typefid['desktop']){
				return false;
			}
			//默认目录不能更换目录；
			if(data.type=='folder' && data.flag!='' && data.isdelete<1 && data.pfid!=_config.space.typefid['desktop'] ) return false;
		}
		//目标是目录的情况
		if(_config.sourcedata.icos[targetid].type=='folder'){
			
			//通用 不能移动到目录的情况
			for(var i in this.icos){
				 var data=_config.sourcedata.icos[this.icos[i]];
				//默认目录不能更换目录；
			   if(data.type=='folder' && data.flag!='' && data.isdelete<1 && data.pfid!=_config.sourcedata.icos[targetid].oid) return false;
				//是目标目录的上级目录时弹回
				if(data.type=='folder' && _ico.isParentFid(data.oid,_config.sourcedata.icos[targetid].oid)) return false;
			}
			
			//判断目标目录是回收站时  
			if(_config.sourcedata.icos[targetid].oid==_config.space.typefid['recycle']){ //目标是回收站时 
				if(!_config.Permission('delete',this.data)) return false; //没有删除权限不能删除
			}else if(!_config.Permission_Container('admin',_config.sourcedata.icos[targetid].oid)){//目标目录没有权限弹回
				return false;
			}
		}
		if(!_config.Permission_Container('admin',_config.sourcedata.icos[targetid].pfid)){//目标目录没有权限弹回
			return false;
		}
		
		
		
	}else if(tid.indexOf('_shadow_task_')!==-1){//是dock图标；
		var targetid=tid.replace('_shadow_task_','');
		if(!_dock.icos[targetid]){
			return false;
		}
		//判断是否是移动到自己身上
		var isself=false;
		if(_dock.icos[targetid].data.icoid && jQuery.inArray(_dock.icos[targetid].data.icoid,this.icos)>-1 ){
			isself=true;
		}
		if(isself){//移动到自己身
			return false;
		}
		if(this.data.isdelete>0) return true; //回收站的允许移动到dock
		/*else if(this.data.pfid==_config.space.typefid['dock']){ //同目录的允许移动
			return true;
		}*/
		for(var i in this.icos){
			var data=_config.sourcedata.icos[this.icos[i]];
			//没有删除权限的弹回;
			 if(!_config.Permission('admin',data) && this.data.pfid==_config.space.typefid['dock']){
				return false;
			}
			//默认目录不能更换目录；
			if(data.type=='folder' && data.flag!='' && data.isdelete<1 && data.pfid!=_config.space.typefid['dock'] ) return false;
		}
		//目标是目录的情况
		if(_dock.icos[targetid].data.type=='folder'){
			//通用 不能移动到目录的情况
			for(var i in this.icos){
				var data=_config.sourcedata.icos[this.icos[i]];
				 
				 //默认目录不能更换目录；
				if(data.type=='folder' && data.flag!='' && data.isdelete<1 && data.pfid!=_dock.icos[targetid].data.oid) return false;
				//是目标目录的上级目录时弹回
				if(data.type=='folder' && _ico.isParentFid(data.oid,_dock.icos[targetid].data.oid)) return false;
				
			}
			
			//判断目标目录是回收站时  
			if(_dock.icos[targetid].data.oid==_config.space.typefid['recycle']){ //目标是回收站时 
				if(!_config.Permission('delete',this.data)) return false; //没有删除权限不能删除
			}else if(!_config.Permission_Container('admin',_dock.icos[targetid].data.oid)){//目标目录没有权限弹回
				return false;
			}
		}
		if(!_config.Permission_Container('admin',_dock.icos[targetid].data.pfid)){//目标目录没有权限弹回
			return false;
		}
		
		
		
	
	}else if(tid.indexOf('_shadow_icosContainer_body_')!==-1){//是桌面图标容器
		if(this.data.isdelete>0) return true; //回收站的允许移动到桌面
		if(this.data.isdelete<1 && this.data.pfid==_config.space.typefid['desktop']){ //同目录的允许移动
			return true;
		}
		for(var i in this.icos){
			var data=_config.sourcedata.icos[this.icos[i]];
			//没有删除权限的弹回;
			 if(!_config.Permission('admin',data)){
				return false;
			}
			//默认目录不能更换目录；
			if(data.type=='folder' && data.flag!='' && data.isdelete<1 && data.pfid!=_config.space.typefid['desktop'] ) return false;
			 
			//是目标目录的上级目录时弹回
			if(data.type=='folder' && _ico.isParentFid(data.oid,_config.space.typefid['desktop'])) return false;
		}
	
	}else if(tid.indexOf('_window_icosContainer_folder_')!==-1){//是目录窗体容器
		var fid=tid.replace('_window_icosContainer_folder_','');
		
		if(this.data.isdelete>0){
			if( fid!=_config.space.typefid['recycle']) return true //回收站的允许移动出来
			else return false;
		}
		if(this.data.pfid==fid) return false;//同目录的返回
		if(!_config.Permission_Container('admin',fid)){ //目标目录没有权限返回
			return false;
		}
		for(var i in this.icos){
			 var data=_config.sourcedata.icos[this.icos[i]];
			//没有删除权限的弹回;
			 if(!_config.Permission('admin',data)){
				return false;
			}
			//默认目录不能更换目录；
			if(data.type=='folder' && data.flag!='' && data.isdelete<1 && data.pfid!=fid) return false;
			 
			//是目标目录的上级目录时弹回
			
			if(data.type=='folder' && _ico.isParentFid(data.oid,fid)) return false;
		}
	
	}else if(tid.indexOf('_shadow__dock')!==-1){//是dock容器
		if(this.data.pfid==_config.space.typefid['dock']) return true;//同目录的允许
		if(this.data.isdelete>0) return true //回收站的允许移动出来；
		for(var i in this.icos){
			if(_dock.icos[this.icos[i]]) var data=_dock.icos[this.icos[i]].data;
			else var data=_config.sourcedata.icos[this.icos[i]];
			//没有删除权限的弹回;
			 if(!_config.Permission('admin',data)){
				return false;
			}
			
			//默认目录不能更换目录；
			if(data.type=='folder' && data.flag!='' &&  data.pfid!=_config.space.typefid['dock'] ) return false;
			 
			//是目标目录的上级目录时弹回
			if(data.type=='folder' && _ico.isParentFid(data.oid,_config.space.typefid['dock'])) return false;
		}
	}else{
		return false;
	}
	return true;
};
_Drag.prototype.DimMoveTo=function(tid,XX,YY){
	jQuery(this.copy).remove();
	jQuery('#_blank').empty().hide();
	if(tid.indexOf('_shadow_dim_group_')!==-1){//是好友组
		var groupid=tid.replace('_shadow_dim_group_','');
		_dim.changeGroup(this.uid,groupid);
		jQuery(this.copy).remove();
		jQuery('#_blank').empty().hide();
	}else if(tid.indexOf('_shadow_dim_user_')!==-1){//是好友
		var uid=tid.replace('_shadow_dim_user_','');
		var gid=jQuery('#DIMBuddy_'+uid).attr('gid');
		_dim.changeGroup(this.uid,gid);
	}else{
		this.IcoMoveSave(tid,XX,YY);
	}
};
_Drag.prototype.IcoMoveSave=function(tid,XX,YY){
	
	var self=this;
	if(this.icos.length>0){
		var data={"obz":'',"tbz":'',"sourcetype":"icoid","icoid":this.icos.join(','),"ticoid":0,"container":""};
	}else{
		var data={"obz":'',"tbz":'',"sourcetype":"icoid","icoid":this.icoid,"ticoid":0,"container":""};
	}
	if(this.container=='icosContainer_dim')
	{
		data.sourcetype='uid';
		data.icoid=this.uid;
		data.obz='';
	}else if(this.container=='chatbox'){
		data.sourcetype='icoid';
		data.iscut=2;
		data.obz=this.data.bz||'';
	}else if(this.container=='_dock'){
		data.sourcetype='icoid';
		data.icoid=_dock.icos[this.icoid].icoid;
		data.obz='';
	}else{
		data.sourcetype='icoid';
		data.obz=(this.data.bz)||'';
		if(data.obz){
			if(this.icos.length>0){
				var arr=[];
				for(var i=0 ;i<this.icos.length;i++){
					arr.push((_config.sourcedata.icos[this.icos[i]].path));
				}
				data.icoid=arr.join(',');
			}else{
				data.icoid=(this.data.path);
			}
		}
	}
	if(tid.indexOf('_shadow_icon_')!==-1){//是应用图标；
		var targetid=tid.replace('_shadow_icon_','');
		if(!_ico.icos[targetid]){
			this.reject();
			return;
		}
		if( _ico.icos[targetid].type!='folder' && !_config.Permission_Container('admin',_config.sourcedata.icos[targetid].pfid) ){
			this.reject();
			return ;
		}
	   data.ticoid=targetid;
	   data.tbz='';
	   if(_config.sourcedata.icos[targetid].type=='folder'){
		    pfid=_config.sourcedata.icos[targetid].oid;
	   }else{
		    pfid=_config.sourcedata.icos[targetid].pfid;
	   }
	  
	}else if(tid.indexOf('_shadow_task_')!==-1){//是应用图标；
		var targetid=tid.replace('_shadow_task_','');
		
		if(!_dock.icos[targetid]){
			this.reject();
			return;
		}
		if( _dock.icos[targetid].data.type!='folder' && !_config.Permission_Container('admin',_config.space.typefid['dock']) ){
			this.reject();
			return ;
		}
		if(_dock.icos[targetid]){
			if(_dock.icos[targetid].pined){
				  data.ticoid=_dock.icos[targetid].data.icoid;
				  pfid=_dock.icos[targetid].data.pfid;
			}else{
				var index=_dock.getIndex(targetid);
				if(index>0){
					  data.ticoid=index;
				}else{
					data.container='_dock_'+_config.space.typefid['dock'];
				} 
				pfid=_config.space.typefid['dock'];
			}
		}
	   data.tbz='';
	  
	}else if(tid=='_shadow__dock' || tid=='_window__dock'){//是dock标容器
		data.container='_dock_'+_config.space.typefid['dock'];
		pfid=_config.space.typefid['dock'];
		data.tbz='';
	}else if(tid.indexOf('_shadow_icosContainer_body_')!==-1 ){//是桌面图标容器
		var fid=tid.replace('_shadow_icosContainer_body_','');
		data.container='icosContainer_body_'+fid;
		pfid=fid;
		 data.tbz='';
	}else if(tid.indexOf('_window_icosContainer_folder_')!==-1){//是目录窗体容器
		var fid=tid.replace('_window_icosContainer_folder_','');
		pfid=fid;
		data.tbz=(_config.sourcedata.folder[fid].bz)||'';
		if(data.tbz){
			data.container='icosContainer_folder_'+(_config.sourcedata.folder[fid].path);
		}else{
			data.container='icosContainer_folder_'+fid;
		}
	}
	
	if(pfid==_config.space.typefid['recycle']){//回收站时的情况
		_ajax.delIco(this.icoid,true);
		jQuery(this.copy).remove();
		jQuery('#_blank').empty().hide();
		return;
	}
	//判断默认应用不能更换容器
	for(var i in this.icos){
		/*if(_config.sourcedata.icos[this.icos[i]].flag!='' && _config.sourcedata.icos[this.icos[i]].type=='folder'){
			self.reject();
			return ;
		}else */if(data.iscut<2 && pfid!=_config.space.typefid['recycle'] && data.sourcetype=='icoid'  && _config.sourcedata.icos[this.icos[i]] ){
			if(_config.sourcedata.icos[this.icos[i]].pfid!=pfid){
				self.reject();
				return ;
			}
		}
		if(data.container!='' && data.container!='chatbox' && !_config.Permission_Container('admin',pfid)){
			self.reject();
			return ;
		}
	}
	var progress='<div class="progress progress-striped active" style="margin:0"><div class="bar" style="width:100%;"></div></div>'
	//alert(_config.saveurl+'&do=move&gid='+_config.gid+'&'+jQuery.param(data));
	showmessage('<p>文件拖动处理中，请不要关闭浏览器或刷新页面</p>'+progress,'info',0,1,'right-bottom');
	jQuery(this.copy).remove();
	jQuery.getJSON(_config.saveurl+'&do=move&'+jQuery.param(data),function(json){
		
		if(json.msg=='success'){
				   self.icos=[];
					self.oicos=[];
					for(var ico in json.successicos){
						self.icos.push(json.successicos[ico]);
						self.oicos.push(ico);
					}
				if(json.iscopy>0){
					showmessage('文件复制成功！','success',3000,1,'right-bottom');
				}else{
					showmessage('文件移动成功！','success',3000,1,'right-bottom');
					self.remove();
				}
				for(var i in json.icoarr){
					_config.sourcedata.icos[json.icoarr[i].icoid]=json.icoarr[i];
				}
				for(var i in json.folderarr){
					_config.sourcedata.folder[json.folderarr[i].fid]=json.folderarr[i];
				}
				self.IcoMoveTo(tid,XX,YY,json.iscopy);
		}else{
			showmessage(json.error,'error',3000,1,'right-bottom');
			//self.reject();
			//Alert(json.error);
		}
	});
};
_Drag.prototype.remove=function(){//移除原来的icoid
	for(var i=0;i<this.oicos.length;i++){
		_ico.removeIcoid(this.oicos[i]);
	}
}
_Drag.prototype.IcoMoveTo=function(tid,XX,YY,iscopy){
	var self=this;
	if(tid.indexOf('_shadow_icon_')!==-1){//是应用图标；
 		var targetid=tid.replace('_shadow_icon_','');
	}else if(tid.indexOf('_shadow_task_')!==-1){//是应用图标；
		var targetid=tid.replace('_shadow_task_','');
	}else  var targetid='';
	_ico.appendIcoids(self.icos,targetid);
	
	jQuery(this.copy).remove();
};
_Drag.prototype.reject=function(){
	jQuery('#_blank').empty().hide();
	jQuery('#navbar').css('z-index',4000);
	//jQuery('#jstree_area .jstree-hovered').removeClass('jstree-hovered');
	//jQuery('.backgound_radius').removeClass('hover');
	if(this.icos.length>0 ){
		var el=jQuery(this.copy);
		el.animate({left:0,top:0},_config.delay,function(){
			jQuery(this).remove();
		});	
	}else{
		var el=jQuery(this.copy);
		var p=jQuery(this.board).offset();
		el.animate({left:p.left+'px',top:p.top+'px'},_config.delay,function(){
			jQuery(this).remove();
		});	
	}
	//if(this.container=='_dock'){
		jQuery('#taskbar_dock_inner').find('.task_Icoblock').each(function(){
			var obj=_dock.icos[this.id.replace('task_','')];
			obj.board.style.left=obj.left+'px';
			obj.board.style.top=obj.top+'px';
		});
	//}
	this.icos=[];
};
