/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function _ico(icoid,container,pos)
{

	this.id=icoid;
	if(container.indexOf('icosContainer_body_')!==-1) {
		
		this.iconview=_config.iconview[_layout.iconview]||{};
		this.divwidth=parseInt(this.iconview.divwidth)||_ico.divwidth;
		this.divheight=parseInt(this.iconview.divheight)||_ico.divheight;
		this.width=parseInt(this.iconview.width)||_ico.width;
		this.height=parseInt(this.iconview.height)||_ico.height;
		this.paddingleft=parseInt(this.iconview.paddingleft)||_ico.paddingLeft;
		this.paddingtop=parseInt(this.iconview.paddingtop)||_ico.paddingTop;
	}else{
		this.iconview={cssname:"middleicon"};
		this.divwidth=_ico.divwidth;
		this.divheight=_ico.divheight;
		this.width=_ico.width;
		this.height=_ico.height;
		this.paddingleft=_ico.paddingLeft;
		this.paddingtop=_ico.paddingTop;
	}
	
	this.string="_ico.icos."+this.id;
	this.zIndex=++_ico.zIndex;
	
	//ico大小
	
	
	//图标排列方式
	this.align=this.iconview.align*1||0;
	
	
	
	this.sourceid=_config.sourcedata.icos[icoid].oid || 0;
	this.type=_config.sourcedata.icos[icoid].type||'';
	
	this.text=_config.sourcedata.icos[icoid].name;
	
	/*if(!_config.Permission('open','',this.id)){
		if(this.type=='user'){
			this.img=_config.ucenterurl+'/images/noavatar_middle.gif';
		}else{
			this.img='dzz/images/default_ys/'+this.type+'.png';
		}
	}else{*/
		this.img=_config.sourcedata.icos[icoid].img||'dzz/images/default/icodefault.png';
	//}
	if(_config.sourcedata.icos[this.id].flag=='recycle'){
		if(_config.sourcedata.folder[this.sourceid] && _config.sourcedata.folder[this.sourceid].iconum>0){
			_config.sourcedata.icos[this.id].img=this.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/recycle1.png';
			this.error='dzz/images/default/system/recycle1.png';
		}else{
			_config.sourcedata.icos[this.id].img=this.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/recycle.png';
			this.error='dzz/images/default/system/recycle.png';
		}
		
	}else if(_config.sourcedata.icos[this.id].flag){
		this.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/'+_config.sourcedata.icos[this.id].flag+'.png';
		this.error='dzz/images/default/system/'+_config.sourcedata.icos[this.id].flag+'.png';
	}else if(_config.sourcedata.icos[this.id].type=='folder'){
		this.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/folder.png';
		this.error='dzz/images/default/system/folder.png';
	}else{
		this.error='dzz/images/default/icodefault.png';
	}
	this.url=_config.sourcedata.icos[icoid].url||'';
	this.open=_config.sourcedata.icos[icoid].open*1||0;
	this.notdelete=_config.sourcedata.icos[icoid].notdelete*1 ||0;
	this.defaultopen=_config.sourcedata.icos[icoid].defaultopen*1 || 0;
	this.wwidth=_config.sourcedata.icos[icoid].wwidth||0;
	this.wheight=_config.sourcedata.icos[icoid].wheight||0;
	
	if(_config.self>0) this.move="move";
	else this.move="no";
	this.className=_ico.ClassName;
	this.pos=pos;
	
	this.container=container;
	_ico.icos[this.id]=this;
};
	_ico.ClassName="Icoblock";
	_ico._defaultbgcolor='#eee';
	_ico.padding=5;
	_ico.Timer=10;
	_ico.icos={};
	_ico.wIndex=1000;
	_ico.zIndex=1000;
	_ico.clientWidth=0;
	_ico.clientHeight=0;
	_ico.onmousemove=null;
	_ico.onmouseup=null;
	_ico.tach=null;
	_ico.onselectstart=1;
	
	//默认 dock sys 图标大小
	
	
	
	//默认图标间距
	_ico.paddingLeft=10;
	_ico.paddingTop=10;
	_ico.Version="dzz! js 1.0";
_ico.ClickIcon=function(obj){
	var el=jQuery(obj);
	var op=el.attr('op');
	var icoid=el.attr('icoid');
	if(!op) return;
	switch(op){
		case 'download':
			if(_config.sourcedata.icos[icoid].type!='attach' && _config.sourcedata.icos[icoid].type!='image' && _config.sourcedata.icos[icoid].type!='document') return;
			_ico.downAttach(icoid);
			break;
		case 'share':
			_ico.UrlShare(icoid,_config.sourcedata.icos[icoid].name);
			break;
		case 'like':
			var val=0;
			if(!el.hasClass('liked_icon')){
				val=1;
			}
			el.toggleClass('liked_icon');
			_config.sourcedata.icos[icoid].liked=val;
			_ico.setTip_icoimg('liked',icoid);
			jQuery.get(DZZSCRIPT+'?mod=system&op=ajax&do=updatelike&icoid='+icoid+'&val='+val);
			break;
		case 'saveto':
				SelectPosition(function(position){
					var data={"sourcetype":"icoid","icoid":icoid,"ticoid":0,"container":position.container,"iscut":2};
					jQuery.getJSON(_config.saveurl+'&do=move&uid='+_config.myuid+'&'+jQuery.param(data),function(json){
						if(json.msg=='success'){
							showPrompt(null,'',_lang.add_success,1000);
							if(json.iscopy>0){
								for(var i in json.icoarr){
									_config.sourcedata.icos[json.icoarr[i].icoid]=json.icoarr[i];
								}
								for(var i in json.folderarr){
									_config.sourcedata.folder[json.folderarr[i].fid]=json.folderarr[i];
								}
							}
							var successicos=[];
							var osuccessicos=[];
							for(var ico in json.successicos){
								osuccessicos.push(ico);
								successicos.push(json.successicos[ico]);
							}
							_select.IcoPasteTo(successicos,osuccessicos,position.container,0,0,json.iscopy,0);
								
						}else{
							Alert(json.msg);
						}
					});
				});
				
			break;
		
	}
}

_ico.setTip=function(oid,sum,type){
	if(type){
		var icoids=_ico.geticoidFromOid(oid,type);
	}else{
		var icoids=[oid];
	}
	if(icoids.length<1) return;
	var jstr='';
	for(var i=0;i<icoids.length;i++){
		_config.icosTips[icoids[i]]=sum;
		if(i==icoids.length-1){
			jstr+='.Icoblock[icoid='+icoids[i]+']';
		}else{
			jstr+='.Icoblock[icoid='+icoids[i]+'],';
		}
	}
	 var el=jQuery(jstr);
	if(el.length<1) return;
	if(sum>0){
		if(sum<10){
			var size=1;
		}else if(sum<100){
			var size=2;
		}else if(sum<1000){
			var size=3;
		}else{
			var size=4;
		}
	
		if(el.find('.icobutton_tips').size()>0) el.find('.icobutton_tips') .html('<span class="icobutton_tips_inner tips_size_'+size+'">'+sum+'</span></div>');
		else{
			el1=jQuery('<div  class="icobutton_tips"><span class="icobutton_tips_inner tips_size_'+size+'">'+sum+'</span></div>').appendTo(el.find('.icoimgtips'));
		}
		
	}else{
		el.find('.icobutton_tips').remove();
	}
}

_ico.setTip_icoimg=function(type,icoid,containerid){//urlsid<1时表示取消此共享;
	if(icoid<1) return;
		if(containerid){
			 var el=jQuery('#'+containerid+' .Icoblock[icoid='+icoid+'] .icoimgtips');
		}else{
		 	var el=jQuery('.Icoblock[icoid='+icoid+'] .icoimgtips');
		}
		 el.each(function(){
			 switch(type){
				 case 'share':
					  if(jQuery(this).find('.icoimg_share_tips').size()<1){
						jQuery('<div class="icoimg_share_tips"></div>').appendTo(jQuery(this));
					 }
					 var el1=jQuery(this).find('.icoimg_share_tips');
					 if(_config.sourcedata.icos[icoid].urlsid>0 && _config.sourcedata.icos[icoid].shareid>0){
						el1.html('<div class="icoimg_share_tips_3"></div>');
					}else if(_config.sourcedata.icos[icoid].urlsid>0){
						el1.html('<div class="icoimg_share_tips_1"></div>');
					}else if(_config.sourcedata.icos[icoid].shareid>0){
						el1.html('<div class="icoimg_share_tips_2"></div>');	
					}else{
						el1.html('');
					}
					break
				case 'liked':
					 if(_config.sourcedata.icos[icoid].liked>0){
						if(jQuery(this).find('.icoimg_liked_tips').size()<1){
							jQuery('<div class="icoimg_liked_tips"></div>').appendTo(jQuery(this));
						 }
					}else{
						jQuery(this).find('.icoimg_liked_tips').remove();
					}
					break;
			 }
		 });
}
_ico.geticoidFromOid=function(oid,type){
	var icos=[];
	for (var icoid in _config.sourcedata.icos){
		if(_config.sourcedata.icos[icoid].uid==_config.space.uid && _config.sourcedata.icos[icoid].type==type && _config.sourcedata.icos[icoid].oid==oid){
			icos.push(icoid);
		}
	}
	return icos;
}

_ico.getPicIcos=function(icoid){
	var data ={};
	var icos=[];
	var current=0;
	var containericos=[];
	if(_ico.icos[icoid]){
		containericos=_config.screenList;
		
	}else if(_dock.icos[icoid]){
		containericos=_config.dockList;
	}else{
		var obj=_config.sourcedata.icos[icoid];
		if(!obj) return false;
		if(obj.isdelete>0){
			var pfid=_config.space.typefid['recycle'];
		}else	var pfid=obj.pfid;
		var currentdata={};
		for(var id in _filemanage.cons){
			if(id.indexOf('f-'+pfid+'-')!==-1){
				currentdata=_filemanage.cons[id].currentdata;
				break;
			}
		}
		for(id in currentdata){
			containericos.push(id.replace('icos_',''));
		}
	}
	for(id in containericos){
		if(_config.sourcedata.icos[containericos[id]].type=='image' ){
			icos.push(containericos[id]);
		}
	}
	for (var i=0;i<icos.length;i++){
		if(icos[i]==icoid) {
			current=i;
			break;
		}
	}
	if(icos.length<1){
		icos=[icoid];
		current=0;
	}
	data.pos=current;
	data.icos=icos;
	return data;
}
_ico.geticoidFromfid=function(fid){
	for(var icoid in _config.sourcedata.icos){
		if(_config.sourcedata.icos[icoid].type=='folder' && _config.sourcedata.icos[icoid].oid==fid){
			return icoid;
		}
	}
}
_ico.isParentFid=function(ofid,tfid){
	var value=false;
	if(ofid==tfid) return true;
	if(!_config.sourcedata.folder[tfid]) return false;
	var tdata=_config.sourcedata.folder[tfid];
	if(_config.sourcedata.folder[ofid].isdelete>0) ofid=_config.space.typefid['recycle'];
	if(tdata.isdelete>0) tdata.pfid=_config.space.typefid['recycle'];
	
	if(String(tdata.pfid)==String(ofid)) value=true;
	else if(String(tdata.pfid)!='0') value=_ico.isParentFid(ofid,tdata.pfid);
	else value=false;
	return value;
}
_ico.getTopFid=function(fid){
	var value=new Array();
	var data=_config.sourcedata.folder[fid];
	if(!data) return [];
	if(String(data.pfid)=='0') value.push(fid);
	else {
		value.push(data.fid);
		var value1=_ico.getTopFid(data.pfid);
		if(value1){
			for(var i=0;i<value1.length;i++){
				value.push(value1[i]);
			}
		}
	}
	
	return value;
};
_ico.createIco=function(data){
	var icosdata=data;
	//添加ico数据
	_ico.removeIcoid(data.icoid);
	_config.sourceids.icos.push(data.icoid);
	_config.sourcedata.icos[data.icoid]=icosdata;
	_ico.appendIcoids([data.icoid]);
}
_ico.getIcoidFromName=function(name,pfid,type){
	for(var icoid in _config.sourcedata.icos){
		if(_config.sourcedata.icos[icoid].name==name && _config.sourcedata.icos[icoid].pfid==pfid && _config.sourcedata.icos[icoid].type==type){
			return icoid;
		}
	}
	return null;
}

_ico.createFolder=function(json){
	//处理数据；
	_config.sourceids.icos.push(json.icoarr.icoid);
	_config.sourcedata.icos[json.icoarr.icoid]={};
	_config.sourcedata.icos[json.icoarr.icoid]=json.icoarr;
	if(!_config.sourceids.folder) _config.sourceids.folder=new Array(); 
	_config.sourceids.folder.push(json.folderarr.fid);
	if(!_config.sourcedata.folder) _config.sourcedata.folder={};
	_config.sourcedata.folder[json.folderarr.fid]=json.folderarr;

	//处理容器  添加此icoid；
	 _ico.appendIcoids([json.icoarr.icoid]);
		
}
/*_ico.resizeDesktops=function(){
	var navid=_layout.fid
	_layout.resize();
	jQuery('#_body_'+navid).css({width:(_config.screenWidth-_layout._body_marginleft-_layout._body_marginright),height:(_config.screenHeight-_layout._body_margintop-_layout._body_marginbottom)});
	if(document.getElementById('icosContainer_body_'+navid)){
		//alert([width,height,(divwidth+paddingleft),(divheight+paddingtop),sum_x,sum_y,page,_config.screenList[navid].icos.length]);
		jQuery('#icosContainer_body_'+navid).css({width:(_config.screenWidth*_layout.page-_layout.marginleft-_layout.marginright),height:(_config.screenHeight-_layout.margintop-_layout.marginbottom)});
		
		_ico.refreshList('icosContainer_body_'+navid);
	}
}*/
_ico.NewIco=function(type,fid){
	if(_config.sourcedata.folder[fid].bz && _config.sourcedata.folder[fid].bz!=''){
		var path=encodeURIComponent(_config.sourcedata.folder[fid].path);
	}else var path=fid;
	switch(type){
		case 'Newfolder':
			showWindow('newfolder',_config.ajaxurl+'&do=newfolder&path='+path);
			break;
		case 'Newlink':
			showWindow('newlink',_config.ajaxurl+'&do=newlink&path='+path , 'get', 0);
			break;
		case 'NewDzzDoc':
			showWindow('newdoc',_config.ajaxurl+'&do=newdoc&path='+path , 'get', 0);
			break;
		case 'NewTxt':
			showWindow('newtxt',_config.ajaxurl+'&do=newtxt&path='+path , 'get', 0);
			//_ajax.newDoc(container,'txt');
			break;
	}
}
_ico.Arrange=function(val,fid,type){
	switch(type){
		case 'iconview':
			if(fid==_layout.fid){//为桌面容器
				//设置导航的icoview值
				_layout.iconview=parseInt(val);
				//设置数据
				_config.space.iconview=parseInt(val);
				
				if(_config.Permission_Container('admin',_layout.fid)) jQuery.post(_config.saveurl+'&do=userfield&datename=iconview',{iconview:parseInt(val)});
			}/*else if(container.indexOf('icosContainer_folder_')!==-1){//为目录容器
				var fid=container.replace('icosContainer_folder_','')*1;
				//设置数据
				_config.sourcedata.folder[fid].iconview=parseInt(val);
				//保存选项
				_config.saveItem.folder.push(fid);
				
			}*/
			jQuery('#right_contextmenu .menu-icon-iconview').each(function(){
				if(jQuery(this).attr('pid')=='menu_icon_iconview_'+val) jQuery(this).removeClass('icon-notselect').addClass('icon-select');
				else jQuery(this).addClass('icon-notselect').removeClass('icon-select');
			});
			
			_ico.reCIcolist(fid);//重新生成桌面
			_layout.resize();
			break;
		
		case 'direction':
			//设置数据和保持选项
			if(fid==_layout.fid){//为桌面容器
				//设置导航的icoview值
				_layout.direction=parseInt(val);
				_config.space.direction=parseInt(val);
				if(_config.Permission_Container('admin',fid)) jQuery.post(_config.saveurl+'&do=userfield&dataname=direction',{direction:parseInt(val)});
			}else{//为目录容器
				return;
			}
			jQuery('#right_contextmenu .menu-icon-direction').each(function(){
				if(jQuery(this).attr('did')=='menu_icon_direction_'+val) jQuery(this).removeClass('icon-notselect').addClass('icon-select');
				else jQuery(this).addClass('icon-notselect').removeClass('icon-select');
			});
			_ico.refreshList(fid);
			break;
		case 'position':
			//设置数据和保持选项
			if(fid==_layout.fid){//为桌面容器
				//设置导航的icoview值
				_layout.iconposition=parseInt(val);
				_config.space.iconposition=parseInt(val);
				if(_config.Permission_Container('admin',fid)) jQuery.post(_config.saveurl+'&do=userfield&dataname=iconposition',{iconposition:parseInt(val)});
			}else{//为目录容器
				return;
			}
			jQuery('#right_contextmenu .menu-icon-position').each(function(){
				if(jQuery(this).attr('pid')=='menu_icon_position_'+val) jQuery(this).removeClass('icon-notselect').addClass('icon-select');
				else jQuery(this).addClass('icon-notselect').removeClass('icon-select');
			});
			_ico.refreshList(fid);
			break;
		case 'autolist':
			//设置数据和保持选项
			if(fid==_layout.fid){//为桌面容器
				//设置导航的icoview值
				_layout.autolist=parseInt(val);
				_config.space.autolist=parseInt(val);
				
				if(_config.Permission_Container('admin',fid)) jQuery.post(_config.saveurl+'&do=userfield&dataname=autolist',{autolist:parseInt(val)});
				
			}/*else if(container.indexOf('icosContainer_folder_')!==-1){//为目录容器
				var fid=container.replace('icosContainer_folder_','')*1;
				//设置数据
				_config.sourcedata.folder[fid].autolist=parseInt(val);
				_config.saveItem.folder.push(fid);
			}*/
			jQuery('#right_contextmenu .menu-icon-autolist').each(function(){
				if(jQuery(this).attr('pid')=='menu_icon_autolist_'+val) jQuery(this).removeClass('icon-notselect').addClass('icon-select');
				else jQuery(this).addClass('icon-notselect').removeClass('icon-select');
			});
			if(_layout.autolist>0) _ico.clearIconposition(fid);
			_ico.refreshList(fid);
			
			break;
	}
};
_ico.deleteFolderIcos=function(container){
	jQuery('#'+container).empty();
	for(var id in _ico.icos){
		var obj=_ico.icos[id];
		if(obj.container==container){
			for(var key in obj) delete obj[key];
			delete _ico.icos[id];
		}
	}
};
_ico.reCIcolist=function(pfid){
	//清除原容器和ico.icos数据
	var container=_config.getContainerByFid(pfid);
	jQuery('#'+container+' .Icoblock').remove();
	for(var id in _ico.icos){
		var obj=_ico.icos[id];
		if(obj.container==container){
			for(var key in obj) delete obj[key];
			delete _ico.icos[id];
		}
	}
	//创建此容器的所有icos
	if(pfid==_layout.fid){//为桌面容器
		var icos=_config.screenList;
	}/*else if(container.indexOf('icosContainer_folder_')!==-1){//为桌面容器
		var fid=container.replace('icosContainer_folder_','');
		var icos=_config.sourcedata.folder[fid].ids;
		
	}*/
	for(var pos=0;pos<icos.length;pos++){
		_ico.CIco(icos[pos],container,pos);
	}
};
_ico.clearIconposition=function(fid){
		var autolist=_layout.autolist;
		var icos=_config.screenList;
		for(var i in icos){
			_config.sourcedata.icos[icos[i]].position='';
		}
		if(_config.Permission_Container('admin',_layout.fid)){
			 jQuery.post(_config.saveurl+'&do=clearIcoposition&dataname=position&gid='+_config.gid,{"icoid[]":icos,fid:_layout.fid});
		}
};
_ico.refreshList=function(fid){
	var autolist=_layout.autolist;
	var icos=_config.screenList;
	var icos1=[];
		for(var i=0 ;i<icos.length; i++){
			if(autolist<1){
				if(_config.sourcedata.icos[icos[i]] && _config.sourcedata.icos[icos[i]].position!=''){
				
				}else{
					icos1.push(icos[i]);
				}
			}else{
				icos1.push(icos[i]);
			}
		}
	for(var i=0 ;i< icos1.length; i++){
		
		var obj=_ico.icos[icos1[i]];
		if(!obj) continue;
		obj.pos=i;
		var p=obj.getpos(i,fid,2);
		obj.left=p[0];
		obj.top=p[1];
		jQuery(obj.board).css({'left':obj.left,'top':obj.top});
	}
};

_ico.prototype.getpos=function (pos,container,autolist)   //纵向排列
{	
	
	var iconpositions= _layout.iconpositions||{};
	
	
	var width=_config.screenWidth-_layout.marginleft-_layout.marginright-_layout._body_marginleft-_layout._body_marginright;//jQuery('#'+container).width();
	var height=_config.screenHeight-_layout.margintop-_layout.marginbottom-_layout._body_margintop-_layout._body_marginbottom;//jQuery('#'+container).height();
	
	var divheight=this.divheight*1;
	var divwidth=this.divwidth*1;
	var paddingtop=this.paddingtop*1;
	var paddingleft=this.paddingleft*1;
    var cautolist=1;
	var dir=0;
	var p=0;
	//if(container.indexOf('icosContainer_body_')!==-1){//为桌面容器
		cautolist=_layout.autolist ||1;
		dir=_layout.direction||0;
		var sum=_config.screenList.length||0;
		p=_layout.iconposition*1 ||0;
	//}
	if( _config.sourcedata.icos[this.id].position && cautolist<1){
		var arr=_config.sourcedata.icos[this.id].position.split('_');
		var position=new Array(0,0);
		position[0]=isNaN(parseInt(arr[0]))?0:parseInt(arr[0]);
		position[1]=isNaN(parseInt(arr[1]))?0:parseInt(arr[1]);
		if(position[0]>width-this.divwidth) position[0]=width-this.divwidth;
		else if(position[0]<0) position[0]=0;
		if(position[1]>height-this.divheight) position[1]=height-this.divheight;
		else if(position[1]<0) position[1]=0;
		return position;
	}

	var sum_y=Math.floor((height+paddingtop)/(divheight+paddingtop));
	if(sum_y<1) sum_y=1;
	//if((sum_y*(divheight+paddingtop)+divheight)<height) sum_y+=1;
	var sum_x=Math.floor((width+paddingleft)/(divwidth+paddingleft));
	if(sum_x<1) sum_x=1;
	//if((sum_x*(divwidth+paddingleft)+divwidth)<width) sum_x+=1;
	var ox=width-sum_x*(divwidth+paddingleft);
	var oy=height-sum_y*(divheight+paddingtop);
//	var xx=(Ox-Math.floor(Ox/(wide+_ico.padding))*(wide+_ico.padding));
//	var yy=(Oy-Math.floor(Oy/(heigh+_ico.padding))*(heigh+_ico.padding));
  if(autolist!=2 ) autolist=cautolist;
   if(autolist>0){
	   if(dir){//横向排列时
	       var area=Math.floor(pos/(sum_x*sum_y));
		   var pos=pos%(sum_x*sum_y);
		   var position= new Array(0,0);
		   switch(p){
				case 0:
					if(pos>sum_x*sum_y-1) {
						var j=sum_x-1;
						var i=sum_y-1;
					}else{
						var i=Math.floor(pos/sum_x);
						var j=pos-i*sum_x;
					}
					position[0]=area*_config.screenWidth+j*(divwidth+paddingleft);
					position[1]=i*(divheight+paddingtop);
					break
				case 2:
					if(pos>sum_x*sum_y-1) {
						var j=sum_x-1;
						var i=0;
					}else{
						var i=sum_y-Math.floor(pos/sum_x)-1;
						 var j=(pos-Math.floor(pos/sum_x)*sum_x); 
					}
					position[0]=area*_config.screenWidth+j*(divwidth+paddingleft);
					position[1]=i*(divheight+paddingtop)+oy;
					break;
				case 1:
					if(pos>sum_x*sum_y-1) {
						var j=0;
						var i=sum_y-1;
					}else{
						var i=Math.floor(pos/sum_x);
						var j=sum_x-(pos-i*sum_x)-1;
					}
					position[0]=area*_config.screenWidth+j*(divwidth+paddingleft)+ox;
					position[1]=i*(divheight+paddingtop);
					break;
				case 3:
					if(pos>sum_x*sum_y-1) {
						var j=0;
						var i=0;
					}else{
						var j=sum_x-(pos-Math.floor(pos/sum_x)*sum_x)-1; 
						var i=sum_y-Math.floor(pos/sum_x)-1;
						//alert('x=='+j+'==i='+i);
					}
					position[0]=area*_config.screenWidth+j*(divwidth+paddingleft)+ox;
					position[1]=i*(divheight+paddingtop)+oy;
					break;
				case 4:
					var sum=0;
					if(_layout.autolist<1){
						for(var i in _config.screenList){
							if(_config.sourcedata.icos[_config.screenList[i]].position==''){
								sum++;
							}
						}
					}else{
						sum=_config.screenList.length
					}
					var shao_sum=sum_x*sum_y-sum;
					if(shao_sum>0)
					{
						var s=getsum(width,height,sum,divwidth+paddingleft,divheight+paddingtop);
					
						sum_x=s[0];
						sum_y=s[1];
						var y=Math.ceil(sum/sum_x);
						area=Math.floor(pos/(sum_x*sum_y));
					 	paddingleft=Math.floor((width-sum_x*divwidth)/(sum_x+1));
						paddingtop=Math.floor((height-y*divheight)/(y+1));
					}else{
					
					 	paddingleft=Math.floor((width-sum_x*divwidth)/(sum_x+1));
						paddingtop=Math.floor((height-sum_y*divheight)/(sum_y+1));
					}
					if(pos>sum_x*sum_y-1) {
						var j=sum_x-1;
						var i=sum_y-1;
					}else{
						var i=Math.floor(pos/sum_x);
						var j=pos-i*sum_x;
					}
					position[0]=area*_config.screenWidth+paddingleft+j*(divwidth+paddingleft);
					position[1]=paddingtop+i*(divheight+paddingtop);
					break;
		   }
		  
			return position;  
	   }else{//纵向排列时
	  	 var area=Math.floor(pos/(sum_x*sum_y));
		  var position= new Array(0,0);
		   switch(p){
				case 0:
					if(pos>sum_x*sum_y-1) {
						var j=Math.floor((pos%(sum_x*sum_y))/sum_y);
						var i=(pos%(sum_x*sum_y))-j*sum_y;
					}else{
						var j=Math.floor(pos/sum_y);
						var i=pos-j*sum_y;
					}
					position[0]=area*_config.screenWidth+j*(divwidth+paddingleft);
					position[1]=i*(divheight+paddingtop);
					break
				case 2:
					if(pos>sum_x*sum_y-1) {
						//var j=sum_x-1;
						//var i=0;
						
						var j=Math.floor((pos%(sum_x*sum_y))/sum_y);
						//var i=(pos%(sum_x*sum_y))-j*sum_y;
						var i=sum_y-((pos%(sum_x*sum_y))-j*sum_y)-1;
						//alert(pos%(sum_x*sum_y)+'==='+j+'==='+i+'====='+area);
					}else{
						var j=Math.floor(pos/sum_y);
						var i=sum_y-(pos-j*sum_y)-1;
					}
					position[0]=_config.screenWidth*area+j*(divwidth+paddingleft);
					position[1]=i*(divheight+paddingtop)+oy;
					break;
				case 1:
					if(pos>sum_x*sum_y-1) {
						//var j=0;
						//var i=sum_y-1;
						//var j=Math.floor((pos%(sum_x*sum_y))/sum_y);
						//var i=(pos%(sum_x*sum_y))-j*sum_y;
						var j=sum_x-Math.floor((pos%(sum_x*sum_y))/sum_y)-1;
						var i=((pos%(sum_x*sum_y))-Math.floor((pos%(sum_x*sum_y))/sum_y)*sum_y);
					}else{
						var j=sum_x-Math.floor(pos/sum_y)-1;
						var i=(pos-Math.floor(pos/sum_y)*sum_y);
					}
					position[0]=area*_config.screenWidth+j*(divwidth+paddingleft)+ox;
					position[1]=i*(divheight+paddingtop);
					break;
				case 3:
					if(pos>sum_x*sum_y-1) {
						var j=0;
						var i=0;
						//var j=Math.floor((pos%(sum_x*sum_y))/sum_y);
						//var i=(pos%(sum_x*sum_y))-j*sum_y;
						var j=sum_x-Math.floor((pos%(sum_x*sum_y))/sum_y)-1;
						var i=sum_y-((pos%(sum_x*sum_y))-Math.floor((pos%(sum_x*sum_y))/sum_y)*sum_y)-1;
					}else{
						var j=sum_x-Math.floor(pos/sum_y)-1;
						var i=sum_y-(pos-Math.floor(pos/sum_y)*sum_y)-1;
						//alert('x=='+j+'==i='+i);
					}
					position[0]=_config.screenWidth*area+j*(divwidth+paddingleft)+ox;
					position[1]=i*(divheight+paddingtop)+oy;
					break;
				case 4:
					var sum=0;
				
						sum=_config.screenList.length
					
					var page=_layout.page-1;
					//alert(page);
					//alert(width+'===='+sum_x+'===='+sum_y);
					if(page<1){
						var shao_sum=sum_x*sum_y-sum;
						var s=getsum(width-paddingleft,height-paddingtop,(sum),divwidth+paddingleft,divheight+paddingtop);
						sum_x=s[0];
						sum_y=s[1];
						
						var x=Math.ceil(sum/sum_y);
						paddingleft=Math.floor((width-x*divwidth)/(x+1));
						paddingtop=Math.floor((height-sum_y*divheight)/(sum_y+1));
					
							var j=Math.floor(pos/sum_y);
							var i=pos-j*sum_y;
						
						position[0]=paddingleft+j*(divwidth+paddingleft);
						position[1]=paddingtop+i*(divheight+paddingtop);
						break;
					}else{
						
						if(pos<page*sum_x*sum_y){
							var paddingleft=Math.floor((width-sum_x*divwidth)/(sum_x+1));
							var paddingtop=Math.floor((height-sum_y*divheight)/(sum_y+1));
							area=Math.floor(pos/(sum_x*sum_y));
							var pos=pos-area*(sum_x*sum_y);
							var j=Math.floor((pos)/sum_y);
							var i=(pos)-j*sum_y;
							
							position[0]=area*_config.screenWidth+paddingleft+j*(divwidth+paddingleft);
							position[1]=paddingtop+i*(divheight+paddingtop);
							break;
						}else{
							 sum=sum-page*sum_x*sum_y;
							 pos=pos-page*sum_x*sum_y;
							var shao_sum=sum_x*sum_y-sum;
							var s=getsum(width-paddingleft,height-paddingtop,(sum),divwidth+paddingleft,divheight+paddingtop,sum_x,sum_y);
							sum_x=s[0];
							sum_y=s[1];
							//alert([width-paddingleft,height-paddingtop,(sum),divwidth+paddingleft,divheight+paddingtop]);
							var x=Math.ceil((sum)/sum_y);
							//alert([pos,page,sum_x,sum_y,x,sum]);
							paddingleft=Math.floor((width-x*divwidth)/(x+1));
							paddingtop=Math.floor((height-sum_y*divheight)/(sum_y+1));
							var j=Math.floor(pos/sum_y);
							var i=pos-j*sum_y;
							//var j=Math.floor((sum_x*sum_y-pos)/sum_y);
							//var i=(sum_x*sum_y-pos)-j*sum_y;
							
							position[0]=page*_config.screenWidth+paddingleft+j*(divwidth+paddingleft);
							position[1]=paddingtop+i*(divheight+paddingtop);
							//alert(sum+'==='+pos+'==='+position+'==='+page+'==='+paddingleft);
							break;
						}
							
					}
					
		   }
		    /*if(area>_layout.page)_layout.page=area+1;*/ 
			return position;  
	   }
   }else{
	   if(dir){//横向排列时
	   		switch(p){
				case 0:
					var position= new Array(0,0);
					for (var i=0;i< sum_y ;i++){
						for (var j=0;j< sum_x;j++){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft)+10;
								position[1]=i*(divheight+paddingtop)+10;
								return position;
							}
						}
					}
					return position;
					break;
				case 2:
					var position= new Array(10,(sum_y-1)*(divheight+paddingtop)+10);
					for (var i=0;i< sum_x ;i++){
						for (var j=sum_y-1;j>=0;j--){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft)+10;
								position[1]=i*(divheight+paddingtop)+oy+10;
								return position;
							}
						}
					}	
					return position;
					break;
				case 1:
					var position= new Array((sum_x-1)*(divwidth+paddingleft)+10,10);
					for (var i=sum_x-1;i>=0 ;i--){
						for (var j=0;j<sum_y;j++){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft)+ox+10;
								position[1]=i*(divheight+paddingtop)+10;
								return position;
							}
						}
					}	
					return position;
					break;
				case 3:
					var position= new Array((sum_x-1)*(divwidth+paddingleft)+10,(sum_y-1)*(divheight+paddingtop)+10);
					for (var i=sum_x-1;i>=0 ;i--){
						for (var j=sum_y-1;j>=0;j--){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft)+ox+10;
								position[1]=i*(divheight+paddingtop)+oy+10;
								return position;
							}
						}
					}	
					return position;
					break;
				case 4:
					var sum=0;
					
					for(var i in _config.screenList){
						if(_layout.autolist<1 && _config.sourcedata.icos[_config.screenList[i]].position==''){
							sum++;
						}
					}
					var shao_sum=sum_x*sum_y-sum;
					if(shao_sum>0)
					{
						var s=getsum(width,height,sum,divwidth+paddingleft,divheight+paddingtop);
					
						sum_x=s[0];
						sum_y=s[1];
						var y=Math.ceil(sum/sum_x);
					 	paddingleft=Math.floor((width-sum_x*divwidth)/(sum_x+1));
						paddingtop=Math.floor((height-y*divheight)/(y+1));
						
					}else{
					
					 	paddingleft=Math.floor((width-sum_x*divwidth)/(sum_x+1));
						paddingtop=Math.floor((height-sum_y*divheight)/(sum_y+1));
					}
					var position= new Array(paddingleft,paddingtop);
					for (var i=0;i< sum_y ;i++){
						for (var j=0;j< sum_x;j++){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=paddingleft+j*(divwidth+paddingleft);
								position[1]=paddingtop+i*(divheight+paddingtop);
								return position;
							}
						}
					}
					return position;
					break;
				
			}

	   }else{//纵向排列时
			switch(p){
				case 0:
					var position= new Array(0,0);
					for (var j=0;j< sum_x ;j++){
						for (var i=0;i< sum_y;i++){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft);
								position[1]=i*(divheight+paddingtop);
								return position;
							}
						}
					}
					return position;
					break;
				case 2:
					var position= new Array(0,(sum_y-1)*(divheight+paddingtop));
					for (var j=0;j< sum_x ;j++){
						for (var i=sum_y-1;i>=0;i--){
						if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft);
								position[1]=i*(divheight+paddingtop)+oy;
								return position;
							}
						}
					}	
					return position;
					break;
				case 1:
					var position= new Array((sum_x-1)*(divwidth+paddingleft),0);
					for (var j=sum_x-1;j>=0 ;j--){
						for (var i=0;i<sum_y;i++){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft)+ox;
								position[1]=i*(divheight+paddingtop);
								return position;
							}
						}
					}	
					return position;
					break;
				case 3:
					var position= new Array((sum_x-1)*(divwidth+paddingleft),(sum_y-1)*(divheight+paddingtop));
					for (var j=sum_x-1;j>=0 ;j--){
						for (var i=sum_y-1;i>=0;i--){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=j*(divwidth+paddingleft)+ox;
								position[1]=i*(divheight+paddingtop)+oy;
								return position;
							}
						}
					}	
					return position;
					break;
				case 4:
					var sum=0;
					for(var i in _config.screenList){
						if(_config.sourcedata.icos[_config.screenList[i]].position==''){
							sum++;
						}
					}
				
					var shao_sum=sum_x*sum_y-sum;
					if(shao_sum>0)
					{
						var s=getsum(width-paddingleft,height-paddingtop,sum,divwidth+paddingleft,divheight+paddingtop);
					
						sum_x=s[0];
						sum_y=s[1];
						var x=Math.ceil(sum/sum_y);
						paddingleft=Math.floor((width-x*divwidth)/(x+1));
						paddingtop=Math.floor((height-sum_y*divheight)/(sum_y+1));
					}else{
					 	paddingleft=Math.floor((width-sum_x*divwidth)/(sum_x+1));
						paddingtop=Math.floor((height-sum_y*divheight)/(sum_y+1));
					}
					var position= new Array(paddingleft,paddingtop);
					for (var j=0;j< sum_x ;j++){
						for (var i=0;i< sum_y;i++){
							if(_ico.getposition(container,j,i,divwidth,divheight,paddingleft,paddingtop)){
								position[0]=paddingleft+j*(divwidth+paddingleft);
								position[1]=paddingtop+i*(divheight+paddingtop);
								return position;
							}
						}
					}
					return position;
					break;
			}
	   }
   }
};
function getsum(width,height,sum,icowidth,icoheight,oldx,oldy){
	
	var sum_y=Math.floor(height/icoheight);
	var sum_x=Math.floor(width/icowidth);
	
	if(sum_y<1) sum_y=1;
	if(sum_x<1) sum_x=1;
	var ox=width-sum_x*icowidth;
	var oy=height-sum_y*icoheight;
	if(sum_x*sum_y<sum) {
		return [oldx,oldy];
	}else if(sum_x*sum_y==sum) {
		return [sum_x,sum_y];
	}else{
		return getsum(width-icowidth,height-icoheight,sum,icowidth,icoheight,sum_x,sum_y);
	}
}
//判断是否有图标占用此位置
_ico.getposition=function (container,x,y,divwidth,divheight,paddingleft,paddingtop){
	for(var id in _ico.icos) {	
		var self=_ico.icos[id];
		if(_config.sourcedata.icos[id].position!='') continue;
			if (self.container==container){
				//判断目标的左上
				if(self.left >=x*(divwidth+paddingleft) && self.left<((x+1)*(divwidth+paddingleft)) && self.top>y*(divheight+paddingtop)&& self.top<((y+1)*(divheight+paddingtop))) return false;
			//判断目标的左下
				if(self.left >=x*(divwidth+paddingleft) && self.left<((x+1)*(divwidth+paddingleft)) && (self.top+self.divheight)>y*(divheight+paddingtop)&& (self.top+self.divheight)<((y+1)*(divheight+paddingtop))) return false;
				//判断目标的右上
				if((self.left+self.divwidth)>x*(divwidth+paddingleft) && (self.left+self.divwidth)<((x+1)*(divwidth+paddingleft)) && self.top>y*(divheight+paddingtop) && self.top<((y+1)*(divheight+paddingtop))) return false;
				//判断目标的右下
				if((self.left+self.divwidth)>=x*(divwidth+paddingleft)&& (self.left+self.bodyWidth)<x*(divwidth+paddingleft) && (self.top+self.height)>(y*(divheight+paddingtop)) && (self.top+self.height)<((y+1)*(divheight+paddingtop)))  return false;
			}
	}
	return true;
};
_ico.CIcolist=function()  
{
	jQuery('#loading_info').fadeOut('slow');
	//创建桌面ico；
	var screenList=_config.screenList;
	for(var j=0;j<screenList.length;j++){
		var obj=_ico.CIco(screenList[j],'icosContainer_body_'+_layout.fid,j);
	//	if(obj.defaultopen>0) _ico.Open(obj.id);
	}
};

_ico.reCIco=function(icoid){
	if(_ico.icos[icoid]){
		var container=_ico.icos[icoid].container;
		var pos=_ico.icos[icoid].pos;
		var pos1=[_ico.icos[icoid].left,_ico.icos[icoid].top];
		//删除原icos
		jQuery(_ico.icos[icoid].board).remove();
		for(var key in _ico.icos[icoid]) delete _ico.icos[icoid][key];
		delete _ico.icos[icoid];
		//生成新icos
		var obj=new _ico(icoid,container,pos);
		if(pos1) {
			obj.left=pos1[0];
			obj.top=pos1[1];
			obj.nopos=1;
		}
		if(obj.img.substr(obj.img.length-4)=='.png' ) obj.ispng=true;
		
		obj.CreatIco();
		
	}
	//处理目录和资源管理器
	for(var id in _filemanage.cons){
		if(_filemanage.cons[id].data[icoid]){
			_filemanage.cons[id].reCreateIcos(_config.sourcedata.icos[icoid]);
		}
	}
}
_ico.CIco=function(appid,container,pos,pos1){ 
	if(_ico.icos[appid]){
		jQuery(_ico.icos[appid].board).remove();
		for(var key in _ico.icos[appid]) delete _ico.icos[appid][key];
		delete _ico.icos[appid];
	}
	var obj=new _ico(appid,container,pos);
	if(pos1) {
		obj.left=pos1[0];
		obj.top=pos1[1];
		obj.nopos=1;
	}
	if(obj.img.substr(obj.img.length-4)=='.png' ) obj.ispng=true;
	else obj.ispng=false;
	
	obj.CreatIco();
	//_layout.resize();
	return obj;
};

_ico.image_resize=function(img,width,height,ispng){
	
	var w=jQuery(img).width();
	var h=jQuery(img).height();
	if((w/h)>1){
		var realw=(w>width)?parseInt(width):w;
		var realh=realw*h/w;
	}else{
		var realh=(h>height)?parseInt(height):h;
		var realw=realh*w/h;
	}
	if(realw<32 && realh<32) jQuery(img).addClass('image_tosmall').css({padding:((height-realh)/2-1)+'px '+((width-realw)/2-1)+'px' });;
	try{
		img.style.width=realw+'px';
		img.style.height=realh+'px';
		
	}catch(e){};
	jQuery(img).show();	
	
	
};
_ico.loadCheck = function (loadding,img,width,height) {
		if(loadding.complete) {
			var w = loadding.width;
			var h = loadding.height;
			if((w/h)>1){
				var realw=(w>width)?parseInt(width):w;
				var realh=realw*h/w;
			}else{
				var realh=(h>height)?parseInt(height):h;
				var realw=realh*w/h;
			}
			if(realw<32 && realh<32) jQuery(img).addClass('image_tosmall').css({padding:((height-realh)/2-1)+'px '+((width-realw)/2-1)+'px' });;
			try{
				img.style.width=realw+'px';
				img.style.height=realh+'px';
				
			}catch(e){};
			img.src=jQuery(img).attr('error');
			jQuery(img).show();	
		} else {
			setTimeout(function () {_ico.loadCheck(loadding,img,width,height); }, 50);
		}
	};
_ico.icoimgError=function(obj,width,height){
	if(jQuery(obj).attr('error')){
		//obj.src=jQuery(obj).attr('error');
		loading = new Image();
		setTimeout(function () {_ico.loadCheck(loading,obj,width,height); }, 100);
		loading.src = jQuery(obj).attr('error');
	}
}
_ico.prototype.CreatIco=function()
{
	var self=this;
	this.board=document.createElement("div");
	this.board.className=this.className+' '+_config.sourcedata.icos[this.id].flag+' '+this.iconview.cssname;
	this.board.style.position="absolute";
	this.board.id='icon_'+this.id;
	this.board.setAttribute('icoid',this.id);
	this.board.setAttribute('oid',this.sourceid);
	this.board.setAttribute('flag',_config.sourcedata.icos[this.id].flag);
	this.board.style.float='left';
	this.board.style.zIndex=this.zIndex;
	document.getElementById(this.container).appendChild(this.board);
	var imgclass='';
	switch(this.type){
		case 'user':
			document.getElementById('usercss_loaded').className='userclass'+this.width+'_'+this.height;
			if(parseInt(jQuery('#usercss_loaded').css('width'))>1){
				imgclass='userclass'+this.width+'_'+this.height;
				var html='<img class="Icoblock_icon '+imgclass+'" src="'+this.img+'"  title="'+this.text+' error="'+this.error+'" onerror="_ico.icoimgError(this)">';
			}else{
				var html='<img  class="Icoblock_icon userclass radius" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			}
			break;
		case 'image':
			imgclass='imageclass';
			var html='<img  class="Icoblock_icon '+imgclass+'" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			break;
		case 'app':
			imgclass='radius';
			var html='<img  class="Icoblock_icon '+imgclass+'" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			break;
		case 'video':
			document.getElementById('videocss_loaded').className='videoclass'+this.width+'_'+this.height;
			if(parseInt(jQuery('#videocss_loaded').css('width'))>1){
				imgclass='videoclass'+this.width+'_'+this.height;
				var html='<img class="Icoblock_icon '+imgclass+'" src="'+this.img+'"  title="'+this.text+'" onerror="_ico.icoimgError(this)" error="'+this.error+'">';
			}else{
				var html='<img  class="Icoblock_icon videoclass radius" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
			}
			break;
		default:
			imgclass='radius';
			var html='<img  class="Icoblock_icon '+imgclass+'" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');" onerror="_ico.icoimgError(this,'+this.width+','+this.height+')" error="'+this.error+'">';
	}
	//添加图片背景和前景层
	var typeclass='icoimgContainer_'+this.type;
	 var html1='';
		html1+='<div class="icoimgContainer '+typeclass+'" style="position:relative;width:'+this.width+'px;height:'+this.height+'px">';
		html1+=   '<table width="100%" height="100%" cellpadding="0" cellspacing="0"><tr><td align="center" valign="middle">'+html+'</td></tr></table>';
		html1+=   '<div class="icoimgCover_up" style="position:absolute;left:0px;top:0px;width:'+this.width+'px;height:'+this.height+'px;z-index:1"></div>';
		html1+=   '<div class="icoimgtips" style="position:absolute;left:0px;top:0px;width:'+this.width+'px;height:'+this.height+'px;z-index:2"></div>';
		html1+=   '<div class="icoimgCover_down" style="position:absolute;left:0px;top:0px;width:'+this.width+'px;height:'+this.height+'px;z-index:-1"></div>';
		html1+='</div>';
	/*if(ieVersion > 0 && ieVersion < 7 && this.ispng )	{
		var html="<img class='"+imgclass+"'  src='dzz/images/b.gif' width="+(this.width)+" height="+(this.height)+"  style=\"_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+this.img+"', sizingMethod='scale');\" title=\""+this.text+"\">";
	}else {*/
		//var html='<img class="'+imgclass+'" src="'+this.img+'" style="display:none;" title="'+this.text+'" onload="_ico.image_resize(this,'+this.width+','+this.height+','+this.ispng+');">';
	/*}*/
	var text=''
	
	if(this.container!='taskbar_dock' && this.container!='taskbar_tray'){
		var textclass='IcoText';
		if(this.container.indexOf('icosContainer_folder_')!==-1){
			textclass='IcoText_folder';
		}
		if(this.align){
			var op_class='op_lefttop';
			text='<td align="left" valign="middle"><div id="text_'+this.id+'" class="IcoText_div" style="width:'+(this.divwidth-this.width-_ico.padding*2-25)+'px;"><a class="'+textclass+'" >'+mb_cutstr_nohtml(this.text,this.iconview.textlength)+'</a></div></td>';
		}else{
			var op_class='op_righttop';
			text='<tr height="35px"><td align="center" valign="middle"><div id="text_'+this.id+'" class="IcoText_div" style="width:'+(this.divwidth-15)+'px;height:35px;"><table cellpadding="0" cellspacing="0" width="100%" height="100%"><tr><td valign="middle" align="center"><a class="'+textclass+'">'+mb_cutstr_nohtml(this.text,this.iconview.textlength)+'</a></td></tr></table></div></td></tr>';
		}
		

	}
	var innerhtml='';
	
	if(this.align){
		
		innerhtml+='<table cellpadding="0" cellspacing="0"  width="'+(this.divwidth)+'" height="'+(this.divheight)+'" ><tr> <td  align="center" valign="middle" style="overflow:hidden;" id="html_'+this.id+'" width="'+(this.width+_ico.padding*2+15)+'" >'+html1+'</td>  '+text+'</tr></table>';
	}else{
		innerhtml+='<table cellpadding="0" cellspacing="0"  width="'+(this.divwidth)+'" height="'+(this.divheight)+'" style="table-layout:fixed;"><tr>    <td  align="center" valign="middle"  style="overflow:hidden;" id="html_'+this.id+'" height="'+(this.divheight-45)+'px">'+html1+'</td></tr>  '+text+'</table>';
	}
	
	
	if((this.notdelete<1 || (this.notdelete>0 && _config.sourcedata.icos[this.id].type=='app')) && _config.Permission('delete',_config.sourcedata.icos[this.id]))	innerhtml+='	<div class="icoblank_tip icoblank_rightbottom" style="z-index:'+this.zIndex+2+'"></div>';
	
	this.board.innerHTML=innerhtml;
	var self=this;
	//创建空层
		innerhtml='';
	  
		
	this.board.title=this.text;	
	var el=jQuery(this.board);
	//操作按钮事件
		el.find('.icoblank_tip .icon').on('click',function(){
				this.onclick();
				return false;
			});	
	//处理多重选择
		if(_config.selectall.container==this.container && jQuery.inArray(this.id,_config.selectall.icos)>-1){
				jQuery(this.board).addClass('Icoselected');
		}
		//处理剪切样式
		if(_config.cut.iscut>0 && jQuery.inArray(this.id,_config.cut.icos)>-1){
				jQuery(this.board).addClass('iscut');
		}
	//事件处理
	if((this.notdelete<1 || (this.notdelete>0 && _config.sourcedata.icos[this.id].type=='app'))  && _config.Permission('delete',_config.sourcedata.icos[this.id])){
		el.find('.icoblank_rightbottom').on('click',function(){
				var flag=true;
				if(jQuery(this).parent().hasClass('Icoselected')){
					 flag=false;
				}
				_select.SelectedStyle('icosContainer_body_'+_layout.fid,self.id,flag,true);
				return false;
			});	
	}
		el.mouseenter(function(){
				jQuery(self.board).addClass('hover');
		})
		.mouseleave(function(){
			jQuery(self.board).removeClass('hover');
		});
		el.on('contextmenu',function(e){ _contextmenu.right_ico(e?e:window.event,self.id,'',_layout.fid); return false;});
	 
		el.find('.IcoText_div a,.icoimgContainer').on('click',function(){
			_ico.Open(self.id);
			return false;
		});
		if((this.notdelete<1 || (this.notdelete>0 && _config.sourcedata.icos[this.id].type=='app'))   && _config.Permission('delete',_config.sourcedata.icos[this.id])){
			el.on('click',function(e){
				e=e?e:window.event;
				var tag = e.srcElement ? e.srcElement :e.target;
				if(tag.type=="text"||tag.type=="textarea"){
					return true;
				}
				var Item=jQuery(this).parent();
				var flag=true;
				if(_hotkey.ctrl && jQuery(this).hasClass('Icoselected')){
					var flag=false;
				}
				if(_hotkey.ctrl) var multi=true;
				else multi=false;
				_select.SelectedStyle(Item.attr('id'),jQuery(this).attr('icoid'),flag,multi);
				//self.createBottom();
				return false;
			});
		}else{
			el.on('click',function(e){
				_ico.Open(self.id);
			});
		}
		
		
		 //创建背景层
		this.board_background=document.createElement("div");
		this.board_background.className='backgound_radius';
		this.board_background.style.cssText="position:absolute;left:0px;top:0px;z-index:-5;width:"+(this.divwidth-2)+"px;height:"+(this.divheight-2)+"px;";
		this.board.appendChild(this.board_background);
		//if(this.Parent=='Recycle')	jQuery(this.icoblank).bind('contextmenu',function(e){ self.Icomenu(e?e:window.event); return false;});
		//jQuery(this.icoblank).bind('click',function(e){ _config.OpenApp(self.id);return false;});
		
		if( _config.icosTips[this.id]>0){
			_ico.setTip(this.id, _config.icosTips[this.id]);
		}
	/*	_ico.setTip_icoimg('share',this.id);
		_ico.setTip_icoimg('liked',this.id);*/
		if(!this.nopos){
			var pos=this.getpos(this.pos,this.container);
			this.left=pos[0];
			this.top=pos[1];
		}
		//alert(this.left+'====='+this.top+'===='+this.nopos);
		this.board.style.left=this.left+'px';
		this.board.style.top=this.top+'px';
		this.board.style.width=(this.divwidth)+'px';
		this.board.style.height=(this.divheight)+'px';
	if(ieVersion<9 && ieVersion>0){
		jQuery(this.board).find('.IcoText').FontEffect({shadow:true, shadowColor:'#000',shadowOffsetTop :1,shadowBlur:1,  shadowOffsetLeft:1,shadowOpacity:0.3})
	}
	this.board.style.overflow="visible";
	
	if(_config.Permission('admin',_config.sourcedata.icos[this.id]) ){
		_Drag.init(this.id,this.board,'',this.container);
	}
	this.status=1;
	//jQuery(this.board).find('.IcoText').FontEffect({  shadow:true, shadowColor:'#000',shadowOffsetTop :1,shadowBlur:1,  shadowOffsetLeft:1,shadowOpacity:0.3})

	//addGlossy(document.getElementById('img_'+this.id));
};
_ico.OpenWin=function(id,navid,tab,left,top){
	
	jQuery('#shadow').hide();
	 if(_ico.icos[id]) {
		 obj=_ico.icos[id];
	 }else{
		 if(!_config.sourcedata.icos[id]) return ;
		 obj=_config.sourcedata.icos[id];
		 obj.id=obj.icoid;
		 obj.text=obj.name;
	 }
	 if(obj.type=='app'){
		if(obj.url.indexOf('dzzjs:')===0){
			eval(obj.url.replace('dzzjs:',''));
			return;
		}
	}
	 /*//查看数统计
	  if(!getcookie('view_'+obj.type+'_'+obj.oid)){
			jQuery.get(DZZSCRIPT+'?mod=system&op=ajax&do=updateview&id='+obj.oid+'&type='+obj.type);
	 }	*/
	 if(typeof(obj)=='undefined'||!obj) return;
		 switch(obj.open){
			 case 0:case 1: //应用窗口
				OpenAppWin(obj.id,null,null,null,tab,left,top,navid);
				break;
			// widget窗口
				/*OpenAppWin(obj.id,obj.url,obj.text,"pattern=noborder,close=yes,minmine=no,maxmine=no,resize=no,width="+obj.wwidth+",height="+(obj.wheight>_config.screenHeight?_config.screenHeight-60:obj.wheight));
				break;*/
			case 2://浏览器窗口
				OpenBrowser(obj.url,obj.text);
				break;
			case 3: //新窗口、
			if(obj.wwidth>0 && obj.wheight>0){
				window.open(obj.url,obj.text,'topbar=0,resizable=1,scrollbars=yes,location=no,menubar=no,status=1,width='+obj.wwidth+',height='+obj.wheight);
			}else{
				window.open(obj.url);
			}
				break;
			default: //应用窗口
				OpenAppWin(obj.id,null,null,null,tab,left,top,navid);
				break;
		 }
	 
};
_ico.ExtOpen_Replace=function(icoid,extid){
	var ico=_config.sourcedata.icos[icoid];
	var extdata=_config.extopen.all[extid];
	if(!ico ||!extdata) return false;
	for(var key in ico){
		extdata_url=extdata.url.replace(/{(\w+)}/g, function($1){
			key=$1.replace(/[{}]/g,'');
			if(key=='url'){
				return encodeURIComponent(ico[key]);
			}else return ico[key]
		});	
	}
	if(ico.bz && ico.bz!=''){
		var path=encodeURIComponent(ico.path)
	}else{
		var path=icoid;
	}
	if(extdata_url.indexOf('dzzjs:')===-1 && extdata_url.indexOf('?')!==-1){
		extdata_url=extdata_url+'&path='+path;
	}
	return extdata_url;
};
_ico.getExtOpen=function(icoid,isdefault){
	var data=_config.sourcedata.icos[icoid];
	if(data.type=='folder'|| data.type=='user' || data.type=='app'|| data.type=='pan'|| data.type=='storage' ){
		return true;
	}
	var openarr=[];
	if(data.ext && _config.extopen.ext[data.ext]){
		for(var i=0;i<_config.extopen.ext[data.ext].length;i++){
		   if(_config.extopen.all[_config.extopen.ext[data.ext][i]]){
			   if(isdefault && _config.extopen.all[_config.extopen.ext[data.ext][i]].isdefault>0) return _config.extopen.all[_config.extopen.ext[data.ext][i]].extid;
				openarr.push(_config.extopen.all[_config.extopen.ext[data.ext][i]]);
		   }
		}
	}
	if(_config.extopen.ext[data.type]){
		for(var i=0;i<_config.extopen.ext[data.type].length;i++){
			
			if(_config.extopen.all[_config.extopen.ext[data.type][i]]){
			   if(isdefault && _config.extopen.all[_config.extopen.ext[data.type][i]].isdefault>0) return _config.extopen.all[_config.extopen.ext[data.type][i]].extid;
			   openarr.push(_config.extopen.all[_config.extopen.ext[data.type][i]]);
			}
		}
	}
	if(isdefault){
		if(openarr.length>0) return openarr[0].extid;
		else return false;
	}else{
		if(openarr.length>0) return openarr;
		else	return false;
	}
};
_ico.Open=function(id,extid){
	jQuery('#shadow').hide();
	var obj=_config.sourcedata.icos[id];
	if(!obj.icoid){
		return;
	}
	 obj.id=obj.icoid;
	 obj.text=obj.name; 
	//判断打开的url中是否含有dzzjs:等特殊协议；为了安全，只有应用才可以
	if(obj.type=='app'){
		if(obj.url.indexOf('dzzjs:')===0){
			eval((obj.url.replace('dzzjs:','')));
			return;
		}else if(obj.open>0){
			window.open(obj.url);
			return;
		}else{
			OpenAppWin(obj.id);
			return;
		}
	}else if(obj.type=='folder' || obj.type=='pan' || obj.type=='storage'){
		OpenFolderWin(obj.id);
		return;
	
	}else if(obj.type=='user'){
		if(_config.myuid>0){
			OpenDim('uid_'+_config.sourcedata.icos[id].oid);
		}else{
			window.open(DZZSCRIPT+'?uid='+_config.sourcedata.icos[id].oid);
		}
		return;
	}
	if(!extid) extid=_ico.getExtOpen(id,true);
	if(extid){
		var extdata_url=_ico.ExtOpen_Replace(id,extid);
		if(extdata_url){
			extdata_url=extdata_url.replace(/{\w+}/g,'');
			if(extdata_url.indexOf('dzzjs:')===0){
				eval(decodeURIComponent(extdata_url.replace('dzzjs:','')));
				return;
			}else{
				if(_config.extopen.all[extid].nodup>0 && _config.extopen.all[extid].appid>0){
					
					OpenApp(_config.extopen.all[extid].appid,extdata_url);
				}else{
					OpenAppWin(obj.icoid,extid,extdata_url);
				}
				
			}
		}
	}else{
		var msg='<dl style="margin:0">';
			msg+='	<dt style="margin-bottom:10px;">没有支持此文件的应用，您可以</dt>';
			msg+='	<dd  style="margin-bottom:10px;">1.&nbsp;打开&nbsp;<a style="color:#08c" href="javascrip:;" onclick="OpenWindow(\'appmarket\',\''+_config.marketurl+'\',\'应用库\');hideMenu(\'fwin_dialog\', \'dialog\');return false">应用库</a> &nbsp;选择相关的应用安装</dd>';
			msg+='	<dd  style="margin-bottom:10px;">2.&nbsp;<a style="color:#08c" href="javascript:;" onclick="_ico.downAttach(\''+id+'\');hideMenu(\'fwin_dialog\', \'dialog\')">立即下载</a></dd>';
			msg+='</dl>';
			Alert(msg,0,null,null,'info');
	}
	
};
_ico.appendIcoids=function(icoids,ticoid){
	//icoids 需要添加的icos 注意这些icoid必须在同一个目录内;
	var pfid=_config.sourcedata.icos[icoids[0]].pfid; //通过第一个icoid判断容器
	
	if(_config.sourcedata.icos[icoids[0]].isdelete>0){
		pfid=_config.space.typefid['recycle'];
	}else{
		for(var i in icoids){
			if(_config.sourcedata.icos[icoids[i]].type=='folder') _config.sourcedata.folder[_config.sourcedata.icos[icoids[i]].oid].pfid=pfid;
		}
	}
	if(pfid==_config.space.typefid['desktop']){ //桌面时
		container='icosContainer_body_'+pfid;
		//添加到_config.screenList;
		
		var icos=_config.screenList;
		var pos=0;
		var arr=[];
		if(jQuery.inArray(ticoid,icos)>-1){
			for(var i=0;i<icos.length;i++){
				if(icos[i]==ticoid){
					arr=arr.concat(icoids);
					arr[arr.length]=icos[i];
					pos=i;
				}else{
					arr[arr.length]=icos[i];
				}
			}
		}else{
			arr=icos.concat(icoids);
		}
		
		_config.screenList=arr;
		if(pos==0) pos=arr.length-1;
		for(var i=0;i<icoids.length;i++){
			var obj=_ico.CIco(icoids[i],container,pos+i);
		}
		_layout.resize();
	}else if(pfid==_config.space.typefid['dock']){//在dock上时
		
		var icos=_config.dockTaskList;
		var pos=-1;
		var arr=[];
		var taskids=[]
		for(var i=0;i<icoids.length;i++){
			if(_config.sourcedata.icos[icoids[i]].type=='app') var taskid='app_'+_config.sourcedata.icos[icoids[i]].oid;
			else var taskid=icoids[i];
			if(_dock.icos[taskid]) _dock.icos[taskid].pined=1;
			else taskids.push(taskid);
		}
		if(jQuery.inArray(ticoid,icos)>-1){
			for(var i=0;i<icos.length;i++){
				if(icos[i]==ticoid){
					arr=arr.concat(taskids);
					arr[arr.length]=icos[i];
					pos=i;
				}else{
					arr[arr.length]=icos[i];
				}
			}
		}else{
			arr=icos.concat(taskids);
		}
		
		
		_config.dockTaskList=arr;
		if(pos==-1) pos=arr.length-1;
		for(var i=0;i<icoids.length;i++){
			if(_config.sourcedata.icos[icoids[i]].type=='app') var taskid='app_'+_config.sourcedata.icos[icoids[i]].oid;
			else var taskid=icoids[i];
			var obj=_dock.Ctask(taskid,null,_config.sourcedata.icos[icoids[i]],1,pos+i);
		}
		_dock.refreshlist();
		
		_dock.setDockSize();
	}
	//var topfids=_ico.getTopFid(pfid);
	for(var id in _filemanage.cons){
		if(_filemanage.cons[id].fid==pfid){
			for(var i=0;i<icoids.length;i++){
				_filemanage.cons[id].CreateIcos(_config.sourcedata.icos[icoids[i]]);
			}
		}/*else if(jQuery.inArray(_filemanage.cons[id].fid,topfids)>-1){
			jQuery("#jstree_area_"+_filemanage.cons[id].winid).jstree('refresh',jQuery('#f-'+pfid+'-'+_filemanage.cons[id].winid));
		}*/
	}
}
_ico.removeIcoid=function(icoid){
	if(!_config.sourcedata.icos[icoid]) return;
	var pfid=_config.sourcedata.icos[icoid].pfid;
	if(_config.sourcedata.icos[icoid].isdelete>0){
		pfid=_config.space.typefid['recycle'];
	}
	if(pfid==_config.space.typefid['desktop']){ //桌面时
		//移除screenicolist；
			
			var arr=new Array();
			var icoids=_config.screenList;
			for(var i=0;i<icoids.length;i++){
				if(icoids[i]!=icoid) arr[arr.length]=icoids[i];
			}
			_config.screenList=arr;
			
			 var autolist=_layout.autolist;
			 if(autolist){
				var obj=_ico.icos[icoid];
				if(_layout.iconposition<4){
					 jQuery('#icosContainer_body_'+_layout.fid).find('.Icoblock').each(function(){
						var id1=this.id.replace('icon_','');
						var obj1=_ico.icos[id1];
						if(obj1.pos>obj.pos) {
							obj1.pos-=1;
							var pos=obj1.getpos(obj1.pos,'icosContainer_body_'+_layout.fid);
						//	alert(obj.pos+'==='+obj1.pos+'===='+pos[0]+'========='+pos[1]);
							obj1.left=pos[0];
							obj1.top=pos[1];
							obj1.board.style.left=obj1.left+'px';
							obj1.board.style.top=obj1.top+'px';
						}
					});
				}else{
					_ico.refreshList(pfid);
				}
				_layout.resize();
			 }
			 _select.SelectedStyle(obj.container,icoid,false);
			jQuery(obj.board).remove();
			for(var key in _ico.icos[icoid]){
				delete _ico.icos[icoid][key];
			}
			delete _ico.icos[icoid];
	}else if(pfid==_config.space.typefid['dock']){//在dock上时
		//移除——config.dockList 中的icoid；
		    var icoarr=_config.sourcedata.icos[icoid];
			if(icoarr.type=='app') var taskid='app_'+icoarr.oid;
			else var taskid=icoid
			var arr=new Array();
			for(var i=0;i<_config.dockTaskList.length;i++){
				if(_config.dockTaskList[i]!=taskid) arr.push(_config.dockTaskList[i]);
			}
			_config.dockTaskList=arr;
		//	alert(_config.dockList.join(','));
			//pos超过此的图标全部向左移动一格
			var obj=_dock.icos[taskid];
			//_dock.refreshlist();
			jQuery('#taskbar_dock').find('.task_Icoblock').each(function(){
				var id1=this.id.replace('task_','');
				var obj1=_dock.icos[id1];
				
				if(obj1.pos>obj.pos) {
					obj1.pos-=1;
					var pos=obj1.getpos(obj1.pos);
					obj1.left=pos[0];
					obj1.top=pos[1];
					obj1.board.style.left=obj1.left+'px';
					obj1.board.style.top=obj1.top+'px';
				}
			});
			//删除图标
			jQuery('#task_'+taskid).remove();
			for(var key in _dock.icos[taskid]){
				delete _dock.icos[taskid][key];
			}
			delete _dock.icos[taskid];
			_dock.setDockSize();
	}else if(pfid==_config.space.typefid['recycle']){//在回收站内
		_config.sourcedata.folder[pfid].iconum=parseInt(_config.sourcedata.folder[pfid].iconum)-1;
		_ico.checkRecycleStatus();
	}
	
	//删除资源管理器和目录内的元素，维护目录树
	
	for(var id in _filemanage.cons){
		var filemanage=_filemanage.cons[id]
		if(filemanage.data[icoid]){
			_select.SelectedStyle('icosContainer_content_'+filemanage.winid+'_'+id,icoid,false);
			filemanage.delIcos(_config.sourcedata.icos[icoid]);
		}
	}
};

_ico.prototype.DetachEvent=function(e)
{
	if(!_ico.tach) return;
	document.body.style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	document.onmousemove=_ico.onmousemove;
	document.onmouseup=_ico.onmouseup;
	document.onselectstart=_ico.onselectstart;
	
	if(this.board.releaseCapture) this.board.releaseCapture();
	
	_ico.tach=0;
	_ico.finishblank=0;
	
};
_ico.prototype.AttachEvent=function(e)
{ 
	  
	if(_ico.tach) return
	
	_ico.onmousemove=document.onmousemove;
	_ico.onmouseup=document.onmouseup;
	_ico.onselectstart=document.onselectstart;
	try{
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else{
			if(this.board.setCapture) this.board.setCapture();
		}
	}catch(e){};
	_ico.tach=1;
};
/*_ico.prototype.Duplicate=function()
{
	this.copy=document.createElement('div');
	document.body.appendChild(this.copy);
	this.copy.innerHTML=this.board.innerHTML; 
	var p=jQuery(this.board).offset();
	this.copy.style.cssText="position:absolute;left:"+(p.left)+"px;top:"+(p.top)+"px;width:"+(this.divwidth)+"px;height:"+(this.divheight)+"px;filter:Alpha(opacity=50);opacity:0.5;z-index:5000;overflow:hidden";
	//jQuery(this.copy).find('#text'+this.id).html('&nbsp;');
	jQuery(this.copy).find('.border_background').remove();
};*/

_ico.prototype.Focus=function()
{
	if(this.zIndex<_ico.zIndex) this.board.style.zIndex=this.zIndex=++_ico.zIndex;
};


_ico.prototype.changeXY=function(x,y,autolist){
	if(!autolist){
		var p=jQuery('#'+this.container).offset();
		this.left=x-p.left;
		this.top=y-p.top;
	}else{
		this.left=x;
		this.top=y;
	}
	this.board.style.left=this.left+'px';
	this.board.style.top=this.top+'px';
	if(autolist){//自动排列时清楚位置记忆
		_config.sourcedata.icos[this.id].position='';
	}else{//自由排列时记忆位置
		_config.sourcedata.icos[this.id].position=this.left+'_'+this.top;
		if(_config.Permission_Container('admin',this.container)  ){
			 jQuery.post(_config.saveurl+'&do=icoposition&dataname=position&gid='+_config.gid,{icoid:this.id,position:this.left+'_'+this.top});
		}
		
		if(_config.saveTimer) window.clearTimeout(_config.saveTimer);
		_config.saveTimer=setTimeout(function(){_config.sendConfig();},_config.savetime);
	}
		
	
}
_ico.Rename=function(id,filemanageid){
	
	if(_ico.icos[id]) var container=_ico.icos[id].container;
	else var container='';
	
	if(!_config.Permission('rename',_config.sourcedata.icos[id])) {
			showDialog(_lang.prompt1.noprevelige_not_self,'notice');
			return;
	}
	
	if(filemanageid){
		var filemanage=_filemanage.cons[filemanageid];
		var el=jQuery('#file_text_'+id);
		el.css('overflow','visible');
		el.parent().css('overflow','visible');
		filemanage.oldtext=el.html();
		if(filemanage.view>3){
			var html="<input type='text' class='txt' name='text'  id='input_"+id+"' style=\"width:"+(el.parent().width()-55)+"px; \" value=\""+filemanage.oldtext+"\">";
		}else{
			var html="<textarea type='textarea' class='textarea' name='text'  id='input_"+id+"' style=\"width:"+(el.parent().width()-5)+"px;height:30px;padding:2px; \">"+filemanage.oldtext+"</textarea>";
		}
			
		el.html(html);
		//jQuery('#content_'+filemanage.winid+' .icoblank[icoid="'+id+'"]').css('z-index',-1);
		var ele=jQuery('#input_'+id);
		ele.select();
		jQuery(document).on('mousedown.file_text_'+id,function(e){
			//var obj = event.srcElement ? event.srcElement : event.target;
			e=e?e:window.event;
			var obj = e.srcElement ? e.srcElement :e.target;
			if(checkInDom(obj,'file_text_'+id)==false){
				jQuery(document).off('.file_text_'+id);
				if(filemanage.oldtext!=ele.val()){
					_ajax.Rename(id,ele.val(),filemanageid);	
				}else{
					el.html(filemanage.oldtext);
					el.css('overflow','hidden');
					el.parent().css('overflow','hidden');
					//jQuery(_ico.icos[id].icoblank).css('z-index',_ico.icos[id].zIndex);	
				}
				//jQuery('#content_'+filemanage.winid+' .icoblank[icoid="'+id+'"]').css('z-index',10);
			}
		});
	}else{
		var el=jQuery('#text_'+id);
		jQuery(_ico.icos[id].board).css('overflow','visible');
		el.css('overflow','visible');
		document.onselectstart=function(){return true;};
		_ico.icos[id].old_text_html=el.html();
		if(!document.getElementById('input_'+id)){
			var html="<textarea class='IcoText_textarea' name='text'  id='input_"+id+"' style=\"width:"+el.css('width')+"; \"></textarea>";
			el.html(html);
			jQuery(_ico.icos[id].icoblank).css('z-index',-10);
		}
		
		document.getElementById('input_'+id).value=_ico.icos[id].text;
		var ele=jQuery('#input_'+id);
		var temp=jQuery('#input_');
		temp.css('width',(_ico.icos[id].divwidth-10));
		temp.html(_ico.icos[id].text);
		//var p=el.offset();
		//ele.css({position:'absolute',left:p.left+'px',top:p.top+'px',width:_ico.icos[id].divwidth+'px',height:temp.height()+'px'});
		if(!BROWSER.ie) ele.css('height',temp.height()+20);
		ele.select();
	
		document.getElementById('input_'+id).onpopertychange=function(){
			document.getElementById('input_').innerHTML=ele.attr('value');
			ele.css('height',temp.height()+20)	;			
		}
		if (window.addEventListener) { 
			document.getElementById('input_'+id).addEventListener('input', function() {
					document.getElementById('input_').innerHTML=ele.attr('value');
					ele.css('height',temp.height()+20)	;																		
			}, false); 
	} 
	
		jQuery(document).on('mousedown.text_'+id,function(e){
			//var obj = event.srcElement ? event.srcElement : event.target;
			e=e?e:window.event;
			var obj = e.srcElement ? e.srcElement :e.target;
			if(checkInDom(obj,'text_'+id)==false){
				
				jQuery(document).off('.text_'+id);
				if(_ico.icos[id].text!=ele.val()){
					_ajax.Rename(id,ele.val());	
				}else{
					el.html(_ico.icos[id].old_text_html);
					el.css('overflow','hidden');
					jQuery(_ico.icos[id].icoblank).css('z-index',_ico.icos[id].zIndex);	
				}
			}
		});
	}
	
};

_ico.Edit=function(id){
	
	if(!_config.Permission('edit','',_config.sourcedata.icos[id])) {
			showDialog(_lang.prompt1.noprevelige,'alert');
			return;
	}
	if(_config.sourcedata.icos[id].type=='topic'){
		//OpenWindow('newtopic',_config.systemurl+'&op=dzzcp&do=topic&tid='+_config.sourcedata.icos[id].oid+'&handlekey=newtopic',_lang.titleButton['EDITTOPIC'],'','width=800,height=600,titlebutton=Max|close,isModal=no');
		OpenAppWin(id,null,null,null,'EDIT');
	}else if((_config.sourcedata.icos[id].type=='document' || _config.sourcedata.icos[id].type=='attach') && jQuery.inArray(_config.sourcedata.icos[id].ext.toUpperCase(),_config.txtexts)>-1){
		OpenAppWin(id,null,null,null,'EDIT');
	}else{
		OpenWindow('editico',_config.systemurl+'&op=dzzcp&do=edit&icoid='+id+'&uid='+_config.space.uid+'&handlekey=edit',_lang.titleButton['EDIT'],'','width=600,height=400,titlebutton=close,resize=no,isModal=yes');
	}
}
_ico.UrlShare=function(id,name){
	if(!_config.Permission('share','',_config.sourcedata.icos[id])) {
		showDialog(_lang.prompt1.noprevelige,'notice');
		return;
	}
	OpenWindow('urlshare',_config.systemurl+'&op=dzzcp&do=urlshare&icoid='+id+'&uid='+_config.space.uid+'&handlekey=urlshare',_lang.WinTitle['urlshare']+':'+(name?name:_config.sourcedata.icos[id].name),'','width=400,height=400,titlebutton=close,resize=no,isModal=yes');
}
_ico.Share=function(id,name){
	OpenWindow('innershare',_config.systemurl+'&op=dzzcp&do=innershare&icoid='+id+'&uid='+_config.space.uid+'&handlekey=innershare',_lang.WinTitle['innershare']+':'+(name?name:_config.sourcedata.icos[id].name),'','width=500,height=400,titlebutton=close,resize=no,isModal=yes');
}
_ico.downAttach=function(id){
	//if(_config.Permission('download','',id)) {
		
		var data=_config.sourcedata.icos[id];
		if(data.bz && data.bz!=='') var url=DZZSCRIPT+'?mod=system&op=attachment&icoid='+encodeURIComponent(data.path)+'&bz='+data.bz;
		else var url=DZZSCRIPT+'?mod=system&op=attachment&icoid='+id;
		if(BROWSER.ie){
			window.open(url);
		}else{
			window.frames['hideframe'].location=url;
		}
	//}
	return false;
};
_ico.Empty=function(fid,confirmed){
	if(fid>0){
		if(!confirmed){
			Confirm(_lang.empty_folder.replace('{name}',_config.sourcedata.folder[fid].fname),function(){_ico.Empty(fid,true);});
			return;	
		}
		jQuery.getJSON(_config.systemurl+'&op=dzzcp&do=emptyFolder&fid='+fid+'&t='+new Date().getTime(),function(json){
			if(json.msg=='success'){
				var icos=[];
				for(var icoid in _config.sourcedata.icos){
					//icos.push(icoid);
					if(fid==_config.space.typefid['recycle']){
						
						if(_config.sourcedata.icos[icoid].isdelete>0) _ico.removeIcoid(icoid);
					}else{
						if(_config.sourcedata.icos[icoid].pfid==fid) _ico.removeIcoid(icoid);
					}
				}
				_config.sourcedata.folder[fid].iconum=0;
				if(_config.space.typefid['recycle']==fid) _ico.checkRecycleStatus();
			}else{
				Alert(json.msg);
			}
		});
	}
};

_ico.checkRecycleStatus=function(){
	var fid=_config.space.typefid['recycle'];
	var el=jQuery('.Icoblock.recycle .icoimgContainer img');//('img.Icoblock_icon').show();
	var src=el.attr('src').replace(/recycle\d*.png/i,'');
	if(_config.sourcedata.folder[fid].iconum>0){
		el.attr('src',src+'recycle1.png');
	}else{
		el.attr('src',src+'recycle.png');
	}
		
}
_ico.Restore=function(icoid){
	var data=_config.sourcedata.icos[icoid];
	var icoids=[];
	if( _config.selectall.icos.length>0 && jQuery.inArray(icoid,_config.selectall.icos)>-1){
		var data={icoid:_config.selectall.icos.join(',')};
		icoids=_config.selectall.icos;
	}else{
		var data={icoid:icoid};
		icoids=[icoid];
	}
	var url=_config.systemurl+'&op=dzzcp&do=restore&'+jQuery.param(data)+'&t='+new Date().getTime()
	jQuery.getJSON(url,function(json){
		if(json.msg=='success'){
			for(var i=0;i<icoids.length;i++){
				//从回收站中删除
				var pfid=_config.sourcedata.icos[icoids[i]].pfid;
				_config.sourcedata.icos[icoids[i]].isdelete=0;
				_select.IcoPasteTo([icoids[i]],[icoids[i]],pfid,0,0,0,1)	;		
			}
		}
	});
	
};
_ico.property=function(icoid){
	var ico=_config.sourcedata.icos[icoid];
	if(ico.bz && ico.bz!=''){
		icoid=encodeURIComponent(ico.path);
	}
	showWindow('property',_config.ajaxurl+'&do=property&icoid='+icoid);	
};

