/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function _layout(json){
	_layout.fid=json.typefid['desktop']||0;
	_layout.taskbar=json.taskbar;
	jQuery('#taskbar').addClass('taskbar-'+_layout.taskbar).show();
	jQuery('#startmenu').addClass(_layout.taskbar);
	//桌面分页层高度
	_layout.pageHeight=20;//jQuery('#page_nav_'+_layout.fid).outerHeight(true);
	//桌面边距；
	_layout.margintop=10;
	_layout.marginright=10;
	_layout.marginbottom=10+_layout.pageHeight;
	_layout.marginleft=10;
	
	_layout._body_margintop=0;
	_layout._body_marginright=0;
	_layout._body_marginbottom=0;
	_layout._body_marginleft=0;
	
	
	switch(json.taskbar){
		case 'bottom':
			_layout._body_marginbottom+=jQuery('#taskbar').height();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'top'});
			_layout.taskbar_direction=1;
			break;
		case 'left':
			_layout._body_marginleft+=jQuery('#taskbar').width();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'right'});
			_layout.taskbar_direction=2;
			break;
		case 'top':
			_layout._body_margintop+=jQuery('#taskbar').height();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'bottom'});
			_layout.taskbar_direction=1;
			break;
		case 'right':
			_layout._body_marginright+=jQuery('#taskbar').width();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'left'});
			_layout.taskbar_direction=2;
			break;
	}
	
	//图标排列方式
	_layout.iconview=json.iconview*1;
	
	_layout.direction=json.direction*1||0;
	//自动排列
	_layout.autolist=json.autolist>0?1:0;
	//图标起始位置
	_layout.iconposition=json.iconposition*1|| 0;//0:左上角；1：右上角；2：左下角；3：右上角
	_layout.currentPage=1;
	_layout.page=1;
	_layout.zIndex=++_layout.zIndex;
	_layout.position=json.positon;
	
	_layout.initContainer();
	
	
};

_layout.navbars={};
_layout.zIndex=0;

_layout.init=function(){
	var obj=new _layout(_config.space);
	 _layout.CIcoContainer();
	 _layout.createPage();
	//创建桌面容器
	return obj;
	
};
_layout.setPageNext=function(){
	var next=_layout.currentPage+1;
	if(next>_layout.page) next=1;
	_layout.setPage(next);
}
_layout.setPagePrev=function(){
	var prev=_layout.currentPage-1;
	if(prev<1) prev=_layout.page;
	_layout.setPage(prev);
}
_layout.setPage=function(index){
	if(_layout.setpageTimer>0) return;
	_layout.setpageTimer=1;
	_layout.currentPage=index;
	jQuery('#page_nav_'+_layout.fid).find('.page_nav_item').removeClass('current');
	jQuery('#page_nav_item_'+index).addClass('current').anim;
	
	jQuery('#icosContainer_body_'+_layout.fid).animate({'left':-((index-1)*_config.screenWidth-_layout.marginleft)},500,function(){
		_layout.setpageTimer=0;
	});
	jQuery('#_shadow_icosContainer_body_'+_layout.fid).css({'left':-((index-1)*_config.screenWidth-_layout.marginleft)});
	
}

 _layout.initContainer=function(){
	 jQuery('#_body').css({left:_layout._body_marginleft,top:_layout._body_margintop,width:(_config.screenWidth-_layout._body_marginleft-_layout._body_marginright),height:(_config.screenHeight-_layout._body_margintop-_layout._body_marginbottom)});
	jQuery('#icosContainer_body_'+_layout.fid).css({'left':_layout.marginleft,'top':_layout.margintop,'width':_config.screenWidth*_layout.page-_layout.marginleft-_layout.marginright-_layout._body_marginleft-_layout._body_marginright,'height':_config.screenHeight-_layout.margintop-_layout.marginbottom-_layout._body_margintop-_layout._body_marginbottom});
 }


_layout.setTaskbarPosition=function(p){
	if(p==_config.space.taskbar) return;
	var taskbar=document.getElementById('taskbar');
	taskbar.className='taskbar taskbar-'+p;
	document.getElementById('startmenu').className='startmenu fade in '+p;
	_config.space.taskbar=p;
	_layout._body_margintop=0;
	_layout._body_marginright=0;
	_layout._body_marginbottom=0;
	_layout._body_marginleft=0;
	
	switch(p){
		case 'bottom':
			_layout._body_marginbottom+=jQuery('#taskbar').height();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'top'});
			_layout.taskbar_direction=1;
			break;
		case 'left':
			_layout._body_marginleft+=jQuery('#taskbar').width();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'right'});
			_layout.taskbar_direction=2;
			break;
		case 'top':
			_layout._body_margintop+=jQuery('#taskbar').height();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'bottom'});
			_layout.taskbar_direction=1;
			break;
		case 'right':
			_layout._body_marginright+=jQuery('#taskbar').width();
			jQuery('#taskbar_start').tooltip('destroy').tooltip({placement:'left'});
			_layout.taskbar_direction=2;
			break;
	}
	_layout.resize();
	jQuery.post(_config.saveurl+'&do=userfield&datename=taskbar',{taskbar:p});
};
_layout.resize=function(){
	
	var width=_config.screenWidth-_layout.marginleft-_layout.marginright-_layout._body_marginleft-_layout._body_marginright;
	var height=_config.screenHeight-_layout.margintop-_layout.marginbottom-_layout._body_margintop-_layout._body_marginbottom;
	var divwidth=parseInt(_config.iconview[_layout.iconview].divwidth)||_ico.divwidth;
	var divheight=parseInt(_config.iconview[_layout.iconview].divheight)||_ico.divheight;
	var paddingleft=parseInt(_config.iconview[_layout.iconview].paddingleft)||_ico.paddingLeft;
	var paddingtop=parseInt(_config.iconview[_layout.iconview].paddingtop)||_ico.paddingTop;
	var sum_x=Math.floor((width+paddingleft)/(divwidth+paddingleft));
	if(sum_x<1) sum_x=1;
	var sum_y=Math.floor((height+paddingtop)/(divheight+paddingtop));
	if(sum_y<1) sum_y=1;
	var page=Math.ceil(_config.screenList.length/(sum_x*sum_y));
	if(_config.createpageTimer) window.clearTimeout(_config.createpageTimer);
	_config.createpageTimer=window.setTimeout(function(){
		
		if(page!=_layout.page){
			_layout.page=page;
			if(_layout.currentPage>page) _layout.currentPage=page;
			if(_config.createpageTimer) window.clearTimeout(_config.createpageTimer);
			_layout.createPage();
		}
		_layout.initContainer();
		_ico.refreshList(_layout.fid);
		_dock.refreshlist();
		_dock.setDockSize();
	},200);
}
_layout.createPage=function(){
	//创建容器
	if(_layout.currentPage>_layout.page) _layout.currentPage=_layout.page;
	if(_layout.page>1){
		if(document.getElementById('page_nav_'+_layout.fid)){
			var page_nav=jQuery('#page_nav_'+_layout.fid);
		}else{
			var page_nav=jQuery('<div id="page_nav_'+_layout.fid+'" class="page_nav_container"></div>').appendTo('#_body');
			_layout.pageHeight=page_nav.outerHeight(true);
			_layout.marginbottom=10+_layout.pageHeight;
			jQuery('#icosContainer_body_'+_layout.fid).css({'width':_config.screenWidth*_layout.page-_layout.marginleft-_layout.marginright,'height':_config.screenHeight-_layout.margintop-_layout.marginbottom-_layout._body_margintop-_layout._body_marginbottom});
		}
		
		//创建导航色块
		var html='';
		for(var i=1;i<=_layout.page;i++){
			
			html+='<div id="page_nav_item_'+i+'" class="page_nav_item " page="'+i+'">';
			html+='	   <table width="100%" height="100%">';
			html+='			<tr><td valign="middle"><div class="page_nav_block"></div></td></tr>';
			html+='		</table>';
			html+='</div>';
		}
		page_nav.html(html);
		page_nav.css('margin-left',-page_nav.width()/2);
		page_nav.find('.page_nav_item').on('click',function(){
			var page=jQuery(this).attr('page');
			jQuery(this).parent().find('.page_nav_item').removeClass('current');
			jQuery(this).addClass('current');
			_layout.currentPage=page;
			//jQuery(
		
			jQuery('#icosContainer_body_'+_layout.fid).animate({'left':-((page-1)*_config.screenWidth-_layout.marginleft)},500);
		});
		jQuery('#page_nav_'+_layout.fid+' .page_nav_item[page='+_layout.currentPage+']').trigger('click');
	}else{
		_layout.pageHeight=0;
		_layout.marginbottom=10+_layout.pageHeight;
		jQuery('#page_nav_'+_layout.fid).remove();
		jQuery('#icosContainer_body_'+_layout.fid).css({'left':_layout.marginleft,'top':_layout.margintop,'width':_config.screenWidth-_layout.marginleft-_layout.marginright-_layout._body_marginleft-_layout._body_marginright,'height':_config.screenHeight-_layout.margintop-_layout.marginbottom-_layout._body_margintop-_layout._body_marginbottom});
	}
	_layout.resize();
}

_layout.CIcoContainer=function(){
		var icolistcontainer=document.createElement('div');
		icolistcontainer.id='icosContainer_body_'+_layout.fid;
		icolistcontainer.className='icosContainer';
		icolistcontainer.setAttribute('unselectable',"on");
		icolistcontainer.setAttribute('onselectstart',"return event.srcElement.type== 'text';");
		icolistcontainer.style.cssText='width:'+(_config.screenWidth*_layout.page-_layout.marginleft-_layout.marginright-_layout._body_marginleft-_layout._body_marginright)+'px; height:'+(_config.screenHeight-_layout.margintop-_layout.marginbottom-_layout._body_margintop-_layout._body_marginbottom)+'px;left:'+(_layout.marginleft+_layout._body_marginleft)+'px;top:'+(_layout.margintop+_layout._body_margintop)+'px;';
		
		document.getElementById('_body').appendChild(icolistcontainer);
		jQuery(icolistcontainer).on('contextmenu',function(e){_contextmenu.right_body(e?e:window.event,_layout.fid);return false});
		
		if(_config.Permission_Container('multiselect',_layout.fid)){
			_select.init('icosContainer_body_'+_layout.fid);
		}
		jQuery('#icosContainer_body_'+_layout.fid).on('click',function(e){
			//清空数据
			//if(_hotkey.ctrl<1) return true;
			e=e?e:window.event;
			var tag = e.srcElement ? e.srcElement :e.target;
			if(tag.type=="text"||tag.type=="textarea"){
				return true;
			}	
			if(this.id==_config.selectall.container){
				_config.selectall.container=this.id;
				_config.selectall.icos=[];
				_config.selectall.position={};
				jQuery(this).find('.Icoblock').removeClass('Icoselected');
			}
		});
		 var input = document.createElement("input");
		input.id='input_icosContainer_body_'+_layout.fid;
		input.style.cssText="position:absolute;z-index:-999999;width:1px;height:1px;border:none;";
		input.setAttribute("multiple", "multiple");
		input.setAttribute("type", "file");
		input.setAttribute("name", "files[]");
	
		document.body.appendChild(input);
		
		
		if(_config.Permission_Container('upload',_layout.fid)){
			_layout.createUpload('input_icosContainer_body_'+_layout.fid,'icosContainer_body_'+_layout.fid,jQuery('#icosContainer_body_'+_layout.fid),jQuery('#icosContainer_body_'+_layout.fid));
		}
		
}
_layout.DetachEvent=function(e)
{
	
	if(!_layout.tach) return;
	document.body.style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	document.onmousemove=_layout.onmousemove;
	document.onmouseup=_layout.onmouseup;
	document.onselectstart=_layout.onselectstart;
	try{
		if(_layout.board.releaseCapture) _layout.board.releaseCapture();
	}catch(e){}
	_layout.tach=0;
	
};
_layout.AttachEvent=function(e)
{ 
	if(_layout.tach) return;
	
	_layout.onmousemove=document.onmousemove;
	_layout.onmouseup=document.onmouseup;
	_layout.onselectstart=document.onselectstart;
	
	try{
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else{
			if(this.board.setCapture) this.board.setCapture();
		}
	}catch(e){};
	_layout.tach=1;
};
_layout.Mousedown=function(e)
{
	if(e.button==2) return ;
	_layout.mousedowndoing=false;
	
	var XX=e.clientX;
	var YY=e.clientY;

	//alert('down');
	if(!_layout.tach) _layout.AttachEvent(e);
	_layout.even=e;
	_layout.mousedownTimer=setTimeout(function(){_layout.PreMove(XX,YY);},200);
};


_layout.Mouseup=function(e)
{
	
	if(_layout.tach) _layout.DetachEvent(e);
	if(!_layout.mousedowndoing) {
		clearTimeout(_layout.mousedownTimer);
	
	}else _layout.Moved(e);
};


_layout.PreMove=function(XX,YY)
{
	jQuery('#_blank').empty().show();
	_layout.mousedowndoing=true;
	if (typeof(_layout.MoveTimer)!="undefined") clearTimeout(_layout.MoveTimer);
	
	_layout.tl=XX-_layout.left;
	_layout.tt=YY-_layout.top;
	
	//var XX=e.clientX;
	//var YY=e.clientY;
	
		if (XX>document.body.clientWidth) XX=document.documentElement.clientWidth;
		if(XX<=0) XX=0;
		if (YY>(document.body.clientHeight)) YY=document.documentElement.clientHeight;
		if(YY<=0) YY=0;
		
	
	if(!_layout.tach) _layout.AttachEvent(_layout.even);
	document.onmousemove=function(e){_layout.Move(e?e:window.event);return false;};
	document.onmouseup=function(e){_layout.Moved(e?e:window.event);return false;};
};

_layout.Move=function(e)
{
	if(!_layout.tach) return;
	var XX=e.clientX;
	var YY=e.clientY;
	if (XX-_layout.tl+_layout.width>_config.screenWidth) XX=_config.screenWidth+_layout.tl-_layout.width;
	if(XX<=_layout.tl) XX=_layout.tl;
	if (YY-_layout.tt+_layout.height>_config.screenHeight) YY=_config.screenHeight+_layout.tt-_layout.height;
	if(YY-_layout.tt<=0) YY=_layout.tt;
	if(_layout.move!="move-y") {_layout.board.style.left=(XX-_layout.tl)+"px";_layout.left=XX-_layout.tl;}
	if(_layout.move!="move-x") {_layout.board.style.top=(YY-_layout.tt)+"px";_layout.top=YY-_layout.tt;}
};

_layout.Moved=function(e)
{
	jQuery('#_blank').hide();
	if(_layout.tach)	_layout.DetachEvent(e);
};
_layout.createUpload=function(id,container,dropzone,pastezone){
	
	var attachextensions=(_config.space.attachextensions).join('|');
	if(attachextensions=='') attachextensions="\.*$";
	else attachextensions="(\.|\/)("+(attachextensions)+")$";
	var fidarr=id.split('_');
	var	fid=fidarr.pop();
	jQuery('#'+id).fileupload({
				url: DZZSCRIPT+'?mod=system&op=dzzcp&do=upload&container='+container,
				dataType: 'json',
				autoUpload: true,
				maxChunkSize:2000000, //2M
				dropZone:dropzone,
				pasteZone:pastezone,
				sequentialUploads:true
			}).on('fileuploadsubmit', function (e, data) {
				
				jQuery.each(data.files, function (index, file) {
					var relativePath=(file.relativePath?file.relativePath:'')
					 data.formData = {relativePath: relativePath};
					return;
				});
			}).on('fileuploadprocessalways', function (e, data) {
				var index = data.index,
					file = data.files[index];
				if (file.error) {
					var relativePath=file.relativePath?file.relativePath:'';
					
				/*	var id=hex_md5(relativePath+file.name);
					var obj=_ico.icos['uploader_'+self.id+'_'+id];
					var text='<div class="upload_text" title="'+file.error+'">'+file.error+'</div>';
					jQuery('#text_'+obj.id).html(text).css('background','#f9d5de');
					jQuery('<div class="upload_failure_close"></div>').appendTo('#text_'+obj.id).bind('click',function(){_ico.removeIcoid(obj.id);});*/
					jQuery('#upload_progress').show();
					if(_config.progressTimer) window.clearTimeout(_config.progressTimer);
					jQuery('#upload_progress .progress-title').html(relativePath+file.name+'<p class="text-error">'+file.error+'</p>');
					_config.progressTimer=window.setTimeout(function(){jQuery('#upload_progress').fadeOut(500)},2000);
					
				}
				
			})
			.on('fileuploadprogress', function (e, data) {
				
				jQuery('#upload_progress').show();
				if(_config.progressTimer) window.clearTimeout(_config.progressTimer);
				 jQuery.each(data.files, function (index, file) {
						jQuery('#upload_progress .progress-title').text((file.relativePath?file.relativePath:'')+file.name);
				});
			})
			.on('fileuploadprogressall', function (e, data) {
				jQuery('#upload_progress').show();
				if(_config.progressTimer) window.clearTimeout(_config.progressTimer);
				var progress = parseInt(data.loaded / data.total * 100, 10);
				jQuery('#upload_progress .bar').css(
					'width',
					progress + '%'
				);
			}).on('fileuploaddone', function (e, data) {
				if(_config.progressTimer) window.clearTimeout(_config.progressTimer);
				_config.progressTimer=window.setTimeout(function(){jQuery('#upload_progress').fadeOut(500)},2000);
				jQuery.each(data.result.files, function (index, file) {
					
				   if(file.error){
					  var relativePath=(file.relativePath?file.relativePath:'');
						jQuery('#upload_progress').show();
						if(_config.progressTimer) window.clearTimeout(_config.progressTimer);
						jQuery('#upload_progress .progress-title').html(relativePath+file.name+'<p class="text-error">'+file.error+'</p>');
						_config.progressTimer=window.setTimeout(function(){jQuery('#upload_progress').fadeOut(500)},2000);
						//continue;
				   }else{
					  
					   var relativePath=file.relativePath||'';
						var id=hex_md5(relativePath+file.name);
						var obj=_ico.icos['uploader_'+self.id+'_'+id];
						if(obj) jQuery(obj.board).remove();
						if(file.data.folderarr){
							for(var i=0;i< file.data.folderarr.length;i++){
								_config.sourcedata.folder[file.data.folderarr[i].fid]=file.data.folderarr[i];
							}
						}
						if(file.data.icoarr){
							for(var i=0;i< file.data.icoarr.length;i++){
								_ico.createIco(file.data.icoarr[i]);
							}
						}
						
				   }
				});
			}).on('fileuploadfail', function (e, data) {
				
				if(_config.progressTimer) window.clearTimeout(_config.progressTimer);
				_config.progressTimer=window.setTimeout(function(){jQuery('#upload_progress').fadeOut(500);},2000);
				jQuery.each(data.files, function (index, file) {
					
					var relativePath=file.relativePath||'';
					jQuery('#upload_progress').show();
					if(_config.progressTimer) window.clearTimeout(_config.progressTimer);
					jQuery('#upload_progress .progress-title').html(relativePath+file.name+'<p class="text-error">'+file.error+'</p>');
					_config.progressTimer=window.setTimeout(function(){jQuery('#upload_progress').fadeOut(500)},2000);
				});
			}).on('fileuploaddrop',function(e,data){
				var url=e.dataTransfer.getData("text/plain");
				if(url){
					 e.preventDefault();
					if( _config.Permission_Container('link',fid)){
						jQuery.getJSON(_config.systemurl+'&op=dzzcp&do=newlink&path='+parseInt(fid)+'&handlekey=handle_add_newlink&link='+encodeURIComponent(url),function(json){
								if(!json) Alert(_lang.network_error,1);
								else if(json.error){
									Alert(json.error,3);
								}else{
									_ico.createIco(json);
								}
							});
						return false;
					}
				}
			}).on('fileuploaddragover',function(e){
				 e.dataTransfer.dropEffect = 'copy';
                    e.preventDefault();
			});
}


