/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

_config.isPower=function(power,action){//判断有无权限;
	var actionArr={   'flag'      : 1,		//标志位为1表示权限设置,否则表示未设置，继承上级；
  					  'upload'    : 2,		//上传
					  'folder'    : 4,		//新建文件夹
					  'link'      : 8,      
					  'document'  : 16,
					  'image'	  : 32,
					  'music'	  : 64,
					  'video'	  : 128,				 
					  'app'   	  : 256,
					  'topic'     : 512,
					  'attach'	  : 1024,	
					  'user'	  : 2048,	
					  'delete'    : 4096,	//允许所有者删除自己的文件或文件夹	
					  'permedit'  : 8192,	//允许所有者编辑容器权限	
					  'edit'      : 16384,	//允许所有者编辑文件属性（名称，图标等）
					  'share'      :32768 	//允许所有者分享文件
	};
	if(power<5) return false;
	else return true;
	if(parseInt(actionArr[action])<1) return false;
	//权限比较时，进行与操作，得到0的话，表示没有权限  
    if( (power & parseInt(actionArr[action])) == 0 ) return false;  
    return true; 
}
_config.FolderSPower=function(power,action){//判断有无权限;
	var actionArr={   'delete'  : 1,		
  					  'folder'  : 2,		
					  'link'   	: 4,		
					  'upload'  : 8,      
					  'document': 16,
					  'topic'	: 32,
					  'app'	  	: 64,
					  'widget'	: 128,	
					  'user'    : 256		 
	};
	//alert([power,action]);
	if(action=='copy') action='delete';
	if(parseInt(actionArr[action])<1) return true;
	//权限比较时，进行与操作，得到0的话，表示没有权限  
    if( (power & parseInt(actionArr[action])) == parseInt(actionArr[action]) ) return false;  
    return true; 
}
_config.FileSPower=function(power,action){//判断有无权限;
   
	var actionArr={   'delete'      : 1,		
  					  'edit'  		 : 2,		
					  'rename'   	: 4,		
					  'move'	    : 8,      
					  'download'  	: 16,
					  'share'		: 32,
					  'widget'	  	: 64,
					  'wallpaper'	: 128			 
	};
	if(action=='copy') action='delete';
	if(parseInt(actionArr[action])<1) return true;
	//权限比较时，进行与操作，得到0的话，表示没有权限  
    if( (power & parseInt(actionArr[action])) == parseInt(actionArr[action]) ) return false;  
    return true; 
}

/*_config.Permission_Container_nogroup=function(action,perm){
	if(action=='admin' || action=='multiselect' || action=='widget') return true;
	if(action=='download' || action=='saveto' || action=='copy') return true;
	//alert(action+'=========='+perm+'======='+_config.isPower(perm,action));
	if(_config.isPower(perm,action)){
		return true;
	}else{
		return false;
	}
}
_config.Permission_Container_group=function(action,perm){
	if(action=='admin' || action=='multiselect'){
		if(_config.group.ismoderator>0) return true;
		else return false;
	}
	
	//是群组管理员的话，只有群组等级里设置的有的权限都会开启；
	if(_config.group.ismoderator>0 && _config.isPower(_config.group.grouplevel.perm,action)) {
		return true;
	}
	if(_config.group.isgroupuser<1) return false;
	
	if(action=='download' || action=='saveto' || action=='copy') return true;
	if(_config.isPower(perm,action)){
		return true;
	}else{
		return false;
	}
}*/
_config.getFidByContainer=function(container){
	if(container.indexOf('icosContainer_body_')!==-1){
		return _config.space.typefid['desktop'];
	}else if(container=='taskbar_dock'){
		return _config.space.typefid['dock'];
	}else if(container=='_dock'){
		return _config.space.typefid['dock'];
	}else if(container.indexOf('icosContainer_folder_')!==-1){
		return container.replace('icosContainer_folder_','');
	}
}
_config.getContainerByFid=function(fid){
	var type='';
	for(var i in _config.space.typefid){
		if(fid==_config.space.typefid[i]) type=i;
	}
	var container='';
	if(type=='dock') container='_dock';
	else if(type=='desktop') container='icosContainer_body_'+_layout.fid;
	else{
		container='icosContainer_folder_'+fid;
	}
	return container;
}

_config.Permission_Container=function(action,fid){
	//预处理些权限
	//首先判断超级权限
	//if(action=='multiselect') return false;
	
	//var fid=_config.getFidByContainer(container);

	if(!_config.sourcedata.folder[fid]) return false;
	var perm=_config.sourcedata.folder[fid].perm;
	var sperm=_config.sourcedata.folder[fid].fsperm;	
	//alert(fid+'===='+perm+'===='+sperm+'==='+action+'====='+_config.FolderSPower(sperm,action));
	//判断超级权限

	if(!_config.FolderSPower(sperm,action)) return false;
	//alert(action+'==='+container);
	if(_config.myuid<1) return false;//游客没有权限；
	if(_config.space.self>1){
		 return true;//系统管理员有权限
	}
	if(_config.isPower(perm,action)){
		return true;
	}
	return false;
}

_config.Permission=function(action,data){
	if(_config.myuid<1) return false; //游客无权限；
	//if(action=='multiselect') return false;
	/*if(!container){
		var desktop=data.desktop;
		if(desktop=='d:-1') container='_dock';
		else if(desktop.indexOf('d:')!==-1) container='icosContainer_body_'+desktop.replace('d:','');
		else if(desktop.indexOf('f:')!==-1) container='icosContainer_folder_'+desktop.replace('f:','');
		else if(desktop.indexOf('s:')!==-1) container='_system';
	}*/
	//预处理些权限
	if(data.isdelete>0) return true; //回收站有权限；
	var fid=data.pfid;
	var sperm=data.sperm;
	if(!_config.FileSPower(sperm,action)) return false;
	
	if(action=='download'){ //不是附件类型的不能下载
		if(data.type!='document' && data.type!='attach' && data.type!='image') return false;
	}else if(action=='copy'){ //回收站内不能复制
		if(data.flag=='recycle') return false;
		if(data.type=='app' ||  data.type=='storage' || data.type=='baidu') return false;
		
	}else if(action=='paste'){ //没有复制或剪切，没法粘帖
		if(_config.cut.icos.length<1) return false;
		action=_config.sourcedata.icos[_config.cut.icos[0]].type;
	}else if(action=='edit'){
		if((data.bz && data.bz!='') || data.type=='music' || data.type=='video' || data.type=='image' || ((data.type=='attach' || data.type=='document') && jQuery.inArray(data.ext.toUpperCase(),_config.txtexts)<0)){
			return false;
		}
	
	}else if(action=='rename'){ //重命名
		if(data.bz && data.bz!='') return false;
		if(fid==_config.space.typefid['dock']) return false;
	}else if(action=='saveto'){ //lin
		
	}
	if(_config.Permission_Container(action,fid)){ //如果容器有权限是，如果是delete,permedit,edit,判断是不是自己的
		return true;
	}else{
		return false;
	}
};
