/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function _select(container)
{
	this.id=this.name=container;
	this.string="_select.icos."+this.id;
	this.board=document.getElementById(container);
	_select.icos[this.id]=this;
};
_select.delay=500;
_select.width=120;
_select.height=120;
_select.icos={};

_select.onmousemove=null;
_select.onmouseup=null;
_select.tach=null;
_select.onselectstart=1;
_select.init=function(container){
	var obj= new _select(container);
	jQuery(obj.board).on('mousedown',function(e){
		e=e?e:window.event;
		var tag = e.srcElement ? e.srcElement :e.target;
		
		if(tag.type=="text"||tag.type=="textarea"){
			return true;
		}	
		if(e.button==2) return true;
		dfire('mousedown');
		obj.Mousedown(e?e:window.event);
	});
	jQuery(obj.board).on('mouseup',function(e){
		e=e?e:window.event;
		var tag = e.srcElement ? e.srcElement :e.target;
		if(tag.type=="text"||tag.type=="textarea"){
			return true;
		}		
		obj.Mouseup(e?e:window.event);
	});
	return obj;
};
_select.prototype.DetachEvent=function(e)
{
	if(!_select.tach) return;
	document.body.style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	document.onmousemove=_select.onmousemove;
	document.onmouseup=_select.onmouseup;
	document.onselectstart=_select.onselectstart;
	try{
		if(this.board.releaseCapture) this.board.releaseCapture();
	}catch(e){};
	_select.tach=0;
	_select.finishblank=0;
	
};
_select.prototype.AttachEvent=function(e)
{ 
	if(_select.tach) return
	_select.onmousemove=document.onmousemove;
	_select.onmouseup=document.onmouseup;
	_select.onselectstart=document.onselectstart;
	try{
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else{
			if(this.board.setCapture) this.board.setCapture();
		}
	}catch(e){};
	_select.tach=1;
};
_select.prototype.Duplicate=function()
{
	this.copy=document.createElement('div');
	
	document.body.appendChild(this.copy);
	this.copy.style.cssText="position:absolute;left:0px;top:0px;width:0px;height:0px;filter:Alpha(opacity=50);opacity:0.5;z-index:9000;overflow:hidden;background:#000;border:1px solid #000;";
	//jQuery(this.copy).find('#text'+this.id).html('&nbsp;');
};
_select.prototype.Mousedown=function(e)
{
	this.mousedowndoing=false;
	var XX=e.clientX;
	var YY=e.clientY;
	//alert('down');
	_select.even=e?e:window.event;
	var self=this;
	if(_hotkey.alt>0) return true;
	if(BROWSER.mozilla) e.preventDefault();
	this.mousedownTimer=setTimeout(function(){self.PreMove(XX,YY);},200);
};

_select.prototype.Mouseup=function(e)
{
	if(_select.tach) this.DetachEvent(e);
	if(!this.mousedowndoing) {
		clearTimeout(this.mousedownTimer);
	}else this.Moved(e);
};
_select.prototype.PreMove=function(XX,YY)
{
	jQuery('#_blank').empty().show();
	if (this.move=="no") return;
	this.Duplicate();
	_select.oldxx=XX;
	_select.oldyy=YY;
	var self=this;
	this.mousedowndoing=true;
	if (typeof(this.MoveTimer)!="undefined") clearTimeout(this.MoveTimer);
	var p=jQuery(this.board).offset();
	
	this.tl=XX;
	this.tt=YY;
	this.oldx=XX;
	this.oldy=YY;
	this.copy.style.left=this.tl+'px';
	this.copy.style.top=this.tt+'px';
	
	//清空数据
	if(_hotkey.ctrl>0 && _config.selectall.container==this.id){
		
	}else{
		jQuery('#'+_config.selectall.container).find('.Icoblock').removeClass('Icoselected');
		_config.selectall.container=this.id;
		_config.selectall.icos=[];
		_config.selectall.position={};
	}
		//计算此容器内的所有ico的绝对位置，并且存入_config.selectall.position中；
		jQuery(this.board).find('.Icoblock').each(function(){
			var el=jQuery(this);
			var p=el.offset();
			var icoid=el.attr('icoid');
			//if(!jQuery.isNumeric(icoid)) return;
			if(icoid){
				_config.selectall.position[icoid]={icoid:icoid,left:p.left,top:p.top,width:el.width(),height:el.height()};
			}
		});
	if(!_select.tach) this.AttachEvent(_select.even);
	document.onmousemove=function(e){self.Move(e?e:window.event);return false;};
	document.onmouseup=function(e){self.Moved(e?e:window.event);return false;};
};
_select.prototype.Move=function(e)
{
	
	if(!_select.tach) return;
	var XX=e.clientX;
	var YY=e.clientY;
	
	var flag=0;
	if(XX-this.oldx>0){
		this.copy.style.width=(XX-this.oldx)+"px";
	}else{
		this.copy.style.width=Math.abs(XX-this.oldx)+"px";
		this.copy.style.left=this.tl+(XX-this.oldx)+"px";
	}
	if(YY-this.oldy>0){
		this.copy.style.height=(YY-this.oldy)+"px";
	}else{
		this.copy.style.height=Math.abs(YY-this.oldy)+"px";
		this.copy.style.top=this.tt+(YY-this.oldy)+"px";
	}
	if(!BROWSER.ie){
		//if(Math.abs(_select.oldxx-XX)>20 || Math.abs(_select.oldyy-YY)>20){
			if(XX>this.oldx && YY > this.oldy){
				this.setSelected(true);
			}else{
				this.setSelected();
			}
	/*	}else{
			_select.oldxx=XX;
			_select.oldyy=YY;
		}*/
	}
};
_select.prototype.Moved=function(e)
{
	var self=this;
	jQuery('#_blank').hide();
	
	var XX=e.clientX;
	var YY=e.clientY;
	if(BROWSER.ie){
		if(XX>this.oldx && YY > this.oldy){
			this.setSelected(true);
		}else{
			this.setSelected();
		}
	}
	if(_select.tach)	this.DetachEvent(e);
	jQuery(this.copy).remove();
	
};
_select.prototype.setSelected=function(flag){
	_select.sum++;
	var p=jQuery(this.copy).offset();
	var icos=[];
	var copydata={left:p.left,top:p.top,width:jQuery(this.copy).width(),height:jQuery(this.copy).height()};
	for(var icoid in _config.selectall.position){
		/*if(!_config.Permission_view('icoid',icoid)){
			continue;
		}*/
		if(_config.sourcedata.icos[icoid].notdelete>0 && _config.sourcedata.icos[icoid].type!='app') continue;
		if(!_config.FileSPower(_config.sourcedata.icos[icoid].sperm,'move')) continue;
		var data=_config.selectall.position[icoid];
		if(_select.checkInArea(copydata,data,flag)){
			_select.SelectedStyle(this.id,icoid,true,true);
		}else if(_hotkey.ctrl<1){
			_select.SelectedStyle(this.id,icoid,false,true);
		}
	}
};
_select.checkInArea=function(copydata,data,flag){
	var rect={minx:0,miny:0,maxx:0,maxy:0}
	rect.minx=Math.max(data.left,copydata.left);
	rect.miny =Math.max(data.top,copydata.top) ;
	rect.maxx =Math.min(data.left+data.width,copydata.left+copydata.width) ;
	rect.maxy =Math.min(data.top+data.height,copydata.top+copydata.height) ;
	if(!flag){
		if(rect.minx>rect.maxx || rect.miny>rect.maxy){
			return false;
		}else{
			return true
		}
	}else{
		if(rect.minx>rect.maxx || rect.miny>rect.maxy){
			return false;
		}else{
			var area=(rect.maxx-rect.minx)*(rect.maxy-rect.miny);
			var dataarea=data.width*data.height;
			if(dataarea==area) return true;
			else return false;
		}
	}
};
_select.SelectedStyle=function(container,icoid,flag,multi){
	var icos=_config.selectall.icos||[];
	var fidarr=container.split('-');
	var fid=parseInt(fidarr[1]);
	var filemanageid='f-'+fidarr[1]+'-'+fidarr[2];
	if(!_config.FileSPower(_config.sourcedata.icos[icoid].sperm,'move')) return;
	var el=jQuery('#'+container).find('.Icoblock[icoid='+icoid+']');
	if(flag){
		if(_config.selectall.container=='') _config.selectall.container=container;
		if(multi && _config.selectall.container==container){
			if(jQuery.inArray(icoid,_config.selectall.icos)<0){
			 	_config.selectall.icos.push(icoid);
			}
		}else{
			jQuery('#'+_config.selectall.container).find('.Icoblock').removeClass('Icoselected');
			_config.selectall.container=container;
			_config.selectall.icos=[icoid];
			_config.selectall.position={};
		}
		el.addClass('Icoselected');
		
	}else{
			el.each(function(){
				if(jQuery(this).hasClass('file-line')){
					var el1=jQuery(this);
					el1.off('.drag');
				}
			});
		var arr=[];
		if(_config.selectall.container==container){
			for(var i in icos){
				if(icos[i]!=icoid) arr.push(icos[i]);
			}
		}
		_config.selectall.icos=arr;
		el.removeClass('Icoselected');	
	}
	if(_filemanage.cons[filemanageid]) _filemanage.cons[filemanageid].selectInfo();
};
_select.Cut=function(icoid){
	//处理原对象 去除样式
	if(_config.cut.iscut>0 && _config.cut.icos.length>0){
		for(var i in _config.cut.icos){
			jQuery('.Icoblock[icoid='+_config.cut.icos[i]+']').removeClass('iscut');
		}
	}
	//添加新对象到剪切板，并且设置剪切样式
	_config.cut.iscut=1;
	if(jQuery.inArray(icoid,_config.selectall.icos)>-1){
		_config.cut.icos=_config.selectall.icos;
	}else{
		_config.cut.icos=[icoid];
	}
	for(var i in _config.cut.icos){
		jQuery('.Icoblock[icoid='+_config.cut.icos[i]+']').addClass('iscut');
	}
}
_select.Copy=function(icoid){
	//处理原对象 去除样式
	if(_config.cut.iscut>0 && _config.cut.icos.length>0){
		for(var i in _config.cut.icos){
			jQuery('.Icoblock[icoid='+_config.cut.icos[i]+']').removeClass('iscut');
		}
	}
	//添加新对象到剪切板，并且设置剪切样式
	_config.cut.iscut=0;
	if(jQuery.inArray(icoid,_config.selectall.icos)>-1){
		_config.cut.icos=_config.selectall.icos;
	}else{
		_config.cut.icos=[icoid];
	}
	
}
_select.Paste=function(pfid,XX,YY){
	if(_config.cut.icos.length<1) return ;//剪贴板无数据，返回;
	//判断默认应用不能更换容器
	/*for(var i=0;i<_config.cut.icos.length;i++){
		if(_config.cut.iscut>0 && !_config.Permission('delete',_config.sourcedata.icos[_config.cut.icos[i]])){
			_config.cut.icos.splice(i,1);
			jQuery('.Icoblock[icoid='+_config.cut.icos[i]+']').removeClass('iscut');
			//showPrompt(null,'',_lang.default_app_not_move,1000);
		}
	}*/
	
	//判断容器是否接受此类图标；
	/*if(!_config.Permission_Container(_config.sourcedata.icos[_config.cut.icos[0]].type,pfid)){
			showPrompt(null,'',_lang.paste.paste_in_here_forbidden,1000);
			return ;
	}*/
	//获得目标路径的tbz
	var tbz=_config.sourcedata.folder[pfid].bz||'';
	if(tbz){
		var path=_config.sourcedata.folder[pfid].path
	}else{
		var path=pfid;
	}
	
	//组织data
	if(_config.sourcedata.icos[_config.cut.icos[0]].bz && _config.sourcedata.icos[_config.cut.icos[0]].bz!=''){
		var paths=[];
		for(var i=0;i<_config.cut.icos.length;i++){
			paths.push(_config.sourcedata.icos[_config.cut.icos[i]].path);
		}
		
		var data={"obz":_config.sourcedata.icos[_config.cut.icos[0]].bz,"tbz":tbz,"sourcetype":"icoid","icoid":paths.join(','),"ticoid":0,"container":'icosContainer_folder_'+path,iscut:_config.cut.iscut>0?1:2};
	}else{
		var data={"obz":'',"tbz":tbz,"sourcetype":"icoid","icoid":_config.cut.icos.join(','),"ticoid":0,"container":'icosContainer_folder_'+path,iscut:_config.cut.iscut>0?1:2};
	}
	var container=_config.getContainerByFid(pfid);
	
	var progress='<div class="progress progress-striped active" style="margin:0"><div class="bar" style="width:100%;"></div></div>'
	//alert(_config.saveurl+'&do=move&gid='+_config.gid+'&'+jQuery.param(data));
	showmessage('<p>文件拖动处理中，请不要关闭浏览器或刷新页面</p>'+progress,'info',0,1,'right-bottom');
	jQuery.getJSON(_config.saveurl+'&do=move&'+jQuery.param(data),function(json){
		if(json.msg=='success'){
			 _config.cut.icos=[];
				_config.cut.successicos=[];
				_config.cut.osuccessicos=[];
				
				for(var ico in json.successicos){
					_config.cut.successicos.push(json.successicos[ico]);
					_config.cut.osuccessicos.push(ico);
					
				}
				if(json.iscopy>0){
					showmessage('文件复制成功！','success',3000,1,'right-bottom')
					
				}else{
					showmessage('文件剪切成功！','success',3000,1,'right-bottom')
				   _select.remove(_config.cut.osuccessicos);
				  
				}	
				for(var i in json.icoarr){
					_config.sourcedata.icos[json.icoarr[i].icoid]=json.icoarr[i];
				}
				for(var i in json.folderarr){
					_config.sourcedata.folder[json.folderarr[i].fid]=json.folderarr[i];
				}
				_ico.appendIcoids(_config.cut.successicos);
				if(json.error){
					showmessage('文件操作失败！','error',3000,1,'right-bottom');
				}
				
		}else{
			showmessage('文件操作失败！','error',3000,1,'right-bottom');
		}
	});
};
_select.remove=function(icos){//移除原来的icoid
	for(var i=0;i<icos.length;i++){
		_ico.removeIcoid(icos[i]);
	}
}
