/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function _start(appid,pos)
{
	this.id=this.name=appid;
	this.string="_start.icos."+this.id;
	this.zIndex=++_start.zIndex;
	this.ispng=false;
	this.data=_config.sourcedata.app[appid];
	this.className=_start.className
	this.container='startmenu_app';
		
	this.width=_start.width;
	this.height=_start.height;
	this.divwidth=_start.divwidth;
	this.divheight=_start.divheight;
	this.pos=pos || 0;
	_start.icos[this.id]=this;

};
_start.icos={};
_start.zIndex=0;
_start.className='startapp';
/*_start.indocksum=5;
_start.istaskup=0;*/
_start.divwidth=70;
_start.divheight=70;
_start.width=40;
_start.height=40;
_start.padding=10;
_start.jumps=[];//跳动中的任务栏

_start.init=function(){
	//创建dockico
	var appList=_config.appList;
	for(var j=0;j<appList.length;j++){
		var obj=_start.CIco(appList[j],j);
	}

	
	_start.currentPage=1;
	_start.setPage();
	
	jQuery('#taskbar_start').on('click',function(){
		jQuery('#startmenu').toggle();
	});
	
	jQuery(document).on('mousedown',function(e){
			//var obj = event.srcElement ? event.srcElement : event.target;
			e=e?e:window.event;
			var obj = e.srcElement ? e.srcElement :e.target;
			if(checkInDom(obj,'startmenu')==false && checkInDom(obj,'right_contextmenu')==false){
				jQuery('#startmenu').hide();
			}
		});
	jQuery('#taskbar').mousedown(function(e){_start.mousedown(e?e:window.event);dfire('mousedown');return false}).mouseup(function(e){_start.mouseup(e?e:window.event);dfire('mouseup');return false;});
	
	if(_config.myuid<1) jQuery('#taskbar_start').trigger('click'); //游客默认打开开始菜单
};
_start.refreshlist=function(){
	jQuery('#startmenu_app').empty();
	
	for(var j=0;j<_config.appList.length;j++){
		var obj=_start.CIco(_config.appList[j],j);
	}
	_start.setCurrent(_start.currentPage);
}
_start.setPage=function(){
	var sum=Math.ceil(_config.appList.length/16);
	_start.page=sum;
	jQuery('#startmenu_app').width(sum*360);
	if(_start.currentPage>sum) _start.currentPage=sum;
	if(_start.currentPage<1) _start.currentPage=1;
	var page=''; 
	if(sum>1){ //大于1页时才显示页导航
		for(var i=1;i<=sum;i++){
		   page+='<a id="startmenu_page_'+i+'" class="startmenu-page-guide "><div class="startmenu-page-guide-block" style="width:100%;height:100%"></div></a>';
		}
		jQuery('#startmenu_page').html(page);
	}
	_start.setCurrent(_start.currentPage);
	var width=jQuery('#startmenu_page_1').outerWidth(true)*sum;
	if(width>300){
		var width_item=Math.floor(300/sum)-20;
		jQuery('#startmenu_page .startmenu-page-guide').width(width1);
	}
	jQuery('#startmenu_page .startmenu-page-guide').on('click',function(){
		var index=parseInt(this.id.replace('startmenu_page_',''));
		_start.setCurrent(index);
	});
}
_start.setCurrent=function(index){
	if(!index){
		index=_start.currentPage;
	}
	if(index>_start.page) index=_start.page;
	else if(index<1) index=1;
	jQuery('#startmenu_page .startmenu-page-guide').removeClass('current');
	jQuery('#startmenu_page_'+index).addClass('current');
	jQuery('#startmenu_app').animate({'left':-(index-1)*360},500);
	_start.currentPage=index;
}
_start.CIco=function(id,pos){
	var obj= new _start(id,pos);
	obj.create();
	return obj;
};
_start.Operation=function(appid,op){
	switch(op){
		case 'todesktop':
			_start.appLinkTo(appid,_layout.fid);
			break;
		case 'todock':
			_start.appLinkTo(appid,_config.space.typefid['dock']);
			break;
		case 'uninstall':
			_start.appUninstall(appid);
			break;
	}
};
_start.appLinkTo=function(appid,pfid){
	
	jQuery.getJSON(_config.systemurl+'&op=dzzcp&do=applinkto&appid='+appid+'&pfid='+pfid,function(json){
		if(json.error){
			showmessage(json.error,'error',3000,1,'right-bottom');
		}else{
			_ico.createIco(json)
		}
	});
}
_start.appUninstall=function(appid){
	jQuery.getJSON(_config.systemurl+'&op=dzzcp&do=appuninstall&appid='+appid,function(json){
		if(json.error){
			showmessage(json.error,'error',3000,1,'right-bottom');
		}else{
			if(json.icoid>0) _ico.removeIcoid(json.icoid);
			_start.removeIco(appid);
		}
	});
};
_start.removeIco=function(appid){
	var obj=_start.icos[appid];
	//移除applist
	var i=jQuery.inArray(appid,_config.appList);
	if(i>-1)_config.appList.splice(i,1);
	_start.refreshlist();
};
_start.Open=function(appid){
	OpenApp(appid);
	jQuery('#startmenu').hide();    
}
_start.prototype.getpos=function(){
	var p=[_start.padding,_start.padding];
	var page=Math.floor(this.pos/16);
	var heng=Math.floor((this.pos-page*16)/4);
	var lie=(this.pos-page*16)%4;
	return [360*page+lie*(_start.padding*2+_start.divwidth)+_start.padding,heng*(_start.padding*2+_start.divwidth)+_start.padding];
}
_start.prototype.create=function(){
	this.board=document.createElement("div");
	this.board.className=this.className;
	this.board.setAttribute('appid',this.id);
	this.board.id='startapp_'+this.id;
	
	var imgclass='radius';
	var html='<img  class="'+imgclass+'" src="'+this.data.appico+'"  title="'+this.data.appname+'" style="width:'+this.width+'px; height:'+this.height+'px">';
	var text="<tr ><td valign='middle' align='center'><a class='appname'>"+this.data.appname+"</a></td></tr>";
	this.board.innerHTML="<table width='"+(this.divwidth)+"' height='"+(this.divheight)+"' ><tr height='"+(this.divheight-24)+"'><td align='center' valign='middle' style=\"overflow:hidden;\" id='html_"+this.id+"'>"+html+"</td></tr>"+text+"</table>";
	
	
	var self=this;
	//创建空层
	
		this.icoblank=document.createElement("div");
		this.icoblank.style.position="absolute";
		this.icoblank.className='task_icoblank';
		this.icoblank.title=this.data.appname;
		this.icoblank.id='_blank_'+this.id;
		
		this.board.appendChild(this.icoblank);
		this.icoblank.style.cssText="position:absolute;;left:0px;top:0px; background:url('dzz/images/b.gif');width:"+this.divwidth+"px; height:"+this.divheight+"px;z-index:"+(this.zIndex+1);
		
		
		
	//创建背景层
	
		this.board_background=document.createElement("div");
		this.board_background.className='backgound_radius';
		this.board.appendChild(this.board_background);
		this.board_background.style.cssText="position:absolute;left:0px;top:0px;z-index:-5;width:"+(this.divwidth-2)+"px;height:"+(this.divheight-2)+"px;";
		
	//事件处理	
		var el=jQuery(this.icoblank);
		el.find('.icoblank_tip .icon').click(function(){
			var op=jQuery(this).attr('op');
			_start.Operation(self.id,op);
			return false;
		});
		el.on('contextmenu',function(e){ _contextmenu.startmenu(e?e:window.event,self.id); return false;});
		el.on('mouseenter',function(){jQuery(self.board).addClass('hover');});
		el.on('mouseleave',function(){jQuery(self.board).removeClass('hover');});
		el.on('click',function(){ 
			_start.Open(self.id);
		});
		el.mousedown(function(e){
			self.icoMousedown(e?e:window.event);
		});
		el.mouseup(function(e){
			self.icoMouseup(e?e:window.event);
		});
		//el.on('contextmenu',function(e){ _contextmenu.right_startapp(e?e:window.event,self.id,'',self.container); return false;});
		
		//if(this.Parent=='Recycle')	jQuery(this.icoblank).bind('contextmenu',function(e){ self.Icomenu(e?e:window.event); return false;});
		//jQuery(this.icoblank).bind('click',function(e){ _config.OpenApp(self.id);return false;});
		
		document.getElementById(this.container).appendChild(this.board);
		var pos=this.getpos();
		this.left=pos[0];
		this.top=pos[1];
		
		this.board.style.position='absolute';
		this.board.style.left=this.left+'px';
		this.board.style.top=this.top+'px';
		this.board.style.width=(this.divwidth)+'px';
		this.board.style.height=(this.divheight)+'px';
		this.board.style.zIndex=this.zIndex;
		//this.board.style.overflow="hidden";
};
_start.DetachEvent=function(e,id)
{
	if(!_start.tach) return;
	document.onmousemove=_start.onmousemove;
	document.onmousemove=_start.onmousemove;
	document.onmouseup=_start.onmouseup;
	document.onselectstart=_start.onselectstart;
	if(document.getElementById(id) && document.getElementById(id).releaseCapture) document.getElementById(id).releaseCapture();
	_start.tach=0;
	jQuery('#_blank').hide();
	//jQuery('.window_blank').css('z-index',100);
	//jQuery(this.blank).css('z-index',-1);
};
_start.AttachEvent=function(e,id)
{
	if(_start.tach) return;
	_start.onmousemove=document.onmousemove;
	_start.onmouseup=document.onmouseup;
	_start.onselectstart=document.onselectstart;
	try{
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else if(document.getElementById(id)){
			if(document.getElementById(id).setCapture) document.getElementById(id).setCapture();
		}
	}catch(e){};
	_start.tach=1;
};



_start.mouseup=function(e)
{
	if(_start.tach) _start.DetachEvent(e);
	if(!_start.mousedowndoing){
		clearTimeout(_start.mousedownTimer);
	}
};
_start.mousedown=function(e)
{
	if(e.button==2) return ;
	var XX=e.clientX;
	var YY=e.clientY;
	_start.mousedowndoing=false;
	_start.even=e?e:window.event;
	if(!_start.tach) _start.AttachEvent(e);
	_start.mousedownTimer=setTimeout(function(){_start.PreMove(XX,YY);},200);
};
_start.PreMove=function(XX,YY)
{
	jQuery('#_blank').empty().show();
	_start.mousedowndoing=true;
	if(!_start.tach) _start.AttachEvent(_start.even);
	eval("document.onmousemove=function(e){_start.Move(e?e:window.event);};");
	eval("document.onmouseup=function(e){_start.Moved(e?e:window.event);};");
	//创建空白dock位置层
	var el=jQuery('#taskbar');
	jQuery('<div id="_shadow_taskbar" class="taskbar_'+_config.space.taskbar+'" style="position:absolute;border:2px dotted #CCC"></div>').appendTo('#_blank');
	
	return false;
};

_start.Move=function(e)
{
	if(!_start.mousedowndoing) return;
	var XX=e.clientX;
	var YY=e.clientY;
	var w=_config.screenWidth;
	var h=_config.screenHeight;
	if(XX<0) XX=0;
	if(YY<0) YY=0;
	if(XX>_config.screenWidth) XX=_config.screenWidth;
	if(YY>_config.screenHeight) YY=_config.screenHeight;
	var shadow_taskbar=document.getElementById('_shadow_taskbar');
	if(XX<YY*(w/h) && YY<(h/w)*(w-XX)){ //left
		shadow_taskbar.className='taskbar-left';
	}else if(XX>YY*(w/h) && YY<(h/w)*(w-XX)){ //top
		shadow_taskbar.className='taskbar-top';
	}else if(XX>YY*(w/h) && YY>(h/w)*(w-XX)){ //right
		shadow_taskbar.className='taskbar-right';
	}else if(XX<YY*(w/h) && YY>(h/w)*(w-XX)){ //bottom
		shadow_taskbar.className='taskbar-bottom';
	}
};
_start.Moved=function(e)
{	
	jQuery('#_blank').hide();
	if(_start.tach) _start.DetachEvent(e);
	var XX=e.clientX;
	var YY=e.clientY;
	var w=_config.screenWidth;
	var h=_config.screenHeight;
	if(XX<0) XX=0;
	if(YY<0) YY=0;
	if(XX>_config.screenWidth) XX=_config.screenWidth;
	if(YY>_config.screenHeight) YY=_config.screenHeight;
	
	var p;
	if(XX<YY*(w/h) && YY<(h/w)*(w-XX)){ //left
		p='left';
	}else if(XX>YY*(w/h) && YY<(h/w)*(w-XX)){ //top
		p='top';
	}else if(XX>YY*(w/h) && YY>(h/w)*(w-XX)){ //right
		p='right';
	}else if(XX<YY*(w/h) && YY>(h/w)*(w-XX)){ //bottom
		p='bottom';
	}
	_layout.setTaskbarPosition(p);
};


//开始菜单应用移动
_start.prototype.icoMousedown=function(e){
	if(e.button==2) return ;
	var self=this;
	var XX=e.clientX;
	var YY=e.clientY;
	this.mousedowndoing=false;
	this.even=e?e:window.event;
	if(!_start.tach) _start.AttachEvent(e,this.board.id);
	this.mousedownTimer=setTimeout(function(){self.icoPreMove(XX,YY);},200);
	return false;
}
_start.prototype.icoMouseup=function(e){
	if(_start.tach) _start.DetachEvent(e,this.board.id);
	if(!this.mousedowndoing){
		clearTimeout(this.mousedownTimer);
	}
	return false;
}
_start.prototype.Duplicate=function(){
	var el=jQuery(this.board).clone();
	el.removeAttr('id').appendTo('#startmenu_appContainer');
	el.find('.task_icoblank,.backgound_radius').remove();
	this.copy=el.get(0);
	var p1=jQuery(this.board).offset();
	var p2=jQuery('#startmenu_appContainer').offset();
	this.copy.style.left=(p1.left-p2.left)+'px';
	this.copy.style.top=(p1.top-p2.top)+'px';
	this.board.style.display='none';
	
	
}
_start.prototype.CreateBlank=function(){
	var self=this;
	jQuery('<div id="_enter" appid="0" class="enter_startapp" style="position:absolute;left:'+this.left+'px;top:'+this.top+'px;width:'+(_start.divwidth-4)+'px;height:'+(_start.divheight-4)+'px;border:2px dotted #CCC"></div>').appendTo('#startmenu_app');
	
	jQuery('#startmenu_app .startapp').each(function(){
		var el=jQuery(this);
		var appid=el.attr('appid');
		if(appid==self.id) appid=0;
		jQuery('<div appid="'+appid+'" class="startapp_shadow" style="left:'+this.style.left+';top:'+this.style.top+';width:'+_start.divwidth+'px;height:'+_start.divheight+'px;position:absolute;"></div>').appendTo('#_blank_startapp');
	});
	jQuery('#_blank_startapp .startapp_shadow').mouseenter(function(e){
		var el=jQuery(this);
		var appid=el.attr('appid');
		if(appid<1) return;
			//交换位置
			var obj=_start.icos[appid];
			obj.left=parseInt(jQuery('#_enter').css('left'));
			obj.top=parseInt(jQuery('#_enter').css('top'));
			jQuery('#startapp_'+appid).css({left:obj.left,top:obj.top});
			jQuery('#_enter').css({left:el.css('left'),top:el.css('top')});
			//交换appid
			jQuery('.startapp_shadow[appid=0]').attr('appid',appid); 
			el.attr('appid',0);
	});
	
}
_start.prototype.icoPreMove=function(XX,YY){
	jQuery('#_blank').empty().show();
	jQuery('#_blank_startapp').empty().show();
	jQuery('#startmenu_page .startmenu-page-guide').on('mouseenter',function(){
		var index=parseInt(this.id.replace('startmenu_page_',''));
		_start.setCurrent(index);
	});
	var self=this;
	
	this.mousedowndoing=true;
	if(!_start.tach) _start.AttachEvent(this.even,this.board.id);
	this.Duplicate();
	this.CreateBlank();
	var p1=jQuery('#startmenu_app').offset();
	
	this.x=XX-p1.left-this.left;
	this.y=YY-p1.top-this.top;
//	eval("document.onmousemove=function(e){"+this.string+".icoMove(e?e:window.event);};");
//	eval("document.onmouseup=function(e){"+this.string+".icoMoved(e?e:window.event);};");
	jQuery(document).on('mousemove',function(e){self.icoMove(e?e:window.event);});
	jQuery(document).on('mouseup',function(e){self.icoMoved(e?e:window.event);});
};
_start.prototype.icoMove=function(e)
{
	if(!this.mousedowndoing) return;
	var XX=e.clientX;
	var YY=e.clientY;
	var p1=jQuery('#startmenu_appContainer').offset();
	if(e.clientX>(p1.left+jQuery('#startmenu_appContainer').width()) && _start.currentPage<_start.page){
		if(_start.icoMoveTimer) window.clearTimeout(_start.icoMoveTimer);
		 _start.icoMoveTimer=window.setTimeout(function(){_start.setCurrent(_start.currentPage+1);},300);
	}else if(e.clientX<=p1.left && _start.currentPage>1){
		if(_start.icoMoveTimer) window.clearTimeout(_start.icoMoveTimer);
		  _start.icoMoveTimer=window.setTimeout(function(){_start.setCurrent(_start.currentPage-1);},300);
	}else{
		if(_start.icoMoveTimer) window.clearTimeout(_start.icoMoveTimer);
	}
	this.copy.style.left=(XX-p1.left-this.x)+'px';
	this.copy.style.top=(YY-p1.top-this.y)+'px';
};
_start.prototype.icoMoved=function(e)
{	
	jQuery('#_blank').hide();
	jQuery('#_blank_startapp').hide();
	jQuery('#startmenu_page .startmenu-page-guide').off('mouseenter');
	if(!this.mousedowndoing) return;
	this.mousedowndoing=false;
	if(_start.tach) _start.DetachEvent(e,this.board.id);
	
	
	this.left=parseInt(jQuery('#_enter').css('left'));
	this.top=parseInt(jQuery('#_enter').css('top'));
	this.board.style.left=this.left+'px';
	this.board.style.top=this.top+'px';
	this.board.style.display='block';
	jQuery('#_enter').remove();
	jQuery(this.copy).remove();
	_start.sortApplist();
};
_start.sortApplist=function(){
	var arr=new Array();
	for(var i =0 ;i<_config.appList.length;i++){
		arr.push(0);
	}
	for(var i in _start.icos){
		var x=Math.ceil(_start.icos[i].left/(_start.padding*2+_start.divwidth));
		var y=Math.ceil(_start.icos[i].top/(_start.padding*2+_start.divheight));
		arr[Math.floor((x-1)/4)*16+(x-1)-Math.floor((x-1)/4)*4+(y-1)*4]=i;
	}
	_config.appList=arr;
	_config.saveItem.appList=1;
	if(_config.saveTimer) window.clearTimeout(_config.saveTimer);
	_config.saveTimer=setTimeout(function(){_config.sendConfig();},_config.savetime);
}
