/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
function _window(features,id)
{
	if(id){
		this.id=this.name="_W_"+id;
	}else{
		this.id=this.name="_W_"+(++_window.zIndex);
	}
	this.string="_window.windows."+this.id;
	this.zIndex=++_window.zIndex;
	//窗体className
	try{
	this.className=_window.getFeature(features,"class") || _config.thame.system.folder || 'window_jd';}catch(e){}
	//窗体大小
	this.bodyWidth=(getcookie('win_'+this.id+'_width')!='')?getcookie('win_'+this.id+'_width'): _window.getFeature(features,"width") ||_window.getFeature(features,"width") ||  _window.Width;
	this.bodyHeight=(getcookie('win_'+this.id+'_height')!='')?getcookie('win_'+this.id+'_height'): _window.getFeature(features,"height") || _window.getFeature(features,"height") ||_window.Height;
	
	//窗体位置
	this.left=_window.getFeature(features,"left")!=''?_window.getFeature(features,"left"):(getcookie('win_'+this.id+'_left')!='' ? parseInt(getcookie('win_'+this.id+'_left')) :'');
	this.top=_window.getFeature(features,"top")!=''?_window.getFeature(features,"top"):(getcookie('win_'+this.id+'_top')!='' ? parseInt(getcookie('win_'+this.id+'_top')) :'');
	this.right=_window.getFeature(features,"right");
	this.bottom=_window.getFeature(features,"bottom");
	//窗体移动选项
	this.move=_window.getFeature(features,"move").toLowerCase()||"move";//move  move-x move-y;
	if(this.move=='no') this.moveable=false;
	else this.moveable=true;
	//窗体按钮OK|Cancel
	this.button=_window.getFeature(features,"button").toUpperCase();
	//窗体改变大小选项
	this.resize=_window.getFeature(features,"resize").toUpperCase()||"RESIZE|RESIZE-X|RESIZE-Y";
	if(this.resize=='no') this.resizeable=false;
	else this.resizeable=true;
	this.size=_window.getFeature(features,"size").toUpperCase()||"NO";
	//窗体操作按钮
	this.titleButton=_window.getFeature(features,"titlebutton").toUpperCase()||'';
	this.isModal=_window.getFeature(features,"ismodal").toLowerCase()=='yes'?true:false;
	this.tabs={};
	this.buttons={};
	this.type=null;
	this.isHide=null;
	this.Sequence=new Array();
	this.Csequence=0;
	
	this.bodyWidth=isNaN(parseInt(this.bodyWidth))?800:parseInt(this.bodyWidth);
	this.bodyHeight=isNaN(parseInt(this.bodyHeight))?500:parseInt(this.bodyHeight);
	this.left=isNaN(parseInt(this.left))?'':parseInt(this.left);
	this.top=isNaN(parseInt(this.top))?'':parseInt(this.top);
	_window.windows[this.id]=this;
	
};
_window.Max=new Array();
_window.Version="dzzdesktop js 1.0";
_window.Width=400;
_window.Height=-1;
_window.Timer=0;
_window.zIndex=3100;
_window.wIndex=3100;
_window.windows={};
_window.clientWidth=document.documentElement.clientWidth;
_window.clientHeight=document.documentElement.clientHeight;
_window.onmousemove=null;
_window.onmouseup=null;
_window.onselectstart=1;
_window.sum=0;
_window.ctrl=0;
_window.alt=0;
_window.hidetime=500;
_window.imgSwitchDelay=5000;

_window.getFeature=function(source,name)
{
	var reg=new RegExp("(^|,|\\s)"+ name +"\\s*=\\s*([^,]*)(\\s|,|$)","i");
	if (reg.test(source)) return RegExp.$2;
	return "";
};
_window.getMaxNumber=function()
{
	var num=0;
	for(var i=0;i<arguments.length;i++) {if(arguments[i]>num) num=arguments[i];}
	return num;
};

_window.getCurrentWindowId=function(){
		var zzIndex=0;
		var id=null;
		for(var winid in _window.windows){
			if( !_window.windows[winid].isHide ){
				if(_window.windows[winid].zIndex>zzIndex){
					 id=winid;
					zzIndex=_window.windows[winid].zIndex;
				}
			}
		}
		return id;
}
_window.currentWindow=function(type){
	var CurrentWindow=_window.getCurrentWindowId();
	if(!CurrentWindow) return;
	var obj=_window.windows[CurrentWindow];
	switch(type){
		case 'Close':
			obj.Close();
			break;
		case 'Max':
			if(obj.MAX){obj.Restore();}else{obj.Max();}
			break;
		case 'Min':
			obj.Min();
			break;
	}
};
_window.CloseAppwinAll=function(){
	for(var win in _window.windows){
		 _window.windows[win].Close();
	}
};
_window.showDesktop=function(){
	jQuery('#shadow').hide();
	if(_window.desktophide){
		for(var win in _window.windows){
				_window.windows[win].board.style.display='block';
				_window.windows[win].isHide=0;
				_window.windows[win].status=1;
		}
		_window.desktophide=0;
	}else{
		for(var win in _window.windows){
			_window.windows[win].board.style.display='none';
			_window.windows[win].isHide=1;
			_window.windows[win].status=0;
			
		}
		_window.desktophide=1;
	}
};
_window.prototype.setTitleText=function(title){
	if(this.type!='folder'){
		jQuery(this.titleCase).find('.titleText').html(title);
	}
}
/* options{
	id:    窗体id
	type:enum['pic','app','folder','message'] 窗体类型
	data:
}*/
_window.prototype.SetTitle=function(title)
{
	var self=this;
	var buttonsWidth=0;
	jQuery('#titleBar_'+this.id).remove();
	var titleBar=document.createElement('div');
	titleBar.className='titleBar';
	titleBar.id='titleBar_'+this.id;
	this.titleCase.appendChild(titleBar);
	var titleButtonBar=document.createElement('div');
	titleButtonBar.className='titleButtonBar';
	titleBar.appendChild(titleButtonBar);
	var titleButtons=this.titleButton.split('|');
	for(var i=0;i<_config.titleButtons.length;i++){
		var a=document.createElement('a');
		a.className=_config.titleButtons[i];
		a.setAttribute('bname',_config.titleButtons[i]);
		a.title=_lang.titleButton[_config.titleButtons[i]];
		if(!in_array(_config.titleButtons[i],titleButtons)) a.style.display='none';
		else a.style.display='block';
		jQuery(a).on('click',function(){
			switch(this.className){
				case 'CLOSE':
					self.Close();
					break;
				case 'MAX':
					self.Max();
					break;
				case 'RESTORE':
					self.Restore();
					break;
				case 'MIN':
					self.Min();
					break;
				case 'FULLSCREEN':
					if(document.getElementById('ifm_'+self.id)) toggleFullScreen(document.getElementById('ifm_'+self.id));
					
					break;
				case 'REFRESH':
					try{
						window.frames[document.getElementById('ifm_'+self.id).name].location.reload();
					}catch(e){};
					break;
			}
			return false;
		});
		titleButtonBar.appendChild(a);
		buttonsWidth+=jQuery(a).outerWidth(true);
	}
	
	var titleText=document.createElement('div');
	titleText.id='title_text_'+this.id;
	titleText.className='titleText';
	titleText.innerHTML=title||'';
	titleBar.appendChild(titleText);
	this.minTitleWidth=buttonsWidth+50;
};
_window.prototype.Create=function(title)
{
	if(this.isModal){
		this.modal=document.createElement("div");
		this.modal.className="MODAL";
		this.modal.style.position="absolute";
		this.modal.style.zIndex=this.zIndex;
		document.body.appendChild(this.modal);
		this.zIndex=++_window.zIndex;
	}
	this.board=document.createElement("div");
	this.board.className='window '+this.className;
	this.board.id=this.id;
	this.board.style.position="absolute";
	this.board.style.zIndex=this.zIndex;
	this.board.style.visibility="hidden";
	this.desktop=_config.currentDesktop;
	document.getElementById('_body').appendChild(this.board);
	if(!_window.clientHeight)
	{
		this.board.style.left = "100%";
		this.board.style.top = "100%";
		_window.clientWidth = this.board.offsetLeft;
		_window.clientHeight = this.board.offsetTop;
	}
	 var styles=new Array("LEFT_TOP","TOP","RIGHT_TOP","RIGHT","RIGHT_BOTTOM","BOTTOM","LEFT_BOTTOM","LEFT","SHADOW_TOP","SHADOW_RIGHT","SHADOW_BOTTOM","SHADOW_LEFT");
	styles[styles.length]="TITLE";
	styles[styles.length]="CONTENT";
	this.sides=new Array();
	if(this.button)
	{
		styles[4]="RIGHT_BOTTOM_BY_BUTTON";
		styles[5]="BOTTOM_BY_BUTTON";
		styles[6]="LEFT_BOTTOM_BY_BUTTON";
		styles[styles.length]="BUTTON";
	}
	var self=this;
	if(this.resize!="no") 	{
		var resizes=this.resize.split('|');
		for (var i=0;i<resizes.length;i++){
			styles[styles.length]=resizes[i];
		}
	}
	for(var i=0;i<styles.length;i++)
	{
		var obj=document.createElement("div");
		obj.className=styles[i];
		obj.style.position="absolute";
		obj.innerHTML='<div class="'+styles[i]+'_inner inner" style="position:absolute;"></div>';
		this.board.appendChild(obj);
		switch(styles[i])
		{
			case "TITLE":
				this.titleCase=obj;
				obj.style.height=obj.offsetHeight+'px';
				obj.style.width=this.bodyWidth+'px';
				this.SetTitle(title);
				jQuery(this.titleCase).bind('dblclick',function(e){if(self.MAX){jQuery(this).find('.RESTORE:visible').trigger('click');}else{jQuery(this).find('.MAX:visible').trigger('click');}});
				if(this.moveable){
					jQuery(this.titleCase).bind('mousedown',function(e){self.Mousedown(e?e:window.event);});
					jQuery(this.titleCase).bind('mouseup',function(e){self.Mouseup(e?e:window.event);});
				}
				break;
			case "CONTENT":
				this.contentCase=obj;
				obj.style.width=this.bodyWidth+"px";
				if(this.bodyHeight>0) obj.style.height=this.bodyHeight+"px";
				obj.style.left=(this.sides[7].width)+"px";
				obj.style.top=(this.sides[1].height)+"px";
				//this.titleCase.style.width=this.bodyWidth+'px';
				this.width=this.bodyWidth+this.sides[3].width+this.sides[7].width;
				this.height=this.bodyHeight+this.sides[1].height+this.sides[5].height;
				this.minWidth=_window.getMaxNumber(this.sides[0].width+this.sides[2].width,this.sides[3].width+this.sides[7].width,this.sides[4].width+this.sides[6].width)+this.minTitleWidth;
				this.minHeight=_window.getMaxNumber(this.sides[0].height+this.sides[6].height,this.sides[1].height+this.sides[5].height,this.sides[2].height+this.sides[4].height)+2;
				if(this.width<this.minwidth) this.width=this.minWidth;
				if(this.height<this.minHeight) this.height=this.minHeight;
				this.board.style.height=this.height+"px";
				this.board.style.width=this.width+"px";
				
				//创建空白覆盖层
				this.blank=document.createElement("div");
				this.blank.id='_blank_'+this.id;
				this.blank.className='window_blank';
				
				this.contentCase.appendChild(this.blank);
				
				//创建loadding层
				this.loadding=document.createElement("div");
				this.loadding.id='window_content_loadding'+this.id;
				this.loadding.className='window_loadding';
				this.loadding.innerHTML='<table width="100%" height="100%"><tbody><tr><td valign="middle" align="center"><div class="loading_img"><div class="loading_process"></div></div></td></tr></tbody></table>';
				this.contentCase.appendChild(this.loadding);
				break;
			case "BUTTON":
				this.buttonCase=obj;
				obj.style.width=this.bodyWidth+"px";
				obj.style.left=this.sides[7].width+'px';
				obj.style.bottom="0px";
				this.buttonCase.dx=obj.offsetWidth-this.width;
				if(this.minWidth<this.buttonCase.dx) this.minWidth=this.buttonCase.dx;
				var buttons=this.button.split("|");
				for(var j=0;j<buttons.length;j++)
				{
					var ox=document.createElement("button");
					ox.className=buttons[j];
					ox.title=buttons[j];
					obj.appendChild(ox);
					jQuery(ox).bind('click',function(e){eval(self.string+".On"+this.title+"()")});
					this.buttons[buttons[j]]=ox;
				}
				break;
			case "RESIZE":
				obj.style.cursor="url('dzz/images/cur/aero_nwse.cur'),auto";
				jQuery(obj).bind('mousedown',function(e){self.resize='yes';self.PreResize(e?e:window.event);});
				break;
			case "RESIZE-X":
					this.resizexCase=obj;
					obj.style.cursor="e-resize";
					jQuery(obj).bind('mousedown',function(e){self.resize='resize-x';self.PreResize(e?e:window.event);});
					
				break;
			case "RESIZE-Y":
					this.resizeyCase=obj;
					obj.style.cursor="s-resize";
					jQuery(obj).bind('mousedown',function(e){self.resize='resize-y';self.PreResize(e?e:window.event);});
				break;
			default:
					this.sides[i]=obj;
					this.sides[i].width=obj.offsetWidth;
					this.sides[i].height=obj.offsetHeight;
					if(this.moveable){
						obj.style.cursor="move";
						jQuery(obj).bind('mousedown',function(e){self.Mousedown(e?e:window.event);});
						jQuery(obj).bind('mouseup',function(e){self.Mouseup(e?e:window.event);});
					}
				break;
		}
	}
	this.sides[1].dx=this.sides[0].width+this.sides[2].width;
	if(this.width>this.sides[1].dx) this.sides[1].style.width=(this.width-this.sides[1].dx)+"px";
	this.sides[3].dy=this.sides[2].height+this.sides[4].height;
	if(this.height>this.sides[3].dy) this.sides[3].style.height=(this.height-this.sides[3].dy)+"px";
	this.sides[5].dx=this.sides[4].width+this.sides[6].width;
	if(this.width>this.sides[5].dx) this.sides[5].style.width=(this.width-this.sides[5].dx)+"px";
	this.sides[7].dy=this.sides[6].height+this.sides[0].height;
	if(this.height>this.sides[7].dy) this.sides[7].style.height=(this.height-this.sides[7].dy)+"px";
	
	
	this.sides[0].style.left="0px";
	this.sides[0].style.top="0px";
	this.sides[1].style.left=this.sides[0].width+"px";
	this.sides[1].style.top="0px";
	this.sides[2].style.right="0px";
	this.sides[2].style.top="0px";
	this.sides[3].style.right="0px";
	this.sides[3].style.top=this.sides[2].height+"px";
	this.sides[4].style.right="0px";
	this.sides[4].style.bottom="0px";
	this.sides[5].style.left=this.sides[6].width+"px";
	this.sides[5].style.bottom="0px";
	this.sides[6].style.left="0px";
	this.sides[6].style.bottom="0px";
	this.sides[7].style.left="0px";
	this.sides[7].style.top=this.sides[0].height+"px";
	this.left=this.left?parseInt(this.left):(this.right?_window.clientWidth-this.width-parseInt(this.right):parseInt((_window.clientWidth-this.width)/2));
	this.top=this.top?parseInt(this.top):(this.bottom?_window.clientHeight-this.height-parseInt(this.bottom):parseInt((_window.clientHeight-this.height)/2));
	if(this.left<0) this.left=0;
	if(this.top<0) this.top=0;
	this.left+=document.documentElement.scrollLeft;
	this.top+=document.documentElement.scrollTop;
	this.board.style.left=this.left+"px";
	this.board.style.top=this.top+"px";
	this.board.style.visibility="visible";
	this.status=1;
	jQuery(this.board).on('mousedown',function(e){self.Focus();});
	if(this.size!='NO' && in_array(this.size,_config.titleButtons)){
		jQuery('#titleBar_'+this.id).find('.'+this.size).trigger('click');
	}
};
_window.OpenPicWin=function(icoid,features){//图片浏览器窗体
  /* var picdata=[{icoid:null,title:'34324.jpg',img:'http://dzz.cc/223341.jpg',thumb:'http://dzz.cc/223341.jpg.thumb.jpg'}];
	current为当前的数组下标；
	如果icoid存在，则和桌面图片图标关联，会有编辑属性、评论、分享、评分等属性；
	*/
	var obj=new _window(features,'sys_pic');
	obj.taskid='sys_pic';
	obj.type='image';
	obj.icoid=icoid;
	obj.Create(_config.sourcedata.icos[icoid].name);
	obj.SetPicContent(icoid,_config.sourcedata.icos[icoid].url);
	return obj;
};

_window.prototype.adjust = function() {
	if(this.type!='image') return;
		if(!document.getElementById('picWin_img')) {
			return;
		}
		var el=jQuery('#picWin_img .img_up')
		var imgw =parseInt(el.attr('w'));
		var imgh =parseInt(el.attr('h'));
		var bodyWidth=jQuery('#picWin_img').width();
		var bodyHeight=jQuery('#picWin_img').height();
		var ratio=bodyWidth/bodyHeight;
		var ratio1=imgw/imgh;
		if(ratio>ratio1){
			if(bodyHeight<imgh){
				height=bodyHeight-20;
				width=imgw/imgh*bodyHeight;
			}else{
				width = imgw;
				height = imgh;
			}
		}else{
			if(bodyWidth<imgw){
				width=bodyWidth-20;
				height=imgh/imgw*bodyWidth;
			} else {
				width = imgw;
				height = imgh;
			}
		}
		this.imgwidth=width;
		this.imgheight=height;
		this.imgleft=(bodyWidth-width)/2;
		this.imgtop=(bodyHeight-height)/2;
		el.css({'position':'absolute','width':this.imgwidth,'height':this.imgheight,'left':this.imgleft,top:this.imgtop});
		//alert([bodyWidth,bodyHeight]+obj.width+'==='+obj.height);
};
_window.prototype.createPic=function(id,url){
	var self=this;
	var el=jQuery('<div id="picWin_img" style="position:absolute;width:100%;height:100%;left:0;top:0;overflow:hidden"><img class="img_up" src="dzz/images/b.gif" style="max-width:none" /><img class="img_down" style="display:none;max-width:none" src="dzz/images/b.gif" /></div>').appendTo(this.contentCase);
		this.imgContainer=el.get(0);
	
	//图片拖动	
	el.find('img').mousedown(function(e){
		var Move=function(e){
			var XX=e.clientX;
			var YY=e.clientY;
			self.imgleft=XX-self.oldx;
			self.imgtop=YY-self.oldy;
			jQuery('#picWin_img .img_up').css({'left':self.imgleft,'top':self.imgtop});
		}
		var Moved=function(e){
			DetachEvent(e,self.imgContainer);
			var XX=e.clientX;
			var YY=e.clientY;
			//var p=jQuery('#picWin_img').offset();
			self.imgleft=XX-self.oldx;
			self.imgtop=YY-self.oldy;
			jQuery('#picWin_img .img_up').css({'left':self.imgleft,'top':self.imgtop});
		}
		var p1=jQuery('#picWin_img').offset();
		var p=jQuery('#picWin_img .img_up').offset();
		self.oldx=e.clientX-p.left+p1.left;
		self.oldy=e.clientY-p.top+p1.top;
		AttachEvent(e,self.imgContainer);
		document.onmousemove=function(e){Move(e?e:window.event);return false;};
		document.onmouseup=function(e){Moved(e?e:window.event);return false;};
		
	}).mouseup(function(e){
		DetachEvent(e,self.imgContainer);
		
	});
	
	//下一张
		self.picop_next=document.createElement("a");
		self.picop_next.className="picop_div_next";
		self.picop_next.innerHTML='<table width="100%" height="100%" cellpadding="0" cellspacing="0"><tr><td align="right" valign="middle"><div id="picop_next" class="picop_next" style="display:none"></div></td></tr></table>';
		self.picop_next.title=_lang.pic_next;
		jQuery(self.picop_next).on('click',function(){
			OpenPicWin(self.data.icos[self.data.pos+1]);
			if(self.autoplayTimer){
				 window.clearInterval(self.autoplayTimer);
				 self.autoplayTimer=0;
				 jQuery('#picop_bottom').find('.icon').removeClass('icon-pause').addClass('icon-play');
			}
		});
		el.get(0).appendChild(self.picop_next);
	
	//上一张	
		self.picop_pre=document.createElement("a");
		self.picop_pre.className="picop_div_pre";
		self.picop_pre.innerHTML='<table width="100%" height="100%" cellpadding="0" cellspacing="0"><tr><td align="left" valign="middle"><div id="picop_pre" class="picop_pre" style="display:none"></div></td></tr></table>';
		self.picop_pre.title=_lang.pic_pre;
		
		jQuery(self.picop_pre).on('click',function(){
			OpenPicWin(self.data.icos[self.data.pos-1]);
			if(self.autoplayTimer){
				 window.clearInterval(self.autoplayTimer);
				 self.autoplayTimer=0;
				 jQuery('#picop_bottom').find('.icon').removeClass('icon-pause').addClass('icon-play');
			}
		});
		el.get(0).appendChild(self.picop_pre);
		
	
	jQuery(self.picop_pre).mouseenter(function(){
		jQuery('#picop_pre').show();
	}).mouseleave(function(){
		jQuery('#picop_pre').hide();
	});
	jQuery(self.picop_next).mouseenter(function(){
		jQuery('#picop_next').show();
	}).mouseleave(function(){
		jQuery('#picop_next').hide();
	});
	
	
	//创建下侧功能区
	self.picop_bottom=document.createElement("div");
	self.picop_bottom.className="picop_div_bottom";
	var ophtml='<table width="100%" height="100%" cellpadding="0" cellspacing="0">';
		ophtml+='<tr><td align="right" valign="middle">';
		ophtml+=' <ul id="picop_bottom" class="picop_bottom inline" >';
		ophtml+='  <li op="download"><i class="icon icon-white icon-arrow-down"></i>下载</li>';
		ophtml+='  <li op="newwindow"><i class="icon icon-white icon- icon-share"></i>查看原图</li>';
		ophtml+='  <li op="rotate"><i class="icon icon-white icon-repeat"></i>旋转</li>';
		ophtml+='  <li op="autoplay"><i class="icon icon-white icon-play"></i>自动播放</li>';
		ophtml+=' </div>';
		ophtml+='</td></tr>';
		ophtml+='</table>';
	self.picop_bottom.innerHTML=ophtml;
	el.get(0).appendChild(self.picop_bottom);
	
	jQuery(self.picop_bottom).mouseenter(function(){
		jQuery(this).addClass('hover');
	}).mouseleave(function(){
		jQuery(this).removeClass('hover');
	});
	//处理操作事件
	jQuery('#picop_bottom li').click(function(){
		var op=jQuery(this).attr('op');
		switch(op){
			case 'download':
				_ico.downAttach(self.icoid);
				break;
			case 'newwindow':
				window.open(_config.sourcedata.icos[self.icoid].url);
				break;
			case 'rotate':
				
				var el1=jQuery('#picWin_img .img_up');
				 self.angle+=90;
				 var rotation=((self.angle%360)/90);
				el1.css({'transform':'rotate('+(self.angle)+'deg)','-webkit-transform':'rotate('+(self.angle)+'deg)','-moz-transform':'rotate('+(self.angle)+'deg)','-o-transform':'rotate('+(self.angle)+'deg)','-ms-transform':'rotate('+(self.angle)+'deg)','filter':'progid:DXImageTransform.Microsoft.BasicImage(Rotation='+(rotation)+'))'});
				break;
			case 'autoplay':
				if(!self.autoplayTimer){
					jQuery(this).find('.icon').removeClass('icon-play').addClass('icon-pause');
					self.autoplayTimer=window.setInterval(function(){
						self.autoPlay();
					},_window.imgSwitchDelay);
				}else{
					jQuery(this).find('.icon').removeClass('icon-pause').addClass('icon-play');
					window.clearInterval(self.autoplayTimer);
					self.autoplayTimer=0;
				}
				break;
			}
			return false;
		});
	
	//右键菜单
	el.on('contextmenu',function(e){_contextmenu.right_img(e?e:window.event,_config.sourcedata.icos[self.icoid].url);return false;});
	
	//滚轮缩放
	el.on('mousewheel',function(e,delta, deltaX, deltaY){
		var dy=delta*100;
		var dx=dy*self.ratio;
		self.imgleft-=dx/2;
		self.imgtop-=dy/2;
		self.imgwidth+=dx;
		self.imgheight+=dy;
		jQuery('#picWin_img .img_up').css({left:self.imgleft,top:self.imgtop,width:self.imgwidth,height:self.imgheight,'max-width':'none'});
		return false;
	});
}
_window.prototype.autoPlay=function(){
	var pos=this.data.pos+1;
	if(pos>=this.data.icos.length) pos=0;
	if(this.data.icos[pos]) OpenPicWin(this.data.icos[pos]);
}
_window.prototype.loadCheck = function (obj,url) {
	var self=this;
	var maxh=this.bodyHeight-20;
		if(obj.complete) {
			var imgw = loading.width;
			var imgh = loading.height;
			var r = imgw / imgh;
			var w =this.bodyWidth-20;
			w = imgw > w ? w : imgw;
			var h = w / r;
			if(h > maxh) {
				h = maxh;
				w = h * r;
			}
			this.showimage(url, Math.ceil(w), Math.ceil(h), imgw, imgh);
		} else {
			setTimeout(function () {self.loadCheck(loading,url); }, 50);
		}
	};
_window.prototype.showloading = function (url, pn) {
	var self=this;
		if(!document.getElementById('img_loading_'+this.id)) {
			self.loading = document.createElement('img');
			self.loading.id='img_loading_'+this.id;
			self.loading.src = 'dzz/images/default/imageloading.gif';
			self.loading.style.opacity = '0.8';
			self.loading.style.filter = 'alpha(opacity=80)';
			self.loading.style.position = 'absolute';
			self.loading.style.left=(self.bodyWidth - 42) / 2 + 'px';
			self.loading.style.top=(self.bodyHeight - 42) / 2 + 'px';
			self.loading.style.zIndex = 100000;
			self.imgContainer.appendChild(self.loading);
		}else {
			self.loading=document.getElementById('img_loading_'+this.id);
			self.loading.style.left=(self.bodyWidth - 42) / 2 + 'px';
			self.loading.style.top=(self.bodyHeight - 42) / 2 + 'px';
			self.loading.style.display = '';
		}
		loading = new Image();
		setTimeout(function () {self.loadCheck(loading,url); }, 100);
		loading.src = url;
	};
_window.prototype.SetPicContent=function(id,url)
{
		jQuery(this.loadding).hide();
		this.contentCase.style.overflow='hidden';
		this.contentCase.style.background='#000';
		//创建空白覆盖层
		
		this.icoid=id;
		this.data=_ico.getPicIcos(id);
		if(!jQuery('#picWin_img').size()){
			this.createPic(id,url);
		}
		if(this.data.pos==0 && this.data.icos.length>1){
			jQuery(this.picop_next).show();
			jQuery(this.picop_pre).hide();
		}else if(this.data.pos==(this.data.icos.length-1) && this.data.icos.length>1){
			jQuery(this.picop_next).hide();
			jQuery(this.picop_pre).show();
		}else if(this.data.pos>0){
			jQuery(this.picop_next).show();
			jQuery(this.picop_pre).show();
		}
		this.showloading(url);
		this.Focus();
};
_window.prototype.showimage=function(url, w, h, imgw, imgh){
	var self=this;
		jQuery(this.loading).fadeOut();
		this.ratio=imgw/imgh
		this.imgwidth=w;
		this.imgheight=h;
		this.imgw=imgw;
		this.imgh=imgh;
		this.angle=0;
		this.imgleft=(this.bodyWidth-w)/2;
		this.imgtop=(this.bodyHeight-h)/2;
		var img_down=jQuery('#picWin_img .img_down');
		var img_up=jQuery('#picWin_img .img_up');
		img_down.attr('src',url).attr('w',imgw).attr('h',imgh).css({'position':'absolute','width':w,'height':h,'left':this.imgleft,top:this.imgtop,'transform':'none','filter':'none'}).fadeIn().attr('class','img_up');;
	    img_up.fadeOut().attr('class','img_down');
	}		

_window.OpenFolderWin=function(id,topfid,treeshow,features){//文件夹窗体
	var obj=new _window(features,++_window.wIndex);
	obj.type='folder';
	obj.fid=topfid[0];
	obj.topfid=topfid;
	if(!treeshow && topfid.length<2) treeshow=1;
	obj.icoid=id;
	obj.taskid=id;
	obj.treeshow=treeshow;
	obj.Create(_config.sourcedata.icos[id].name);
	obj.SetFolderContent(id);
	//obj.CreatFolderWin(id,_config.sourcedata.icos[id].name);
	obj.treeHide(treeshow);
	return obj;
};

_window.prototype.treeHide=function(treeshow){
	if(!treeshow){
		jQuery('#jstree_area_'+this.id).hide();
		jQuery('#filemanage-ltdrager_'+this.id).hide();
		jQuery('#content_'+this.id).css('margin-left',0);
		this.treeshow=0;
		jQuery('#treeshow_'+this.id).find('a').removeClass('treeshow-guide-left').addClass('treeshow-guide-right');
	}else{
		jQuery('#jstree_area_'+this.id).show();
		jQuery('#filemanage-ltdrager_'+this.id).show();
		jQuery('#content_'+this.id).css('margin-left',jQuery('#jstree_area_'+this.id).width());
		this.treeshow=1;
		jQuery('#treeshow_'+this.id).find('a').removeClass('treeshow-guide-right').addClass('treeshow-guide-left');
		
		if((this.right_minWidth+jQuery('#jstree_area_'+this.id).width())>this.width){
			this.ResizeTo(this.right_minWidth+jQuery('#jstree_area_'+this.id).width(),this.bodyHeight);
		}
	}
	
}
_window.prototype.SetFolderContent=function(id)
{
	jQuery(this.contentCase).addClass('filemanage');
	jQuery(this.loadding).hide();
	var self=this;
	var initially_select=['f-'+this.fid+'-'+this.id];
	var openarr=[]
	for(var i=this.topfid.length-1;i>=0;i--){
		openarr.push('f-'+this.topfid[i]+'-'+this.id);
	}
	var initially_open=openarr;
	var left=document.createElement('div');
	left.id='jstree_area_'+this.id;
	left.className="filemanage-left";
	jQuery(left).mousedown(function(){return false;});
	this.contentCase.appendChild(left);
	
	var right=document.createElement('div');
	right.id='content_'+this.id;
	right.className="filemanage-right";
	this.contentCase.appendChild(right);
	
	
	var drag=document.createElement('div');
	drag.id='filemanage-ltdrager_'+this.id;
	drag.className="filemanage-ltdrager";
	jQuery(drag).bind('mousedown',function(e){
		self.ltdrager_start(e?e:window.event);
	});
	this.contentCase.appendChild(drag);
	
	var CURRENT_PATH='dzz/system';
	jQuery("#jstree_area_"+this.id).jstree({ 
					// List of active plugins
					"plugins" : [ 
						"themes","json_data","ui","types","hotkeys" 
					],
					
					// I usually configure the plugin that handles the data first
					// This example uses JSON as it is most common
					"json_data" : { 
						// This tree is ajax enabled - as this is most common, and maybe a bit more complex
						// All the options are almost the same as jQuery's AJAX (read the docs)
						"ajax" : {
							// the URL to fetch the data
							"url" : _config.systemurl+'&op=explorer',
							// the `data` function is executed in the instance's scope
							// the parameter is the node being loaded 
							// (may be -1, 0, or undefined when loading the root nodes)
							"data" : function (n) { 
								// the result is fed to the AJAX request `data` option
								if(n.attr){
									var id=n.attr('id');
									//alert('id==='+id);
									var fid=id.split('-')[1];
									var bz=_config.sourcedata.folder[fid].bz;
									var path=encodeURIComponent(_config.sourcedata.folder[fid].path);
								}else{
									//alert('icoid='+self.icoid);
									var id=0;
									var bz=_config.sourcedata.folder[self.topfid[self.topfid.length-1]].bz;
									var path=encodeURIComponent(_config.sourcedata.folder[self.topfid[self.topfid.length-1]].path);
								}
								return { 
									"do" : "get_children",
									"id" : id,
									"winid":self.id,
									"bz":bz,
									"path":path,
									't': new Date().getTime()
								}
							},
							"success":function(data){
								
								if(!data) return;
								if(data.error){ alert(data.error);return}
								var datas=data[data.length-1];
								if(!datas) return ;
								
								if(datas.icosdata){
									for(var icoid in datas.icosdata){
										_config.sourcedata.icos[icoid]=datas.icosdata[icoid];
										_config.sourceids.icos.push(icoid);
									}
								}
								if(datas.folderdata){
									for(var fid in datas.folderdata){
										if(!_config.sourcedata.folder) _config.sourcedata.folder={};
										_config.sourcedata.folder[fid]=datas.folderdata[fid];
										if(!_config.sourceids.folderids) _config.sourceids.folderids=new Array();
										_config.sourceids.folderids.push(fid);
									}
								}
							}
						}
					},
					"themes":{
						"theme" : "default",
						"dots":false
					},
					// Using types - most of the time this is an overkill
					// read the docs carefully to decide whether you need types
					"types" : {
						// I set both options to -2, as I do not need depth and children count checking
						// Those two checks may slow jstree a lot, so use only when needed
						/*"max_depth" : -2,
						"max_children" : -2,*/
						// I want only `drive` nodes to be root nodes 
						// This will prevent moving or creating any other type as a root node
						"valid_children" : [ "drive" ],
						"types" : {
							// The default type
							"default" : {
								// I want this type to have no children (so only leaf nodes)
								// In my case - those are files
								"valid_children" : "none",
								// If we specify an icon for the default type it WILL OVERRIDE the theme icons
								"icon" : {
									"image" : CURRENT_PATH+"/images/file.png"
								}
							},
							// The `folder` type
							"folder" : {
								// can have files and other folders inside of it, but NOT `drive` nodes
								"valid_children" : [ "default", "folder" ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/folder.png"
								}
							},
							
							"home" : {
								// can have files and folders inside, but NOT other `drive` nodes
								"valid_children" : [],
								"icon" : {
									"image" : CURRENT_PATH+"/images/home.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"create_node" : false,
								"rename" : false,
								"remove" : false
							},
							
							"document" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [  ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/document.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"create_node" : false,
								"rename" : false,
								"remove" : false
							},
							"recycle" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [  ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/recycle.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"create_node" : false,
								"rename" : false,
								"remove" : false
							},
							"dock" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [  ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/dock.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"create_node" : false,
								"rename" : false,
								"remove" : false
							},
							
							
							"desktop" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : ["folder" ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/desktop.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"remove" : false,
								"rename" : false
							},
							"organization" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [ ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/organization.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"remove" : false,
								"rename" : false
							},
							"google" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [ ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/google.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"remove" : false,
								"rename" : false
							},
							"skydrive" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [ ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/skydrive.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"remove" : false,
								"rename" : false
							},
							"baiduPCS" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [ ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/baiduPCS.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"remove" : false,
								"rename" : false
							},
							"ALIOSS" : {
								// can have files and folders inside, but NOT other `root` nodes
								"valid_children" : [ ],
								"icon" : {
									"image" : CURRENT_PATH+"/images/ALIOSS.png"
								},
								// those prevent the functions with the same name to be used on `drive` nodes
								// internally the `before` event is used
								"start_drag" : false,
								"move_node" : false,
								"delete_node" : false,
								"remove" : false,
								"rename" : false
							}
						}
					},
					
					// UI & core - the nodes to initially select and open will be overwritten by the cookie plugin
			
					// the UI plugin - it handles selecting/deselecting/hovering nodes
					"ui" : {
						// this makes the node with ID node_4 selected onload
						"initially_select" : initially_select
					},
					// the core plugin - not many options here
					"core" : { 
						// just open those two nodes up
						// as this is an AJAX enabled tree, both will be downloaded from the server
						"initially_open" : initially_open
					}
				})			
		.bind("select_node.jstree", function (event, data) {
						// `data.rslt.obj` is the jquery extended node that was clicked
						if(data.rslt.obj.hasClass("jstree-closed")) { jQuery("#jstree_area_"+self.id).jstree('open_node',data.rslt.obj); }
						//ajaxget(_config.systemurl+'&op=explorer&do=filemanage&id='+data.rslt.obj.attr("id")+'&winid='+self.id+'&perpage='+_filemanage.perpage+'&t='+new Date().getTime(),'content_'+self.id,'content_'+self.id);
						var fidarr=data.rslt.obj.attr("id").split('-');
						self.fid=(fidarr[1]);
						self.topfid=_ico.getTopFid(self.fid);
						
						if(_config.sourcedata.folder[self.fid]){
							var fdata=_config.sourcedata.folder[self.fid];
							var img=fdata.icon;
							var error='dzz/images/default/system/folder.png';
							if(fdata.flag=='recycle'){
								if(_config.sourcedata.icos[self.icoid].iconum>0){
									 img='dzz/styles/thame/'+_config.thame.system.folder+'/system/'+fdata.flag+'1.png';
									 error='dzz/images/default/system/'+fdata.flag+'1.png';
								}else{
								 	img='dzz/styles/thame/'+_config.thame.system.folder+'/system/'+fdata.flag+'.png';
									error='dzz/images/default/system/'+fdata.flag+'.png';
								}
								error='dzz/images/default/system/'+fdata.flag+'.png';
							}else if(fdata.flag){
								 img='dzz/styles/thame/'+_config.thame.system.folder+'/system/'+fdata.flag+'.png';
								 error='dzz/images/default/system/'+fdata.flag+'.png';
							}
							_dock.Change(self.taskid,img,fdata.fname,error);
						}
						/*if(!self.isCsquence){
							self.Sequence.splice(self.Csequence,self.Sequence.length-self.Csequence);
							self.Csequence=self.Sequence.push(data.rslt.obj.attr("id"));
						}else{
							self.isCsquence=0;
						}
						if( self.Csequence<=1){
							jQuery('#seq_back_'+self.id).removeClass('BACK2').addClass('BACK1');
						}else{
							jQuery('#seq_back_'+self.id).removeClass('BACK1').addClass('BACK2');
						}
						if(self.Csequence<self.Sequence.length){
							jQuery('#seq_next_'+self.id).removeClass('NEXT1').addClass('NEXT2');
						}else{
							jQuery('#seq_next_'+self.id).removeClass('NEXT2').addClass('NEXT1');
						}
						*/
						var path=jQuery("#jstree_area_"+self.id).jstree('get_path',data.rslt.obj);
						var ids=jQuery("#jstree_area_"+self.id).jstree('get_path',data.rslt.obj,true);
						var titlestr=''
						for(var i=0;i<path.length;i++){
							titlestr+='<a node="'+ids[i]+'" class="title_path_item">'+mb_cutstr_nohtml(path[i], 30,'...')+'</a>';
							if(i!=path.length-1) titlestr+='<span class="title_path_item_speacer">-></span>';
						}
						jQuery('#title_text_'+self.id).html(titlestr);
						jQuery('#title_text_'+self.id+' .title_path_item').each(function(){
							jQuery(this).bind('click',function(){
								jQuery("#jstree_area_"+self.id).jstree('select_node',jQuery('#'+jQuery(this).attr('node')),true);
							});
						});
						jQuery('#content_'+self.id).empty();
						
						jQuery(self.loadding).show();
						jQuery(self.blank).css('z-index',100);
						_filemanage.getData(_config.systemurl+'&op=explorer&do=filemanage&id='+data.rslt.obj.attr("id")+'&winid='+self.id+'&perpage='+_filemanage.perpage+'&bz='+_config.sourcedata.folder[self.fid].bz+'&asc=1&disp='+_config.sourcedata.folder[self.fid].disp+'&iconview='+_config.sourcedata.folder[self.fid].iconview+'&path='+encodeURIComponent(_config.sourcedata.folder[self.fid].path)+'&t='+new Date().getTime(),function(){
							jQuery(self.loadding).hide();
							jQuery(self.blank).css('z-index',-1);
						});
						self.filemanageid=null;
						jQuery(self.titleCase).find('.operator').hide();
						
						//关闭相邻的节点
						//data.rslt.obj;
						var arr=jQuery("#jstree_area_"+self.id).jstree('get_path',data.rslt.obj,false);
						data.rslt.obj.siblings().each(function(){
							jQuery("#jstree_area_"+self.id).jstree('close_node',jQuery(this));
						});
						//jQuery("#jstree_area").jstree('get_path',data.rslt.obj
				});
	
	this.treeHide(this.treeshow);
	this.Focus(1);
	
	
};

_window.prototype.ChangeSequence=function(direction,app,type)
{
	if((this.Csequence<=1 && direction=='back') || (this.Csequence>=this.Sequence.length && direction=='next')) return;
	else{
		if(direction=='back') this.Csequence-=1;
		else this.Csequence+=1;
	}
	
	if(app=='storage'){
		this.fid=this.Sequence[this.Csequence-1];
		this.path=_config.sourcedata.folder[this.fid].path;
		this.SetStorageTitle();
		this.SetStorageContent(this.fid);
	}else{
		
		this.isCsquence=1;
		jQuery("#jstree_area_"+this.id).jstree('select_node',jQuery('#'+this.Sequence[this.Csequence-1]),true);
		
	}
};


_window.prototype.ltdrager_start=function(e)
{
	this.XX=e.clientX;
	this.AttachEvent(e);
	document.getElementById('_blank').style.cursor='e-resize';
	jQuery('#_blank').show();
	var self=this;
	this.ltdrager_left=jQuery('#jstree_area_'+this.id).width();
	this.ltdrager_right=this.bodyWidth-this.ltdrager_left;
	eval("document.onmousemove=function(e){"+this.string+".ltdraging(e?e:window.event);};");
	eval("document.onmouseup=function(e){"+this.string+".ltdraged(e?e:window.event);};");
};
_window.prototype.ltdraging=function(e)
{
	//alert(this.XX+'====='+e.clientX);
	
		var xx=e.clientX-this.XX;
		var ltdrager_left=this.ltdrager_left+xx;
		var ltdrager_right=this.ltdrager_right-xx;
		//alert([ltdrager_right,this.right_minWidth])
		if(ltdrager_right<this.right_minWidth){
			ltdrager_left=this.bodyWidth-this.right_minWidth;
		}
		if(ltdrager_left<15) ltdrager_left=15;
		if(ltdrager_left>this.bodyWidth-200) ltdrager_left=this.bodyWidth-200;
		jQuery('#jstree_area_'+this.id).css('width',ltdrager_left);
		jQuery('#filemanage-ltdrager_'+this.id).css('left',ltdrager_left);
		jQuery('#content_'+this.id).css('marginLeft',ltdrager_left);
		
};
_window.prototype.ltdraged=function(e)
{
	this.DetachEvent(e);
	jQuery('#_blank').hide();
	document.getElementById('_blank').style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	//alert(document.getElementById('tabs_cover').offsetLeft+'========='+document.getElementById('tabs_cover').offsetWidth);
	
};

_window.OpenApp=function(appid,features){
	var app=_config.sourcedata.app[appid];
	var obj=new _window(features,'app_'+appid);
	obj.taskid='app_'+appid;
	obj.Create(app.appname);
	obj.SetAppWinContent(app.url);
	return obj;
}
_window.OpenAppWin=function(id,icoid,url,features)
{  //应用窗体;
	var ico=_config.sourcedata.icos[icoid];
	var obj=new _window(features,id);
	url=url?url:ico.url;
	obj.url=url;
	//obj.extid=(extid?extid:'');
	if(ico.open==1) {
		obj.type='widget';
	}else obj.type='appwin';
	 if(ico.idtype=='pluginid'){
		obj.idtype='pluginid';
		obj.pluginid=ico.typeid;
	}
	obj.icoid=icoid;
	obj.taskid=id;
	
	var title=ico.name;//extid?(_config.extopen.all[extid].name+'-'+ico.name):ico.name;
	obj.Create(title);
	obj.SetAppWinContent(url);
	return obj;
};
_window.prototype.SetAppWinContent=function(url)
{
		
		if(this.iframe){
			if(this.contentCase.firstChild!=this.iframe) this.contentCase.replaceChild(this.iframe,this.contentCase.firstChild);
			this.iframe.src=url;
		}else{
			var data={uid:_config.myuid,username:_config.myusername,self:_config.space.self,winid:this.id,time:new Date().getTime()};
			var name =encodeURIComponent(jQuery.toJSON(data));
			this.loaddingTimer=setTimeout(function(){jQuery(self.loadding).fadeOut();},5000);
			var self=this;
			var el=jQuery('<iframe frameborder="0" name="'+name+'" id="ifm_'+this.id+'" marginheight="0" marginwidth="0" allowtransparency="true" src="'+url+'" class="appIframe"  style="overflow-x: hidden;" onload="jQuery(\'#window_content_loadding'+this.id+'\').fadeOut();clearTimeout('+self.loaddingTimer+');"></iframe>').appendTo(this.contentCase);
			this.iframe=el.get(0);
			if(this.bodyHeight<0) this.bodyHeight=300;
			
		}
		this.Focus();
};


_window.Open=function(id,content,title,features,container)
{
	if(id=='url') {var id1=id;id=encodeURIComponent(content).replace(/\./g,'_').replace(/%/g,'_');}
	var obj=new _window(features,id);
	if(id && !id1) {
		obj.type='syswin';
		obj.taskid=id;
	}
	obj.Create(title);
	obj.SetContent(content,id,container);
	return obj;
};

_window.prototype.SetContent=function(content,id,container){
	if(in_array(id,["sys_addApp","sys_theme","sys_market","sys_widget","sys_filemamage","sys_findfriend","sys_config"])){
		var url='';
		switch(id){
			case 'sys_addApp':
				url=_config.sysaddappurl+'&url='+escape(document.getElementById('address').value);
				break;
			case 'sys_theme':
				url=_config.systhameurl;
				break;
			case 'sys_market':
				url=encodeURI(_config.marketurl+'&container='+container);
				break;
			case 'sys_widget':
				url=encodeURI(_config.widgeturl);
				break;
			case 'sys_findfriend':
				url=encodeURI(_config.findfriendurl);
				break;
			case 'sys_config':
				url=encodeURI(_config.spacecpurl);
				break;
		}
		content='[url]'+url;
		
	}
	
	var type=content.slice(0,5),tent=content.slice(5);
	if(type=="[url]"){
		
		 if(tent.substr(tent.lastIndexOf('.')).toLowerCase()=='.swf'){
			
			this.contentCase.innerHTML=AC_FL_RunContent('width', '100%', 'height', '100%', 'allowNetworking', 'internal', 'allowScriptAccess', 'never', 'src', tent, 'quality', 'high', 'bgcolor', '#ffffff', 'wmode', 'transparent', 'allowfullscreen', 'true');
			
			this.contentCase.style.overflow='hidden';
			if(this.bodyHeight<0) this.bodyHeight=400;
	   }else if(tent.substr(tent.lastIndexOf('.')).toLowerCase()=='.flv'){
			
			this.contentCase.innerHTML=AC_FL_RunContent('width', '100%', 'height', '100%', 'allowNetworking', 'internal', 'allowScriptAccess', 'never', 'src', STATICURL+'image/common/flvplayer.swf','flashvars', 'file='+encodeURI(tent), 'quality', 'high', 'bgcolor', '#ffffff', 'wmode', 'transparent', 'allowfullscreen', 'true');
			
			this.contentCase.style.overflow='hidden';
			if(this.bodyHeight<0) this.bodyHeight=400;
		}else{
			
			if(!this.loadding)	this.loadding=jQuery('<div id="window_content_loadding'+this.id+'" style="position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; margin: 0px; padding: 0px; overflow: hidden; z-index: 999999;" ><table width="100%" height="100%"><tbody><tr><td valign="middle" align="center"><div class="loading_img"><div class="loading_process"></div></div></td></tr></tbody></table></div>').appendTo(this.contentCase).get(0);
			if(this.iframe){
				if(this.contentCase.firstChild!=this.iframe) this.contentCase.replaceChild(this.iframe,this.contentCase.firstChild);
				this.iframe.src=tent;
			}else{
				
				var data={uid:_config.myuid,username:_config.myusername,self:_config.space.self,winid:this.id,time:new Date().getTime()};
				var name =encodeURIComponent(jQuery.toJSON(data));
				this.loaddingTimer=setTimeout(function(){jQuery(self.loadding).fadeOut();},5000);
				var self=this;
				var el=jQuery('<iframe frameborder="0" name="'+name+'" id="ifm_'+this.id+'" marginheight="0" marginwidth="0" allowtransparency="true" src="'+tent+'" class="appIframe"  style="overflow-x: hidden;" onload="jQuery(\'#window_content_loadding'+this.id+'\').fadeOut();clearTimeout('+self.loaddingTimer+');"></iframe>').appendTo(this.contentCase);
				this.iframe=el.get(0);
				if(this.bodyHeight<0) this.bodyHeight=300;
				
			}
		}
	}else{
		if(this.form)
		{
			if(this.contentCase.firstChild!=this.form) this.contentCase.replaceChild(this.form,this.contentCase.firstChild);
		}
		else
		{
			this.form=document.createElement("form");
		 	this.form.className="FORM";
			this.form.method="post";
			this.form.onsubmit=function(e){ return false;};
			if(this.contentCase.hasChildNodes())this.contentCase.replaceChild(this.form,this.contentCase.firstChild);
			else this.contentCase.appendChild(this.form);
			
		}
		if(content.slice(0,4)=="[id]")
		{
			this.oldcontent=document.getElementById(content.slice(4));
			var el=jQuery(this.oldcontent).clone();
			if(ieVersion > 0 && ieVersion < 7) fixPNG(el,'dzz/images/b.gif');
			this.form.innerHTML=el.html();
		}
		else
		{
			this.form.innerHTML=content;
		}
		

		if(this.bodyHeight<0 ) this.bodyHeight=jQuery(this.contentCase).height();
		this.contentCase.style.overflow="hidden";
	
			var self=this;
			jQuery(this.contentCase).bind('mousedown',function(e){self.Focus();});
		
	}
	this.Focus();	
};
_window.OpenMsgWin=function(id,title,msg,features)
{
	jQuery(this.loadding).hide();
	var obj=new _window(features,id);
	if(id=='alert') obj.type='alert';
	else if(id=='confirm') obj.type='confirm';
	else obj.type='message';
	obj.Create(title);
	obj.SetContent_msgWin(id,msg);
	return obj;
};

_window.prototype.SetContent_msgWin=function(id,content)
{
		jQuery(this.loadding).hide();
		if(this.form)
		{
			if(this.contentCase.firstChild!=this.form) this.contentCase.replaceChild(this.form,this.contentCase.firstChild);
		}
		else
		{
			this.form=document.createElement("form");
		 	this.form.className="FORM";
			this.form.method="post";
			this.form.onsubmit=function(e){ return false;};
			if(this.contentCase.hasChildNodes())this.contentCase.replaceChild(this.form,this.contentCase.firstChild);
			else this.contentCase.appendChild(this.form);
		}
		this.form.innerHTML=content;
		
		if(this.moveable){
			var self=this;
			jQuery(this.contentCase).bind('mousedown',function(e){self.Mousedown(e?e:window.event);});
			jQuery(this.contentCase).bind('mouseup',function(e){self.Mouseup(e?e:window.event);});
		}
	
	this.Focus();	
};

_window.prototype.Close=function()
{
	try{
		if(this.autoplayTimer) window.clearInterval(this.autoplayTimer);
	}catch(e){};
	try{
			if(_filemanage && _filemanage.showicosTimer[this.id]) window.clearTimeout(_filemanage.showicosTimer[this.id]);
			
		}catch(e){};
	try{
		if(parseInt(this.uid)>0){
			startVideoShow(this.uid,false);
		}
		}catch(e){};
	
	if(this.needsave==1 ){
		if(!confirm(_lang.need_save_confirm)){
			try{
				window.frames[document.getElementById('ifm_'+this.id).name].autosave();
			}catch(e){return false;};
		}
	}else if(this.needsave>1 ){
		try{
			window.frames[document.getElementById('ifm_'+this.id).name].autosave();
		}catch(e){};
	}
	try{
		// window.frames[document.getElementById('ifm_'+this.id).name].contentWindow.location.replace(url)
		  window.frames[document.getElementById('ifm_'+this.id).name].location='about:blank';
		}catch(e){};
	

	jQuery(this.board).hide().remove();
	jQuery('#MsgContainer').hide();
	jQuery(this.modal).remove();
	
	try{
		_dock.Dtask(this.taskid);
		
	}catch(e){};
	
	//删除_filemanage_cons中含有此窗体的项目
	for(var id in _filemanage.cons){
		var arr=id.split('-');
		if(arr[2]==this.id) {
			for(var key in _filemanage.cons[id]) delete key;
			delete _filemanage.cons[id];
		}
	}

	delete _window.windows[this.id];
	for(var key in this) delete this[key];
	
	var currentId=_window.getCurrentWindowId();
	if(_window.windows[currentId]) _window.windows[currentId].Focus();
	return false;
};

_window.prototype.Min=function()
{
	if(this.minmine=='no') return;
	jQuery(this.board).fadeOut(_ico.delay).removeClass('window_current');
	//jQuery(this.contentCase).find('.app_swf').attr('width',1).attr('height',1);
	this.MIN=1;
	this.isHide=1;
	this.status=0;
	_dock.setCurrent();
	
}
_window.prototype.Showhide=function()
{
	this.Focus();
	this.board.style.display='block';
	this.isHide=0;
	this.status=1;
	if(this.taskid) _dock.setCurrent(this.taskid);
};
_window.prototype.Windowmenu=function()
{

};
_window.prototype.Max=function()
{
	if(this.maxmine=='no') return;
	
	var Max_x=jQuery('#_body').width();
	var Max_y=jQuery('#_body').height();
	this.board.style.height=(Max_y+this.sides[8].height+this.sides[10].height)+"px";
	this.board.style.width=(Max_x+this.sides[9].width+this.sides[11].width)+"px";
	this.board.style.left=-this.sides[11].width+"px";
	this.board.style.top=-this.sides[8].height+"px";
	this.oldleft=this.left;
	this.left=-this.sides[11].width;
	this.oldtop=this.top;
	this.top=-this.sides[8].height;
	this.oldwidth=this.width;
	this.width=(Max_x+this.sides[9].width+this.sides[11].width);
	this.oldheight=this.height;
	this.height=(Max_y+this.sides[8].height+this.sides[10].height);
	this.oldbodyWidth=this.bodyWidth;
	this.bodyWidth=Max_x+this.sides[9].width+this.sides[11].width-this.sides[7].width-this.sides[3].width;
	this.oldbodyHeight=this.bodyHeight;
	this.bodyHeight=Max_y+this.sides[8].height+this.sides[10].height-this.sides[5].height-this.sides[1].height-jQuery(this.topbarCase).height();
	this.contentCase.style.width=this.bodyWidth+"px";
	this.contentCase.style.height=this.bodyHeight+"px";
	this.titleCase.style.width=this.bodyWidth+"px";
	if(this.button){
		this.buttonCase.style.width=Max_x+this.sides[9].width+this.sides[11].width-this.sides[7].width-this.sides[3].width+"px";
		this.buttonCase.style.bottom="0px";
	}
	this.sides[0].style.left="0px";
	this.sides[0].style.top="0px";
	this.sides[1].style.left=this.sides[0].width+"px";
	this.sides[1].style.width=(Max_x+this.sides[9].width+this.sides[11].width-this.sides[0].width-this.sides[2].width)+'px';
	this.sides[1].style.top="0px";
	this.sides[2].style.right="0px";
	this.sides[2].style.top="0px";
	this.sides[3].style.right="0px";
	this.sides[3].style.top=this.sides[2].height+"px";
	this.sides[3].style.height=(Max_y+this.sides[8].height+this.sides[10].height-this.sides[2].height-this.sides[4].height)+'px';
	this.sides[4].style.right="0px";
	this.sides[4].style.bottom="0px";
	this.sides[5].style.left=this.sides[6].width+"px";
	this.sides[5].style.width=(Max_x+this.sides[9].width+this.sides[11].width-this.sides[4].width-this.sides[6].width)+'px';
	this.sides[5].style.bottom="0px";
	this.sides[6].style.left="0px";

	this.sides[6].style.bottom="0px";
	this.sides[7].style.left="0px";
	this.sides[7].style.top=this.sides[0].height+"px";
	this.sides[7].style.height=(Max_y+this.sides[8].height+this.sides[10].height-this.sides[0].height-this.sides[6].height)+'px';
		
	this.move="no";
	this.MAX=1;
	
	_window.Max[this.id]=1;
	this.Focus();
	if(this.id=='_W_dim'){
			_dim.setContainerHeight()
	}
	if(parseInt(this.uid)>0){
			_dim.setContainerHeight_dimwin(this.uid);
	}
	var el=jQuery(this.titleCase);
	el.find('.RESTORE').show();
	el.find('.MAX').hide();
	
	if(this.filemanageid){
			_filemanage.cons[this.filemanageid].Resize();
		}
	//_config.dock_up_down('down');
	//jQuery('#navbar').hide();
	try{_filemanage.stack_run(this.id);}catch(e){};
	if(this.type=='image') this.adjust();
	if(this.taskid) _dock.setCurrent(this.taskid);
};
_window.prototype.Restore=function()
{
	//var scrollH=document.documentElement.scrollHeight
	//alert(document.documentElement.scrollHeight);
	if(!this.MAX) return;
		
	
	this.width=this.oldwidth;
	this.height=this.oldheight;
	this.left=this.oldleft;
	this.top=this.oldtop;
	this.bodyWidth=this.oldbodyWidth;
	this.bodyHeight=this.oldbodyHeight;
	this.contentCase.style.width=this.bodyWidth+"px";
	this.contentCase.style.height=this.bodyHeight+"px";
	
	if(typeof(this.topbarCase)!='undefined') this.topbarCase.style.width=this.sides['topbar'].width+'px';
	if(this.id!='_W_sys_browser') this.titleCase.style.width=this.bodyWidth+"px";
	
	this.board.style.height=this.height+"px";
	this.board.style.width=this.width+"px";
				

	if(this.button)
	{
				this.buttonCase.style.width=this.width-this.sides[7].width+"px";
				this.buttonCase.style.bottom="0px";
	}
				
	this.board.style.left=this.left+"px";
	this.board.style.top=this.top+"px";
			
				
	this.sides[1].dx=this.sides[0].width+this.sides[2].width;
	if(this.width>this.sides[1].dx) this.sides[1].style.width=(this.width-this.sides[1].dx)+"px";
	this.sides[3].dy=this.sides[2].height+this.sides[4].height;
	if(this.height>this.sides[3].dy) this.sides[3].style.height=(this.height-this.sides[3].dy)+"px";
	this.sides[5].dx=this.sides[4].width+this.sides[6].width;
	if(this.width>this.sides[5].dx) this.sides[5].style.width=(this.width-this.sides[5].dx)+"px";
	this.sides[7].dy=this.sides[6].height+this.sides[0].height;
	if(this.height>this.sides[7].dy) this.sides[7].style.height=(this.height-this.sides[7].dy)+"px";
	
	
	this.sides[0].style.left="0px";
	this.sides[0].style.top="0px";
	this.sides[1].style.left=this.sides[0].width+"px";
	this.sides[1].style.top="0px";
	this.sides[2].style.right="0px";
	this.sides[2].style.top="0px";
	this.sides[3].style.right="0px";
	this.sides[3].style.top=this.sides[2].height+"px";
	this.sides[4].style.right="0px";
	this.sides[4].style.bottom="0px";
	this.sides[5].style.left=this.sides[6].width+"px";
	this.sides[5].style.bottom="0px";
	this.sides[6].style.left="0px";
	this.sides[6].style.bottom="0px";
	this.sides[7].style.left="0px";
	this.sides[7].style.top=this.sides[0].height+"px";
	this.move="move";
	this.MAX=0;
	_window.Max[this.id]=0;
	
	this.Focus();
	if(this.id=='_W_sys_browser'){
	document.getElementById('tabs_container').style.left=(document.getElementById('tabs_cover').offsetLeft)+"px";
	document.getElementById('tabs_container').style.width=(document.getElementById('tabs_cover').offsetWidth)+"px";
	if(document.getElementById('leftrun')) document.getElementById('leftrun').style.left=document.getElementById('tabs_cover').offsetLeft+"px";
	_window.resetTabs();
	}
	if(this.id=='_W_dim'){
			_dim.setContainerHeight()
	}
	if(parseInt(this.uid)>0){
			_dim.setContainerHeight_dimwin(this.uid);
			this.ResizeBy(0,0);
	}
	var el=jQuery(this.titleCase);
	el.find('.RESTORE').hide();
	el.find('.MAX').show();
	
	if(this.filemanageid){
			_filemanage.cons[this.filemanageid].Resize();
		}
/*	_navbar.navbars[_config.currentDesktop].setDockShow();
	_navbar.navbars[_config.currentDesktop].setTopbarShow();*/
	/*if(ieVersion > 0 && ieVersion < 8){
		_navbar.checkTopbar_overWindow(_config.currentDesktop);
	}*/
	try{_filemanage.stack_run(this.id);}catch(e){};
	if(this.type=='image') this.adjust();
};
_window.prototype.Hide=function()
{
	jQuery(this.board).fadeOut(_ico.delay);
	_dock.setCurrent();
	
};
_window.prototype.Show=function()
{
	if(!this.MIN) jQuery(this.board).fadeIn(_ico.delay);
	if(this.taskid) _dock.setCurrent(this.taskid);
};
_window.prototype.DetachEvent=function(e)
{
	if(!_window.tach) return;
	document.onmousemove=_window.onmousemove;
	document.onmousemove=_window.onmousemove;
	document.onmouseup=_window.onmouseup;
	document.onselectstart=_window.onselectstart;
	if(this.board.releaseCapture) this.board.releaseCapture();
	_window.tach=0;
	jQuery('#_blank').hide();
	//jQuery('.window_blank').css('z-index',100);
	//jQuery(this.blank).css('z-index',-1);
};
_window.prototype.AttachEvent=function(e)
{
	if(_window.tach) return;
	_window.onmousemove=document.onmousemove;
	_window.onmouseup=document.onmouseup;
	_window.onselectstart=document.onselectstart;
	try{
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else{
			if(this.board.setCapture) this.board.setCapture();
		}
	}catch(e){};
	_window.tach=1;
};
_window.prototype.Focus=function(flag)
{
	if(_window.desktophide==1) _window.showDesktop();
	if(this.zIndex<_window.zIndex) this.board.style.zIndex=this.zIndex=++_window.zIndex;
	
	jQuery('.window').removeClass('window_current');
	jQuery('#'+this.id).addClass('window_current');
	if(this.taskid) _dock.setCurrent(this.taskid);
	if(!flag){
		jQuery('.window_blank').each(function(){
			var winid=this.id.replace('_blank_','');
			if(_window.windows[winid] && _window.windows[winid].type!='folder' && _window.windows[winid].type!='storage' && _window.windows[winid].type!='filemanage' && _window.windows[winid].type!='image' && _window.windows[winid].type!='dim_win'){
				jQuery(this).css('z-index',100);
			}
		});
		jQuery(this.blank).css('z-index',-1);
	}
	this.isHide=0;
	this.status=1;
	this.MIN=0;
	if(this.type=='dim_win' && !flag) {
		var uid=this.id.replace('_W_uid_','');
		//try{
			_dim.message_print(uid);
		//}catch(e){};
	}
	jQuery(this.board).show();
	return false;
};

_window.prototype.PreResize=function(e)
{
	if(this.move=='no') return;
	if (typeof(this.ResizeTimer)!="undefined") clearTimeout(this.ResizeTimer);
	this.Focus();
	//this.Duplicate();
	this.resizeX=e.clientX-this.width-4;
	this.resizeY=e.clientY-this.height-4;
	//document.body.style.cursor="url('dzz/images/cur/aero_nwse.cur'),auto";;
	this.AttachEvent(e);
	if(this.resize=='resize-x')	document.getElementById('_blank').style.cursor='e-resize';
	else if(this.resize=='resize-y')	document.getElementById('_blank').style.cursor='s-resize';
	else document.getElementById('_blank').style.cursor='se-resize';
	document.getElementById('_blank').style.display='';
	var self=this;
	eval("document.onmousemove=function(e){"+this.string+".Resize(e?e:window.event);};");
	eval("document.onmouseup=function(e){"+this.string+".Resized(e?e:window.event);};");
};
_window.prototype.Resize=function(e)
{
	var dx=0;
	var dy=0;
	if(this.resize!="resize-y")
	{
		var w=e.clientX-this.resizeX-4;
		var minWidth=this.treeshow>0?(jQuery('#jstree_area_'+this.id).width()+this.right_minWidth):this.right_minWidth;
		minWidth=(this.minWidth<minWidth)?(minWidth):this.minWidth;
		
		w=(w>minWidth)?w:minWidth;
		if((w+this.left)>_config.screenWidth) w=_config.screenWidth-this.left;
		
		dx=w-this.width;
		
		if(this.bodyWidth+dx<minWidth){
			dx=minWidth-this.bodyWidth
		}
		this.width+=dx*1;
		//this.resizeyCase.style.width=this.width+'px';
		this.board.style.width=this.width+"px";
		
		this.sides[1].style.width=(this.width-this.sides[1].dx)+"px";
		this.sides[5].style.width=(this.width-this.sides[5].dx)+"px";
		
		
		if(this.buttonCase) this.buttonCase.style.width=(this.width-this.buttonCase.dx)+"px";
		this.bodyWidth+=dx*1;
		this.titleCase.style.width=this.bodyWidth+'px';
		this.contentCase.style.width=this.bodyWidth+"px";
		
		if(this.id=='_W_openfile'){
			jQuery('#right_top').css('width',this.bodyWidth-jQuery('#openfile_left').width());
			jQuery('#right_bottom').css('width',this.bodyWidth-jQuery('#openfile_left').width());
		}
		
	}
	if(this.resize!="resize-x")
	{
		var h=e.clientY-this.resizeY;
		var h=(h>this.minHeight*1)?h:this.minHeight*1;
		if((h+this.top)>_config.screenHeight) h=_config.screenHeight-this.top;
		dy=h-this.height;
		
		if(this.bodyHeight+dy<this.minHeight*1){
			dx=this.minHeight*1-this.bodyHeight
		}
		this.height+=dy*1;
		//this.resizexCase.style.height=this.height+'px';
		this.board.style.height=this.height+"px";
		this.sides[3].style.height=(this.height-this.sides[3].dy)+"px";
		this.sides[7].style.height=(this.height-this.sides[7].dy)+"px";
		this.bodyHeight+=dy*1;
		if(this.id=='_W_openfile'){
			jQuery('#right_top').css('height',this.bodyHeight-jQuery('#right_bottom').height());
		}
		
		if(parseInt(this.uid)>0){
			_dim.setContainerHeight_dimwin(this.uid);
	}
		this.contentCase.style.height=this.bodyHeight+"px";
		if(this.filemanageid){
			_filemanage.cons[this.filemanageid].Resize();
		}
		
	}
	if(this.id=='_W_dim'){
		_dim.setContainerHeight()
	}
	if(parseInt(this.uid)>0){
			_dim.setContainerHeight_dimwin(this.uid);
	}
	
	if(this.type=='image') this.adjust();
	
};
_window.prototype.Resized=function(e)
{
	this.DetachEvent(e);
	document.getElementById('_blank').style.display='none';
	document.getElementById('_blank').style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";


	//记录窗口的大小
	if(this.type!='folder'){
		if(this.type=='dim_win' && jQuery('#chatBox_chatLogButton_'+this.uid).hasClass('hover')){
			setcookie('win_'+this.id+'_width',this.bodyWidth*1-_dim.chatlogWidth,60*60*24*365);
			setcookie('win_'+this.id+'_height',this.bodyHeight*1,60*60*24*365);
		}else if(this.type=='dim_win' && jQuery('#chatBox_showButton_'+this.uid).hasClass('hover')){
			setcookie('win_'+this.id+'_width',this.bodyWidth*1-_dim.videoShowWidth,60*60*24*365);
			setcookie('win_'+this.id+'_height',this.bodyHeight*1,60*60*24*365);
		}else{
			
			setcookie('win_'+this.id+'_width',this.bodyWidth*1,60*60*24*365);
			setcookie('win_'+this.id+'_height',this.bodyHeight*1,60*60*24*365);
		}
	}
	try{_filemanage.stack_run(this.id);}catch(e){};
	if(this.type=='image') this.adjust();
	
};
_window.prototype.ResizeTo=function(x,y)
{
	var dx=x*1-this.bodyWidth*1;
	var dy=y*1-this.bodyHeight*1;
	this.ResizeBy(dx,dy);
	
};
_window.prototype.ResizeBy=function(dx,dy)
{
	//alert([this.bodyWidth,dx,this.minWidth]);
	//if(this.bodyWidth+dx<this.minWidth) dx=this.minWidth-this.bodyWidth;
	//if(this.bodyHeight+dy<this.minHeight) dx=this.minHeight-this.bodyHeight;
	//alert(dx);
	if(dx)
	{
		this.width+=dx*1;
		this.board.style.width=this.width+"px";
		this.board.style.left=this.left+"px";
		//if(this.blank) this.blank.style.width=this.width+'px';
		this.sides[1].style.width=(this.width-this.sides[1].dx)+"px";
		this.sides[5].style.width=(this.width-this.sides[5].dx)+"px";
		
		if(this.buttonCase) this.buttonCase.style.width=(this.width-this.buttonCase.dx)+"px";
		this.bodyWidth+=dx*1;
		this.contentCase.style.width=this.bodyWidth+"px";
		if(this.id!='_W_sys_browser') this.titleCase.style.width=this.bodyWidth+"px";
		
	}
	if(dy){
		this.height+=dy*1;
		this.board.style.height=this.height+"px";
		this.board.style.top=this.top+"px";
		//if(this.blank) this.blank.style.height=this.height+"px";
		this.sides[3].style.height=(this.height-this.sides[3].dy)+"px";
		this.sides[7].style.height=(this.height-this.sides[7].dy)+"px";
		this.bodyHeight+=dy*1;
		this.contentCase.style.height=this.bodyHeight+"px";
		
	}
		if(this.id=='_W_dim'){
			_dim.setContainerHeight()
		}
		if(parseInt(this.uid)>0){
			_dim.setContainerHeight_dimwin(this.uid);
		}

		//if(this.folder) this.SetFolderContent(this.folder,this.id);
};
_window.prototype.ActResizeBy=function(dx,dy,complete)
{
	if(BROWSER.ie){
		this.ResizeBy(dx,dy);
	}else{
		if(dx!=0||dy!=0){
			var x=dx/10;
			x=(x>0)?Math.ceil(x):Math.floor(x);
			var y=dy/10;
			y=(y>0)?Math.ceil(y):Math.floor(y);
			this.ResizeBy(x,y);
			dx-=x;
			dy-=y;
			
			if(complete && this.ResizeTimer){
				 clearTimeout(this.ResizeTimer);
			}
			this.ResizeTimer=window.setTimeout(this.string+".ActResizeBy("+dx+","+dy+")",50);
		}
	}
};

_window.prototype.Mousedown=function(e)
{
	
	this.Focus();
	if(e.button==2) return ;
	var self=this;
	var XX=e.clientX;
	var YY=e.clientY;
	if (!this.moveable){
		 return true;
	}
	var tag = e.srcElement ? e.srcElement :e.target;
	
	if(tag.type=="text"||tag.type=="textarea"){
		return true;
	}
	this.mousedowndoing=false;
	_window.even=e?e:window.event;
	if(!_window.tach) this.AttachEvent(e);
	this.mousedownTimer=setTimeout(function(){self.PreMove(XX,YY);},200);
	//this.PreMove(XX,YY);
	//eval("document.onmouseup=function(e){"+this.string+".Moved(e?e:window.event);};");
};
_window.prototype.Mouseup=function(e)
{
	if(_window.tach) this.DetachEvent(e);
	if(!this.mousedowndoing){
		clearTimeout(this.mousedownTimer);
	}
};
_window.prototype.PreMove=function(XX,YY)
{
	jQuery('#_blank').empty().show();
	if(this.MAX>0){
		jQuery('#_blank').hide();
		if(_window.tach) this.DetachEvent(_window.even);
		return;
	}
	this.oldleft=this.left;
	this.oldtop=this.top;
	this.mousedowndoing=true;
	this.moveX=XX-this.left;
	this.moveY=YY-this.top;
	if(!_window.tach) this.AttachEvent(_window.even);
	eval("document.onmousemove=function(e){"+this.string+".Move(e?e:window.event);};");
	eval("document.onmouseup=function(e){"+this.string+".Moved(e?e:window.event);};");
};

_window.prototype.Move=function(e)
{
	
	// window.captureEvents(e.MOUSEDOWN|e.MOUSEMOVE|e.MOUSEUP);;
	if(!this.mousedowndoing) return;
	var XX=e.clientX;
	var YY=e.clientY;
	if(XX<0) XX=0;
	if(YY<0) YY=0;
	if(XX>_config.screenWidth) XX=_config.screenWidth;
	if(YY>_config.screenHeight) YY=_config.screenHeight;
	
	/*if(Math.abs((XX-this.moveX)-this.left)<1) return;
	if(Math.abs((YY-this.moveY)-this.top)<1) return;*/
	if(this.move!="move-y") {this.board.style.left=(XX-this.moveX)+"px";this.left=XX-this.moveX;}
	if(this.move!="move-x") {this.board.style.top=(YY-this.moveY)+"px";this.top=YY-this.moveY;}
};
_window.prototype.Moved=function(e)
{	jQuery('#_blank').hide();
	if(_window.tach) this.DetachEvent(e);
	
	var XX=e.clientX;
	var YY=e.clientY;
	if(XX<0) XX=0;
	if(YY<0) YY=0;
	if(XX>_config.screenWidth) XX=_config.screenWidth;
	if(YY>_config.screenHeight) YY=_config.screenHeight;
	var tx=(this.move=="move-y")?null:(XX-this.moveX);
	var ty=(this.move=="move-x")?null:(YY-this.moveY);
	this.board.style.left=tx+"px";
	this.board.style.top=ty+"px";
	if(this.type!='folder'){
		setcookie('win_'+this.id+'_left',this.left*1,60*60*24*365);
		setcookie('win_'+this.id+'_top',this.top*1,60*60*24*365);
	}
};
_window.prototype.DisableButton=function(name,style)
{
	name=name.toUpperCase();
	this.buttons[name].disabled=true;
	this.buttons[name].className=(style?style:"DISABLED")+" "+name;
};
_window.prototype.EnableButton=function(name)
{
	name=name.toUpperCase();
	this.buttons[name].disabled=false;
	this.buttons[name].className=name;
};
_window.prototype.OnOK=function()
{
	this.Close();
};
_window.prototype.OnCANCEL=function()
{
	this.Close();
};

_window.prototype.reject=function(){
	
	jQuery('#_blank').empty().hide();
	//jQuery('#navbar').css('z-index',4001);
	var self=this;
	jQuery(this.board).animate({left:this.oldleft+'px',top:this.oldtop+'px'},_config.delay,function(){
		self.left=self.oldleft;
		self.top=self.oldtop;
	});
};
_window.prototype.save=function(){
	if(this.type!=='widget' || !_config.Permission_Container('admin','icosContainer_body_'+this.desktop)) return;
};
