/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */

function _filemanage(id,data,param){
	 page=isNaN(parseInt(param.page))?1:parseInt(param.page);
	 total=isNaN(parseInt(param.total))?1:parseInt(param.total);
	
	this.total=total;
	//alert('filemangeid='+id);
	this.bz=param.bz||'';//标志是那个api的数据
	
	this.perpage=param.perpage;
	this.totalpage=Math.ceil(this.total/this.perpage);
	this.totalpage=this.totalpage<1?1:this.totalpage;
	this.id=id;
	this.string="_filemanage.cons."+this.id;
	//alert(this.id);
	this.fid=id.split('-')[1];
	this.winid=param.winid;
	this.keyword=param.keyword;
	
	this.folderdata=_config.sourcedata.folder[this.fid]||{};
	
	this.view=parseInt(this.folderdata.iconview||_filemanage.view);
	this.disp=parseInt(this.folderdata.disp||_filemanage.disp);
	this.asc=param.asc;//_filemanage.asc;
	this.detailper=_filemanage.detailper;
	if(!this.data) this.data={};
	this.data=data;
	this.currentpage=page;
	this.container=param.container;
	this.odata=[];
	this.sum=0;
	_window.windows[this.winid].filemanageid=this.id;
	_filemanage.cons[this.id]=this;
	this.pageloadding=true;
}
_filemanage.speed=5;
_filemanage.perpage=100;//每页最多个数；
_filemanage.cons={}
_filemanage.view=1;
_filemanage.disp=0;
_filemanage.asc=1;
_filemanage.detailper=[47,10,20,15,8];//依此对应：名称  大小  类型  修改时间；
_filemanage.onmousemove=null;
_filemanage.onmouseup=null;
_filemanage.onselectstart=1;
_filemanage.stack_data={};
_filemanage.showicosTimer={};
_filemanage.apicacheTimer={};
_filemanage.viewstyle=['bigicon','middleicon','middlelist','smalllist','detaillist'];
_filemanage.Ctopic=function(container){
	if(!_config.Permission_Container('topic',container)) {
			showDialog(_lang.prompt1.noprevelige,'notice');
			return;
	}
	OpenWindow('newtopic',_config.systemurl+'&op=topic&do=topic&container='+container+'&handlekey=newtopic',_lang.titleButton['NEWTOPIC'],'','width=800,height=600,titlebutton=close,resize=no,isModal=yes');
};
_filemanage.glow=function(el){
	var delay=200;
	for(var i=0;i<4;i++){
		window.setTimeout(function(){
			el.find('.toggleGlow').toggleClass('glow');
		},delay*i);
	}
}
_filemanage.Arrange=function(id,view,winid){
	var obj=_filemanage.cons[id];
	obj.view=parseInt(view);
	var fid=obj.fid;
	if(fid>0 && _config.Permission_Container('admin',fid)) {
		jQuery.post(_config.saveurl+'&do=folder',{fid:fid,iconview:parseInt(view)});
	}
	obj.view=parseInt(view);
	_config.sourcedata.folder[fid]['iconview']=parseInt(view);
	obj.showIcos();
	//var classend=jQuery('#filemanage_view'+winid).attr('class').replace(/filemanage_view\d+_/i,'');
	//jQuery('#filemanage_view'+winid).attr('class','filemanage_view'+view+'_'+classend);
	jQuery('#right_contextmenu .menu-icon-iconview').each(function(){
		if(jQuery(this).attr('view')==view) jQuery(this).removeClass('icon-notselect').addClass('icon-select');
		else jQuery(this).addClass('icon-notselect').removeClass('icon-select');
	});
}
_filemanage.Disp=function(id,disp,winid){
	
	if(!_window.windows[winid].filemanageid) return;
	var obj=_filemanage.cons[id];
	var fid=obj.fid;
	if(_config.Permission_Container('admin',fid)) jQuery.post(_config.saveurl+'&do=folder',{fid:fid,disp:parseInt(disp)});
	obj.disp=parseInt(disp);
	_config.sourcedata.folder[fid]['disp']=parseInt(disp);
	if(obj.bz.indexOf('ALIOSS')===0){
		obj.showIcos();
	}else{
		obj.pageClick(1);
	}
	
	jQuery('#right_contextmenu .menu-icon-disp').each(function(){
				if(jQuery(this).attr('disp')==disp) jQuery(this).removeClass('icon-notselect').addClass('icon-select');
				else jQuery(this).addClass('icon-notselect').removeClass('icon-select');
			});
}
_filemanage.searchsubmit=function(winid){
	var keyword=document.getElementById('searchInput_'+winid).value;
	if(keyword==_lang.fsearch) keyword='' ;
	if(!_window.windows[winid].filemanageid) return;
	var obj=_filemanage.cons[_window.windows[winid].filemanageid];
	if(!obj) return;
	if(obj.bz.indexOf('ALIOSS')===0){
		obj.keyword=keyword;
		obj.showIcos();
	}else{
		obj.pageClick(1);
	}
}
function Search(data,keyword){
	var data1={};
	for(var i in data){
		if(data[i].name.toLowerCase().indexOf(keyword.toLowerCase())!==-1){
			data1[i]=data[i];
		}
	}
	return data1;
}
function Sort(data,disp,asc){
	var sarr=new Array();
	if(!data) return new Array();
	for(var i in data){
	
		/*if(!_config.Permission('open','',data[i].icoid)){
			if(data[i].type=='user'){
				data[i].img=_config.ucenterurl+'/images/noavatar_middle.gif';
			}else{
				data[i].img='dzz/images/default_ys/'+data[i].type+'.png';
			}
		}*/
		switch(parseInt(disp)){
			case 0:
				
				if(data[i].type=='folder'){
					sarr[sarr.length]=' '+data[i].name+' ___'+i;
				}else{
					sarr[sarr.length]=data[i].name+'___'+i;
				}
				break;
			case 1:
				sarr[sarr.length]=data[i].size+'___'+i;
				break;
			case 2:
				if(data[i].type=='folder'){
					sarr[sarr.length]=' '+'___'+i;
				}else{
					sarr[sarr.length]=data[i].ext+data[i].type+'___'+i;
				}
				break;
			case 3:
				//asc=0;
				sarr[sarr.length]=(data[i].dateline)+'___'+i;
				break;
		}
	}
	if(parseInt(disp)==1){
		sarr=sarr.sort(function(a,b){
			return (parseInt(a)>parseInt(b))?1:0;
		});
	}else{
		sarr=sarr.sort();
	}
	var temp={};
	if(asc>0){
		for(var i=0 ;i<sarr.length;i++){
			var temp1=sarr[i].split('___');
			temp['icos_'+temp1[1]]=data[temp1[1]];
		}
	}else{
		for(var i=sarr.length-1 ;i>=0;i--){
			var temp1=sarr[i].split('___');
			temp['icos_'+temp1[temp1.length-1]]=data[temp1[temp1.length-1]];
		}
	}
	return temp;
}
function get_ico_template(view,type){
		switch(type){
				case 'image':
					var html='<img class="imageclass" src="{img}" style="display:none;" title="{name}" onload="_ico.image_resize(this,{width},{height},{ispng});" onerror="_ico.icoimgError(this,{width},{height});" error="{error}" >';
					break;
				case 'video':
					if(view<3){
						var html='<img class="videoclass{width}_{height}" src="{img}"  title="{name}" >';
					}else{
						var html='<img class="videoclass" src="{img}" style="display:none;" title="{name}" onload="_ico.image_resize(this,{width},{height},{ispng});"  onerror="_ico.icoimgError(this,{width},{height});" error="{error}">';
					}
					break;
				case 'user':
					if(view<3){
						var html='<img class="userclass{width}_{height}" src="{img}"  title="{name}" >';
					}else{
						var html='<img class="userclass radius" src="{img}" style="display:none;" title="{name}" onload="_ico.image_resize(this,{width},{height},{ispng});"  onerror="_ico.icoimgError(this,{width},{height});" error="{error}">';
					}
					break;
				default:
					var html='<img class="radius" src="{img}" style="display:none;" title="{name}" onload="_ico.image_resize(this,{width},{height},{ispng});"  onerror="_ico.icoimgError(this,{width},{height});" error="{error}">';
					break;
	}
	var typeclass='icoimgContainer_'+type;
	 var html1='';
		html1+='<div class="icoimgContainer '+typeclass+'" icoid="{icoid}" style="position:relative;width:{width}px;height:{height}px">';
		//if(view>3) html1+='<div icoid="{icoid}" class="icoblank" style="position:absolute;;left:0px;top:0px; background:url(dzz/images/b.gif);width:100%; height:100%;z-index:10;"><a class="icoblank_tip icoblank_rightbottom"></a></div>';
		html1+=   '<table width="100%" height="100%" cellpadding="0" cellspacing="0"><tr><td align="center" valign="middle">'+html+'</td></tr></table>';
		html1+=   '<div class="icoimgCover_up" style="position:absolute;left:0px;top:0px;width:{width}px;height:{height}px;z-index:1"></div>';
		html1+=   '<div class="icoimgtips" style="position:absolute;left:0px;top:0px;width:{width}px;height:{height}px;z-index:2"></div>';
		html1+=   '<div class="icoimgCover_down" style="position:absolute;left:0px;top:0px;width:{width}px;height:{height}px;z-index:-1"></div>';
		html1+='</div>'
	var str23='<div style="width:{divwidth}px;height:{divheight}px;" class="toggleGlow">';
		str23+='	<table width="{divwidth}" height="{divheight}" style="table-layout:fixed;">';
		str23+='		<tr> <td  align="center" valign="middle"  width="{width_10}">'+html1+'</td>';
		str23+='		<td align="left" valign="middle">';
		str23+='			<div class="IcoText_div" style="width:{text_width}px;" title="{name}">';
		str23+='				<table cellpadding="0" cellspacing="0" width="100%" height="100%"><tr><td valign="middle" align="left"><a id="file_text_{icoid}" class="IcoText_folder" style="overflow:hidden;" >{name}</a></td></tr></table>';
		str23+='			</div>';
		str23+='		</td></tr>';
		str23+='	</table>';
		str23+='</div>';
		
		str23+='	<div class="icoblank_tip icoblank_rightbottom"></div>';
		str23+='<div class="backgound_radius" style="position: absolute; left: 0px; top: 0px; z-index: -5; width: {divwidth_2}px; height: {divheight_2}px;"></div>';
	
	var str01='<div style="width:{divwidth}px;height:{divheight}px;" class="toggleGlow">';
		str01+='	<table width="{divwidth}" height="{divheight}" style="table-layout:fixed;">';
		str01+='		<tr><td  align="center" valign="middle" style="" height="{divheight_45}">'+html1+'</td></tr>';
		str01+='	    <tr><td align="center" valign="middle">';
		str01+='			<div  class="IcoText_div" style="width:{text_width}px;" title="{name}">';
		str01+='				<a id="file_text_{icoid}" class="ico_item ico_item_name" style="width:{text_width}px;overflow:hidden" title="{name}">{name}</a>';
		str01+='			</div>';
		str01+='		</td></tr>';
		str01+='	</table>';
		str01+='</div>';
	
		str01+='	<div class="icoblank_tip icoblank_rightbottom"></div>';
		//str01+='	</div>';
		str01+='<div class="backgound_radius" style="position: absolute; left: 0px; top: 0px; z-index: -5; width: {divwidth_2}px; height: {divheight_2}px;"></div>';
	
		var str1='';
		str1+='<tr class="detail_tr Icoblock"  icoid="{icoid}">';
			
			//多选 字段	
			str1+='<td class="detail_item_td "  valign="middle" width="'+_filemanage.detailper[4]+'%" style="overflow:hidden">';
				str1+='<div class="detail_item_td_div detail_item_td_select" title="多选" icoid="{icoid}">';
					str1+='<a class="selectbox" icoid="{icoid}" title="选取"></a>';
				str1+='</div>';
			str1+='</td>';
			//名称 字段	
			str1+='<td class="detail_item_td "  valign="middle" width="'+_filemanage.detailper[0]+'%" style="overflow:hidden">';
		      	str1+='<div class="detail_item_td_div detail_item_td_name toggleGlow" title="{name}" icoid="{icoid}">';
					//str1+='	<a class="selectbox" icoid="{icoid}" title="选取"></a>';
					str1+='<a href="javascript:;"><img class="detail_item_name_icon" src="{img}" title="{name}" error="{error}" onerror="jQuery(this).attr(\'src\',jQuery(this).attr(\'error\'))"></a>';
					str1+='<a href="javascript:;" id="file_text_{icoid}" class="detail_text detail_item_name_text">{name}</a>';
				str1+='</div>';
			str1+='</td>';
			
			//大小  字段	
			str1+='<td class="detail_item_td detail_item_td_size" valign="middle" width="'+_filemanage.detailper[1]+'%" style="overflow:hidden">';
		      	str1+='<div class="detail_item_td_div">';
					str1+='<div class="detail_text detail_item_size_text">{size}</div>';
				str1+='</div>';
			str1+='</td>';
			
			//类型  字段	
			str1+='<td class="detail_item_td detail_item_td_type" valign="middle" width="'+_filemanage.detailper[2]+'%" style="overflow:hidden">';
		      	str1+='<div class="detail_item_td_div">';
					str1+='<div class="detail_text detail_item_size_type">{type}</div>';
				str1+='</div>';
			str1+='</td>';
			
			//时间  字段	
			str1+='<td class="detail_item_td detail_item_td_type" valign="middle" width="'+_filemanage.detailper[3]+'%" style="overflow:hidden">';
		      	str1+='<div class="detail_item_td_div">';
					str1+='<div class="detail_text detail_item_size_type">{dateline}</div>';
				str1+='</div>';
			str1+='</td>';
			
		str1+='</tr>';
	var str='';
	switch(view){
		case 0:
			str=str01.replace(/{divwidth}/g,150);
			str=str.replace(/{divheight}/g,150);
			str=str.replace(/{divheight_2}/g,150-2);
			str=str.replace(/{divwidth_2}/g,150-2);
			str=str.replace(/{divheight_45}/g,150-45);
			str=str.replace(/{width}/g,100);
			str=str.replace(/{height}/g,100);
			str=str.replace(/{width_10}/g,100-10);
			str=str.replace(/{text_width}/g,150-15);
			str=str.replace(/{textheight}/g,45);
			str=str.replace(/{view_0}/g,'');
			str=str.replace(/{\/view_0}/g,'');
			break;
		case 1:
			str=str01.replace(/{divwidth}/g,100);
			str=str.replace(/{divheight}/g,103);
			str=str.replace(/{divheight_2}/g,103-2);
			str=str.replace(/{divwidth_2}/g,100-2);
			str=str.replace(/{divheight_45}/g,103-45);
			str=str.replace(/{width}/g,50);
			str=str.replace(/{height}/g,50);
			str=str.replace(/{width_10}/g,50+10);
			str=str.replace(/{text_width}/g,100-15);
			str=str.replace(/{text_height}/g,35);
			str=str.replace(/{textheight}/g,45);
			str=str.replace(/{view_0}(.+?){\/view_0}/g,'');
			break;
		case 2:
			str=str23.replace(/{divwidth}/g,180);
			str=str.replace(/{divheight}/g,70);
			str=str.replace(/{divheight_2}/g,70-2);
			str=str.replace(/{divwidth_2}/g,180-2);
			str=str.replace(/{width}/g,50);
			str=str.replace(/{height}/g,50);
			str=str.replace(/{width_10}/g,50+25);
			str=str.replace(/{text_width}/g,180-50-35);
			break;
		case 3:
			str=str23.replace(/{divwidth}/g,220);
			str=str.replace(/{divheight}/g,42);
			str=str.replace(/{divheight_2}/g,42-2);
			str=str.replace(/{divwidth_2}/g,220-2);
			str=str.replace(/{width}/g,32);
			str=str.replace(/{height}/g,32);
			str=str.replace(/{width_10}/g,32+10);
			str=str.replace(/{text_width}/g,220-32-15);
			break;
		
		case 4:
			str=str1.replace(/{width}/g,40);
			str=str.replace(/{height}/g,45);
			str=str.replace(/{width_10}/g,40+10);
			str=str.replace(/{height_10}/g,40+10);
			
			break;
	}
	return str;
	
}
/*
view: 图标排列方式：0:大图标，1：中图标，2：中图标列表，3小图标列表,4:详细
disp：图标排列顺序：0：原始顺序:按名称；1：按大小；2：按类型；3：按时间
asc :升序或降序：0：升序；1：降序
*/
_filemanage.prototype.delIcos=function(data){
	var self=this;
	//this.asc= this.asc?1:0;
	containerid='content_'+this.winid;
	var el=jQuery('#icosContainer_'+containerid+'_'+this.id+' .Icoblock[icoid='+data.icoid+']');
		el.remove();
	if(data.type=='folder'){
		for(var id in _filemanage.cons){
			if(_filemanage.cons[id].fid==data.pfid){
				jQuery("#jstree_area_"+_filemanage.cons[id].winid).jstree('refresh',jQuery('#f-'+data.pfid+'-'+self.winid));
				jQuery("#jstree_area_"+_filemanage.cons[id].winid).jstree('correct_state',jQuery('#f-'+data.pfid+'-'+self.winid));
			}
		}
	}
	
	delete this.data[data.icoid];
	delete this.currentdata['icos_'+data.icoid];
	this.sum--;
	this.total--;
	this.PageInfo();
	_filemanage.stack_run(this.winid); //删除时如果有未显示的接着显示
	
	
}

_filemanage.prototype.reCreateIcos=function(data){
	var self=this;
	containerid='content_'+this.winid;
	this.data[data.icoid]=data;
		var template=get_ico_template(this.view,data.type);
		//创建图标列表
		 var ispng=true;
		if(data.flag!=''){
			data.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/'+data.flag+'.png';
			data.error='dzz/images/default/system/'+data.flag+'.png';
		}else if(data.type=='folder'){
			data.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/folder.png';
			data.error='dzz/images/default/system/folder.png';
		}else{
			data.error='dzz/images/default/icodefault.png';
		}
		
		var html=template.replace(/\{name\}/g,data.name);
		html=html.replace(/\{icoid\}/g,data.icoid);
		html=html.replace(/\{ispng\}/g,ispng);
		html=html.replace(/\{img\}/g,data.img);
		html=html.replace(/\{username\}/g,data.username);
		html=html.replace(/\{replynum\}/g,data.replynum?data.replynum:'0');
		html=html.replace(/\{fdateline\}/g,data.fdateline);
		html=html.replace(/\{name\}/g,data.name);
		html=html.replace(/\{icoid\}/g,data.icoid);
		html=html.replace(/\{img\}/g,data.img);
		html=html.replace(/\{error\}/g,data.error);
		html=html.replace(/\{size\}/g,data.fsize);
		html=html.replace(/\{type\}/g,data.ftype);
		html=html.replace(/\{dateline\}/g,data.fdateline);
		
		//处理操作按钮
		//html=this.filterOPIcon(data,html);
		
		
		if(this.view<4){
		var el=jQuery('#'+containerid+' .Icoblock[icoid='+data.icoid+']');
		el.html(html);
			/*if( _config.icosTips[data.icoid]>0){
				_ico.setTip(data.icoid, _config.icosTips[data.icoid]);
			}
			if(_config.Permission('delete',data)){
				_Drag.init(data.icoid,el.get(0),self.id,self.container);
			}*/
			
			/*el.on('contextmenu',function(e){_contextmenu.right_ico(e?e:window.event,jQuery(this).attr('icoid'),self.id,self.fid); return false;});
			
			el.on('mouseenter',function(e){
				jQuery(this).addClass('hover');
				
			});
			el.on('mouseleave',function(e){
				jQuery(this).removeClass('hover');
				
			});*/
			//处理多选框
			if(_config.Permission_Container('multiselect',this.fid)){
				el.find('.icoblank_rightbottom').on('click',function(){
					var flag=true;
					var ell=jQuery(this).parent();
					var icoid=ell.attr('icoid');
					if(ell.hasClass('Icoselected')){
						var flag=false;
					}
					_select.SelectedStyle(ell.parent().attr('id'),icoid,flag,true);
					
					return false;
				});
				//处理操作按钮
				el.off('click').on('click',function(e){
					var tag = e.srcElement ? e.srcElement :e.target;
					if(tag.type=="text"||tag.type=="textarea"){
						return true;
					}
					var flag=true;
					if(_hotkey.ctrl && jQuery(this).hasClass('Icoselected')){
						var flag=false;
					}
					if(_hotkey.ctrl) var multi=true;
					else multi=false;
					_select.SelectedStyle(jQuery(this).parent().attr('id'),jQuery(this).attr('icoid'),flag,multi);
					//self.createBottom();
					return false;
				});
			}else{
				el.find('.icoblank_rightbottom').remove();
			}
			
			el.find('.IcoText_div a,.icoimgContainer').on('click',function(e){
				var tag = e.srcElement ? e.srcElement :e.target;
				
				if(tag.type=="text"||tag.type=="textarea"){
					return true;
				}
				
				if(data.type=='folder'){
					jQuery("#jstree_area_"+self.winid).jstree('select_node',jQuery('#f-'+data.oid+'-'+self.winid),true);
				}else{
					_ico.Open(data.icoid);
				}
				dfire('click');
				return false;
			});
		
	
		}else{ //详细列表时
			var el=jQuery('#'+containerid+' .Icoblock[icoid='+data.icoid+']');
			el.replaceWith(html);
			var el=jQuery('#'+containerid+' .Icoblock[icoid='+data.icoid+']');
			el.find('.detail_item_td_name').on('contextmenu',function(e){ _contextmenu.right_ico(e?e:window.event,jQuery(this).attr('icoid'),self.id,self.fid); return false;});
			el.find('.detail_item_td_name').each(function(e){
				if(_config.Permission('drag',_config.sourcedata.icos[jQuery(this).attr('icoid')])){
					_Drag.init(jQuery(this).attr('icoid'),this,self.id,self.container);
				}
			});
			el.bind('mouseenter',function(e){
						jQuery(this).addClass('hover');
						return false;
					})
			el.bind('mouseleave',function(e){
				jQuery(this).removeClass('hover');
				return false;
			});
			el.find('.detail_item_td_name a,.icoimgContainer').on('click',function(e){
				var tag = e.srcElement ? e.srcElement :e.target;
				if(tag.type=="text"||tag.type=="textarea"){
					return true;
				}
				if(data.type=='folder'){
					jQuery("#jstree_area_"+self.winid).jstree('select_node',jQuery('#f-'+data.oid+'-'+self.winid),true);
				}else{
					_ico.Open(data.icoid);
				}
				return false;
			});
			if(_config.Permission_Container('multiselect',this.fid)){
				el.off('click').on('click',function(e){
					e=e?e:window.event;
					var tag = e.srcElement ? e.srcElement :e.target;
					if(tag.type=="text"||tag.type=="textarea"){
						return true;
					}
					var Item=jQuery(this).parent().parent().parent();
					var flag=true;
					if(_hotkey.ctrl && Item.hasClass('Icoselected')){
						var flag=false;
					}
					if(_hotkey.ctrl) var multi=true;
					else multi=false;
					_select.SelectedStyle(Item.attr('id'),jQuery(this).attr('icoid'),flag,multi);
					//self.createBottom();
					return false;
				});
				el.find('.selectbox').on('click',function(){
					var flag=true;
					var icoid=jQuery(this).parent().attr('icoid');
					var ell=jQuery(this).parent().parent().parent().parent().parent().parent();
					if(jQuery(this).parent().parent().parent().hasClass('Icoselected')){
						var flag=false;
					}
					_select.SelectedStyle(ell.attr('id'),icoid,flag,true);
					return false;
				});
			}
	}
	//处理按钮
	if(this.view<5){
		el.find('.icoblank_tip .icon').on('click',function(){
			this.onclick;
			return false;
		});
		
	}
	this.currentdata['icos_'+data.icoid]=data;
	if(data.type=='folder'){
		jQuery("#jstree_area_"+self.winid).jstree('refresh',jQuery('#f-'+data.pfid+'-'+self.winid));
	}
}

_filemanage.prototype.filterOPIcon=function(data,html){ //过滤操作按钮
	//处理like
		if((data.bz && data.bz!='') || _config.myuid<1){
			html=html.replace(/\{like\}(.+?)\{\/like\}/g,'');
		}
		//处理download
		if(!(_config.Permission('download',this.container,data))){
			html=html.replace(/\{download\}(.+?)\{\/download\}/g,'');
		}
		
		//处理share
		if((data.bz && data.bz!='') || !_config.Permission('share',this.container,data)){
			html=html.replace(/\{share\}(.+?)\{\/share\}/g,'');
		}
		//处理saveto
		if(_config.gid<1 ||(data.bz && data.bz!='') || !(_config.Permission('saveto',this.container,data))){
			html=html.replace(/\{saveto\}(.+?)\{\/saveto\}/g,'');
		}
		
	
		
		//回收站时无操作按钮
		
		 if(_config.space.typefid['recycle']==this.fid){
			 html=html.replace(/\{\w+\}(.+?)\{\/\w+\}/g,'');
		 }
		 html=html.replace(/\{\w+\}/g,'');
		 html=html.replace(/\{\/\w+\}/g,'');
		return html;
}
_filemanage.prototype.CreateIcos=function(data,flag){
	var self=this;
	containerid='content_'+this.winid;
	if(!flag && this.data[data.icoid]){ //如果已经存在
		var el=jQuery('#'+containerid+' .Icoblock[icoid='+data.icoid+']');
		_filemanage.glow(el);
		return;
	}
	this.data[data.icoid]=data;
		var template=get_ico_template(this.view,data.type);
		//创建图标列表
		 var ispng=true;
		if(data.flag!=''){
			data.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/'+data.flag+'.png';
			data.error='dzz/images/default/system/'+data.flag+'.png';
		}else if(data.type=='folder'){
			data.img='dzz/styles/thame/'+_config.thame.system.folder+'/system/folder.png';
			data.error='dzz/images/default/system/folder.png';
		}else{
			data.error='dzz/images/default/icodefault.png';
		}
		
		var html=template.replace(/\{name\}/g,data.name);
		html=html.replace(/\{icoid\}/g,data.icoid);
		html=html.replace(/\{ispng\}/g,ispng);
		html=html.replace(/\{img\}/g,data.img);
		html=html.replace(/\{username\}/g,data.username);
		html=html.replace(/\{replynum\}/g,data.replynum?data.replynum:'0');
		html=html.replace(/\{fdateline\}/g,data.fdateline);
		html=html.replace(/\{name\}/g,data.name);
		html=html.replace(/\{icoid\}/g,data.icoid);
		html=html.replace(/\{img\}/g,data.img);
		html=html.replace(/\{error\}/g,data.error);
		html=html.replace(/\{size\}/g,data.fsize);
		html=html.replace(/\{type\}/g,data.ftype);
		html=html.replace(/\{dateline\}/g,data.fdateline);
		
		//处理操作按钮
		//html=this.filterOPIcon(data,html);
		
		if(this.view<4){
			var fileclass='file-icoitem '+_filemanage.viewstyle[this.view];
		
			var el=jQuery('<div id="folder_Icoblock_'+data.icoid+'" icoid="'+data.icoid+'" oid="'+data.oid+'"  class="'+fileclass+' Icoblock  ">'+html+'</div>').appendTo('#icosContainer_'+containerid+'_'+this.id);
			if( _config.icosTips[data.icoid]>0){
				_ico.setTip(data.icoid, _config.icosTips[data.icoid]);
			}
			if(_config.Permission('delete',data)){
				_Drag.init(data.icoid,el.get(0),self.id,self.container);
			}
			
			el.on('contextmenu',function(e){_contextmenu.right_ico(e?e:window.event,jQuery(this).attr('icoid'),self.id,self.fid); return false;});
			
			el.on('mouseenter',function(e){
				jQuery(this).addClass('hover');
				
			});
			el.on('mouseleave',function(e){
				jQuery(this).removeClass('hover');
				
			});
			//处理多选框
			if(_config.Permission_Container('multiselect',this.fid)){
				el.find('.icoblank_rightbottom').on('click',function(){
					var flag=true;
					var ell=jQuery(this).parent();
					var icoid=ell.attr('icoid');
					if(ell.hasClass('Icoselected')){
						var flag=false;
					}
					_select.SelectedStyle(ell.parent().attr('id'),icoid,flag,true);
					
					return false;
				});
				//处理操作按钮
				el.on('click',function(e){
					var tag = e.srcElement ? e.srcElement :e.target;
					if(tag.type=="text"||tag.type=="textarea"){
						return true;
					}
					var flag=true;
					if(_hotkey.ctrl && jQuery(this).hasClass('Icoselected')){
						var flag=false;
					}
					if(_hotkey.ctrl) var multi=true;
					else multi=false;
					_select.SelectedStyle(jQuery(this).parent().attr('id'),jQuery(this).attr('icoid'),flag,multi);
					//self.createBottom();
					return false;
				});
			}else{
				el.find('.icoblank_rightbottom').remove();
			}
			
			el.find('.IcoText_div a,.icoimgContainer').on('click',function(e){
				var tag = e.srcElement ? e.srcElement :e.target;
				
				if(tag.type=="text"||tag.type=="textarea"){
					return true;
				}
				
				if(data.type=='folder'){
					jQuery("#jstree_area_"+self.winid).jstree('select_node',jQuery('#f-'+data.oid+'-'+self.winid),true);
				}else{
					_ico.Open(data.icoid);
				}
				dfire('click');
				return false;
			});
		
	
		}else{ //详细列表时
			var el=jQuery(html).appendTo('#detail_'+containerid+'_'+this.id+' table');
			el.find('.detail_item_td_name').on('contextmenu',function(e){ _contextmenu.right_ico(e?e:window.event,jQuery(this).attr('icoid'),self.id,self.fid); return false;});
			el.find('.detail_item_td_name').each(function(e){
				if(_config.Permission('drag',_config.sourcedata.icos[jQuery(this).attr('icoid')])){
					_Drag.init(jQuery(this).attr('icoid'),this,self.id,self.container);
				}
			});
			el.bind('mouseenter',function(e){
						jQuery(this).addClass('hover');
						return false;
					})
			el.bind('mouseleave',function(e){
				jQuery(this).removeClass('hover');
				return false;
			});
			el.find('.detail_item_td_name a,.icoimgContainer').on('click',function(e){
				var tag = e.srcElement ? e.srcElement :e.target;
				if(tag.type=="text"||tag.type=="textarea"){
					return true;
				}
				if(data.type=='folder'){
					jQuery("#jstree_area_"+self.winid).jstree('select_node',jQuery('#f-'+data.oid+'-'+self.winid),true);
				}else{
					_ico.Open(data.icoid);
				}
				return false;
			});
			if(_config.Permission_Container('multiselect',this.fid)){
				el.on('click',function(e){
					e=e?e:window.event;
					var tag = e.srcElement ? e.srcElement :e.target;
					if(tag.type=="text"||tag.type=="textarea"){
						return true;
					}
					var Item=jQuery(this).parent().parent().parent();
					var flag=true;
					if(_hotkey.ctrl && Item.hasClass('Icoselected')){
						var flag=false;
					}
					if(_hotkey.ctrl) var multi=true;
					else multi=false;
					_select.SelectedStyle(Item.attr('id'),jQuery(this).attr('icoid'),flag,multi);
					//self.createBottom();
					return false;
				});
				el.find('.selectbox').on('click',function(){
					var flag=true;
					var icoid=jQuery(this).parent().attr('icoid');
					var ell=jQuery(this).parent().parent().parent().parent().parent().parent();
					if(jQuery(this).parent().parent().parent().hasClass('Icoselected')){
						var flag=false;
					}
					_select.SelectedStyle(ell.attr('id'),icoid,flag,true);
					return false;
				});
			}
	}
	//处理按钮
	if(this.view<5){
		el.find('.icoblank_tip .icon').on('click',function(){
			this.onclick;
			return false;
		});
		
	}
	if(!flag) {
		_filemanage.glow(el);
		this.sum++;
		this.total++;
		jQuery('#'+containerid).scrollTop(9999999);
		//this.checkPageChange();
		this.PageInfo();
		this.currentdata['icos_'+data.icoid]=data;
		if(data.type=='folder'){
			jQuery("#jstree_area_"+self.winid).jstree('refresh',jQuery('#f-'+data.pfid+'-'+self.winid));
		}
	}
}

_filemanage.prototype.showIcos=function(){
	
	//排序数据
	
	var self=this;
	if(_filemanage.showicosTimer[this.winid]) window.clearTimeout(_filemanage.showicosTimer[this.winid]);
	_window.windows[this.winid].filemanageid=this.id;
	var containerid='content_'+this.winid;
	jQuery('#'+containerid).empty();
	
	
	this.createHeader();
	this.createIcosContainer();
	this.createBottom();
	if(_config.Permission_Container('upload',this.fid)){
		if(this.folderdata.bz && this.folderdata.bz!='') var fid=encodeURIComponent(this.folderdata.path);
		else var fid=this.folderdata.fid;
		jQuery('<input type="file" id="input_icosContainer_folder_'+this.folderdata.fid+'" style="position: absolute; z-index: -999999; width: 1px; height: 1px; border: medium none;" multiple="multiple" name="files[]">').appendTo('#'+containerid);
		_layout.createUpload('input_icosContainer_folder_'+this.folderdata.fid,'icosContainer_folder_'+fid,jQuery('#icosContainer_'+containerid+'_'+this.id),jQuery('#icosContainer_'+containerid+'_'+this.id));
	}	
	var container=jQuery('#icosContainer_'+containerid+'_'+this.id);
	if(this.keyword){
		 var data_sorted=Sort(Search(this.data,this.keyword),this.disp,this.asc);
		 jQuery('#searchInput_'+this.winid).val(this.keyword);
	}else	var data_sorted=Sort(this.data,this.disp,this.asc);
	this.currentdata=data_sorted;
	
	_filemanage.stack_data[self.winid]=Array();
	for(var i in data_sorted){
		_filemanage.stack_data[self.winid].push({data:data_sorted[i],"obj":self});
	}
	window.setTimeout(function(){_filemanage.stack_run(self.winid);},1);
	jQuery('#filemanage_view'+this.winid).attr('class','filemanage_view'+this.view+'_1');
	//增加底部信息
	this.pageloadding=false;
};
_filemanage.prototype.appendIcos=function(data){
	var self=this;
	if(_filemanage.showicosTimer[this.winid]) window.clearTimeout(_filemanage.showicosTimer[this.winid]);
	_filemanage.stack_data[self.winid]=Array();
	for(var i in data){
		//this.data[i]=data[i];
		_filemanage.stack_data[self.winid].push({data:data[i],"obj":self});
	}
	window.setTimeout(function(){_filemanage.stack_run(self.winid);},1);
	this.pageloadding=false;
};
_filemanage.prototype.createHeader=function(){
	//创建right_header
	var self=this;
	var right_header=document.createElement('div');
	right_header.className="filemanage-header clearfix";
	right_header.id='header_content_'+this.winid+'_'+this.id;
	document.getElementById('content_'+this.winid).appendChild(right_header);
	//切换工具
   var win=_window.windows[this.winid];
   var html='';
    html+='<ul class="nav nav-pills clearfix">';
	html+='<div class="treeshow-guide" id="treeshow_'+this.winid+'" style="line-height:34px" onclick="_filemanage.treeshow(\''+this.winid+'\')"><a href="#" class="treeshow-guide-left"></a></div>';
		//排序方式
			html+='  <li class="dropdown pull-right">';
			html+='		<a href="#" data-toggle="dropdown" class="dropdown-toggle"><span>'+_lang.filemanage_disp[this.disp]+'</span> <b class="caret"></b></a>';
			html+='		<ul class="dropdown-menu">';
			for(var i=0 ;i<4;i++){
				html+='	   	 <li><a href="#" onClick="_filemanage.Disp(\''+this.id+'\',\''+i+'\',\''+this.winid+'\')">'+_lang.filemanage_disp[i]+'</a></li>';
			}
			html+='		</ul>';
			html+='  </li>';
		//图标大小
			html+='  <li class="dropdown pull-right">';
			html+='		<a href="#" data-toggle="dropdown" class="dropdown-toggle"><span>'+_lang.filemanage_view[this.view]+'</span> <b class="caret"></b></a>';
			html+='		<ul class="dropdown-menu">';
			for(var i=0 ;i<5;i++){
				html+='	   	 <li><a href="#" onClick="_filemanage.Arrange(\''+this.id+'\',\''+i+'\',\''+this.winid+'\')">'+_lang.filemanage_view[i]+'</a></li>';
			}
			html+='		</ul>';
			html+='  </li>';
	if(this.fid!=_config.space.typefid['recycle']){
	//新建
	
		if( _config.Permission_Container('link',this.fid) || _config.Permission_Container('app',this.fid) || _config.Permission_Container('topic',this.fid) ||_config.Permission_Container('folder',this.fid)){
			html+='  <li class="dropdown pull-right">';
			html+='		<a href="#" data-toggle="dropdown" class="dropdown-toggle">新建 <b class="caret"></b></a>';
			html+='		<ul class="dropdown-menu">';
			if(_config.Permission_Container('folder',this.fid)){ //新建文件夹
				html+='	    <li><a href="#" onclick="_ico.NewIco(\'Newfolder\',\''+this.fid+'\');">'+_lang.folderTabs['NEWFOLDER']+'</a></li>';
			}
			if(_config.Permission_Container('link',this.fid)){ //新建文件夹
				html+='	    <li><a href="#" onclick="_ico.NewIco(\'Newlink\',\''+this.fid+'\')">'+_lang.folderTabs['NEWLINK']+'</a></li>';
			}
			if(_config.Permission_Container('document',this.fid)){ //新建文件夹
				html+='	    <li><a href="#" onclick="_ico.NewIco(\'NewDzzDoc\',\''+this.fid+'\')">'+_lang.folderTabs['NEWDZZDOC']+'</a></li>';
				html+='	    <li><a href="#" onclick="_ico.NewIco(\'NewTxt\',\''+this.fid+'\')">'+_lang.folderTabs['NEWTXT']+'</a></li>';
			}
			if(_config.Permission_Container('topic',this.fid)){ //新建文件夹
				html+='	    <li><a href="#"  onclick="_filemanage.Ctopic(\''+this.fid+'\')">'+_lang.titleButton['NEWTOPIC']+'</a></li>';
			}
			html+='		</ul>';
			html+='  </li>';
			
		}
		//上传
		if( _config.Permission_Container('upload',this.fid)){
			html+='  <li class="pull-right" style="position:relative;overflow:hidden;"><a id="buttonContainer_input_icosContainer_folder_'+this.fid+'" href="#" >上传</a></li>';
		}
	}else{
		if( _config.Permission_Container('admin',this.fid)){
			html+='  <li class="pull-right"><a href="#" onclick="_ico.Empty(\''+this.fid+'\');return false">清空回收站</a></li>';
		}
	}	 
	
	
	html+='  <li style="line-height:34px"><div class="input-prepend" ><span class="add-on"><i class="icon icon-search"></i></span><input class="span2" id="searchInput_'+this.winid+'" type="text" placeholder="'+_lang.fsearch+'" onkeydown="if(event.keyCode==13){_filemanage.searchsubmit(\''+this.winid+'\');jQuery(this).trigger(\'blur\');}"  onblur="if(this.value==\'\'){this.value=\''+_lang.fsearch+'\';}" onfocus="if(this.value==\''+_lang.fsearch+'\'){this.value=\'\';}else{this.select();};dbind(this.id,\'blur\');"></div></li>';	
	html+='</ul>';

	right_header.innerHTML=html;
	if( _config.Permission_Container('upload',this.fid)){
		if(BROWSER.ie){
					jQuery('<input id="button_input_icosContainer_folder_'+this.fid+'" name="files[]" tabIndex="-1" style="position: absolute;outline:none; filter: alpha(opacity=0); PADDING-BOTTOM: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font-family: Arial; font-size: 14px; top: 0px; cursor: pointer; right: 0px; padding-top: 0px; opacity: 0;direction:ltr;background-image:none" type="file" >').appendTo('#buttonContainer_input_icosContainer_folder_'+this.fid);
					_layout.createUpload('button_input_icosContainer_folder_'+this.fid,'icosContainer_folder_'+encodeURIComponent(this.folderdata.path),null,null,1024*1024*2);
					
		}else{
			jQuery('#buttonContainer_input_icosContainer_folder_'+this.fid).get(0).onclick=function(){jQuery('#input_icosContainer_folder_'+self.fid).trigger('click');}
		}
	}
	jQuery(right_header).find('.dropdown-menu li a').click(function(){
		jQuery(this).parent().parent().parent().find('.dropdown-toggle span').html(this.innerHTML);
	});
	if(this.keyword && this.keyword!=_lang.fsearch){
		document.getElementById('searchInput_'+this.winid).value=this.keyword;
	}else{
		document.getElementById('searchInput_'+this.winid).value=_lang.fsearch;
	}
	
	var minwidth=0;
	jQuery(right_header).find('.nav li').each(function(){
		minwidth+=jQuery(this).outerWidth(true);
	});
	minwidth+=50;
	minwidth+=jQuery(right_header).outerWidth(true)-jQuery(right_header).find('.nav').outerWidth(true);
	_window.windows[this.winid].right_minWidth=minwidth;
	
	if(_window.windows[this.winid].minWidth<minwidth) _window.windows[this.winid].minWidth=minwidth;
}
_filemanage.prototype.createIcosContainer=function(){
	var self=this;
	var containerid='content_'+this.winid;
	var div =document.createElement('div');
	div.className="icosContainer";
	div.id='icosContainer_content_'+this.winid+'_'+this.id;
	div.setAttribute('unselectable',"on");
	div.setAttribute('onselectstart',"return event.srcElement.type== 'text';");
	
	jQuery(div).on('contextmenu',function(e){_contextmenu.right_folder(e?e:window.event,self.winid);return false;});
	
	document.getElementById('content_'+this.winid).appendChild(div);
	jQuery('#icosContainer_'+containerid+'_'+this.id).css('height',_window.windows[this.winid].bodyHeight-jQuery('#header_'+containerid+'_'+this.id).outerHeight(true));
	if(this.view<4){
		jQuery(div).scroll(function(){
				if((jQuery('#icosContainer_'+containerid+'_'+self.id+' .Icoblock').last().offset().top-jQuery('#icosContainer_'+containerid+'_'+self.id).offset().top)<jQuery('#icosContainer_'+containerid+'_'+self.id).height()){
				if(self.currentpage>=self.totalpage || self.pageloadding) return ;
				self.pageloadding=true;
				self.currentpage++;
				self.pageClick(self.currentpage);
			}
		});
		if(_config.Permission_Container('multiselect',this.fid)){
			_select.init('icosContainer_'+containerid+'_'+this.id);
		}
		jQuery(div).on('click',function(e){
				//清空数据
				//if(_hotkey.ctrl<1) return true;
				e=e?e:window.event;
				var tag = e.srcElement ? e.srcElement :e.target;
				if(tag.type=="text"||tag.type=="textarea"){
					return true;
				}	
				if(this.id==_config.selectall.container){
					_config.selectall.container=this.id;
					_config.selectall.icos=[];
					_config.selectall.position={};
					jQuery(div).find('.Icoblock').removeClass('Icoselected');
				}
				jQuery('#bottom_content_'+self.winid+'_'+self.id).hide();
				dfire('click');
				return false;
			});
	}else{
			var header='';
			header+='<table class="table " width="100%" border="0"   style="table-layout:fixed;margin:0">';
			header+='<thead class="detail_header_tr">';
			header+='<th class="detail_header_select" width="'+this.detailper[4]+'%">';
					header+='<div class="detail_header_td_div">';
						header+='<a class="selectbox" icoid="{icoid}" title="选取"></a>';
					header+='</div>';
				
				header+='</th>';
				header+='<th disp="0" class=" detail_header detail_header_0 '+(this.disp==0?'detail_header_hover':'')+'" width="'+this.detailper[0]+'%">';
					
					header+='<div class="detail_header_td_div">';
						header+='<span class="detail_header_title">'+_lang.detail['name']+'</span>';
						header+='<div disp="0"  class="detail_header_drag" ></div>';
						if(this.disp==0 ) header+='<a class="detail_header_asc detail_header_asc_'+this.asc+'" style="display:inline-block;" ></a>';
					header+='</div>';
				
				header+='</th>';
				
				header+='<th disp="1" class=" detail_header detail_header_1 '+(this.disp==1?'detail_header_hover':'')+'"  width="'+this.detailper[1]+'%">';
					header+='<div class="detail_header_td_div">';
						header+='<span class="detail_header_title">'+_lang.detail['size']+'</span>';
						if(this.disp==1) header+='<a class="detail_header_asc detail_header_asc_'+this.asc+'" style="display:inline-block;" ></a>';
						header+='<div disp="1"  class="detail_header_drag" ></div>';
					header+='</div>';
				header+='</th>';
				header+='<th disp="2" class=" detail_header detail_header_2 '+(this.disp==2?'detail_header_hover':'')+'"  width="'+this.detailper[2]+'%">';
					header+='<div class="detail_header_td_div">';	
						header+='<span class="detail_header_title">'+_lang.detail['type']+'</span>';
						if(this.disp==2) header+='<a class="detail_header_asc detail_header_asc_'+this.asc+'" style="display:inline-block;" ></a>';
						header+='<div disp="2"  class="detail_header_drag" style="float:right" ></div>';
					header+='</div>';
				header+='</th>';
				header+='<th disp="3" class=" detail_header detail_header_3 '+(this.disp==3?'detail_header_hover':'')+'"  width="'+this.detailper[3]+'%">';
					header+='<div class="detail_header_td_div">';
						header+='<span class="detail_header_title">'+_lang.detail['dateline']+'</span>';
						if(this.disp==3) header+='<a class="detail_header_asc detail_header_asc_'+this.asc+'" style="display:inline-block;" ></a>';
						
					header+='</div>';
				header+='</th>';
			header+='</thead>';
			header+='</table>';
			var str='';
			str+='<table class="table " width="100%" border="0"   style="table-layout:fixed;margin:0">';
			
			
			var str2='</table>';
			var html='';
			
			var el1=jQuery('<div class="filemanage-detail-header ">'+header+'</div>').appendTo('#icosContainer_'+containerid+'_'+this.id);
			var el=jQuery('<div id="detail_'+containerid+'_'+this.id+'" style="height:'+(jQuery('#icosContainer_'+containerid+'_'+this.id).height()-el1.height())+'px;overflow-x:hidden;overflow-y:auto">'+str+html+str2+'</div>').appendTo('#icosContainer_'+containerid+'_'+this.id);
			jQuery('#icosContainer_'+containerid+'_'+this.id).css('overflow','hidden');
			jQuery('#detail_'+containerid+'_'+this.id).scroll(function(){
				if((jQuery('#detail_'+containerid+'_'+self.id+' .detail_tr').last().offset().top-jQuery('#icosContainer_'+containerid+'_'+self.id).offset().top)<jQuery('#icosContainer_'+containerid+'_'+self.id).height()){
					if(self.currentpage>=self.totalpage || self.pageloadding) return ;
					self.pageloadding=true;
					self.currentpage++;
					self.pageClick(self.currentpage);
				}
			});
			if(_config.Permission_Container('multiselect',this.fid)){
				_select.init('detail_'+containerid+'_'+this.id);
			}
			//容器点击解除所有选择
			el.on('click',function(e){
				//清空数据
				//if(_hotkey.ctrl<1) return true;
				e=e?e:window.event;
				var tag = e.srcElement ? e.srcElement :e.target;
				if(tag.type=="text"||tag.type=="textarea"){
					return true;
				}	
				if(this.id==_config.selectall.container){
					_config.selectall.container=this.id;
					_config.selectall.icos=[];
					_config.selectall.position={};
					jQuery(el).find('.Icoblock').removeClass('Icoselected');
				}
				jQuery('#bottom_content_'+self.winid+'_'+self.id).hide();
				dfire('click');
				return false;
			});
			jQuery('#icosContainer_'+containerid+'_'+this.id).find('.detail_header_select').on('click',function(){
				var el=jQuery(this);
				var selectall=true;
				if(el.hasClass('Icoselected')){
					el.removeClass('Icoselected');
					selectall=false;
					_config.selectall.icos=[];
				}else{
					el.addClass('Icoselected');
					selectall=true;
					_config.selectall.icos=[];
				}
				_config.selectall.container='detail_'+containerid+'_'+self.id;
				jQuery('#detail_'+containerid+'_'+self.id).find('.Icoblock').each(function(){
					if(selectall){
						jQuery(this).addClass('Icoselected');
						_config.selectall.icos.push(jQuery(this).attr('icoid'));;
					}else{
						jQuery(this).removeClass('Icoselected');
					}
				});
				self.selectInfo();
			})
			jQuery('#icosContainer_'+containerid+'_'+this.id).find('.detail_header:not(.detail_header_select)').on('click',function(){
				var disp=parseInt(jQuery(this).attr('disp'));
				
				if(disp*1==self.disp*1){
					if(self.asc>0){
						 self.asc=0;
					}
					else self.asc=1;
				}else{
					_filemanage.Disp(self.id,disp,self.winid)
					self.asc=1;
				}
				self.disp=disp;
				_config.sourcedata.folder[self.fid].disp=disp;
				if(self.bz.indexOf('ALIOSS')===0){
					self.showIcos();
				}else{
					self.pageClick(1);
				}
			});
	}
}
_filemanage.treeshow=function(winid){
	var win= _window.windows[winid];
	win.treeHide(!win.treeshow);
	
};
_filemanage.prototype.createBottom=function(){
	//创建right_bottom
	var right_bottom=document.createElement('div');
	right_bottom.className="filemanage-bottom";
	right_bottom.id='bottom_content_'+this.winid+'_'+this.id;
	document.getElementById('content_'+this.winid).appendChild(right_bottom);
	this.PageInfo();
};
_filemanage.prototype.selectInfo=function(){
	var self=this;
	if(this.selectinfoTimer) window.clearTimeout(this.selectinfoTimer);
	this.selectinfoTimer=window.setTimeout(function(){
		self._selectInfo();
	},200);
}
_filemanage.prototype._selectInfo=function(){
	if(this.bottomShowTimer) window.clearTimeout(this.bottomShowTimer);
	
	var sum=_config.selectall.icos.length;
	if(sum<1){
		this.PageInfo();
	}else if(sum==1){
		var icoid=_config.selectall.icos[0];
		var data=this.data[icoid];
		var info='';
		info+='<ul class="nav nav-pills clearfix">';
		//判断打开方式
			var subdata=_ico.getExtOpen(icoid);
			if(subdata===true || subdata.length==1){ //有默认打开方式，但是没有下拉列表；
				info+='<li ><a href="javascript:;" onClick="_ico.Open(\''+icoid+'\')">打开</a></li>';
			/*}else if(subdata.length=1){//无打开方式
				info+='<li ><a onClick="_ico.Open(\''+icoid+'\',\''+subdata[0].extid+'\')"  href="javascript:;">'+subdata[0].name+'</a></li>';*/
			}else if(subdata.length>1){
				info+='<li class="dropdown">';
				info+='		<a class="dropdown-toggle" data-toggle="dropdown" href="#"><span>打开方式</span> <b class="caret"></b></a>';
				info+='		<ul class="dropdown-menu">';
				for(var i=0;i<subdata.length;i++){
				info+='			<li><a onClick="_ico.Open(\''+icoid+'\',\''+subdata[i].extid+'\')" href="#">'+subdata[i].name+'</a></li>';
				}
				info+='		</ul>';
				info+='</li>';
			}
			
		//判断下载
		if(_config.Permission('download',data)){
			info+='<li ><a href="javascript:;" onClick="_ico.downAttach(\''+icoid+'\')">下载</a></li>';
		}
		//判断删除
		if(_config.Permission('delete',data)){
			info+='<li ><a href="javascript:;" onClick="_ajax.delIco(\''+icoid+'\')">删除</a></li>';
		}
		info+='<li ><a href="javascript:;" onClick="_ico.property(\''+icoid+'\')">信息</a></li>';
		//设为壁纸
		if(data.type=='image' && data.isdelete<1){
			info+='<li class="dropdown">';
			info+='		<a class="dropdown-toggle" data-toggle="dropdown" href="#"><span>设为壁纸</span> <b class="caret"></b></a>';
			info+='		<ul class="dropdown-menu">';
			//拉伸
				info+='			<li><a onClick="_config.setback(\''+data.url+'\',1,\'\',\'backimg\')" href="#">拉伸</a></li>';
			//平铺
				info+='			<li><a onClick="_config.setback(\''+data.url+'\',2,\'\',\'backimg\')" href="#">平铺</a></li>';
			//居中
				info+='			<li><a onClick="_config.setback(\''+data.url+'\',3,\'\',\'backimg\')" href="#">居中</a></li>';
			info+='		</ul>';
			info+='</li>';
		}
		//更多下拉
		info+='<li class="dropdown">';
		info+='		<a class="dropdown-toggle" data-toggle="dropdown" href="#"><span>更多</span> <b class="caret"></b></a>';
		info+='		<ul class="dropdown-menu">';
		//剪切
		if(_config.Permission('delete',data)){
			info+='			<li><a onClick="_select.Cut(\''+icoid+'\')" href="#">剪切</a></li>';
		}
		//复制
			info+='			<li><a onClick="_select.Copy(\''+icoid+'\')" href="#">复制</a></li>';
		//重命名
		if(_config.Permission('rename',data)){
			info+='			<li><a onClick="_ico.Rename(\''+icoid+'\',\''+this.id+'\')" href="#">重命名</a></li>';
		}
		info+='		</ul>';
		info+='</li>';
		
		
		info+='		</ul>';
	}else{
		var size=0;
		for(var i =0 ;i<_config.selectall.icos.length;i++){
			size+=this.data[_config.selectall.icos[i]].size*1;
		}
		var icoid=_config.selectall.icos[0];
		var data=this.data[icoid];
		var info='';
		info+='<ul class="nav nav-pills clearfix">';
		info+='		<li style="line-height:34px">'+_lang.bottom_selectallinfo.replace('{n}',sum).replace('{size}',formatSize(size)).replace('{total}',this.total)+'</li>';
		if(_config.Permission('delete',data)){
			info+='	<li class="pull-right"><a href="javascript:;" onClick="_ajax.delIco(\''+icoid+'\')">删除</a></li>';
			info+='	<li class="pull-right"><a onClick="_select.Cut(\''+icoid+'\')" href="#">剪切</a></li>';
			
		}
		//复制
			info+=' <li class="pull-right"><a onClick="_select.Copy(\''+icoid+'\')" href="#">复制</a></li>';
		info+='</ul>';
	}
	
	jQuery('#bottom_content_'+this.winid+'_'+this.id).html(info);
	jQuery('#bottom_content_'+this.winid+'_'+this.id).show();
	
	/*var self=this;
	this.bottomShowTimer=window.setTimeout(function(){
		jQuery('#bottom_content_'+self.winid+'_'+self.id).hide();
	},3000);*/
};
_filemanage.prototype.PageInfo=function(){
	var Sum=0;
	var Size=0;
	for(var i in this.data){
		Sum++;
		Size+=(this.data[i].size)*1;
	}
	var leftinfo=_lang.bottom_leftinfo.replace('{n}',Sum).replace('{size}',formatSize(Size)).replace('{total}',this.total);
	jQuery('#bottom_content_'+this.winid+'_'+this.id).html(leftinfo);
	//jQuery('#'+this.winid+' .BOTTOM .info_right').html();
	jQuery('#bottom_content_'+this.winid+'_'+this.id).show();
	if(this.bottomShowTimer) window.clearTimeout(this.bottomShowTimer);
	var self=this;
	this.bottomShowTimer=window.setTimeout(function(){
		jQuery('#bottom_content_'+self.winid+'_'+self.id).hide();
	},1000);
}
_filemanage.getData=function(url,callback){
	jQuery.getJSON(url,function(json){
		if(json.error){
			alert(json.error);
		}else{
			
			for(var id in json.data){
				_config.sourcedata.icos[id]=json.data[id];
				_config.sourceids.icos.push(id);
			}
			for(var fid in json.folderdata){
				_config.sourcedata.folder[fid]=json.folderdata[fid];
			}
			
			if(json.param.page>1){
				var obj=_filemanage.cons[json.sid];
				obj.appendIcos(json.data);
				obj.total=parseInt(json.total);
				obj.totalpage=Math.ceil(obj.total/obj.perpage);
			}else{
				var obj=new _filemanage(json.sid,json.data,json.param);
				obj.showIcos();
			}
			if(typeof(callback)=='function') callback();
			
		}
	});
	
}
_filemanage.prototype.pageClick=function(page){
	var self=this;
	this.pageloadding=true;
	if(!page){ page=1;}
	this.currentpage=page;
	var keyword=document.getElementById('searchInput_'+this.winid).value;
	if(keyword==_lang.fsearch) keyword='' ;
	
	_filemanage.getData(_config.systemurl+'&op=explorer&do=filemanage&bz='+this.bz+'&path='+encodeURIComponent(_config.sourcedata.folder[this.fid].path)+'&id='+this.id+'&winid='+this.winid+'&disp='+this.disp+'&asc='+this.asc+'&perpage='+this.perpage+'&iconview='+this.view+'&keyword='+encodeURI(keyword)+'&page='+page+'&marker='+_config.sourcedata.folder[this.fid].nextMarker+'&t='+new Date().getTime(),function(){self.PageInfo()});
};

_filemanage.stack_run=function(winid){
	//if(_filemanage.showicosTimer[winid]) window.clearTimeout(_filemanage.showicosTimer[winid]);
	if(_filemanage.stack_data[winid].length>0 ){
		var obj=_filemanage.stack_data[winid][0].obj;
		for(var i=0;i<_filemanage.speed;i++){
			if(_filemanage.stack_data[winid].length>0){
				_filemanage.stack_data[winid][0].obj.CreateIcos(_filemanage.stack_data[winid][0]['data'],1);
				_filemanage.stack_data[winid].splice(0,1);
			}else break;
		}
		_filemanage.showicosTimer[winid]=window.setTimeout(function(){_filemanage.stack_run(winid)},1);
	}
};
_filemanage.prototype.tddrager_start=function(e)
{
	this.XX=e.clientX;
	document.getElementById('_blank').style.cursor='e-resize';
	jQuery('#_blank').show();
	var self=this;
	this.AttachEvent(e);
	//document.onmousemove=function(e){self.tddraging(e?e:window.event);return false;};
	//document.onmouseup=function(e){self.tddraged(e?e:window.event);return false;};
	eval("document.onmousemove=function(e){"+this.string+".tddraging(e?e:window.event);};");
	eval("document.onmouseup=function(e){"+this.string+".tddraged(e?e:window.event);};");
};
_filemanage.prototype.tddraging=function(e)
{
	document.body.style.cursor='e-resize';
		
};
_filemanage.prototype.tddraged=function(e)
{
	this.DetachEvent(e);
	jQuery('#_blank').hide();
	document.getElementById('_blank').style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	document.body.style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	var xx=e.clientX-this.XX;
	//计算新的各个td的百分比
	var right_width=_window.windows[this.winid].bodyWidth-jQuery('#jstree_area').width();
	current_width=right_width*this.detailper[this.tddrager_disp]/100;
	var width=xx+current_width;
	//if(width>right_width-150) width=right_width-200;
	if(width<50) width=50;
	var all_width=new Array();
	for(var i=0;i<4;i++){
		all_width[i]=right_width*this.detailper[i]/100;
	}
	var dx=width-current_width;
	if(xx>0){
		if(all_width[this.tddrager_disp+1]-dx>50) all_width[this.tddrager_disp+1]-=dx;
		else{
			var dx1=dx+(all_width[this.tddrager_disp+1]-50)
			all_width[this.tddrager_disp+1]=50;
			if((this.tddrager_disp+1+1)<4){
				if(all_width[this.tddrager_disp+1+1]-dx1>50) all_width[this.tddrager_disp+1+1]-=dx;
				else{
					var dx2=dx1+(all_width[this.tddrager_disp+1+1]-50)
					all_width[this.tddrager_disp+1+1]=50;
					if((this.tddrager_disp+1+1+1)<4){
						if(all_width[this.tddrager_disp+1+1+1]-dx2>50) all_width[this.tddrager_disp+1+1+1]-=dx;
						else{
							all_width[this.tddrager_disp+1+1+1]=50;
						}
					}
				}
			}
			
		}
		var other_width=0;
		for(var i=0;i<4;i++){
			if(i!=this.tddrager_disp) other_width+=all_width[i];
		}
		all_width[this.tddrager_disp]=right_width-other_width;
	}else{
		all_width[this.tddrager_disp]=width;
		all_width[this.tddrager_disp+1]-=dx;
	}
	var other_width=0;
		for(var i=0;i<4;i++){
			if(i!=this.tddrager_disp) other_width+=all_width[i];
		}
		all_width[this.tddrager_disp]=right_width-other_width;
	for(var i=0;i<4;i++){
		this.detailper[i]=Math.floor((all_width[i]/right_width)*100);
	}
	this.showIcos(this.winid);
	//alert(document.getElementById('tabs_cover').offsetLeft+'========='+document.getElementById('tabs_cover').offsetWidth);
};
_filemanage.prototype.DetachEvent=function(e)
{
	
	document.body.style.cursor="url('dzz/images/cur/aero_arrow.cur'),auto";
	document.onmousemove=_filemanage.onmousemove;
	document.onmouseup=_filemanage.onmouseup;
	document.onselectstart=_filemanage.onselectstart;
	

	
};
_filemanage.prototype.AttachEvent=function(e)
{ 
	_filemanage.onmousemove=document.onmousemove;
	_filemanage.onmouseup=document.onmouseup;
	_filemanage.onselectstart=document.onselectstart;
	try{
		document.onselectstart=function(){return false;}
		if(e.preventDefault) e.preventDefault();
		else{
			if(this.board.setCapture) this.board.setCapture();
		}
	}catch(e){};
};
_filemanage.prototype.Resize=function(){
	var win=_window.windows[this.winid];
	jQuery('#icosContainer_content_'+this.winid+'_'+this.id).css('height',win.bodyHeight-jQuery('#header_content_'+this.winid+'_'+this.id).outerHeight(true));
	jQuery('#detail_content_'+this.winid+'_'+this.id).css('height',jQuery('#icosContainer_content_'+this.winid+'_'+this.id).height()-jQuery(win.contentCase).find('.filemanage-detail-header').height());
		
}
