DROP TABLE IF EXISTS dzz_user;
CREATE TABLE dzz_user (
  uid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  email char(40) NOT NULL DEFAULT '',
  username varchar(255) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  emailstatus tinyint(1) NOT NULL DEFAULT '0',
  avatarstatus tinyint(1) NOT NULL DEFAULT '0',
  adminid tinyint(1) NOT NULL DEFAULT '0',
  groupid smallint(6) unsigned NOT NULL DEFAULT '9',
  regdate int(10) unsigned NOT NULL DEFAULT '0',
  secques char(8) NOT NULL DEFAULT '',
  salt char(6) NOT NULL DEFAULT '',
  authstr varchar(255) NOT NULL,
  PRIMARY KEY (uid),
  UNIQUE KEY email (email),
  KEY groupid (groupid),
  KEY username (username)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_admincp_session;
CREATE TABLE dzz_admincp_session (
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  adminid smallint(6) unsigned NOT NULL DEFAULT '0',
  panel tinyint(1) NOT NULL DEFAULT '0',
  ip varchar(15) NOT NULL DEFAULT '',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  errorcount tinyint(1) NOT NULL DEFAULT '0',
  `storage` mediumtext NOT NULL,
  PRIMARY KEY (uid,panel)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_api_cache;
CREATE TABLE dzz_api_cache (
  cachekey char(32) NOT NULL COMMENT 'path的md5值',
  cachevalue mediumtext NOT NULL COMMENT '结果的serialize',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  `hash` varchar(255) NOT NULL,
  UNIQUE KEY cachekey (cachekey)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_app_market;
CREATE TABLE dzz_app_market (
  appid int(10) unsigned NOT NULL AUTO_INCREMENT,
  appname varchar(255) NOT NULL,
  appico varchar(255) NOT NULL,
  appdesc text NOT NULL,
  appurl varchar(255) NOT NULL,
  dateline int(10) unsigned NOT NULL,
  disp int(10) unsigned NOT NULL DEFAULT '0',
  vendor varchar(255) NOT NULL COMMENT '提供商',
  haveflash tinyint(1) unsigned NOT NULL,
  isshow tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示应用图标',
  havetask tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示任务栏',
  hideInMarket tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '应用市场里不显示',
  feature text NOT NULL COMMENT '窗体feature',
  fileext text NOT NULL COMMENT '可以打开的文件类型',
  `group` tinyint(1) NOT NULL DEFAULT '1' COMMENT '应用的分组:0:全部；''-1'':游客可用，''3'':系统管理员可用;''2''：部门管理员可用;''1'':所有成员可用',
  orgid int(10) unsigned NOT NULL DEFAULT '0' COMMENT '可以使用的部门id，为0表示不限制',
  position tinyint(1) NOT NULL DEFAULT '0' COMMENT '2：''desktop'',3：''taskbar'',1：''apparea''',
  system tinyint(1) NOT NULL DEFAULT '0',
  notdelete tinyint(1) NOT NULL DEFAULT '0',
  `open` tinyint(1) NOT NULL DEFAULT '0',
  nodup tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (appid),
  KEY appurl (appurl)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_app_open;
CREATE TABLE dzz_app_open (
  ext varchar(255) NOT NULL DEFAULT '',
  appid int(10) NOT NULL DEFAULT '0',
  isdefault tinyint(1) NOT NULL DEFAULT '0',
  disp smallint(6) NOT NULL DEFAULT '0',
  icon varchar(255) NOT NULL DEFAULT '',
  url varchar(255) NOT NULL DEFAULT '',
  system tinyint(1) NOT NULL DEFAULT '0',
  extid smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  feature varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (extid),
  KEY appid (appid),
  KEY ext (ext,disp,isdefault)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_app_open_default;
CREATE TABLE dzz_app_open_default (
  uid int(10) unsigned NOT NULL,
  ext varchar(255) NOT NULL DEFAULT '',
  extid smallint(6) NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY defaultext (ext,uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_app_organization;
CREATE TABLE dzz_app_organization (
  appid int(10) NOT NULL DEFAULT '0',
  orgid smallint(6) NOT NULL DEFAULT '0',
  dateline int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY orgid (appid,orgid),
  KEY appid (appid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_app_pic;
CREATE TABLE dzz_app_pic (
  picid mediumint(8) NOT NULL AUTO_INCREMENT,
  appid int(10) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(15) NOT NULL DEFAULT '',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  aid int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (picid),
  KEY uid (uid),
  KEY idtype (appid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_app_relative;
CREATE TABLE dzz_app_relative (
  rid int(11) NOT NULL AUTO_INCREMENT,
  appid int(10) NOT NULL DEFAULT '0',
  tagid int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (rid),
  UNIQUE KEY appid (appid,tagid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_app_tag;
CREATE TABLE dzz_app_tag (
  tagid int(10) NOT NULL AUTO_INCREMENT,
  hot int(10) unsigned NOT NULL DEFAULT '0',
  tagname varchar(255) NOT NULL DEFAULT '0',
  dateline int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (tagid),
  KEY appid (hot),
  KEY classid (tagname)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_attachment;
CREATE TABLE dzz_attachment (
  aid int(10) unsigned NOT NULL AUTO_INCREMENT,
  filename char(100) NOT NULL DEFAULT '',
  filetype char(50) NOT NULL DEFAULT '',
  filesize int(10) unsigned NOT NULL DEFAULT '0',
  attachment char(100) NOT NULL DEFAULT '',
  remote tinyint(1) unsigned NOT NULL DEFAULT '0',
  copys smallint(6) NOT NULL DEFAULT '0',
  md5 varchar(255) NOT NULL,
  thumb tinyint(1) unsigned NOT NULL DEFAULT '0',
  pdf tinyint(1) NOT NULL DEFAULT '0',
  needpdf tinyint(1) NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (aid),
  KEY md5 (md5)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_cache;
CREATE TABLE dzz_cache (
  cachekey varchar(255) NOT NULL DEFAULT '',
  cachevalue mediumblob NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (cachekey)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_cai_image;
CREATE TABLE dzz_cai_image (
  cid mediumint(8) NOT NULL AUTO_INCREMENT,
  aid int(10) unsigned NOT NULL DEFAULT '0',
  copys int(10) unsigned NOT NULL DEFAULT '0',
  ourl varchar(255) NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (cid),
  UNIQUE KEY ourl (ourl)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_cai_link;
CREATE TABLE dzz_cai_link (
  cid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  img varchar(255) NOT NULL DEFAULT '',
  url varchar(255) NOT NULL DEFAULT '',
  title varchar(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  copys int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (cid),
  UNIQUE KEY url (url)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_cai_music;
CREATE TABLE dzz_cai_music (
  cid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  img varchar(255) NOT NULL DEFAULT '',
  url varchar(255) NOT NULL DEFAULT '',
  title varchar(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  ourl varchar(255) NOT NULL,
  copys int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (cid),
  UNIQUE KEY ourl (ourl)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_cai_video;
CREATE TABLE dzz_cai_video (
  cid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  img varchar(255) NOT NULL DEFAULT '',
  url varchar(255) NOT NULL DEFAULT '',
  title varchar(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  ourl varchar(255) NOT NULL,
  copys int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (cid),
  UNIQUE KEY ourl (ourl)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_connect;
CREATE TABLE dzz_connect (
  `name` varchar(255) NOT NULL,
  id varchar(255) NOT NULL DEFAULT '',
  secret varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL COMMENT 'pan,mail,storage,web',
  bz varchar(255) NOT NULL COMMENT 'Dropbox,Box,Google,Aliyun,Grandcloud',
  root varchar(255) NOT NULL DEFAULT '',
  available tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否可用',
  dname varchar(255) NOT NULL COMMENT '数据库名称',
  curl varchar(255) NOT NULL COMMENT '授权地址',
  disp smallint(6) NOT NULL DEFAULT '0',
  UNIQUE KEY bz (bz),
  KEY disp (disp)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_connect_pan;
CREATE TABLE dzz_connect_pan (
  id int(10) NOT NULL AUTO_INCREMENT,
  bz varchar(255) NOT NULL,
  cloudname varchar(255) NOT NULL DEFAULT '',
  cuid int(10) unsigned NOT NULL DEFAULT '0',
  cusername varchar(255) NOT NULL,
  portrait varchar(255) NOT NULL DEFAULT '',
  uid int(10) unsigned NOT NULL,
  expires_in int(10) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  refreshtime int(10) unsigned NOT NULL DEFAULT '0',
  perm smallint(6) unsigned NOT NULL DEFAULT '29751',
  refresh_token varchar(255) NOT NULL,
  access_token varchar(255) NOT NULL,
  scope varchar(255) NOT NULL,
  session_key varchar(255) NOT NULL,
  session_secret varchar(255) NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY cuid (cuid,uid,bz)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_connect_storage;
CREATE TABLE dzz_connect_storage (
  id int(10) NOT NULL AUTO_INCREMENT,
  uid int(10) unsigned NOT NULL,
  cloudname varchar(255) NOT NULL DEFAULT '',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  perm smallint(6) unsigned NOT NULL DEFAULT '29751',
  access_id varchar(255) NOT NULL,
  access_key varchar(255) NOT NULL,
  bucket varchar(255) NOT NULL DEFAULT '',
  bz varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (id),
  UNIQUE KEY access_id (access_id,uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_count;
CREATE TABLE dzz_count (
  jid int(10) NOT NULL AUTO_INCREMENT,
  id mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` enum('document','image','video','music','link','attach','topic','app','folder') NOT NULL,
  viewnum int(10) unsigned NOT NULL DEFAULT '0',
  replynum int(10) unsigned NOT NULL DEFAULT '0',
  downnum int(10) unsigned NOT NULL DEFAULT '0',
  updatetime int(10) unsigned NOT NULL DEFAULT '0',
  star float(2,1) NOT NULL DEFAULT '0.0',
  statnum int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (jid),
  KEY id (id,`type`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_cron;
CREATE TABLE dzz_cron (
  cronid smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  available tinyint(1) NOT NULL DEFAULT '0',
  `type` enum('user','system','plugin') NOT NULL DEFAULT 'user',
  `name` char(50) NOT NULL DEFAULT '',
  filename char(50) NOT NULL DEFAULT '',
  lastrun int(10) unsigned NOT NULL DEFAULT '0',
  nextrun int(10) unsigned NOT NULL DEFAULT '0',
  weekday tinyint(1) NOT NULL DEFAULT '0',
  `day` tinyint(2) NOT NULL DEFAULT '0',
  `hour` tinyint(2) NOT NULL DEFAULT '0',
  `minute` char(36) NOT NULL DEFAULT '',
  PRIMARY KEY (cronid),
  KEY nextrun (available,nextrun)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_district;
CREATE TABLE dzz_district (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `level` tinyint(4) unsigned NOT NULL DEFAULT '0',
  usetype tinyint(1) unsigned NOT NULL DEFAULT '0',
  upid mediumint(8) unsigned NOT NULL DEFAULT '0',
  displayorder smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY upid (upid,displayorder)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_failedlogin;
CREATE TABLE dzz_failedlogin (
  ip char(15) NOT NULL DEFAULT '',
  username char(32) NOT NULL DEFAULT '',
  count tinyint(1) unsigned NOT NULL DEFAULT '0',
  lastupdate int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (ip,username)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_folder;
CREATE TABLE dzz_folder (
  fid int(10) NOT NULL AUTO_INCREMENT,
  pfid int(10) NOT NULL DEFAULT '0',
  uid int(10) unsigned NOT NULL DEFAULT '0',
  username varchar(255) NOT NULL DEFAULT '',
  ficon varchar(255) NOT NULL DEFAULT '',
  innav tinyint(1) NOT NULL DEFAULT '1',
  fname varchar(255) NOT NULL DEFAULT '',
  bz varchar(255) NOT NULL DEFAULT '',
  perm smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '0:继承；1：只读；2：可写',
  fsperm smallint(6) NOT NULL DEFAULT '0',
  disp smallint(6) NOT NULL DEFAULT '0',
  iconview tinyint(1) NOT NULL DEFAULT '1',
  display smallint(6) NOT NULL DEFAULT '0',
  dateline int(10) NOT NULL DEFAULT '0',
  gid int(10) NOT NULL DEFAULT '0',
  flag varchar(255) NOT NULL DEFAULT 'folder',
  `default` varchar(255) NOT NULL DEFAULT '',
  isdelete tinyint(1) NOT NULL DEFAULT '0',
  deldateline int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (fid),
  KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_folder_default;
CREATE TABLE dzz_folder_default (
  fid int(10) NOT NULL AUTO_INCREMENT,
  innav tinyint(1) NOT NULL DEFAULT '1',
  fname varchar(255) NOT NULL DEFAULT '',
  perm smallint(6) unsigned NOT NULL DEFAULT '0',
  disp smallint(6) NOT NULL DEFAULT '0',
  iconview tinyint(1) NOT NULL DEFAULT '0',
  display smallint(6) NOT NULL DEFAULT '10',
  flag varchar(255) NOT NULL DEFAULT 'folder',
  `default` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (fid),
  UNIQUE KEY `type` (flag)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_icon;
CREATE TABLE dzz_icon (
  did int(10) unsigned NOT NULL AUTO_INCREMENT,
  domain varchar(255) NOT NULL,
  pic varchar(255) NOT NULL,
  dateline int(10) NOT NULL DEFAULT '0',
  `check` tinyint(1) unsigned NOT NULL DEFAULT '1',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(255) NOT NULL,
  copys int(10) NOT NULL DEFAULT '0',
  disp smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (did),
  KEY domain (domain),
  KEY `check` (`check`),
  KEY uid (uid),
  KEY copys (copys),
  KEY disp (disp)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_icon_sys;
CREATE TABLE dzz_icon_sys (
  id smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  title varchar(255) NOT NULL,
  icon varchar(255) NOT NULL,
  `type` enum('folder','url','group') NOT NULL,
  copys int(10) unsigned NOT NULL,
  disp int(10) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  `default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY disp (disp),
  KEY `default` (`default`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_icon_user;
CREATE TABLE dzz_icon_user (
  did int(10) unsigned NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  domain varchar(255) NOT NULL,
  pic varchar(255) NOT NULL,
  dateline int(10) NOT NULL DEFAULT '0',
  pdid int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (did),
  UNIQUE KEY domain (domain,uid),
  KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_iconview;
CREATE TABLE dzz_iconview (
  id smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  width smallint(6) unsigned NOT NULL DEFAULT '64',
  height smallint(6) unsigned NOT NULL DEFAULT '64',
  divwidth smallint(6) unsigned NOT NULL DEFAULT '100',
  divheight smallint(6) unsigned NOT NULL DEFAULT '100',
  paddingtop smallint(6) unsigned NOT NULL DEFAULT '0',
  paddingleft smallint(6) unsigned NOT NULL DEFAULT '0',
  textlength smallint(6) unsigned NOT NULL DEFAULT '30',
  align tinyint(1) unsigned NOT NULL DEFAULT '0',
  avaliable tinyint(1) unsigned NOT NULL DEFAULT '1',
  disp smallint(6) unsigned NOT NULL DEFAULT '0',
  cssname varchar(60) NOT NULL,
  PRIMARY KEY (id),
  KEY avaliable (avaliable,disp)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_icos;
CREATE TABLE dzz_icos (
  icoid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  uid int(10) NOT NULL DEFAULT '0',
  username char(15) NOT NULL DEFAULT '',
  oid mediumint(8) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  img varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  pfid int(10) NOT NULL DEFAULT '0',
  opuid mediumint(8) unsigned NOT NULL DEFAULT '0',
  urlsid int(10) unsigned NOT NULL DEFAULT '0',
  isdelete tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '删除标志',
  deldateline int(10) NOT NULL DEFAULT '0',
  gid int(10) NOT NULL DEFAULT '0',
  position varchar(255) NOT NULL DEFAULT '',
  flag varchar(255) NOT NULL DEFAULT '',
  sperm int(10) NOT NULL DEFAULT '0',
  size int(10) NOT NULL DEFAULT '0',
  ext varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (icoid),
  UNIQUE KEY sourceunique (uid,`type`,oid),
  KEY dateline (dateline),
  KEY `type` (`type`),
  KEY uid (uid),
  KEY `name` (`name`),
  KEY pfid (pfid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_mailcron;
CREATE TABLE dzz_mailcron (
  cid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  touid mediumint(8) unsigned NOT NULL DEFAULT '0',
  email varchar(100) NOT NULL DEFAULT '',
  sendtime int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (cid),
  KEY sendtime (sendtime)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_mailqueue;
CREATE TABLE dzz_mailqueue (
  qid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  cid mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subject` text NOT NULL,
  message text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (qid),
  KEY mcid (cid,dateline)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_music_playlist;
CREATE TABLE dzz_music_playlist (
  playlist text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  updatetime int(10) unsigned NOT NULL DEFAULT '0',
  idtype enum('wid','icoid') NOT NULL,
  typeid int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY uid (idtype,typeid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_onlinetime;
CREATE TABLE dzz_onlinetime (
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  thismonth smallint(6) unsigned NOT NULL DEFAULT '0',
  total mediumint(8) unsigned NOT NULL DEFAULT '0',
  lastupdate int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_organization;
CREATE TABLE dzz_organization (
  orgid smallint(6) NOT NULL AUTO_INCREMENT,
  orgname varchar(255) NOT NULL DEFAULT '',
  forgid smallint(6) NOT NULL DEFAULT '0',
  fid int(10) NOT NULL DEFAULT '0',
  disp smallint(6) NOT NULL DEFAULT '0',
  dateline int(10) NOT NULL DEFAULT '0',
  usesize bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (orgid),
  KEY disp (disp),
  KEY dateline (dateline)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_organization_user;
CREATE TABLE dzz_organization_user (
  orgid smallint(6) NOT NULL DEFAULT '0',
  uid mediumint(8) NOT NULL DEFAULT '0',
  ismoderator tinyint(1) NOT NULL DEFAULT '0',
  dateline int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY orgid (orgid,uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_process;
CREATE TABLE dzz_process (
  processid char(32) NOT NULL,
  expiry int(10) DEFAULT NULL,
  extra int(10) DEFAULT NULL,
  PRIMARY KEY (processid),
  KEY expiry (expiry)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS dzz_session;
CREATE TABLE dzz_session (
  sid char(6) NOT NULL DEFAULT '',
  ip1 tinyint(3) unsigned NOT NULL DEFAULT '0',
  ip2 tinyint(3) unsigned NOT NULL DEFAULT '0',
  ip3 tinyint(3) unsigned NOT NULL DEFAULT '0',
  ip4 tinyint(3) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username char(15) NOT NULL DEFAULT '',
  groupid smallint(6) unsigned NOT NULL DEFAULT '0',
  invisible tinyint(1) NOT NULL DEFAULT '0',
  `action` tinyint(1) unsigned NOT NULL DEFAULT '0',
  lastactivity int(10) unsigned NOT NULL DEFAULT '0',
  lastolupdate int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY sid (sid),
  KEY uid (uid)
) ENGINE=MEMORY;

DROP TABLE IF EXISTS dzz_setting;
CREATE TABLE dzz_setting (
  skey varchar(255) NOT NULL DEFAULT '',
  svalue text NOT NULL,
  PRIMARY KEY (skey)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_source_attach;
CREATE TABLE dzz_source_attach (
  qid int(10) unsigned NOT NULL AUTO_INCREMENT,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(255) NOT NULL,
  aid int(10) unsigned NOT NULL DEFAULT '0',
  title varchar(255) NOT NULL,
  `desc` text NOT NULL,
  gid int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (qid),
  KEY uid (uid),
  KEY dateline (dateline)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_source_document;
CREATE TABLE dzz_source_document (
  did int(10) unsigned NOT NULL AUTO_INCREMENT,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(255) NOT NULL,
  aid int(10) unsigned NOT NULL DEFAULT '0',
  title varchar(255) NOT NULL,
  `desc` text NOT NULL,
  gid int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (did),
  KEY uid (uid),
  KEY dateline (dateline)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_source_image;
CREATE TABLE dzz_source_image (
  picid mediumint(8) NOT NULL AUTO_INCREMENT,
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(15) NOT NULL DEFAULT '',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  aid int(10) unsigned NOT NULL DEFAULT '0',
  postip varchar(255) NOT NULL DEFAULT '',
  cid int(10) unsigned NOT NULL DEFAULT '0',
  width int(10) unsigned NOT NULL DEFAULT '0',
  height int(10) unsigned NOT NULL DEFAULT '0',
  gid int(10) NOT NULL DEFAULT '0',
  title varchar(255) NOT NULL,
  `desc` text NOT NULL,
  PRIMARY KEY (picid),
  KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_source_link;
CREATE TABLE dzz_source_link (
  lid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  url varchar(255) NOT NULL DEFAULT '',
  title varchar(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(60) NOT NULL,
  cid int(10) unsigned NOT NULL DEFAULT '0',
  gid int(10) NOT NULL DEFAULT '0',
  did int(10) unsigned NOT NULL DEFAULT '0',
  icon varchar(255) NOT NULL,
  PRIMARY KEY (lid),
  KEY dateline (dateline),
  KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_source_music;
CREATE TABLE dzz_source_music (
  mid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  icon varchar(255) NOT NULL,
  url varchar(255) NOT NULL DEFAULT '',
  title varchar(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(60) NOT NULL,
  cid int(10) unsigned NOT NULL DEFAULT '0',
  gid int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (mid),
  KEY dateline (dateline),
  KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_source_video;
CREATE TABLE dzz_source_video (
  vid mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  icon varchar(255) NOT NULL,
  url varchar(255) NOT NULL DEFAULT '',
  title varchar(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  username varchar(60) NOT NULL,
  cid int(10) unsigned NOT NULL DEFAULT '0',
  gid int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (vid),
  KEY dateline (dateline),
  KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_stat;
CREATE TABLE dzz_stat (
  daytime int(10) unsigned NOT NULL DEFAULT '0',
  login int(10) unsigned NOT NULL DEFAULT '0',
  mobilelogin int(10) unsigned NOT NULL DEFAULT '0',
  connectlogin int(10) unsigned NOT NULL DEFAULT '0',
  register int(10) unsigned NOT NULL DEFAULT '0',
  invite int(10) unsigned NOT NULL DEFAULT '0',
  activity int(10) unsigned NOT NULL DEFAULT '0',
  debate int(10) unsigned NOT NULL DEFAULT '0',
  wall int(10) unsigned NOT NULL DEFAULT '0',
  poke int(10) unsigned NOT NULL DEFAULT '0',
  sendpm int(10) unsigned NOT NULL DEFAULT '0',
  friend int(10) unsigned NOT NULL DEFAULT '0',
  addfriend int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (daytime)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_statuser;
CREATE TABLE dzz_statuser (
  uid mediumint(8) unsigned NOT NULL DEFAULT '0',
  daytime int(10) unsigned NOT NULL DEFAULT '0',
  `type` char(20) NOT NULL DEFAULT '',
  KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_syscache;
CREATE TABLE dzz_syscache (
  cname varchar(32) NOT NULL,
  ctype tinyint(3) unsigned NOT NULL,
  dateline int(10) unsigned NOT NULL,
  `data` mediumblob NOT NULL,
  PRIMARY KEY (cname)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_thame;
CREATE TABLE dzz_thame (
  id smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  folder varchar(255) NOT NULL DEFAULT 'window_jd',
  backimg varchar(255) NOT NULL,
  thumb varchar(255) NOT NULL,
  btype tinyint(1) NOT NULL DEFAULT '1',
  url varchar(255) NOT NULL,
  `default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  disp smallint(6) unsigned NOT NULL DEFAULT '0',
  modules text NOT NULL,
  color varchar(255) NOT NULL DEFAULT '',
  enable_color tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  KEY disp (disp)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_user_field;
CREATE TABLE dzz_user_field (
  uid mediumint(8) unsigned NOT NULL,
  docklist text NOT NULL,
  screenlist text NOT NULL,
  applist text NOT NULL,
  iconview tinyint(1) NOT NULL DEFAULT '1',
  iconposition tinyint(1) NOT NULL DEFAULT '0',
  direction tinyint(1) NOT NULL DEFAULT '0',
  autolist tinyint(1) NOT NULL DEFAULT '1',
  taskbar enum('bottom','left','top','right') NOT NULL DEFAULT 'bottom',
  dateline int(10) unsigned NOT NULL,
  updatetime int(10) unsigned NOT NULL,
  attachextensions varchar(255) NOT NULL DEFAULT '-1',
  maxattachsize int(10) NOT NULL DEFAULT '-1',
  usesize bigint(20) unsigned NOT NULL DEFAULT '0',
  addsize bigint(20) unsigned NOT NULL DEFAULT '0',
  buysize bigint(20) unsigned NOT NULL DEFAULT '0',
  wins text NOT NULL,
  perm int(10) NOT NULL DEFAULT '3',
  UNIQUE KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_user_playlist;
CREATE TABLE dzz_user_playlist (
  playlist text NOT NULL,
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  updatetime int(10) unsigned NOT NULL DEFAULT '0',
  uid mediumint(8) NOT NULL DEFAULT '0',
  UNIQUE KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_user_profile;
CREATE TABLE dzz_user_profile (
  uid mediumint(8) unsigned NOT NULL,
  realname varchar(255) NOT NULL DEFAULT '',
  gender tinyint(1) NOT NULL DEFAULT '0',
  birthyear smallint(6) unsigned NOT NULL DEFAULT '0',
  birthmonth tinyint(3) unsigned NOT NULL DEFAULT '0',
  birthday tinyint(3) unsigned NOT NULL DEFAULT '0',
  constellation varchar(255) NOT NULL DEFAULT '',
  zodiac varchar(255) NOT NULL DEFAULT '',
  telephone varchar(255) NOT NULL DEFAULT '',
  mobile varchar(255) NOT NULL DEFAULT '',
  idcardtype varchar(255) NOT NULL DEFAULT '',
  idcard varchar(255) NOT NULL DEFAULT '',
  address varchar(255) NOT NULL DEFAULT '',
  zipcode varchar(255) NOT NULL DEFAULT '',
  nationality varchar(255) NOT NULL DEFAULT '',
  birthprovince varchar(255) NOT NULL DEFAULT '',
  birthcity varchar(255) NOT NULL DEFAULT '',
  birthdist varchar(20) NOT NULL DEFAULT '',
  birthcommunity varchar(255) NOT NULL DEFAULT '',
  resideprovince varchar(255) NOT NULL DEFAULT '',
  residecity varchar(255) NOT NULL DEFAULT '',
  residedist varchar(20) NOT NULL DEFAULT '',
  residecommunity varchar(255) NOT NULL DEFAULT '',
  residesuite varchar(255) NOT NULL DEFAULT '',
  graduateschool varchar(255) NOT NULL DEFAULT '',
  company varchar(255) NOT NULL DEFAULT '',
  education varchar(255) NOT NULL DEFAULT '',
  occupation varchar(255) NOT NULL DEFAULT '',
  position varchar(255) NOT NULL DEFAULT '',
  revenue varchar(255) NOT NULL DEFAULT '',
  affectivestatus varchar(255) NOT NULL DEFAULT '',
  lookingfor varchar(255) NOT NULL DEFAULT '',
  bloodtype varchar(255) NOT NULL DEFAULT '',
  height varchar(255) NOT NULL DEFAULT '',
  weight varchar(255) NOT NULL DEFAULT '',
  alipay varchar(255) NOT NULL DEFAULT '',
  icq varchar(255) NOT NULL DEFAULT '',
  qq varchar(255) NOT NULL DEFAULT '',
  yahoo varchar(255) NOT NULL DEFAULT '',
  skype varchar(255) NOT NULL DEFAULT '',
  taobao varchar(255) NOT NULL DEFAULT '',
  site varchar(255) NOT NULL DEFAULT '',
  bio text NOT NULL,
  interest text NOT NULL,
  field1 text NOT NULL,
  field2 text NOT NULL,
  field3 text NOT NULL,
  field4 text NOT NULL,
  field5 text NOT NULL,
  field6 text NOT NULL,
  field7 text NOT NULL,
  field8 text NOT NULL,
  UNIQUE KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_user_profile_setting;
CREATE TABLE dzz_user_profile_setting (
  fieldid varchar(255) NOT NULL DEFAULT '',
  available tinyint(1) NOT NULL DEFAULT '0',
  invisible tinyint(1) NOT NULL DEFAULT '0',
  needverify tinyint(1) NOT NULL DEFAULT '0',
  title varchar(255) NOT NULL DEFAULT '',
  description varchar(255) NOT NULL DEFAULT '',
  displayorder smallint(6) unsigned NOT NULL DEFAULT '0',
  required tinyint(1) NOT NULL DEFAULT '0',
  unchangeable tinyint(1) NOT NULL DEFAULT '0',
  showincard tinyint(1) NOT NULL DEFAULT '0',
  showinthread tinyint(1) NOT NULL DEFAULT '0',
  showinregister tinyint(1) NOT NULL DEFAULT '0',
  allowsearch tinyint(1) NOT NULL DEFAULT '0',
  formtype varchar(255) NOT NULL,
  size smallint(6) unsigned NOT NULL DEFAULT '0',
  choices text NOT NULL,
  validate text NOT NULL,
  PRIMARY KEY (fieldid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_user_status;
CREATE TABLE dzz_user_status (
  uid mediumint(8) unsigned NOT NULL,
  regip char(15) NOT NULL DEFAULT '',
  lastip char(15) NOT NULL DEFAULT '',
  lastvisit int(10) unsigned NOT NULL DEFAULT '0',
  lastactivity int(10) unsigned NOT NULL DEFAULT '0',
  lastsendmail int(10) unsigned NOT NULL DEFAULT '0',
  invisible tinyint(1) NOT NULL DEFAULT '0',
  profileprogress tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (uid),
  KEY lastactivity (lastactivity,invisible)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_user_thame;
CREATE TABLE dzz_user_thame (
  uid int(10) NOT NULL DEFAULT '0',
  custom_backimg varchar(255) NOT NULL,
  custom_url varchar(255) NOT NULL,
  custom_btype tinyint(1) unsigned NOT NULL,
  custom_color varchar(255) NOT NULL DEFAULT '',
  thame smallint(6) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY uid (uid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_usergroup;
CREATE TABLE dzz_usergroup (
  groupid smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  radminid tinyint(3) NOT NULL DEFAULT '0',
  `type` enum('system','special','member') NOT NULL DEFAULT 'member',
  system varchar(255) NOT NULL DEFAULT 'private',
  grouptitle varchar(255) NOT NULL DEFAULT '',
  creditshigher int(10) NOT NULL DEFAULT '0',
  creditslower int(10) NOT NULL DEFAULT '0',
  stars tinyint(3) NOT NULL DEFAULT '0',
  color varchar(255) NOT NULL DEFAULT '',
  icon varchar(255) NOT NULL DEFAULT '',
  allowvisit tinyint(1) NOT NULL DEFAULT '0',
  allowsendpm tinyint(1) NOT NULL DEFAULT '1',
  allowinvite tinyint(1) NOT NULL DEFAULT '0',
  allowmailinvite tinyint(1) NOT NULL DEFAULT '0',
  maxinvitenum tinyint(3) unsigned NOT NULL DEFAULT '0',
  inviteprice smallint(6) unsigned NOT NULL DEFAULT '0',
  maxinviteday smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (groupid),
  KEY creditsrange (creditshigher,creditslower)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_usergroup_field;
CREATE TABLE dzz_usergroup_field (
  groupid smallint(6) unsigned NOT NULL DEFAULT '0',
  maxspacesize int(10) unsigned NOT NULL DEFAULT '0',
  attachextensions varchar(255) NOT NULL,
  maxattachsize int(10) unsigned NOT NULL DEFAULT '0',
  perm smallint(6) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY groupid (groupid)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_wallpaper;
CREATE TABLE dzz_wallpaper (
  bid smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL,
  title varchar(255) NOT NULL,
  val varchar(255) NOT NULL,
  classid smallint(6) unsigned NOT NULL DEFAULT '0',
  dateline int(10) unsigned NOT NULL DEFAULT '0',
  disp smallint(6) unsigned NOT NULL DEFAULT '0',
  thumb tinyint(1) unsigned NOT NULL DEFAULT '0',
  img varchar(255) NOT NULL,
  PRIMARY KEY (bid),
  KEY classid (classid),
  KEY disp (disp),
  KEY `type` (`type`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS dzz_wallpaper_class;
CREATE TABLE dzz_wallpaper_class (
  classid smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  classname varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  disp smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (classid),
  KEY disp (disp),
  KEY `type` (`type`)
) ENGINE=MyISAM;