<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice Alpha 2013.9.10
 * @link        http://www.dzzoffice.com
 * @author      dzzfox(dzzfox@gmail.com)
 */
if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

$uid=intval($_G['uid']);

	include_once libfile('function/profile');
	$space = getuserbyuid($uid);
	space_merge($space, 'profile');
	loadcache('profilesetting');
	if(empty($_G['cache']['profilesetting'])) {
		require_once libfile('function/cache');
		updatecache('profilesetting');
		loadcache('profilesetting');
	}
	if(submitcheck('profilesubmit')){
		$setarr=array();
		foreach($_GET as $key => $value) {
			$field = $_G['cache']['profilesetting'][$key];
			if(empty($field)) {
				continue;
			}elseif(profile_check($key, $value, $space)) {
				$setarr[$key] = dhtmlspecialchars(trim($value));
			}
		}
		if(isset($_POST['birthmonth']) && ($space['birthmonth'] != $_POST['birthmonth'] || $space['birthday'] != $_POST['birthday'])) {
			$setarr['constellation'] = get_constellation($_POST['birthmonth'], $_POST['birthday']);
		}
		if(isset($_POST['birthyear']) && $space['birthyear'] != $_POST['birthyear']) {
			$setarr['zodiac'] = get_zodiac($_POST['birthyear']);
		}
		
		if($setarr) {
			$setarr['uid']=$uid;
			C::t('user_profile')->insert($setarr,0,1);
		}
		showmessage('do_success',dreferer());
	}else{
		$allowitems = array();
		foreach($_G['cache']['profilesetting'] as $key => $value){
			if($value['available']>0) $allowitems[]=$key;
		}
		
		$htmls = $settings = array();
		
		$space['realname']=$space['username'];
		foreach($allowitems as $fieldid) {
			if(!in_array($fieldid, array('sightml', 'customstatus', 'timeoffset'))) {
				$html = profile_setting($fieldid, $space, $vid ? false : true);
				if($html) {
					$settings[$fieldid] = $_G['cache']['profilesetting'][$fieldid];
					$htmls[$fieldid] = $html;
				}
			}
		}
		$active=array('profile'=>'class="active"');
		
		include template('profile');
	}
?>
