/**
 * @author XXJ 2012-12-28
 */

/** --------------------------------------------------------------------------------------**/
/** -------------------------------------  可公用的JS方法 --------------------------------**/
/** --------------------------------------------------------------------------------------**/

/**
 * 跳转到添加/修改页面
 */
function toMerge(url){
	window.location.href = url;
}

/**
 * 删除
 * @param flag  1-单个 2-批量删除
 * @param idStr ID或ID拼接字符串
 */
function toDelete(state,idStr){
	var flag = "";
	if(state=="2"){
		flag = "isBatch";
		idStr = getChecked();
	}
	if(idStr==null||idStr == ""){
		alert("请先选择要删除的数据信息，再进行删除操作！");
		return false;
	}
	if(confirm("是否确认删除？")){
		$("#flag").val(flag);
		$("#idStr").val(idStr);
		$("#delForm").submit();
	}	
}

//执行更新事件
function doMerge(){
	$("#mergeForm").submit();
}

/**
 * 重置表单
 */
function toReset(){
	location.replace(location);
}

/**
 * 权限操作
 */
function checkAll(obj){
	if(obj.checked){
		$("[name='check']").attr("checked","true");
	}else{
		$("[name='check']").removeAttr("checked");
	}
}


/**
 * 获取选中的值
 * @return
 */
function getChecked(){
	var str = document.getElementsByName("check");
	var len = str.length;
	var idStr = "";
	for(i=0;i<len;i++){
		if(str[i].checked == true){
			if(idStr != ""){
				idStr += ",";
			}
			idStr += str[i].value;
		}
	}
	$("#idStr").val(idStr);
	return idStr;
}

//页面搜索事件
function seaEvent(){
	$("#seaForm").submit();
}

/* 部门树下拉选项样式-设置字体颜色 */
function depart_setFont(treeId, treeNode) {
	if (treeNode && treeNode.isParent) {
		return {color: "blue"};
	} else {
		return null;
	}
}

/* 部门树下拉选项样式-部门树显示事件 */
function depart_showMenu() {
	var cityObj = $("#dname");
	var cityOffset = $("#dname").offset();
	$("#DropdownMenuBackground").css({left:cityOffset.left + "px", top:cityOffset.top + cityObj.outerHeight() + "px"}).slideDown("fast");
	
}

/* 部门树下拉选项样式 -隐藏事件 */
function depart_hideMenu() {
	$("#DropdownMenuBackground").fadeOut("fast");
}

/* 部门树下拉选项样式 -选中树单击前事件 */
function departTreeOnBeforeClick(treeId, treeNode) {
	var check = treeNode;
	return check;
}

/* 部门树下拉选项样式 --选中树单击事件 */
function departTreeOnClick(event, treeId, treeNode) {
	if (treeNode) {
		$("#dname").val(treeNode.name);
		$("#did").val(treeNode.id);
		depart_hideMenu();
	}
} 

/** --------------------------------------------------------------------------------------**/
/** -------------------------------------  zTree公用方法 -------------------------------**/
/** --------------------------------------------------------------------------------------**/
/**
 * zTree右键菜单事件
 */
function zTreeOnRightClick(event, treeId, treeNode){
	zTree1.selectNode(treeNode);
	showRMenu("node", event.clientX, event.clientY);
}

/**
 * zTree显示右键菜单
 */
function showRMenu(type, x, y) {
	$("#rMenu ul").show();
	$("#rMenu").css({"top":y+"px", "left":x+"px", "visibility":"visible"});
}

/**
 * zTree隐藏右键菜单
 */
function hideRMenu() {
	if (rMenu) rMenu.style.visibility = "hidden";
}

/** --------------------------------------------------------------------------------------**/
/** ------------------------------------  角色管理JS方法 ---------------------------------**/
/** --------------------------------------------------------------------------------------**/

function roleRefreshResTree(asyncUrl) {
	setting.asyncUrl = "getChildRes";
	zTree1 = $("#treeDemo").zTree(setting, zNodes);
}
 
/** 判断改变后树节点选中值 */
function roleResTreeOnChange(){
	var resIds = $("#resIds").val();
	var temp = zTree1.getCheckedNodes();
	var idStr = "";
	$.each(temp,function(i,item){
		var limitId = item.id;
		if(idStr != ""){
			idStr += ",";
		}
		idStr += item.id;
	});
	$("#resIds").val(idStr);
}


/** --------------------------------------------------------------------------------------**/
/** ---------------------------------  权限管理JS方法 ------------------------------------**/
/** --------------------------------------------------------------------------------------**/

/**
 * 根据权限等级，查询当前等级的权限集合
 */
function changeRes(curParent){
	var level = $("#resLevel").val();
	$("#parentRes").empty();
	$("#parentRes").append("<option value='0' selected>--请选择--</option>");
	if(level !=null && level !=""&&level>1){
		level = level-1;
		$.ajax({
			type:'post',
			url:'getResJson',
			data:{
				'level':level
			},
			success:function call(json){
				var objStr = $.parseJSON(json);
				$.each(objStr,function(i,item){
					var s = "<option value='"+item.resourceId+"' ";
					if(curParent == item.resourceId){
						s += " selected ";	
					}
					s +=">"+ item.resourceName+"</option>";
					$("#parentRes").append(s);
				});
			}
		});
	}
	
}

/**
 * 删除权限节点
 */
function removeResNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	if(confirm("删除权限会导致部分功能不能正常使用，是否确认删除？")){
		$.ajax({
			type:'post',
			url:'deleteRes',
			data:{
				'resId':node.id
			},
			success:function call(){
				alert("删除成功！");
				refreshTree();
			}
		});
	}
}

/**
 * 添加权限树节点
 */
function addResNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	toMergeRes(1,node);
}

function mergeResNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	toMergeRes(2,node);
}

/**
 * 执行保存操作
 */
function doSaveRes(){
	var resId = $("#resId").val();
	var resType = $("#resType").val();
	var resName = $("#resName").val();
	var resUrl = $("#resUrl").val();
	var resLevel = $("#resLevel").val();
	var parentId = $("#parentRes").val();
	var state = $("#state").val();
	
	if(checkRes(resName,resUrl,resLevel,parentId)){
		$.ajax({
			type:'post',
			url:'doMergeRes',
			data:{
				'resId':resId,
				'resName':resName,
				'resType':resType,
				'resUrl':resUrl,
				'resLevel':resLevel,
				'resParent':parentId,
				'state':state
			},
			success:function call(json){
				alert(json);
				refreshTree();
				toResetRes();
			}
		});
	}
	
}

/**
 * 信息校验
 */
function checkRes(name,url,level,pid){
	var  flag = 0;
	$("#nameWarn").empty();
	if(name==null||name==""){
		$("#nameWarn").html("权限名称不能为空！");
		flag += 1;
	}
	if(url == null || url ==""){
		$("#resUrl").val("#");
	}
	if(level == null || level == 0){
		$("#resLevel").val(1);
	}
	$("#presWarn").empty();
	if(level>1){
		if(pid == null || pid == 0){
			$("#presWarn").html("请选择父权限信息！");
			flag +=1;
		}
	}
	if(flag >0){
		return false;
	}
	return true;
}

/**
 * 重置权限信息
 */
function toResetRes(){
	$("#resId").val("");
	$("#resType").val(0);
	$("#resName").val("");
	$("#resUrl").val("#");
	$("#resLevel").val(0);
	$("#parentRes").val(0);
	$("input[name='state'][value='0']").attr("checked",true);
	$("#nameWarn").empty();
	$("#presWarn").empty();
}

/**
 * 修改权限树节点
 */
function toMergeRes(type,node){
	var resId = "";
	if(node !=null && node.id !=""){
		resId = node.id;
	}
	$.ajax({
		type:'post',
		url:'toMergeRes',
		data:{
			'type':type,
			'resId':resId
		},
		success:function(json){
			if(json != null && json !=""){
				var obj = $.parseJSON(json);
				$("#resId").val(obj.id);
				$("#resType").val(obj.type);
				$("#resName").val(obj.name);
				$("#resUrl").val(obj.url);
				$("#resLevel").val(obj.level);
				$("input[name='state'][value='"+obj.state+"']").attr("checked",true);
				changeRes(obj.pid);
			}
		}
	});

}


/** --------------------------------------------------------------------------------------**/
/** -------------------------------  组织结构管理JS方法 ---------------------------------**/
/** --------------------------------------------------------------------------------------**/

/** 删除组织结构节点  */
function removeDepartNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	if(confirm("是否确认删除？")){
		$.ajax({
			type:'post',
			url:'deleteDepart',
			data:{
				'departId':node.id
			},
			success:function call(json){
				alert(json);
				refreshTree();
			}
		});
	}
}

/**  添加组织结构树节点  */
function addDepartNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	toMergeDepart(1,node);
}

/**  更新组织结构树节点 */
function mergeDepartNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	toMergeDepart(2,node);
}

/** 执行保存操作  */
function doSaveDepart(){
	var resId = $("#departId").val();
	var resType = $("#departType").val();
	var resName = $("#departName").val();
	var resLevel = $("#departLevel").val();
	var parentId = $("#parentDepart").val();
	var state = $("#state").val();
	
	if(checkDepart(resName,resLevel,resType)){
		$.ajax({
			type:'post',
			url:'doMergeDepart',
			data:{
				'departId':resId,
				'departName':resName,
				'departType':resType,
				'departLevel':resLevel,
				'parentId':parentId,
				'state':state
			},
			success:function call(json){
				alert("执行成功！");
				refreshTree();
				toResetDepart();
			}
		});
	}
}

/** 更新部门信息 */
function toMergeDepart(type,node){
	var resId = "";
	if(node !=null && node.id !=""){
		resId = node.id;
	}
	$.ajax({
		type:'post',
		url:'toMergeDepart',
		data:{
			'type':type,
			'departId':resId
		},
		success:function(json){
			if(json != null && json !=""){
				var obj = $.parseJSON(json);
				$("#departId").val(obj.id);
				$("#departType").val(obj.dtype);
				$("#departName").val(obj.name);
				$("#departLevel").val(obj.dlevel);
				$("input[name='state'][value='"+obj.state+"']").attr("checked",true);
				changeDepart(obj.pid);
			}
		}
	});
}

/**
 * 信息校验
 */
function checkDepart(name,level,type){
	var  flag = true;
	$("#nameWarn").empty();
	$("#typeWarn").empty();
	if(name==null||name==""){
		$("#nameWarn").html("权限名称不能为空！");
		flag = false;
	}
	if(level == null || level == 0){
		$("#resLevel").val(1);
		flag = false;
	}
	if(type == null || type ==""){
		$("#typeWarn").html("请选择组织结构类型！");
		flag = false;
	}
	return flag;
}

/**
 * 重置权限信息
 */
function toResetDepart(){
	$("#departId").val("");
	$("#departType").val(0);
	$("#departName").val("");
	$("#departLevel").val(1);
	$("#parentDepart").empty();
	$("#parentDepart").append("<option value='0'>---请选择---</option>");
	$("input[name='state'][value='0']").attr("checked",true);
	$("#nameWarn").empty();
	
}

/** 根据父部门或部门级别更新部门信息   */
function changeDepart(curParent){
	var level = $("#departLevel").val();
	if(level !=null && level !=""&&level>1){
		level = level-1;
		$.ajax({
			type:'post',
			url:'getJsonDepartList',
			data:{
				'level':level
			},
			success:function call(json){
				var objStr = $.parseJSON(json);
				$("#parentDepart").empty();
				$("#parentDepart").append("<option value='0' selected>--请选择--</option>");
				
				$.each(objStr,function(i,item){
					var s = "<option value='"+item.id+"' ";
					if(curParent == item.id){
						s += " selected ";	
					}
					s +=">"+ item.name+"</option>";
					$("#parentDepart").append(s);
				});
			}
		});
	}
}


/** --------------------------------------------------------------------------------------**/
/** ----------------------------------  用户管理JS方法 -----------------------------------**/
/** --------------------------------------------------------------------------------------**/

/**
 * 删除电话输入框

function delTel(){
	var num = $("#telNum").val();
	var now = parseInt(num)-1;
	$("#telp"+num).remove();
	$("#telNum").val(now);
}
 */

/**
 * 添加电话输入框
 
function addTel(){
	var num = $("#telNum").val();
	var now = parseInt(num)+1;
	$("#telNum").val(now);
	var s = "<span id='telp"+now+"'></br><input type='text' id='tele"+now+"' style='margin-top: 5px;' >&nbsp;"
	+"<a href='#' onclick='delTel()'><image src='../../resources/oa/common/images/bule_list_57.jpg'></a></span>";
	$("#telDiv").append(s);
}
*/

/**
 * 添加邮箱输入框
 
function addMail(){
	var num = $("#mailNum").val();
	var now = parseInt(num)+1;
	$("#mailNum").val(now);
	var s = "<span id='mailp"+now+"'></br><input type='text' id='mail"+now+"' style='margin-top: 5px;' >&nbsp;"
	+"<a href='#' onclick='delMail()'><image src='../../resources/oa/common/images/bule_list_57.jpg'></a></span>";
	$("#mailDiv").append(s);
}
*/

/**
 * 删除邮箱输入框

function delMail(){
	var num = $("#mailNum").val();
	var now = parseInt(num)-1;
	$("#mailp"+num).remove();
	$("#mailNum").val(now);
}
 */

/**
 * 获取用户信息-电话信息

function  initTele(){
	var num = $("#telNum").val();
	var now = parseInt(num);
	var telMes = "";
	for(var i=1;i<=now;i++){
		var limt = $("#tele"+i).val();
		if(limt != null && limt !=""){
			if(telMes!=""){
				telMes += ";";
			}
			telMes += limt;
		}
	}
	$("#telephone").val(telMes);
}
 */

/**
 * 获取用户信息-邮件信息

function  initMail(){
	var num = $("#mailNum").val();
	var now = parseInt(num);
	var telMes = "";
	for(var i=1;i<=now;i++){
		var limt = $("#mail"+i).val();
		if(limt != null && limt !=""){
			if(telMes!=""){
				telMes += ";";
			}
			telMes += limt;
		}
	}
	$("#email").val(telMes);
}
 */

/* 重新加载职位信息 */
function refreshLoadPost(){
	var did = $("#did").val();
	showPostBydid(did,"");
}

/* 显示职位信息 */
function showPostBydid(departId,defaultVal){
	$.ajax({
		type:'post',
		url:'getJsonPostByDepart',
		data:{
			"departId":departId
		},
		success:function call(json){
			appendPost(json,defaultVal);
		}
	});
}

/* ajax拼接职位信息 */
function appendPost(varJson,defaultVal){
	$("#post").empty();
	var s = "<option value='' selected >--请选择--</option>";
	if(varJson!=""){
		var objList = $.parseJSON(varJson);
		$.each(objList,function(i,item){
			s += "<option value='"+item.postId+"' ";
			if(defaultVal==item.postId){
				s += " selected ";
			}
			s += ">"+item.postName+"</option>";
		});
	}
	$("#post").append(s);
}

function userRolesOnChange(){
	var resIds = $("#roleStr").val();
	var temp = zTree1.getCheckedNodes();
	var idStr = "";
	$.each(temp,function(i,item){
		var limitId = item.id;
		if(idStr != ""){
			idStr += ",";
		}
		idStr += item.id;
	});
	$("#roleStr").val(idStr);
}

/* 部门树下拉选项样式 --选中树单击事件 */
function departTreeOnClick(event, treeId, treeNode) {
	if (treeNode) {
		$("#dname").val(treeNode.name);
		$("#did").val(treeNode.id);
		depart_hideMenu();
		refreshLoadPost();
	}
}

/** 给用户名赋值 */
function setUserName(){
	var realName = $("#realName").val();
	$.ajax({
		type:'post',
		url:'getSpellName',
		data:{
			"realName":realName
		},
		success:function call(json){
			$("#userName").val(json);
		}
	});
}

/** -----------------------------------------------------------------------------------------------**/
/** -----------------------------------  数据字典管理JS方法 --------------------------------------**/
/** -----------------------------------------------------------------------------------------------**/

/** 数据字典校验 */
function validateDict(){
	//$("#dictDesc").val(KE.html('dictDesc'));
	var flag = true;
	var dictName = $("#dictName").val();
	var dictType = $("#dictType").val();
	$("#nameNode").html("");
	$("#typeNode").html("");
	
	if(dictName == null || dictName == ""){
		$("#nameNode").html("字典名称不能为空！");
		flag = false;
	}
	
	if(dictType == null || dictType == ""){
		$("#typeNode").html("字典类型不能为空！");
		flag = false;
	}
	/*
	var dictNo = $("#dictNo").val();
	$("#noNode").html("");
	if(dictNo==null||dictNo==""){
		$("#noNode").html("字典编号不能为空！");
		flag = false;
	}
	
	if(flag){
		checkSingleDict(dictNo,dictType);
		var single = $("#single").val();
		if(single == 3){
			flag = false;
		} 
	}*/
	return flag;
}

/** 检查编号单一性 */
function checkSingleDict(dictNo,dictType){
	$.ajax({
		type:'post',
		async: false,
		url:'checkUniqueDict',
		data:{
			"dictNo":dictNo,
			"dictType":dictType
		},
		success:function call(json){
			if(json == "3"){
				$("#noNode").html("同类型的字典编号不能重复！");
				$("#single").val(3);
			}else{
				$("#single").val(2);
			}
		}
	});
}

/** -----------------------------------------------------------------------------------------------**/
/** -----------------------------------  通讯录管理JS方法 --------------------------------------**/
/** -----------------------------------------------------------------------------------------------**/

/** 显示选中用户的详细信息 */
function toShowInterAddress(event, treeId, treeNode){
	var userType = treeNode.ttype;
	var userId = treeNode.id;
	if(userType=="user"){
		$.ajax({
			type:'post',
			url:'getUserJson',
			async: false,
			data:{
				"userId":userId
			},
			success:function(user){
				if(user != ""){
					var uobj = $.parseJSON(user);
					$("#userId").val(uobj.id);
					$("#realName").val(uobj.name);
					$("#dname").val(uobj.dname);
					$("#pname").val(uobj.postName);
					$("#tel").val(uobj.tel);
					$("#postCode").val(uobj.postCode);
					$("#email").val(uobj.email);
					$("#mobile").val(uobj.mobile);
					$("#faxes").val(uobj.faxes);
				}
			} 
		});
	}
}

function checkInterAdd(tel,mobile,faxes,email){
	var numReg = /^(\d{3,4}-)?\d{7,8}$/ ;   //固话正则
	var phoneReg = /^(\d{11})|^((\d{7,8})|(\d{4}|\d{3})-(\d{7,8})|(\d{4}|\d{3})-(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1})|(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1}))$/;  //手机正则
	var emialReg=/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/; //邮箱正则
	if(email == null || email == ""){
		alert("请填写员工的电子邮箱地址！");
		return  false;
	}else if(!emialReg.test(email)){
		alert("电子邮箱的格式不对，请重新填写！");
		return false;
	}
	if(tel != null && tel != ""){
		if(!numReg.test(tel)){
			alert("您填写的固话格式不对，请重新填写！");
			return false;
		}
	}
	if(mobile != null && mobile != ""){
		if(!phoneReg.test(mobile)){
			alert("请填写正确的手机号！");
			return false;
		}
	}
	if(faxes != null && faxes != ""){
		if(!numReg.test(faxes)){
			alert("您填写的传真格式不对，请重新填写！");
			return false;
		}
	}
	
	return  true;
}

/** 提交更新后的通讯录 */
function doMergeInterAddress(){
	var tel = $("#tel").val();
	var mobile = $("#mobile").val();
	var faxes = $("#faxes").val();
	var email = $("#email").val();
	var postCode = $("#postCode").val();
	var userId = $("#userId").val();
	var address = $("#address").val();
	if(userId == "undefined" || userId ==""){
		alert("请选择要编辑的联系人！");
		return;
	}
	if(checkInterAdd(tel,mobile,faxes,email)){
		$.ajax({
			type:'post',
			url:'doMergeInterAddress',
			data:{
				"userId":userId,
				"tel":tel,
				"email":email,
				"postCode":postCode,
				"address":address,
				"mobile": mobile,
				"faxes":faxes
			},
			success:function(json){
				alert(json);
				clearInterAddress();
			}
		});
	}
}

/** 重置通讯录消息 */
function clearInterAddress(){
	$("#userId").val("");
	$("#realName").val("");
	$("#dname").val("");
	$("#pname").val("");
	$("#tel").val("");
	$("#postCode").val("");
	$("#email").val("");
	$("#mobile").val("");
	$("#faxes").val("");
}

/** 初始化通讯录分组信息  */
function initAddressGroup(groupId,type){
	$.ajax({
		type:'post',
		url:'getJsonDictList',
		data:{
			"dictType":'1',
			"state":type
		},
		success:function call(reJson){
			$("#group").empty();
			var s = "<option value='' selected>--请选择--</option>";
			if(reJson != ""){
				var objList = $.parseJSON(reJson);
				$.each(objList,function(i,item){
					s  += "<option value='"+item.id+"' ";
					if(groupId == item.id){
						s += " selected ";
					}
					s  += ">"+item.name+"</option>";
				});
			}
			$("#group").append(s);
		}
	});
}

/** 通讯录查询 */
function toSearchAddress(obj){
	var dictId = $(obj).attr("id");
	$("#dictId").val(dictId);
	$("#seaForm").submit();
}

/** 设置通讯录分组li鼠标滑过样式  */
function changeBg(obj,flag){
	if(flag == "out"){
		$(obj).attr("class","libgColor2");
	}
	if(flag=="over"){
		$(obj).attr("class","libgColor1");
	}
}


/** -----------------------------------------------------------------------------------------------**/
/** ------------------------------------  薪资管理使用JS -----------------------------------------**/
/** -----------------------------------------------------------------------------------------------**/


/** 工资单字段信息校验  */
function verifyField(){
	var cname = $("#fieldCname").val();
	var ename = $("#fieldEname").val();
	
	$("#cnode").html("");
	$("#enode").html("");
	flag = true;
	if(cname==null && cname ==""){
		$("#cnode").html("字段中文名不能为空！");
		flag = false;
	}
	if(cname==null && cname ==""){
		$("#enode").html("字段名称不能为空！");
		flag = false;
	}
	return flag;
}

/** 根据部门查询对应工资单字段 **/
function payrollByDepart(event, treeId, treeNode){
	//清空历史选中
	clearPrayroll();
	var departId = treeNode.id;
	$("#departId").val(treeNode.id);
	$.ajax({
		type:'post',
		url:'getDepartPayroll',
		data:{
			"departId":departId
		},
		success:function(json){
			if(json != ""){
				idStr = json.split(",");
				$.each(idStr,function(i,item){
					$("#"+item).attr("checked","true");
				});
			}
		}
	});
}

/** 清空选中项 **/
function clearPrayroll(){
	$('input[name="fvalue"]:checked').attr('checked',false);
}


/** 执行更新工资单 **/
function doMergeParyroll(){
	var departId = $("#departId").val();
	if(departId == null || departId == ""){
		alert("请选择部门，进行工资单设置！");
		return  false;
	}else{
		getCheckedPayroll();
		var idStr = $("#idStr").val();
		$.ajax({
			type:'post',
			url:'doMergeDepartParyroll',
			data:{
				"idStr":idStr,
				"departId":departId
			},
			success:function(json){
				if(json == "1"){
					alert("设置成功！");
				}
				//clearPrayroll();
			}
		});
	}
}

/** 获取选中的工资单字段 **/
function getCheckedPayroll(){
	var sfruit = "";
	$('input[name="fvalue"]:checked').each(function(){
		if(sfruit != ""){
			sfruit += ",";
		}
        sfruit += $(this).val();
 	});
 	$("#idStr").val(sfruit);
}


/** -----------------------------------------------------------------------------------------------**/
/** ------------------------------------  OA信息管理中使用JS ------------------------------------**/
/** -----------------------------------------------------------------------------------------------**/

/** 修改记录点击事件 **/
function showMergeTr(){
	$("#mergeSpan").click(function(){
		var flag = $("#mergeTr").css('display');
		if(flag=='none'){
			$("#mergeSpan").find('img').attr('src','../../resources/oa/blue/images/xsx.jpg');
			$("#mergeTr").show();
		}else{
			$("#mergeSpan").find('img').attr('src','../../resources/oa/blue/images/xsj.jpg');
			$("#mergeTr").hide();
		}
	});
}


/** 阅读记录点击事件 **/
function showReadTr(){
	$("#readSpan").click(function(){
		var flag = $("#readTr").css('display');
		if(flag=='none'){
			$("#readSpan").find('img').attr('src','../../resources/oa/blue/images/xsx.jpg');
			$("#readTr").show();
		}else{
			$("#readSpan").find('img').attr('src','../../resources/oa/blue/images/xsj.jpg');
			$("#readTr").hide();
		}
	});
}


/** ---------------------------------------------------------------------------------------------------**/
/** ------------------------------------  常用资料分类管理-使用JS ------------------------------------**/
/** ---------------------------------------------------------------------------------------------------**/


/**
 * 删除权限节点
 */
function removeRepTypeNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	if(confirm("删除分组可能会导致常用文件丢失，是否确认删除？")){
		$.ajax({
			type:'post',
			url:'deleteRepostType',
			data:{
				'repid':node.id
			},
			success:function call(json){
				if(json != null &&json=='1'){
					alert("删除成功！");
				}else if(json=='2'){
					alert("此分组下有资源，不能删除！");
				}
				refreshTree();
			}
		});
	}
}

/**
 * 添加权限树节点
 */
function addRepTypeNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	toMergeRepType(1,node);
}

function mergeRepTypeNode(){
	hideRMenu();
	var node = zTree1.getSelectedNode();
	toMergeRepType(2,node);
}

/**
 * 执行保存操作
 */
function doSaveRepType(){
	var resId = $("#typeId").val();
	var resName = $("#typeName").val();
	var resLevel = $("#typeLevel").val();
	var parentId = $("#parentType").val();
	var state = $("#state").val();
	var remark = $("#remark").val();
	
	if(checkRes(resName,resLevel,parentId)){
		$.ajax({
			type:'post',
			url:'doMergeRepostType',
			data:{
				'typeId':resId,
				'typeName':resName,
				'typeLevel':resLevel,
				'parentType':parentId,
				'state':state,
				'remark':remark
			},
			success:function call(json){
				refreshTree();
				toResetRepType();
			}
		});
	}
	
}

/**
 * 信息校验
 */
function checkRepType(name,level,pid){
	var  flag = 0;
	$("#nameWarn").empty();
	if(name==null||name==""){
		$("#nameWarn").html("权限名称不能为空！");
		flag += 1;
	}
	if(level == null || level == 0){
		$("#typeLevel").val(1);
	}
	$("#presWarn").empty();
	if(level>1){
		if(pid == null || pid == 0){
			$("#presWarn").html("请选择父权限信息！");
			flag +=1;
		}
	}
	if(flag >0){
		return false;
	}
	return true;
}

/**
 * 重置常用资料分组信息
 */
function toResetRepType(){
	$("#typeId").val("");
	$("#typeName").val("");
	$("#typeLevel").val(0);
	$("#parentType").val(0);
	$("#remark").val("");
	$("input[name='state'][value='0']").attr("checked",true);
	$("#nameWarn").empty();
	$("#presWarn").empty();
}

/**
 * 修改常用资料分组树节点
 */
function toMergeRepType(type,node){
	var resId = "";
	if(node !=null && node.id !=""){
		resId = node.id;
	}
	$.ajax({
		type:'post',
		url:'toMergeRepostType',
		async:false,
		data:{
			'type':type,
			'repid':resId
		},
		success:function(json){
			if(json != null && json !=""){
				var obj = $.parseJSON(json);
				$("#typeId").val(obj.id);
				$("#typeName").val(obj.name);
				$("#typeLevel").val(obj.level);
				$("#remark").val(obj.remark);
				$("input[name='state'][value='"+obj.state+"']").attr("checked",true);
				changeTypeLevel(obj.pid);
			}
		}
	});

}

/**
 * 根据常用资料分组等级，查询当前等级的常用资料分组集合
 */
function changeTypeLevel(curParent){
	var level = $("#typeLevel").val();
	$("#parentType").empty();
	$("#parentType").append("<option value='0' selected>--请选择--</option>");
	if(level !=null && level !=""&&level>1){
		level = level-1;
		$.ajax({
			type:'post',
			url:'getJsonRepTypeByLevel',
			data:{
				'level':level
			},
			success:function call(json){
				var objStr = $.parseJSON(json);
				$.each(objStr,function(i,item){
					var s = "<option value='"+item.id+"' ";
					if(curParent == item.id){
						s += " selected ";	
					}
					s +=">"+ item.name+"</option>";
					$("#parentType").append(s);
				});
			}
		});
	}
}


/* 常用资料分组树下拉选项样式 -隐藏事件 */
function type_hideMenu() {
	$("#repostTypeMenu").fadeOut("fast");
}

/* 常用资料分组树下拉选项样式-部门树显示事件 */
function type_showMenu() {
	var cityObj = $("#tname");
	var cityOffset = $("#tname").offset();
	$("#repostTypeMenu").css({left:cityOffset.left + "px", top:cityOffset.top + cityObj.outerHeight() + "px"}).slideDown("fast");
}


/* 常用资料分组树下拉选项样式 -选中树单击前事件 */
function typeTreeOnBeforeClick(treeId, treeNode) {
	var check = treeNode;
	return check;
}

/* 常用资料分组树下拉选项样式 --选中树单击事件 */
function typeTreeOnClick(event, treeId, treeNode) {
	if (treeNode) {
		$("#tname").val(treeNode.name);
		$("#tid").val(treeNode.id);
		type_hideMenu();
	}
} 

