<?php
	class cls_addImgWater{

		private $imgUrl="";
		private $wImg="";
		private $wWord="";
		private $position=3;
		private $alpha=30;
		
		function __construct($arr=array()){
			$proArr=get_class_vars(__CLASS__);

			foreach($arr as $key=>$value){
				if(array_key_exists($key,$proArr)){
					$this->$key=$value;
				}
			}			
		}

		private function getImg($imgUrl){
			$imageInfo=getimagesize($imgUrl);
			switch($imageInfo[2]){
				case 1;$img=imagecreatefromgif($imgUrl);break;
				case 2;$img=imagecreatefromjpeg($imgUrl);break;
				case 3;$img=imagecreatefrompng($imgUrl);break;
				case 6;$img=imagecreatefromwbmp($imgUrl);break;
			}
			imagealphablending($img, true);
			return $img;
		}

		private function getImgTypeNum($imgUrl){
			$imageInfo=getimagesize($imgUrl);
			return $imageInfo[2];
		}

		private function getImgWidth($img){
			return imagesx($img);
		}

		private function getImgHeight($img){
			return imagesy($img);
		}

		public function addWaterMark(){
			if(!is_file($this->imgUrl))return;
			$img=$this->getImg($this->imgUrl);
			$imgW=$this->getImgWidth($img);
			$imgH=$this->getImgHeight($img);

			if(is_file($this->wImg)){
				$wImg=$this->getImg($this->wImg);
				$wImgW=$this->getImgWidth($wImg);
				$wImgH=$this->getImgHeight($wImg);

				switch($this->position){
					case 1:
						$offsetX=1;
						$offsetY=1;
						break;
					case 2:
						$offsetX=$imgW-$wImgW-5;
						$offsetY=5;
						break;
					case 3:
						$offsetX=$imgW-$wImgW-5;
						$offsetY=$imgH-$wImgH-5;
						break;
					case 4:
						$offsetX=5;
						$offsetY=$imgH-$wImgH-5;
						break;
					case 5:
						$offsetX=floor(($imgW-$wImgW)/2);
						$offsetY=floor(($imgH-$wImgH)/2);

				}

				imagecopymerge($img, $wImg, $offsetX, $offsetY, 0, 0, $wImgW, $wImgH,$this->alpha);
				$imgTypeNum=$this->getImgTypeNum($this->imgUrl);
				
				switch($imgTypeNum){
					case 1;imagegif($img,$this->imgUrl);break;
					case 2;imagejpeg($img,$this->imgUrl);break;
					case 3;imagepng($img,$this->imgUrl);break;
					case 6;imagewbmp($img,$this->imgUrl);break;
				}

				imagedestroy($wImg);

			}else{
				if($this->wWater=='')$this->wWater=$_SERVER["SERVER_NAME"];
				echo $this->wWater;
			}

			imagedestroy($img);
			
		}
	}
