<?php
/**
 * Ⱥ
 *
 * @copyright Copyright (c) 2005 - 2009 Yanwee.net (www.anleye.com)
 * @author һ yandy@yanwee.com
 * @package Core
 * @version $Id$
 */

/**
 * Group ̨û
 * @package Apps
 */
class Group {

	/**
	 * @var Object $db ݿѯ
	 * @access private
	 */
	private $db = NULL;
	
	/**
	 * @var string $filepath ļ·
	 * @access private
	 */
	private $filepath;
	
	/**
	 * 캯
	 * @param Object $db ݲѯ
	 * @access public
	 * @return void
	 */
	function Group($db) {
		$this->db = $db;
		$this->filepath = $GLOBALS['cfg']['path']['conf'] . 'groups.cfg.php';
	}
	
	/**
	 * ȡûб
	 * @access public
	 * @return array
	 */
	function getList() {
		return $this->db->select('select * from fke_group');
	}
	
	/**
	 * ûϢ
	 * @param string $info ûϢ
	 * @access public
	 * @return bool
	 */
	function save($info) {
		specConvert($info, array('group_name'));
		$group_id = intval($info['group_id']);
		if ($group_id) {// 
			$this->db->update('fke_group',array(
						'group_name' => $info['group_name'],
						), 'group_id=' . $group_id);
		} else {//  
			$this->db->insert('fke_group',array(
						'group_name' => $info['group_name'],
						));
		}
		$this->cache();
		return $result;
	}
	
	/**
	 * ȡûϢ
	 * @param string $userId ûID
	 * @param string $field ֶ
	 * @access public
	 * @return array
	 */
	function getInfo($groupId, $field = '*') {
		return $this->db->getValue('select ' . $field . ' from fke_group where group_id=' . intval($groupId));
	}
	
	/**
	 * ɾûϢ
	 * @param mixed $groups ûID
	 * @access public
	 * @return bool
	 */
	function delete($groups) {
		$groups = implode(',',$groups);
		$where = 'group_id in (' . $groups . ')';
		$this->db->execute('delete from fke_group where ' . $where);
		$this->cache();
		return true;
	}
	
	/**
	 * ûϢ
	 * @access public
	 * @return void
	 */
	function cache() {
		$array = $this->db->select('select group_id,group_name from fke_group','hashmap');
		$fp = fopen ($this->filepath, 'w');
		fputs($fp, '<?php return ' . var_export($array, true) . ';?>');
		fclose($fp);
	}
	
	/**
	 * ȡûѡ
	 * @param int $value ûID
	 * @access public
	 * @return void
	 */
	function getSelect($value) {
		$array = require($this->filepath);
		$html = '<select name="group_id">';
		foreach ($array as $key => $v) {
			if ($key==$value) {
				$selected = ' selected';
			} else {
				$selected = '';
			}
			$html .= '<option value="' . $key . '"' . $selected . '>' . $v . '</option>';
		}
		$html .= '</select>';
		return $html;
	}
}
?>