<?php
/**
 * PHPĿʹ - PHPĿ
 * Copyright (c) 2006-2008 Ѷ
 * All rights reserved.
 * δɣֹҵ;
 *
 * @package    Util
 * @author     ־ <dzjzmj@163.com>
 * @copyright  2006-2008 Walk Watch
 * @version    v1.0
 */

/**
 * ArrayHandle 
 * @package Util
 */
class ArrayHandle {

	/**
	 * @var array $arrayData 
	 * @access public
	 */
	public $arrayData = array();
	
	/**
	 * 캯
	 * @param array $array 
     */
	public function __construct (& $array) {
		if ($array) {
			if (!is_array($array)) {
				throw new Exception('param is not an array');
			} else {
				$this->arrayData = &$array;
			} 
		}
	}
	
	/**
	 * ѯ,жkey
	 * @param array $array 
	 * @param mixed $value Ҫѯֵ
	 * @return mixed
	 */
	public static function search(&$array, $value, $field = NULL, $once = false) {
		$index = array();
		foreach ($array as $key => $arrayValue) {
			if ($field) {
				if ($arrayValue[$field]==$value) {
					$index[] = $key;
					if ($once) {
						break;
					}
				}
			} else {
				if ($value==$arrayValue) {
					$index[] = $key;
					if ($once) {
						break;
					}
				}
			}
		}
		$indexCount = count($index);
		if ($indexCount<1) {
			return -1;
		} elseif ($indexCount==1) {
			return $index[0];
		} else {
			return $index;
		}
	}
	
	/**
	 * ָkeyֵǰ
	 * @param array $array 
	 * @param string $key ֵ
	 * @param mixed $value ֵ
	 * @param bool $before Ƿָkey֮ǰ
	 * @return void
	 */
	public static function insert(&$array, $key, $newValue, $before = true) {
		$result = false;
		$size = sizeof($array);
		for ($i=0; $i<$size; $i++) {
			$value = array_shift($array);
			if ($i==$key) {
				if ($before) {
					array_push($array, $newValue);
					array_push($array, $value);
				} else {
					array_push($array, $value);
					array_push($array, $newValue);
				}
				$result = true;
			} else {
				array_push($array, $value);
			}
		}
		if (!$result) {
			array_push($array, $newValue);
		}
		return;
	}
	
	/**
	 * ɾkeyΪָkeyֵ
	 * @param array $array 
	 * @param string $key ֵ
	 * @return void
	 */
	public static function delete(&$array, $key) {
		if (!is_array($key)) {
			$key = array($key);
		}
		foreach ($key as $k) {
			unset($array[$k]);
		}
		$array = array_values($array);
	}
	
	/**
	 * 
	 * @param array $array 
	 * @param string $type keyvalueֵ
	 * @param string $field ֶ
	 * @param string $order ʽasc˳desc
	 * @return void
	 */
	public static function sort(&$array, $type = 'value', $field = NULL, $order = 'asc') {
		if ($field) {
			foreach ($array as $key => $value) {
				$temp[$key] = $value[$field];
			}
			if ($order=='asc') {
				asort($temp);
			} else {
				arsort($temp);
			}
			$newarray = array();
			foreach ($temp as $key => $value) {
				$newarray[] = $array[$key];
			}
			$array = $newarray;
		} else {
			if ($type=='key') {
				if ($order=='asc') {
					ksort($array);
				} else {
					krsort($array);
				}
			} else {
				if ($order=='asc') {
					asort($array);
				} else {
					arsort($array);
				}
			}
		}
		
	}
}
?>