<?php
/**
 * HTML
 *
 * @author һ yandy@yanwee.com
 * @package 1.0
 * @version $Id$
 */

/**
 * Html html
 * @package Util
 */
class Html {
	/**
	 * @var string $output html
	 * @access private
	 */
	private $output = '';
	/**
	 * @var bool $inJsArea Ƿjs
	 * @access private
	 */
	private $inJsArea = false;
	/**
	 * 캯
	 */
	public function __construct() {
	
	}
	/**
	 * htmlǩ
	 * @param string $tag ǩ
	 * @param mixed $attribute 
	 * @param string $content 
	 * @return string
	 */
	public function addTag($tag, $attribute = NULL, $content = NULL) {
		$this->js();
		$html = '';
		$tag = strtolower($tag);
		$html .= '<'.$tag;
		if ($attribute!=NULL) {
			if (is_array($attribute)) {
				foreach ($attribute as $key=>$value) {
					$html .= ' '.strtolower($key).'="'.$value.'"';
				}
			} else {
				$html .= ' '.$attribute;
			}
		}
		if ($content) {
			$html .= '>'.$content.'</'.$tag.'>';
		} else {
			$html .= ' />';
		}
		
		$this->output .= $html;
		return $html;
	
	}
	/**
	 * htmlı
	 * @param string $content 
	 * @return string
	 */
	public function addText($content) {
		$this->js();
		$content = htmlentities($content);
		$this->output .= $content;
		return $content;
	}
	/**
	 * js
	 * @param string $jscode js
	 * @param bool $end Ƿرjs 
	 * @return void
	 */
	public function js($jscode = NULL, $end = false) {
		
		if (!$this->inJsArea && $jscode) {
			$this->output .= "\n<script language='JavaScript' type='text/javascript'>\n//<![CDATA[\n";
			$this->inJsArea = true;
		}
		if ($jscode==NULL && $this->inJsArea==true) {
			$this->output .= "\n//]]>\n</script>\n";
			$this->inJsArea = false;
		} else {
			$this->output .= "\t$jscode\n";
			if ($end) {
				$this->js();
			}
		}
		return;
	}
	/**
	 * jsʾ
	 * @param string $message ʾ
	 * @param bool $end Ƿرjs 
	 * @return void
	 */
	public function jsAlert($message, $end = false) {
		$this->js('alert("' . strtr($message, '"', '\\"') . '");', $end);
	}
	/**
	 * jsļ
	 * @param string $fileName ļ
	 * @param bool $defer Ƿdefer
	 * @return string
	 */
	public function jsInclude($fileName,$return = false, $defer = false) {
		if (!$return) {
			$this->js();
		}
		$html = '<script language="JavaScript" type="text/javascript" src="' 
				. $fileName . '"' . ( ($defer) ? ' defer' : '' ) 
				. '></script>';
		if (!$return) {
			$this->output .= $html;
		} else {
			return $html;
		}
	}
	/**
	 * cssļ
	 * @param string $fileName ļ
	 * @return string
	 */
	public function cssInclude($fileName,$return = false) {
		if (!$return) {
			$this->js();
		}
		$html = '<LINK href="' . $fileName . '" rel=stylesheet>' . chr(13);
		if (!$return) {
			$this->output .= $html;
		} else {
			return $html;
		}
	}
	/**
	 * html
	 * @param bool $print ǷֱѡĬϷ
	 * @return void
	 */
	public function output($print = false) {
		$this->js();
		if ($print) {
			echo $this->output;
			$this->output = '';
			return;
		} else {
			$output = $this->output;
			$this->output = '';
			return $output;
		}
		
	}
}
?>