<?php
/**
 * mysql ݲ
 *
 * @author һ yandy@yanwee.com
 * @package 1.0
 * @version $Id$
 */

/**
 * Mysql ݿdbQuery
 * @package Util
 */
class DbQueryForMysql {
	/**
	 * selectص¼
	 */
	const MAX_ROW_NUM = 1000;

	/**
	 * ݲѯ
	 * @var object $dataSet
	 */
	public $dataSet			= NULL ;

	/**
	 * Դ
	 * @var object $ds
	 */
	public $ds				= NULL ;

	/**
	 * ѯSQL
	 * @var string $sql
	 */
	public $sql				= '' ;
	
	public $transCnt 		= 0;
	
	/**
	 * ִвѯģʽֵΪ OCI_COMMIT_ON_SUCCESS  OCI_DEFAULT
	 * @var string $excuteMode
	 */
	public $executeMode	= OCI_COMMIT_ON_SUCCESS ;

	/**
	 * 캯
	 * @param object $ds ݿ
	 * @param string $sql ҪʼѯSQL
	 */
	function __construct($ds=NULL , $sql=NULL) {
		if (!$ds) {
			$this->error(DbException::DB_UNCONNECTED, 'ݿ⻹δӡ');
		} else {
			$this->ds = $ds;
			if ($sql) {
				$this->open($sql);
			}
		}
	}
	
	/**
	 * ͷռõڴ
	 * @param object $dataSet ҪͷԴĽ
	 * @access public
	 */
	public function close($dataSet=NULL) {
		if ($dataSet) {
			@mysql_free_result($dataSet);
		} else {
			@mysql_free_result($this->dataSet);
			$this->eof = false ;
			$this->recordCount = 0 ;
			$this->recNo = -1 ;
		}
	}
	
	/**
	 * $passݿ,ؼֵ֮
	 * @param string $pass Ҫַܵ
	 * @return string
	 * @access public
	 */
	public function encodePassword($pass) {
		return $this->getValue("SELECT password('$pass') AS pass");
	}
	
	/**
	 * õϢʹ
	 * @param integer $queryResult ѯ
	 * @return array
	 * @access protected
	 */
	protected function errorInfo($queryResult = NULL) {
		$result['message'] = @mysql_error($this->ds->connect);
		$result['code'] = @mysql_errno($this->ds->connect);
		return $result;
	}
	
	/**
	 * Ϣ
	 * @param string $errorId ID
	 * @param string $errorMessage Ϣ
	 * @access protected
	 */
	protected function error($errorId, $errorMessage) {
		throw new DbException($errorMessage, $errorId);
	}
	
	/**
	 * ִSQL
	 * @param string $sql SQL
	 * @return object
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @access public
	 * @see DbQuery::open
	 */
	public function execute($sql = '', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM, $error = true) {
		if ($rowTo != self::MAX_ROW_NUM || $rowFrom!=0) {
			$nrows = $rowTo - $rowFrom + 1; 
			$start = $rowFrom - 1;
			$start = ($start>=0) ? ((integer)$start) . ',' : '';
			$sql .= ' limit ' . $start  . $nrows;
		}
		//echo $sql.'<br>'; 
		$dataSet = @mysql_query($sql,  $this->ds->connect);
		
		if (!$dataSet && $error) {
			$sqlError = $this->errorInfo();
			$errorMessage = 'ִ[<b><font color="#FF0000">' . $sql 
					. '</font></b>]<br> <font color=#FF0000> ['
					. $sqlError['code'] . ']: '
					. $sqlError['message'] . '</font>' ;
			$this->error(DbException::DB_QUERY_ERROR, $errorMessage);
		}
	
		return $dataSet;
	}
	
	/**
	 * ִSQL䣬浽$dataSet
	 * @param string $sql SQL
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @return object
	 * @access public
	 * @see DbQuery::execute
	 */
	public function open($sql='', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM) {
		$this->dataSet = $this->execute($sql, $rowFrom, $rowTo);
		$this->sql = $sql ;
		return $this->dataSet;
	}

	/**
	 * һеĸֵֵֶһ
	 * @param object $dataSet 
	 * @param integer $resultType ͣOCI_ASSOCOCI_NUM  OCI_BOTH
	 * @return array
	 */
	public function fetchRecord($dataSet=NULL, $resultType=MYSQL_BOTH) {
		$result = @mysql_fetch_array(($dataSet) ? $dataSet : $this->dataSet, $resultType);
		return $result;
	}

	/**
	 * ȡֶ
	 * @param object $dataSet 
	 * @return integer
	 */
	public function getFieldCount($dataSet = NULL) {
	
		return mysql_num_fields(($dataSet) ? $dataSet : $this->dataSet);
	}
	
	/**
	 * ȡһ¼ؼ¼ţ˼¼β򷵻FALSE
	 * @return integer
	 * @access public
	 * @see getPrior()
	 */
	public function next() {
		return $this->fetchRecord();
	}
	
	/**
	 * õǰݿʱ䣬ʽΪyyyy-mm-dd hh:mm:ss
	 * @return string
	 * @access public
	 */
	public function getNow() {
		return $this->getValue('SELECT NOW() AS dateOfNow');
	}
	
	/**
	 * SQLݱȡݣֻȡһ¼ֵ
	 * ¼ֻһֶΣֵֶֻ
	 * δҵ FALSE
	 *
	 * @param string $sql SQL
	 * @return array
	 * @access public
	 */
	public function getValue($sql = '') { 
		$dataSet = $this->execute($sql, 1, 1);
		if ($result = $this->fetchRecord($dataSet)) {
			$fieldCount = $this->getFieldCount($dataSet);
			$this->close($dataSet);
			return ($fieldCount<=1) ? $result[0] : $result;
		} else {
			return false ;
		}
	}
	
	public function getInsertId() {
		return $this->getValue('SELECT LAST_INSERT_ID()');
	}

	public function getSeq($seq = '') { 
		$this->execute('BEGIN TRANSACTION adodbseq');
		$ok = $this->execute("update $seq with (tablock,holdlock) set id = id + 1", 0, self::MAX_ROW_NUM, false);
		if (!$ok) {
			$this->execute("create table $seq (id float(53))");
			$ok = $this->execute("insert into $seq with (tablock,holdlock) values(1)", 0, self::MAX_ROW_NUM, false);
			if (!$ok) {
				$this->execute('ROLLBACK TRANSACTION adodbseq');
				return false;
			}
			$this->execute('COMMIT TRANSACTION adodbseq'); 
			return 1;
		}
		$num = $this->getValue("select id from $seq");
		$this->execute('COMMIT TRANSACTION adodbseq'); 
		return $num;
	}
	/**
	 * Ƿڣtrue
	 * @param string $tableName Ҫѯı
	 * @return bool
	 * @access public
	 */
	public function tableIsExists($tableName) {
		$result = @mysql_query('SELECT * FROM ' . $tableName . ' LIMIT 0,1', $this->db->connect);
		return $result!==false;
	}
	
	/**
	 * ʼ
	 * @access public
	 */
	public function begin() {
		$this->transCnt += 1;
	   	$this->execute('BEGIN TRAN');
	   	return true;
	}
	
	/**
	 * ύ
	 * @access public
	 */
	public function commit() {
		if ($this->transCnt) {
			$this->transCnt -= 1;
		}
		$this->execute('COMMIT TRAN');
		return true;
	}
	
	/**
	 * ع
	 * @access public
	 */
	public function rollback() {
		if ($this->transCnt){
			$this->transCnt -= 1;
		}
		$this->execute('ROLLBACK TRAN');
		return true;
	}
	
	/**
	 * һ¼
	 * @param string $tableName 
	 * @param array $fieldArray ֶ
	 * @param string $whereForUnique Ψһ
	 * @return int
	 * @access public
	 */
	public function insert($tableName, $fieldArray, $whereForUnique = NULL) {
		if (!$tableName || !$fieldArray || !is_array($fieldArray)) {
			throw new Exception(' $tableName  $fieldArray ֵϷ');
		}
		if ($whereForUnique) {
			$where = ' WHERE ' . $whereForUnique;
			$isExisted = $this->getValue('SELECT COUNT(*) FROM ' . $tableName . $where);
			if ($isExisted) {
				throw new DbException('¼Ѿڣ', DbException::DB_RECORD_IS_EXISTED);
			}
		}
		$fieldNameList = array();
		$fieldValueList = array();
		foreach ($fieldArray as $fieldName => $fieldValue) {
			if (!is_int($fieldName)) {
				$fieldNameList[] = $fieldName;
				$fieldValueList[] = '\'' . $fieldValue . '\'';
			}
		}
		$fieldName = implode(',', $fieldNameList);
		$fieldValue = implode(',', $fieldValueList);
		$sql = 'INSERT INTO ' . $tableName . '('
					. $fieldName . ') VALUES (' . $fieldValue . ')';
		
		return $this->execute($sql);
	}
	
	/**
	 * һ¼
	 * @param string $tableName 
	 * @param array $fieldArray ֶ
	 * @param string $whereForUpdate ѯ
	 * @param string $whereForUnique Ψһ
	 * @return int
	 * @access public
	 */
	public function update($tableName, $fieldArray, $whereForUpdate=NULL, $whereForUnique=NULL) {
		if (!$tableName || !$fieldArray || !is_array($fieldArray)) {
			throw new Exception(' $tableName  $fieldArray ֵϷ');
		}
		if ($whereForUnique) {
			$where = ' WHERE ' . $whereForUnique;
			$isExisted = $this->getValue('SELECT COUNT(*) FROM ' . $tableName . $where);
			if ($isExisted) {
				throw new DbException('¼Ѿڣ', DbException::DB_RECORD_IS_EXISTED);
			}
		}
		$fieldNameValueList = array();
		foreach ($fieldArray as $fieldName => $fieldValue) {
			if (!is_int($fieldName)) {
				$fieldNameValueList[] = $fieldName . '=\'' . $fieldValue . '\'';
			}
		}
		$fieldNameValue = implode(',', $fieldNameValueList);
		if ($whereForUpdate) {
			$whereForUpdate = ' WHERE ' . $whereForUpdate;
		}
		$sql = 'UPDATE ' . $tableName 
				. ' SET ' . $fieldNameValue . $whereForUpdate;
		return $this->execute($sql);
	}
	
	/**
	 * ѡһ¼
	 * @param string $sql sql
	 * @param string $dataFormat ݸʽ, ֵ"array","hashmap","hashmap_str","dataset"
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @result array
	 * @access public
	 */
	public function select($sql, $dataFormat = 'array', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM) {
		$dataSet = $this->execute($sql, $rowFrom, $rowTo);
		switch ($dataFormat) {
		case 'array': //
			$result = array();
			$isMultiField = ($this->getFieldCount($dataSet) > 1);
			$i = 0;
			while ($data = $this->fetchRecord($dataSet)) {
				$result[$i] = ($isMultiField) ? $data : $data[0];
				$i++;
			}
			$this->close($dataSet);
			break;

		case 'hashmap': //ɢб
			$result = array();
			while ($data = $this->fetchRecord($dataSet)) {
				$result[ $data[0] ] = $data[1];
			}
			$this->close($dataSet);
			break;

		case 'hashmap_str': //ɢбַ
			$result = array();
			while ($data = $this->fetchRecord($dataSet, OCI_NUM)) {
				$result[] = $data[0] . '=' . $data[1];
			}
			$result = implode('|', $result);
			$this->close($dataSet);
			break;

		default: //dataset ݼݸʽΪݼʱselectĹexecuteͬ
			$result = $dataSet;
		}
		return $result;
	}
	
	/**
	 * ֵ
	 * @param string $tableName 
	 * @param string $idField ֶ
	 * @param string $where ѯ
	 * @return int
	 * @access public
	 */
	public function getMax($tableName, $idField, $where = NULL) {
		$where = ($where) ? (' WHERE ' . $where) : '';
		return $this->getValue('SELECT MAX(' . $idField . ') FROM ' . $tableName . $where);
	}
}
?>
