<?php
/**
 * Oricle ݿ
 *
 * @author һ yandy@yanwee.com
 * @package 1.0
 * @version $Id$
 */


define('OCI_RETURN_ALLS',OCI_BOTH + OCI_RETURN_LOBS);
/**
 *  Oracle ݿDbQueryForOracle
 *
 * @package .lib.db
 * @author κ
 */
class DbQueryForOracle {
	/**
	 * selectص¼
	 */
	const MAX_ROW_NUM = 1000;

	/**
	 * ݲѯ
	 * @var object $dataSet
	 */
	public $dataSet			= NULL ;

	/**
	 * Դ
	 * @var object $ds
	 */
	public $ds				= NULL ;

	/**
	 * ѯSQL
	 * @var string $sql
	 */
	public $sql				= '' ;
	
	/**
	 * ִвѯģʽֵΪ OCI_COMMIT_ON_SUCCESS  OCI_DEFAULT
	 * @var string $excuteMode
	 */
	public $executeMode	= OCI_COMMIT_ON_SUCCESS ;

	/**
	 * 캯
	 * @param object $ds ݿ
	 * @param string $sql ҪʼѯSQL
	 */
	function __construct($ds=NULL , $sql=NULL) {
		if (!$ds) {
			$this->error(DbException::DB_UNCONNECTED, 'ݿ⻹δӡ');
		} else {
			$this->ds = $ds;
			if ($sql) {
				$this->open($sql);
			}
		}
	}
	
	/**
	 * ͷռõڴ
	 * @param object $dataSet ҪͷԴĽ
	 * @access public
	 */
	public function close($dataSet=NULL) {
		if ($dataSet) {
			@oci_free_statement($dataSet);
		} else {
			@oci_free_statement($this->dataSet);
			$this->eof = false ;
			$this->recordCount = 0 ;
			$this->recNo = -1 ;
		}
	}
	
	/**
	 * $passݿ,ؼֵ֮
	 * @param string $pass Ҫַܵ
	 * @return string
	 * @access public
	 */
	public function encodePassword($pass) {
		return md5($pass);
	}
	
	/**
	 * õϢʹ
	 * @param integer $queryResult ѯ
	 * @return array
	 * @access protected
	 */
	protected function errorInfo($queryResult = NULL) {
		$result = oci_error($this->ds->connect);
		return $result;
	}
	
	/**
	 * Ϣ
	 * @param string $errorId ID
	 * @param string $errorMessage Ϣ
	 * @access protected
	 */
	protected function error($errorId, $errorMessage) {
		throw new DbException($errorMessage, $errorId);
	}
	
	/**
	 * ִSQL
	 * @param string $sql SQL
	 * @return object
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @access public
	 * @see DbQuery::open
	 */
	public function execute($sql = '', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM) {
		if ($rowFrom != 0 || $rowTo != self::MAX_ROW_NUM) {
			$sql = 'select * from (select row_.*, rownum rownum_ from ('
					. $sql . ') row_ where rownum <= '
					. $rowTo . ') where rownum_ >= ' . $rowFrom;
		}
		//echo $sql . '<br>';
		//$start = microtime(true);
		$dataSet = @oci_parse($this->ds->connect, $sql);
		$executeSucceed = @oci_execute($dataSet, $this->executeMode);
		//echo 'sql:'. ((string)(microtime(true)-$start)) . '<br>';
		if (!$dataSet || !$executeSucceed) {
			$sqlError = $this->errorInfo();
			$errorMessage = 'ִ[<b><font color="#FF0000">' . $sql 
					. '</font></b>]<br> <font color=#FF0000> ['
					. $sqlError['code'] . ']: '
					. $sqlError['message'] . '</font>' ;
			$this->error(DbException::DB_QUERY_ERROR, $errorMessage);
		}
		return $dataSet;
	}
	
	/**
	 * ִSQL䣬浽$dataSet
	 * @param string $sql SQL
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @return object
	 * @access public
	 * @see DbQuery::execute
	 */
	public function open($sql='', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM) {
		$this->dataSet = $this->execute($sql, $rowFrom, $rowTo);
		$this->sql = $sql ;
		return $this->dataSet;
	}

	/**
	 * һеĸֵֵֶһ
	 * @param object $dataSet 
	 * @param integer $resultType ͣOCI_ASSOCOCI_NUM  OCI_BOTH
	 * @return array
	 */
	public function fetchRecord($dataSet=NULL, $resultType=OCI_BOTH) {
		$result = @oci_fetch_array(($dataSet) ? $dataSet : $this->dataSet, $resultType);
		if (is_array($result)) {
			foreach ($result as $key => $value) {
				if (!is_numeric($key)) {
					$result[strtolower($key)] = $value;
				}
			}
		}
		return $result;
	}


	public function snext() {
		$result = @oci_fetch_array($this->dataSet, OCI_BOTH);
		return $result;
	}
	/**
	 * ȡֶ
	 * @param object $dataSet 
	 * @return integer
	 */
	public function getFieldCount($dataSet = NULL) {
		return oci_num_fields(($dataSet) ? $dataSet : $this->dataSet);
	}
	
	/**
	 * ȡһ¼ؼ¼ţ˼¼β򷵻FALSE
	 * @return integer
	 * @access public
	 * @see getPrior()
	 */
	public function next() {
		return $this->fetchRecord();
	}
	
	/**
	 * õǰݿʱ䣬ʽΪyyyy-mm-dd hh:mm:ss
	 * @return string
	 * @access public
	 */
	public function getNow() {
		return $this->getValue('SELECT TO_CHAR(SYSDATE, \'YYYY-MM-DD HH24:MI:SS\') dateOfNow FROM DUAL');
	}
	
	/**
	 * SQLݱȡݣֻȡһ¼ֵ
	 * ¼ֻһֶΣֵֶֻ
	 * δҵ FALSE
	 *
	 * @param string $sql SQL
	 * @return array
	 * @access public
	 */
	public function getValue($sql = '', $hasClob = false) { 
		$dataSet = $this->execute($sql, 1, 1);
		if ($hasClob) {
			$returnType = OCI_RETURN_ALLS;
		} else {
			$returnType = OCI_BOTH;
		}
		if ($result = $this->fetchRecord($dataSet,$returnType)) {
			$fieldCount = $this->getFieldCount($dataSet);
			$this->close($dataSet);
			return ($fieldCount<=2) ? $result[0] : $result;
		} else {
			return false ;
		}
	}

	public function getSeq($seqName = '') { 
		$dataSet = $this->execute('SELECT '.$seqName.'.nextval from sys.dual');
		if ($result = $this->fetchRecord($dataSet)) {
			$fieldCount = $this->getFieldCount($dataSet);
			$this->close($dataSet);
			return ($fieldCount<=2) ? $result[0] : $result;
		} else {
			return false ;
		}
	}
	/**
	 * Ƿڣtrue
	 * @param string $tableName Ҫѯı
	 * @return bool
	 * @access public
	 */
	public function tableIsExists($tableName) {
		return false;
	}
	
	/**
	 * ʼ
	 * @access public
	 */
	public function begin() {
		$this->executeMode = OCI_DEFAULT;
	}
	
	/**
	 * ύ
	 * @access public
	 */
	public function commit() {
		oci_commit($this->ds->connect);
		$this->executeMode = OCI_COMMIT_ON_SUCCESS;
	}
	
	/**
	 * ع
	 * @access public
	 */
	public function rollback() {
		oci_rollback($this->ds->connect);
		$this->executeMode = OCI_COMMIT_ON_SUCCESS;
	}
	
	/**
	 * һ¼
	 * @param string $tableName 
	 * @param array $fieldArray ֶ
	 * @param string $whereForUnique Ψһ
	 * @return int
	 * @access public
	 */
	public function insert($tableName, $fieldArray, $whereForUnique = NULL, $clobField = NULL ) {
		if (!$tableName || !$fieldArray || !is_array($fieldArray)) {
			throw new Exception(' $tableName  $fieldArray ֵϷ');
		}
		if ($whereForUnique) {
			$where = ' WHERE ' . $whereForUnique;
			$isExisted = $this->getValue('SELECT COUNT(*) FROM ' . $tableName . $where);
			if ($isExisted) {
				throw new DbException('¼Ѿڣ', DbException::DB_RECORD_IS_EXISTED);
			}
		}
		$fieldNameList = array();
		$fieldValueList = array();
		foreach ($fieldArray as $fieldName => $fieldValue) {
			if (!is_int($fieldName)) {
				$fieldNameList[] = $fieldName;
				if ($clobField && $clobField==$fieldName) {
					$fieldValueList[] = 'EMPTY_CLOB()';
					$hasClob = true;
					$clobStr = str_replace("''","'",$fieldValue);
				} else {
					$fieldValueList[] = '\'' . $fieldValue . '\'';
				}
			}
		}
		$fieldName = implode(',', $fieldNameList);
		$fieldValue = implode(',', $fieldValueList);
		$sql = 'INSERT INTO ' . $tableName . '('
					. $fieldName . ') VALUES (' . $fieldValue . ')';
		if ($hasClob) {
			$sql .= ' RETURNING content INTO :clob_string';
			$dataSet = oci_parse($this->ds->connect, $sql);
			$clob = oci_new_descriptor($this->ds->connect, OCI_D_LOB);
			oci_bind_by_name($dataSet, ':clob_string', $clob, -1, OCI_B_CLOB);
			oci_execute($dataSet, OCI_DEFAULT);
			$clob->save($clobStr);
			oci_commit($this->ds->connect);
			return $dataSet;
		} else {
			return $this->execute($sql);
		}
	}
	
	/**
	 * һ¼
	 * @param string $tableName 
	 * @param array $fieldArray ֶ
	 * @param string $whereForUpdate ѯ
	 * @param string $whereForUnique Ψһ
	 * @return int
	 * @access public
	 */
	public function update($tableName, $fieldArray, $whereForUpdate=NULL, $whereForUnique=NULL, $clobField = NULL) {
		if (!$tableName || !$fieldArray || !is_array($fieldArray)) {
			throw new Exception(' $tableName  $fieldArray ֵϷ');
		}
		if ($whereForUnique) {
			$where = ' WHERE ' . $whereForUnique;
			$isExisted = $this->getValue('SELECT COUNT(*) FROM ' . $tableName . $where);
			if ($isExisted) {
				throw new DbException('¼Ѿڣ', DbException::DB_RECORD_IS_EXISTED);
			}
		}
		$fieldNameValueList = array();
		foreach ($fieldArray as $fieldName => $fieldValue) {
			if (!is_int($fieldName)) {
				if ($clobField && $clobField==$fieldName) {
					$fieldNameValueList[] = $fieldName . '=EMPTY_CLOB()';
					$hasClob = true;
					$clobStr = str_replace("''","'",$fieldValue);
				} else {
					$fieldNameValueList[] = $fieldName . '=\'' . $fieldValue . '\'';
				}
			}
		}
		$fieldNameValue = implode(',', $fieldNameValueList);
		if ($whereForUpdate) {
			$whereForUpdate = ' WHERE ' . $whereForUpdate;
		}
		$sql = 'UPDATE ' . $tableName 
				. ' SET ' . $fieldNameValue . $whereForUpdate;
		if ($hasClob) {
			$sql .= ' RETURNING content INTO :clob_string';
			$dataSet = oci_parse($this->ds->connect, $sql);
			$clob = oci_new_descriptor($this->ds->connect, OCI_D_LOB);
			oci_bind_by_name($dataSet, ':clob_string', $clob, -1, OCI_B_CLOB);
			oci_execute($dataSet, OCI_DEFAULT);
			$clob->save($clobStr);
			oci_commit($this->ds->connect);
			return $dataSet;
		} else {
			return $this->execute($sql);
		}
	}
	
	/**
	 * ѡһ¼
	 * @param string $sql sql
	 * @param string $dataFormat ݸʽ, ֵ"array","hashmap","hashmap_str","dataset"
	 * @param int $rowFrom ʼкţкŴ1ʼ
	 * @param int $rowTo кţֵΪ0ʾ
	 * @result array
	 * @access public
	 */
	public function select($sql, $dataFormat = 'array', $rowFrom = 0, $rowTo = self::MAX_ROW_NUM, $hasClob = false) {
		$dataSet = $this->execute($sql, $rowFrom, $rowTo);
		switch ($dataFormat) {
		case 'array': //
			$result = array();
			$isMultiField = ($this->getFieldCount($dataSet) > 1);
			$i = 0;
			if ($hasClob) {
				$returnType = OCI_RETURN_ALLS;
			} else {
				$returnType = OCI_BOTH;
			}
			while ($data = $this->fetchRecord($dataSet,$returnType)) {
				$result[$i] = ($isMultiField) ? $data : $data[0];
				$i++;
			}
			$this->close($dataSet);
			break;

		case 'hashmap': //ɢб
			$result = array();
			while ($data = $this->fetchRecord($dataSet)) {
				$result[ $data[0] ] = $data[1];
			}
			$this->close($dataSet);
			break;

		case 'hashmap_str': //ɢбַ
			$result = array();
			while ($data = $this->fetchRecord($dataSet, OCI_NUM)) {
				$result[] = $data[0] . '=' . $data[1];
			}
			$result = implode('|', $result);
			$this->close($dataSet);
			break;

		default: //dataset ݼݸʽΪݼʱselectĹexecuteͬ
			$result = $dataSet;
		}
		return $result;
	}
	
	/**
	 * ֵ
	 * @param string $tableName 
	 * @param string $idField ֶ
	 * @param string $where ѯ
	 * @return int
	 * @access public
	 */
	public function getMax($tableName, $idField, $where = NULL) {
		$where = ($where) ? (' WHERE ' . $where) : '';
		return $this->getValue('SELECT MAX(' . $idField . ') FROM ' . $tableName . $where);
	}
}
?>
