<?php
/**
 * 基本文字回复处理类
 * 
 * [WeEngine System] Copyright (c) 2013 WE7.CC
 */
defined('IN_IA') or exit('Access Denied');

class BasicModuleProcessor extends WeModuleProcessor {
    
    public $name = 'Basic';

    public function isNeedInitContext() {
        return 0;
    }
	
    public function respond() {
        $rids = array();
        foreach($this->rules as $rule) {
            if(strtolower($rule['module']) == 'basic') {
                $rids[] = intval($rule['id']);
            }
        }
        $ids = implode($rids, ',');
        $sql = "SELECT * FROM " . tablename('basic_reply') . " WHERE `rid` IN ({$ids})";
        $sql .= " ORDER BY RAND() LIMIT 1";
        $reply = pdo_fetch($sql);
        $reply['content'] = htmlspecialchars_decode($reply['content']);
        //过滤HTML
        $reply['content'] = str_replace(array('<br>', '&nbsp;'), array("\n", ' '), $reply['content']);
        $reply['content'] = strip_tags($reply['content'], '<a>');
        $r = array();
        $r['FromUserName'] = $this->message['to'];
        $r['ToUserName'] = $this->message['from'];
        $r['MsgType'] = 'text';
        $r['Content'] = htmlspecialchars_decode($reply['content']);
        return $r;
    }

    public function isNeedSaveContext() {
        return false;
    }
}
