<?php 
/**
 * 用于微擎运行环境检测程序
 *
 * [WeEngine System] Copyright (c) 2013 WE7.CC
 */
require './source/bootstrap.inc.php';
$chk_func = array(
	array(
		'method' => 'ini_get',
		'name' => 'allow_url_fopen',
	),
	array(
		'method' => 'function_exists',
		'name' => 'mysql_connect',
	),
	array(
		'method' => 'function_exists',
		'name' => 'file_get_contents',
	),
	array(
		'method' => 'function_exists',
		'name' => 'fsockopen',
	),
	array(
		'method' => 'function_exists',
		'name' => 'xml_parser_create',
	),
	array(
		'method' => 'extension_loaded',
		'name' => 'pdo_mysql',
	),
	array(
		'method' => 'function_exists',
		'name' => 'curl_init',
	),
);
foreach ($chk_func as $func) {
	$result[$func['name']] = $func['method']($func['name']) ? '<font color=green>[√]On</font>' : '<font color=red>[×]Off</font>';
}
$result['chk_dir'] = array(
	'/data',
	'/data/logs',
	'/data/tpl',
	'/data/cookie',
	'/resource',
	'/resource/attachment'
);
foreach ($result['chk_dir'] as $dir) {
	if(!dir_writeable(IA_ROOT.$dir)) {
		if(is_dir(IA_ROOT.$dir)) {
			$result['chk_'.md5($dir)] = '<font color=red>[×]只读</font>';
		} else {
			$result['chk_'.md5($dir)] = '<font color=red>[×]不存在</font>';
		}
	} else {
		$result['chk_'.md5($dir)] = '<font color=green>[√]可写</font>';
	}
}

extract($result);
$chk_dir_html = '';
foreach ($chk_dir as $dir) {
    $status = 'chk_'.md5($dir);
    $chk_dir_html .= '
     <tr>
		<td>'.$dir.'</td>
  		<td><font color=green>[√]可写</font></td>
   		<td>'.$$status.'</td>
   	</tr>';    
}
echo <<<EOF
<style type="text/css">
body{margin:0; padding:0; font-size:14px;line-height:1.6;font-family:"微软雅黑",Helvetica,"宋体",Arial,Tahoma;background:#F9F9F9;}
.notice{padding-left:8px;height:25px;line-height:25px;overflow:hidden;color:red;background:#ffe27c;border:1px #ffc000 dashed;margin-top:3px;}
.twbox{border:1px solid #478fce;border-top:0;width:720px;font-size:12px;overflow:hidden;}
.twbox thead tr td{background:url(body_title_bg.gif) -1px -1px repeat-x;height:31px;line-height:31px;text-indent:10px;}
.twbox thead tr td strong{letter-spacing:2px;margin-right:14px;color:#FFF;font-size:14px;}
.twbox thead tr td span{color:#CDA;}
.twbox thead tr td p{height:31px;display:inline;float:right;overflow:hidden;margin:-31px 10px 0 0;}
.twbox thead tr td p *{float:right;}
.twbox thead tr td a.thlink{color:#FFF;}
.twbox thead tr td a.thlink:hover{color:#FF0;text-decoration:none;}
.twbox tbody{overflow:hidden;text-align:left;}
.twbox tbody tr th{background:#daecf9;color:#478fce;line-height:21px;height:21px;text-indent:30px;font-weight:400;border-bottom:1px solid #478fce;letter-spacing:2px;}
.twbox tbody tr td{border-bottom:1px solid #F2F2F2;color:#333;vertical-align:top;padding:7px;}
.twbox tbody tr td p{line-height:21px;}
.twbox tbody tr td img{vertical-align:top;margin:0 10px 5px 0;}
.twbox tbody tr td small{color:#888;}
.twbox tfoot tr td{line-height:25px;text-align:center;padding:10px;}
.twbox tfoot tr td p{line-height:21px;margin-bottom:10px;}
</style>
<div style="width:700; margin:0 auto;">
<div class="pr-title"><h3>程序依赖性检查</h3></div>
<table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
	<tr>
		<th width="200" align="center"><strong>需开启的变量或函数</strong></th>
		<th width="80"><strong>要求</strong></th>
		<th width="400"><strong>实际状态及建议</strong></th>
	</tr>
	<tr>
		<td>mysql_connect()</td>
		<td align="center">On </td>
		<td>{$mysql_connect} <small>(mysql_connect与pdo必须支持其中一个)</small></td>
	</tr>
	<tr>
		<td>PDO</td>
		<td align="center">On </td>
		<td>{$pdo_mysql} <small>(mysql_connect与pdo必须支持其中一个)</small></td>
	</tr>
	<tr>
		<td>allow_url_fopen</td>
		<td align="center">On </td>
		<td>{$allow_url_fopen} <small></small></td>
	</tr>
	<tr>
		<td>file_get_contents()</td>
		<td align="center">On</td>
		<td>{$file_get_contents} <small></small></td>
	</tr>
	<tr>
		<td>xml_parser_create()</td>
		<td align="center">On</td>
		<td>{$xml_parser_create} <small></small></td>
	</tr>
	<tr>
		<td>fsockopen()</td>
		<td align="center">On</td>
		<td>{$fsockopen} <small></small></td>
	</tr>
	<tr>
		<td>curl</td>
		<td align="center">On</td>
		<td>{$curl_init} <small></small></td>
	</tr>
</table>
<div class="notice">系统环境要求必须满足下列所有条件，否则系统或系统部份功能将无法使用。</div>

<div class="pr-title"><h3>目录权限检测</h3></div>
<table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
	<tr>
		<th width="300" align="center"><strong>目录名</strong></th>
		<th width="212"><strong>所需状态</strong></th>
		<th width="212"><strong>当前状态</strong></th>
	</tr>
    {$chk_dir_html}
</table>
<div class="notice">
	系统要求必须满足下列所有的目录权限全部可读写的需求才能使用，其它应用目录可安装后在管理后台检测。
</div>
EOF;

function dir_writeable($dir) {
	$writeable = 0;
	if(!is_dir($dir)) {
		@mkdir($dir, 0777);
	}
	if(is_dir($dir)) {
		if($fp = fopen("$dir/test.txt", 'w')) {
			fclose($fp);
			unlink("$dir/test.txt");
			$writeable = 1;
		} else {
			$writeable = 0;
		}
	}
	return $writeable;
}