<?php
//52挂Q核心类
defined('IN') or die('Access Denied');
class config
{
    function __construct()
    {
        $this->config_file = SITE_PATH.'/config/config_site.php';
        if (!file_exists($this->config_file))
            exit('未找到配置文件');
        
    }
    function get($ini, $type = "string")
    {
        $str = file_get_contents($this->config_file);
        if ($type == "int") {
            $config = preg_match("/" . preg_quote($ini) . "=(.*);/", $str, $res);
            return $res[1];
        } else {
            $config = preg_match("/" . preg_quote($ini) . "=\"(.*)\";/", $str, $res);
            if ($res[1] == null) {
                $config = preg_match("/" . preg_quote($ini) . "='(.*)';/", $str, $res);
            }
            return $res[1];
        }
    }
    
    function update($ini_array, $type = "string")
    {
        //$ini,$value,
        $str = file_get_contents($this->config_file);
        foreach ($ini_array as $ini => $value) {
            if ($type == "int") {
                $str = preg_replace("/define\(\'{$ini}\',.*?\)/", 'define(\'' . $ini . '\',' . $value . ')', $str);
            } else {
                $str = preg_replace("/define\(\'{$ini}\',.*?\)/", 'define(\'' . $ini . '\',\'' . addslashes($value) . '\')', $str);
            }
        }
        @$write = file_put_contents($this->config_file, $str);
        if ($write) {
            return true;
        } else {
            return false;
        }
    }
	function plugin_update($ini_array, $file_path,$type = "string")
    {
        //$ini,$value,
        $file_path=SITE_PATH.'/plugins/'.$file_path.'/config_plugin.php';
		$str = file_get_contents($file_path);
        foreach ($ini_array as $ini => $value) {
            if ($type == "int") {
                $str = preg_replace("/define\(\'{$ini}\',.*?\)/", 'define(\'' . $ini . '\',' . $value . ')', $str);
            } else {
                $str = preg_replace("/define\(\'{$ini}\',.*?\)/", 'define(\'' . $ini . '\',\'' . addslashes($value) . '\')', $str);
            }
        }
        @$write = file_put_contents($file_path, $str);
        if ($write) {
            return true;
        } else {
            return false;
        }
    }
    function file_mode_info($file_path)
    {
        /* 如果不存在，则不可读、不可写、不可改 */
        if (!file_exists($file_path)) {
            return false;
        }
        $mark = 0;
        if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
            /* 测试文件 */
            $test_file = $file_path . '/cf_test.txt';
            /* 如果是目录 */
            if (is_dir($file_path)) {
                /* 检查目录是否可读 */
                $dir = @opendir($file_path);
                if ($dir === false) {
                    return $mark; //如果目录打开失败，直接返回目录不可修改、不可写、不可读
                }
                if (@readdir($dir) !== false) {
                    $mark ^= 1; //目录可读 001，目录不可读 000
                }
                @closedir($dir);
                /* 检查目录是否可写 */
                $fp = @fopen($test_file, 'wb');
                if ($fp === false) {
                    return $mark; //如果目录中的文件创建失败，返回不可写。
                }
                if (@fwrite($fp, 'directory access testing.') !== false) {
                    $mark ^= 2; //目录可写可读011，目录可写不可读 010
                }
                @fclose($fp);
                @unlink($test_file);
                /* 检查目录是否可修改 */
                $fp = @fopen($test_file, 'ab+');
                if ($fp === false) {
                    return $mark;
                }
                if (@fwrite($fp, "modify test.\r\n") !== false) {
                    $mark ^= 4;
                }
                @fclose($fp);
                /* 检查目录下是否有执行rename()函数的权限 */
                if (@rename($test_file, $test_file) !== false) {
                    $mark ^= 8;
                }
                @unlink($test_file);
            }
            /* 如果是文件 */
            elseif (is_file($file_path)) {
                /* 以读方式打开 */
                $fp = @fopen($file_path, 'rb');
                if ($fp) {
                    $mark ^= 1; //可读 001
                }
                @fclose($fp);
                /* 试着修改文件 */
                $fp = @fopen($file_path, 'ab+');
                if ($fp && @fwrite($fp, '') !== false) {
                    $mark ^= 6; //可修改可写可读 111，不可修改可写可读011...
                }
                @fclose($fp);
                /* 检查目录下是否有执行rename()函数的权限 */
                if (@rename($test_file, $test_file) !== false) {
                    $mark ^= 8;
                }
            }
        } else {
            if (@is_readable($file_path)) {
                $mark ^= 1;
            }
            if (@is_writable($file_path)) {
                $mark ^= 14;
            }
        }
        return $mark;
    }
} 