<?php
//52挂Q核心类
defined('IN') or die('Access Denied');
class Page
{
    public $count; #结果总数
    public $page; #当前页
    public $pagesize; #每页结果数
    public $pagecount; #翻页数
    public $baseurl; #url
    public $result; #结果数组集
    public $pagelist; #每翻页数
    
    #构造函数，初始化变量
    function __construct($count, $page, $pagesize, $pagelist, $baseurl = false)
    {
        $this->count    = $count;
        $this->page     = $page;
        $this->pagesize = $pagesize;
        $this->baseurl  = isset($baseurl) ? $baseurl : $this->__geturl();
        $this->pagelist = $pagelist;
    }
    
    #获得当前url
    function __geturl()
    {
        return ereg_replace("(^|&)page={$page}", "", $_SERVER['QUERY_STRING']);
    }
    
    #获得分页列表
    function __getpagelist()
    {
        $this->result['count']     = $this->count;
        $this->result['page']      = $this->page;
        $this->result['pagesize']  = $this->pagesize;
        $this->result['pagecount'] = ceil($this->count / $this->pagesize);
        if ($this->result['pagecount'] <= 1) //只有一页以下
            {
            $this->result['pagelist'] = 0;
            $this->result['first']    = $this->result['pre'] = $this->result['next'] = $this->result['last'] = 0;
        } else //一页以上
            {
            #前一页，第一页的算法
            $this->result['first'] = ($this->page == 1) ? 0 : 1;
            $this->result['pre']   = ($this->page == 1) ? 0 : 1;
            #后一页，最后一页的算法
            $this->result['next']  = ($this->page == $this->result['pagecount']) ? 0 : 1;
            //if($this->page==$this->pagecount ){ $this->result['next'] = 0 ;}else{$this->result['next']=1;}
            $this->result['last']  = ($this->page == $this->result['pagecount']) ? 0 : 1;
            //echo $this->page.$this->result['pagecount'];
            
            
            #起始
            $pagearray = array();
            $start     = floor(($this->page - 1) / 10) * 10 + 1;
            $count     = 10;
            if ($this->result['pagecount'] - $start < 10) {
                $count = $this->result['pagecount'] - $start + 1;
            }
            
            //if($this->result['pagecount']<$count){$count=$this->result['pagecount'];}
            for ($i = 0; $i < $count; $i++) {
                if (($start + $i) <= $this->result['pagecount']) {
                    $pagearray[$i]['page'] = $start + $i;
                }
                if (($start + $i) != $this->page) {
                    $pagearray[$i]['link'] = 1;
                } else {
                    $pagearray[$i]['link'] = 0;
                }
            }
            #分页导航列表
            $this->result['pagelist'] = $pagearray;
            $this->result['baseurl']  = $this->baseurl;
        }
    }
}
?> 