<?php
//52挂Q核心类
defined('IN') or die('Access Denied');
class sysinfo
{
    public function GetServerTime()
    {
        return date('Y-m-d　H:i:s');
    }
    
    public function GetServerSoftwares()
    {
        return $_SERVER['SERVER_SOFTWARE'];
    }
    
    public function GetPhpVersion()
    {
        return PHP_VERSION;
    }
    
    public function GetMysqlVersion()
    {
        return mysql_get_server_info();
    }
    
    public function GetHttpVersion()
    {
        return $_SERVER['SERVER_PROTOCOL'];
    }
    
    public function GetDocumentRoot()
    {
        return $_SERVER['DOCUMENT_ROOT'];
    }
    
    public function GetMaxExecutionTime()
    {
        return ini_get('max_execution_time') . ' Seconds';
    }
    
    public function GetServerFileUpload()
    {
        if (@ini_get('file_uploads')) {
            return '允许 ' . ini_get('upload_max_filesize');
        } else {
            return '<font color="red">禁止</font>';
        }
    }
    
    public function GetRegisterGlobals()
    {
        return $this->GetPhpCfg('register_globals');
    }
    
    public function GetSafeMode()
    {
        return $this->GetPhpCfg('safe_mode');
    }
    
    public function GetGdVersion()
    {
        if (function_exists('gd_info')) {
            $GDArray           = gd_info();
            $gd_version_number = $GDArray['GD Version'] ? $GDArray['GD Version'] : '不支持';
        } else {
            $gd_version_number = '不支持';
        }
        return $gd_version_number;
    }
    
    public function GetMemoryUsage()
    {
        return $this->ConversionDataUnit(memory_get_usage());
    }
    
    private function ConversionDataUnit($size)
    {
        $kb = 1024; // Kilobyte
        $mb = 1024 * $kb; // Megabyte
        $gb = 1024 * $mb; // Gigabyte
        $tb = 1024 * $gb; // Terabyte
        //round() 对浮点数进行四舍五入
        if ($size < $kb) {
            return $size . ' Byte';
        } else if ($size < $mb) {
            return round($size / $kb, 2) . ' KB';
        } else if ($size < $gb) {
            return round($size / $mb, 2) . ' MB';
        } else if ($size < $tb) {
            return round($size / $gb, 2) . ' GB';
        } else {
            return round($size / $tb, 2) . ' TB';
        }
    }
    
    private function GetPhpCfg($val)
    {
        switch ($result = get_cfg_var($val)) {
            case 0:
                return '关闭';
                break;
            case 1:
                return '打开';
                break;
            default:
                return $result;
                break;
        }
    }
    function GetFreeDisk($val)
    {
        if(function_exists('disk_free_space')) {
				$result = floor(disk_free_space($val) / (1024*1024)).'M';
			} else {
				$result = '未知';
			}
			return $result;
    }
} //类定义结束

?> 