var H = {};

H.TabManager = function(pList,pActiveStyle,pDisableStyle){
    var _self = this;
    var _obj = {
        List: pList,
        ActiveStyle: pActiveStyle,
        DisableStyle: pDisableStyle
    };
    var _ChangeHandler;
    var time ;
    var _autoTimer;
    this._autoTimeOut = 5000;
    this.Animate = false
    var overObj;
    var activeIndex;
    var _autostate = false;
    function display(){
        for(var j = 0; j < _obj.List.length; j++){
            var ele = _obj.List[j].Tab;
            ele.removeClass(_obj.ActiveStyle);
            ele.addClass(_obj.DisableStyle);
            if(_self.Animate){
                _obj.List[j].Content.fadeOut();
            }
            else{
                _obj.List[j].Content.hide();
            }
        }

        overObj.Tab.addClass(_obj.ActiveStyle);
        if(_self.Animate){
            overObj.Content.fadeIn();
        }
        else{
            overObj.Content.show();
        }
        if(_ChangeHandler){
            _ChangeHandler(overObj);
        }
    }

    function autoDisplay(){
        activeIndex++;
        if(activeIndex >= _obj.List.length){
            activeIndex = 0;
        }
        overObj = _obj.List[activeIndex];
        display();
    }

    var init = function(){
        for(var i = 0; i < _obj.List.length; i++){
            var item = _obj.List[i];
            item.Tab.bind("mouseover",{
                obj:item,
                index:i
            },function(e){
                overObj = e.data.obj;
                activeIndex = e.data.index;
                time = window.setTimeout(display,300);
                _self.SetAuto(_autostate);
            }).bind("click",{
                obj:item,
                index:i
            },function(e){
                overObj = e.data.obj;
                activeIndex = e.data.index;
                if(time){
                    window.clearTimeout(time);
                }
                display();
                this.blur();
                _self.SetAuto(_autostate);
            }).bind("mouseout",function(){
                if(time){
                    window.clearTimeout(time);
                }
            });
        }

    }
	
    this.RemoveMouseOver = function(){
        for(var i = 0; i < _obj.List.length; i++){
            var item = _obj.List[i];
            item.Tab.unbind("mouseover");
            
        }
    }
	
    this.Stop = function(){
        if(_autoTimer){
            window.clearInterval(_autoTimer);
        }
    }
    
    this.Start = function(){
        _self.SetAuto(_autostate);
    }
	
    this.SetAuto = function(v){
        if(_autoTimer){
            window.clearInterval(_autoTimer);
        }
        if(v){
            _autoTimer = window.setInterval(autoDisplay,_self._autoTimeOut);
        }
        _autostate = v;
    }
    this.SetChangeHandler = function(pHandler){
        _ChangeHandler = pHandler;
    },
    this.Select = function(key){
        activeIndex = key;
        overObj = _obj.List[key];
        display();
    }
    init();
}


H.Login = (function(){
    
    var _cache = {};
    
    var checkInputVal = function(){
        if(_cache.inputs){
            for(var i = 0, len = _cache.inputs.length; i < len; i++){
                var input = _cache.inputs[i];
                var label = input.prev();
                if(input.val() != ""){   
                    label.css("display") != "none" && label.hide();
                }
                else{
                    label.css("display") == "none" && label.show();
                }
            }
        }
    }
    
    var checkFun = function(input){
        var val = input.val();
        var type = input.attr("errortype");
        switch(type){
            case "notempty":
                if($.trim(val) == ""){
                    return false;
                }
                if(input.attr("minlen") && val.length < Number(input.attr("minlen"))){
                    return false;
                }
                break;
        }
        
        return true;
    }
    
    var showMsg = function(input, error_msg){
        var par = input.parent();
        var hint = par.find(".popup-hint");
        var warIco = par.find(".ico-war");
        var msg = input.attr("errmsg");
        if(!hint.length){
            hint = $('<span class="popup-hint" style="z-index:3"><i></i>'+msg+'</span>');
            warIco = $('<b class="ico-war"></b>');
            warIco.on("mouseover", function(){
                warIco.attr("is_over", "1");
                hint.show();
            }).on("mouseout", function(){
                warIco.attr("is_over", "");
                hint.hide();
            });
            
            par.append(warIco);
            par.append(hint);
        }
        if(error_msg){
            msg = error_msg;
        }
        hint.html('<i></i>' + msg);
        warIco.show();
        hint.show();
        /*window.setTimeout(function(){
            if(!warIco.attr("is_over")){
                hint.hide();
            }
        }, 2000);*/
        input.addClass("text-war");
        
    }
    
    var hideMsg = function(input){
        var par = input.parent();
        var hint = par.find(".popup-hint");
        var warIco = par.find(".ico-war");
        if(hint.length){
            hint.hide();
        }
        if(warIco.length){
            warIco.hide();
        }
        input.removeClass("text-war");
    }
    
    var _focusTimer;
    var bindInput = function(input){
        var label = input.prev();
        label.on("mouseover", function(){
            if(_focusTimer) window.clearTimeout(_focusTimer);
            _focusTimer = window.setTimeout(function(){
                input.focus();
            }, 200);
        }).on("mouseout", function(){
            if(_focusTimer) window.clearTimeout(_focusTimer);
        });
    }
    
    return {
        Init: function(form){
            var account = $("#account"), pwd = $("#passwd");
            _cache.inputs = [account, pwd];
            bindInput(account);
            account.on("keypress", function(e){
                if(e.keyCode == 13){
                    if($(this).val() && pwd.val() == ""){
                        window.setTimeout(function(){
                            pwd.focus();
                        }, 10);
                        return false;
                    }
                }
            });
            bindInput(pwd);
            for(var i = 0, len = _cache.inputs.length; i < len; i++){
                var ele = _cache.inputs[i];
                ele.on("keydown", function(){
                    hideMsg($(this));
                })
            }
            
            form.on("submit", function(){
                var res = true;
                var firstDom;
                for(var i = 0, len = _cache.inputs.length; i < len; i++){
                    var ele = _cache.inputs[i];
                    if(!checkFun(ele)){
                        showMsg(ele);
                        res = false;
                        if(!firstDom){
                            firstDom = ele;
                        }
                    }
                    else{
                        hideMsg(ele);
                    }
                }
                if(firstDom){
                    firstDom.focus();
                }
                return res;
            });
            
            window.setInterval(checkInputVal, 100);
        },
        ShowMsg: function(input, msg){
            showMsg(input, msg);
        },
        HideMsg: function(input){
            hideMsg(input);
        }
    }
})();

(function(){
    var focusTimer;
    
    $(document).on("mouseover", function(e){
        var el = e.target;
        var tagName = el.tagName.toUpperCase();
        if((tagName == "INPUT" && (el.type == "text" || el.type == "password")) || tagName == "TEXTAREA"){
            if(focusTimer) window.clearTimeout(focusTimer);
            focusTimer = window.setTimeout(function(){
                el.focus();
            }, 200);
        }
    }).on("mouseout", function(e){
        var el = e.target;
        var tagName = el.tagName.toUpperCase();
        if((tagName == "INPUT" && (el.type == "text" || el.type == "password")) || tagName == "TEXTAREA"){
            if(focusTimer) window.clearTimeout(focusTimer);
        }
    });
    
})();