var PP = window["PP"] || {};

PP.Vali = {};

PP.Vali.CONFIG = {
    MSGTemp: '<b class="ico-war"></b><span class="%1 %2"></span>',
    MSGClass: 'popup-hint',
    MSGErrClass: 'form-err',
    MSGIco: '<i></i>',
    MSGErrAttr: "data-error",

    ErrClass:"text-war",

    Dangerous: "passwd-level pwd-dangerous",
    Simple: "passwd-level pwd-simple",
    Safe: "passwd-level pwd-safe",
    LineTag: "i"
}


/**
 * 验证UI展现函数
 */
PP.Vali.UI = (function(){
    return {
        ShowErrorMsg: function(input, msg){
            var par = input.parent();
            var hint = par.find("." + PP.Vali.CONFIG.MSGClass);
            if(!hint.length){
                hint = $(String.format(PP.Vali.CONFIG.MSGTemp, PP.Vali.CONFIG.MSGClass, PP.Vali.CONFIG.MSGErrClass));
                par.append(hint);
                hint = hint.filter("span");
            }
            if(!msg){
                msg = input.attr(PP.Vali.CONFIG.MSGErrAttr);
            }
            hint.html(PP.Vali.CONFIG.MSGIco + msg);
            hint.show();
            hint.prev().show().mouseenter().mouseleave();
            input.addClass(PP.Vali.CONFIG.ErrClass);
        },
        HideErrorMsg: function(input){
            var par = input.parent();
            var hint = par.find("." + PP.Vali.CONFIG.MSGClass);
            if(hint.length){
                hint.hide();
                hint.prev().hide();
            }
            
            input.removeClass( PP.Vali.CONFIG.ErrClass);
        },
        CheckInput: function(el){
            var res = true;
            if(el.val() == ""){
                PP.Vali.UI.ShowErrorMsg(el);
                res = false;
            }
            else{
                var min = el.attr("minlen");
                if(min){
                    min = Number(min);
                    if(el.val().length < min){
                        PP.Vali.UI.ShowErrorMsg(el);
                        res = false;
                    }
                }
                var rate = el.attr("rate");
                if(rate){
                    if(el.val() != $("#" + rate).val()){
                        PP.Vali.UI.ShowErrorMsg(el);
                        res = false;
                    }
                }
            }
            return res;
        },
        BindInput: function(input, config){
            if(!config) config={};
            
            input.bind("keyup", function(){
                var el = $(this);
                if(el.val() != ""){
                    PP.Vali.UI.HideErrorMsg(el);
                }
            });
            
            if(!config.NotBlur){
                input.blur(function(){
                    var el = $(this);
                    if(el.val() != ""){
                        PP.Vali.UI.CheckInput(el);
                    }
                });
            }
        },
        CheckPasswod: function(config){
            if(!config) {
                config = {};
            }
            
            config.LineTag = config.LineTag || "i";
            
           //以下用于检查密码强度
            var agt = navigator.userAgent.toLowerCase();
            var is_op = (agt.indexOf("opera") != -1);
            var is_ie = (agt.indexOf("msie") != -1) && document.all && !is_op;
            var is_mac = (agt.indexOf("mac") != -1);
            var is_gk = (agt.indexOf("gecko") != -1);
            var is_sf = (agt.indexOf("safari") != -1);

            function gff(str, pfx){
                var i = str.indexOf(pfx);
                if (i != -1) {
                    var v = parseFloat(str.substring(i + pfx.length));
                    if (!isNaN(v)) {
                        return v;
                    }
                }
                return null;
            }

            function Compatible(){
                if (is_ie && !is_op && !is_mac) {
                    var v = gff(agt, "msie ");
                    if (v != null) {
                        return (v >= 6.0);
                    }
                }
                if (is_gk && !is_sf) {
                    var v = gff(agt, "rv:");
                    if (v != null) {
                        return (v >= 1.4);
                    }
                    else {
                        v = gff(agt, "galeon/");
                        if (v != null) {
                            return (v >= 1.3);
                        }
                    }
                }
                if (is_sf) {
                    var v = gff(agt, "applewebkit/");
                    if (v != null) {
                        return (v >= 124);
                    }
                }
                return false;
            }

            /* We also try to create an xmlhttp object to see if the browser supports it */
            var isBrowserCompatible = Compatible();

            //CharMode函数
            //测试某个字符是属于哪一类.
            function CharMode(iN){
                if (iN >= 48 && iN <= 57) //数字
                    return 1;
                if (iN >= 65 && iN <= 90) //大写字母
                    return 2;
                if (iN >= 97 && iN <= 122) //小写
                    return 4;
                else
                    return 8; //特殊字符
            }

            //bitTotal函数
            //计算出当前密码当中一共有多少种模式
            function bitTotal(num){
                modes = 0;
                for (i = 0; i < 4; i++) {
                    if (num & 1)
                        modes++;
                    num >>>= 1;
                }
                return modes;
            }
            //checkStrong函数
            //返回密码的强度级别
            function checkPasswdRate(sPW){
                if (sPW.length <= 5)
                    return 0; //密码太短
                Modes = 0;
                for (var i = 0; i < sPW.length; i++) {
                    //测试每一个字符的类别并统计一共有多少种模式.
                    Modes |= CharMode(sPW.charCodeAt(i));
                }
                return bitTotal(Modes);
            }

            config.Input.bind("keyup", function(){
                var val = $(this).val(), level = checkPasswdRate(val), levelStr = ["不合格", "弱", "一般", "强", "极强"];
                var className = PP.Vali.CONFIG.Dangerous;
                var persent = 0;
                if (level > 0 && level < 3) {
                    className = PP.Vali.CONFIG.Dangerous;
                    persent = "30%";
                }
                if (level > 2) {
                    if (level < 4) {
                        className = PP.Vali.CONFIG.Simple;
                        persent = "60%";
                    }
                    else {
                        className = PP.Vali.CONFIG.Safe;
                        persent = "100%";
                    }
                }
                
                config.Text.html(levelStr[level]);
                var strongBox = config.Strong;
                strongBox.removeClass().addClass(className);
                strongBox.find(config.LineTag).css({width: persent});
            });
        }
    }
})();

if(!String.format){
    String.format = function(str) {
        var args = arguments, re = new RegExp("%([1-" + args.length + "])", "g");
        return String(str).replace(
            re,
            function($1, $2) {
                return args[$2];
            }
            );
    };
}

if(String.formatmodel){
    String.formatmodel = function(str,model){
        for(var k in model){
            var re = new RegExp("{"+k+"}","g");
            str = str.replace(re,model[k]);
        }
        return str;
    }
}