<?php
// This is the handler for captcha image requests
// The captcha ID is placed in the session, so session vars are required for this plug-in
if (!isset($_SESSION)) {
	session_start();
}

// -------------------- EDIT THESE ----------------- //
$images = array(
  '十字'=> 'captcha/captchaImages/103.png',
  '信封'=> 'captcha/captchaImages/200.png',
  '房子'=> 'captcha/captchaImages/01.png',
  '钥匙'=> 'captcha/captchaImages/04.png',
  '旗帜'=> 'captcha/captchaImages/06.png',
  '钟表'=> 'captcha/captchaImages/15.png',
  '齿轮'=> 'captcha/captchaImages/235.png',
  '臭虫'=> 'captcha/captchaImages/16.png',
  '圆珠笔'=> 'captcha/captchaImages/19.png',
  '灯泡'=> 'captcha/captchaImages/21.png',
  '铅笔'=> 'captcha/captchaImages/560.png',
  '放大镜'=> 'captcha/captchaImages/233.png',
  '音符'=> 'captcha/captchaImages/40.png',
  '红心'=> 'captcha/captchaImages/43.png',
  '地球'=> 'captcha/captchaImages/99.png'
);
// ------------------- STOP EDITING ---------------- //

$_SESSION['simpleCaptchaAnswer'] = null;
$_SESSION['simpleCaptchaTimestamp'] = time();
$SALT = "o^Gj".$_SESSION['simpleCaptchaTimestamp']."7%8W";
$resp = array();

header("Content-Type: application/json");

if (!isset($images) || !is_array($images) || sizeof($images) < 3) {
  $resp['error'] = "There aren\'t enough images!";
  echo json_encode($resp);
  exit;
}

if (isset($_POST['numImages']) && strlen($_POST['numImages']) > 0) {
  $numImages = intval($_POST['numImages']);
} else if (isset($_GET['numImages']) && strlen($_GET['numImages']) > 0) {
  $numImages = intval($_GET['numImages']);
}
$numImages = ($numImages > 0)?$numImages:5;
$size = sizeof($images);
$num = min(array($size, $numImages));

$keys = array_keys($images);
$used = array();
mt_srand(((float) microtime() * 587) / 33);
for ($i=0; $i<$num; ++$i) {
  $r = rand(0, $size-1);
  while (array_search($keys[$r], $used) !== false) {
    $r = rand(0, $size-1);
  }
  array_push($used, $keys[$r]);
}
$selectText = $used[rand(0, $num-1)];
$_SESSION['simpleCaptchaAnswer'] = sha1($selectText . $SALT);

$resp['text'] = ''.$selectText;
$resp['images'] = array();

shuffle($used);
for ($i=0; $i<sizeof($used); ++$i) {
  array_push($resp['images'], array(
    'hash'=>sha1($used[$i] . $SALT),
    'file'=>$images[$used[$i]]
  ));
}
echo json_encode($resp);
exit;
?>