<?php
/**
 * 作者：露兜
 * 博客：http://www.ludou.org/
 *
 * 更新记录
 *  2012年02月23日 ：
 *  首个版本发布
 
 *  2012年09月19日 ：
 *  修改一些小错误
 *  
 *  更多内容详见：http://www.ludou.org/file-download-tool.html
 */
 
 
// 参数设置
$captcha = "#";	//将#替换成captcha文件夹的路径，如：http://www.abc.com/captcha/
$folder = "#";	//将#替换成你的文件存储目录路径，如：/home/abccom/public_html/file/ 或 D:/PHP/wp/
$home = "#";    //将#替换成你网站网址，如：www.abc.com，记住没有http://
$name = "#";    //将#替换成你网站名称，如：露兜博客

/**********************************************************
以下内容请勿修改，除非你懂
**********************************************************/

//header("Content-type: text/html; charset=utf-8");
date_default_timezone_set('Asia/Shanghai');

function myFileSize($file, $setup = null)
{
	// 文件大小单位换算
	$FZ = ($file && @is_file($file)) ? filesize($file) : NULL;
	$FS = array("B","kB","MB","GB","TB","PB","EB","ZB","YB");
    
	if(!$setup && $setup !== 0) 
		return number_format($FZ/pow(1024, $i=floor(log($FZ, 1024))), ($i >= 1) ? 2 : 0) . ' ' . $FS[$i];
	elseif ($setup == 'INT')
		return number_format($FZ);
	else
		return number_format($FZ/pow(1024, $setup), ($setup >= 1) ? 2 : 0 ). ' ' . $FS[$setup];
}

function wp_die($word, $title='') {
	// 错误提示
	if($title=='')
		$title = '下载错误';
		
	echo '<!DOCTYPE html>
	<html dir="ltr" lang="zh-CN">
	<head>
	<meta charset="UTF-8" />
	<title>'.$title.'</title>
	<script type="application/javascript">
	//<![CDATA[
	var pgo = 0;
	function JumpUrl() {
		if(pgo == 0) { 
			location = "javascript:history.go(-1);"; 
			pgo = 1; 
		}
	}
	setTimeout("JumpUrl()",5000);
	//]]>
	</script>
	</head>
	<body>
	<h2>'.$word.'</h2>
	<a href="javascript:history.go(-1);">如果你的浏览器没反应，请点击这里...</a>
	</body>
	</html>';
	exit();
}

if (empty($_SERVER['HTTP_REFERER']) || strpos(strtoupper($_SERVER['HTTP_REFERER']),strtoupper($home)) === false)
	wp_die('请从<a href="http://'.$home.'/">'.$name.'</a>下载此文件，请勿直接复制文件URL进行下载。', '下载错误 - 禁止盗链');

if (empty($_GET['f']))
  wp_die("文件不存在", '下载错误 - 文件不存在');

// Nullbyte hack fix
if (strpos($_GET['f'], "\0") !== FALSE)
	wp_die('文件不存在', '下载错误 - 文件不存在');

// Get real file name.
// Remove any path info to avoid hacking by adding relative path, etc.
$fname = basename($_GET['f']);

$file = $folder . $fname;

if(!is_file($file))
	wp_die('文件不存在', '下载错误 - 文件不存在');

if (!isset($_SESSION)) {
 	session_start();
	session_regenerate_id(TRUE);
}

if(!empty($_POST['bj_captchaSelection'])) {
	if ($_POST['bj_captchaSelection'] != $_SESSION['simpleCaptchaAnswer'])
		wp_die('请按提示点选正确的图标。', '下载错误 - 验证码错误');
	
	session_unset();
	session_destroy();

  //Gather relevent info about file
  $len = filesize($file);
  $filename = basename($file);
  $file_extension = strtolower(substr(strrchr($filename,"."),1));

  //This will set the Content-Type to the appropriate setting for the file
  switch( $file_extension ) {
  	case "zip": $ctype="application/zip"; break;
  	case "rar": $ctype="application/x-rar-compressed"; break;
    case "pdf": $ctype="application/pdf"; break;
    case "exe": $ctype="application/octet-stream"; break;
		case "doc": $ctype="application/msword"; break;
		case "xls": $ctype="application/vnd.ms-excel"; break;
		case "ppt": $ctype="application/vnd.ms-powerpoint"; break;
		case "gif": $ctype="image/gif"; break;
		case "png": $ctype="image/png"; break;
		case "jpeg":
		case "jpg": $ctype="image/jpg"; break;
		case "mp3": $ctype="audio/mpeg"; break;
		case "wav": $ctype="audio/x-wav"; break;
		case "mpeg":
		case "mpg":
		case "mpe": $ctype="video/mpeg"; break;
		case "mov": $ctype="video/quicktime"; break;
		case "avi": $ctype="video/x-msvideo"; break;

		//The following are for extensions that shouldn't be downloaded (sensitive stuff, like php files)
		case "php":
		case "htm":
		case "html":
		case "txt": wp_die($file_extension ." : 此后缀名的文件无法提供下载!", '下载错误 - 文件后缀错误'); break;

		default: $ctype="application/force-download";
   }

		//Begin writing headers
  	header("Pragma: public");
   	header("Expires: 0");
   	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
   	header("Cache-Control: public");
   	header("Content-Description: File Transfer");
   
   	//Use the switch-generated Content-Type
   	header("Content-Type: $ctype");

   	//Force the download
   	$header="Content-Disposition: attachment; filename=".$filename.";";
   	header($header );
   	header("Content-Transfer-Encoding: binary");
   	header("Content-Length: ".$len);
   	ob_clean();   
   	flush();
	 	readfile($file);
	 	exit;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><?php echo $fname; ?> - 文件下载</title>
<script type="text/javascript" src="http://ajax.aspnetcdn.com/ajax/jQuery/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="<?php echo $captcha; ?>jquery.simpleCaptcha-0.2.min.js"></script>
<script type="text/javascript">
//<![CDATA[
	$(document).ready(function() {
  $('#captcha_89').simpleCaptcha({
		numImages: 5,
  	introText: '<p>请您点选下面的 &quot;<strong class="captchaText"></strong>&quot; 图标，再进行下载</p>',
		scriptPath: '<?php echo $captcha; ?>simpleCaptcha.php',
		inputName: 'bj_captchaSelection'
	});
});
//]]>
</script>
<style type="text/css">
<!--
.captchaImage {
    padding: 2px;
}
.simpleCaptchaSelected {
    border: 2px solid #339933;
    padding: 0;
}
p {
	font-size:12px;
}
h1 {
    font-size: 15px;
    margin: 0 0 10px;
}
-->
</style>
</head>
<body style="padding:20px;border: 1px solid #ccc;margin: 20px auto;position: relative; width: 420px;">
<h1><?php echo $name; ?>文件下载</h1>
<p><strong>文件名称：</strong><?php echo $fname; ?></p>
<p><strong>文件大小：</strong><?php echo myFileSize($file); ?></p>
<form action="#" method="post">
	<div id="captcha_89"></div>
	<input type="submit" value="点此下载" id="submit" name="submit" />
</form>
</body>
</html>