<?php

/*-----------------------------------------------------------------------------------

 	Plugin Name: WP Recently Viewed
 	Plugin URI: http://www.ludou.org/wordpress-recently-viewed.html
 	Description: 在WordPress中显示访客最近阅读过的文章列表
 	Version: 1.0
 	Author: 露兜
 	Author URI: http://www.ludou.org/
 
-----------------------------------------------------------------------------------*/


// Add function to widgets_init that'll load our widget
add_action( 'widgets_init', 'wp_recently_viewed_widgets' );

// Register widget
function wp_recently_viewed_widgets() {
	register_widget( 'wp_recently_viewed_widgets' );
}

class wp_recently_viewed_widgets extends WP_Widget {

	function wp_recently_viewed_widgets() {
		/* Widget settings */
		$widget_ops = array( 'classname' => 'wp_recently_viewed', 'description' => '显示访客浏览历史' );

		/* Create the widget */
		$this->WP_Widget( 'wp_recently_viewed_widget', '浏览历史', $widget_ops );
	}

	function widget( $args, $instance ) {
	  $title = apply_filters('widget_title', $instance['title'] );
		echo '<li id="recently_viewed" class="widget-container widget_recently_viewed"><h3 class="widget-title">'.$title.'</h3></li>';
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );

		return $instance;
	}

	function form( $instance ) {
		/* Set up some default widget settings. */
		$defaults = array( 'title' => '您刚刚看过' );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'framework') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		
	<?php
	}
}

function wp_recently_viewed_js() {
	$script_html = '<script type="text/javascript" src="'.plugins_url( 'js/view-history.js' , __FILE__ ).'"></script>';
	if( is_single() ) {
	  $script_html .= "\n" .'<script type="text/javascript" src="'.plugins_url( 'js/add-history.js' , __FILE__ ).'"></script>';
	}
	
	echo "\n" . $script_html. "\n";
}
 
if (!is_admin()) {
	// 在主题中尾部插入js
	add_action("wp_footer", "wp_recently_viewed_js");
}

?>