<?php
function filterimg($html){
	$html = htmlspecialchars_decode($html);
    preg_match_all('/<img(.*?)src=("|\'|\s)?(.*?)(?="|\'|\s)/',$html,$img_array);
    $img_array = array_unique( $img_array[3] );
    if (count($img_array) > 0 ) {
    	return $img_array[0];
    }
}

function msubstr($str, $length, $charset="utf-8", $suffix=true)
{
	$start=0;
    if(function_exists("mb_substr"))
	{
		if ($suffix && strlen($str)>$length)
			return mb_substr($str, $start, $length, $charset)."...";
        else
			return mb_substr($str, $start, $length, $charset);
    }
    elseif(function_exists('iconv_substr'))
	{
		if ($suffix && strlen($str)>$length)
			return iconv_substr($str,$start,$length,$charset)."...";
        else
			return iconv_substr($str,$start,$length,$charset);
    }

    $re['utf-8']   = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
    $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
    $re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
    $re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
    preg_match_all($re[$charset], $str, $match);
    $slice = join("",array_slice($match[0], $start, $length));
    if($suffix)
		return $slice."…";
    return $slice;
}
function html2text($str){  
  	$str = preg_replace("/<style .*?<\/style>/is", "", $str);  $str = preg_replace("/<script .*?<\/script>/is", "", $str);  
	$str = preg_replace("/<br \s*\/?\/>/i", "&#x0A;", $str);  
	$str = preg_replace("/<\/?p>/i", "&#x0A;", $str);  
	$str = preg_replace("/<\/?td>/i", "&#x0A;", $str);  
	$str = preg_replace("/<\/?div>/i", "&#x0A;", $str);  
	$str = preg_replace("/<\/?blockquote>/i", "\n", $str);  
	$str = preg_replace("/<\/?li>/i", "\n", $str);  
	$str = preg_replace("/\&nbsp\;/i", " ", $str);  
	$str = preg_replace("/\&nbsp/i", " ", $str);  
	$str = preg_replace("/\&amp\;/i", "&", $str);  
	$str = preg_replace("/\&amp/i", "&", $str);    
	$str = preg_replace("/\&lt\;/i", "<", $str);  
	$str = preg_replace("/\&lt/i", "<", $str);  
	$str = preg_replace("/\&ldquo\;/i", '"', $str);  
	$str = preg_replace("/\&ldquo/i", '"', $str);  
	$str = preg_replace("/\&lsquo\;/i", "'", $str);  
	$str = preg_replace("/\&lsquo/i", "'", $str);  
	$str = preg_replace("/\&rsquo\;/i", "'", $str);  
	$str = preg_replace("/\&rsquo/i", "'", $str);  
	$str = preg_replace("/\&gt\;/i", ">", $str);   
	$str = preg_replace("/\&gt/i", ">", $str);   
	$str = preg_replace("/\&rdquo\;/i", '"', $str);   
	$str = preg_replace("/\&rdquo/i", '"', $str);   
	$str = strip_tags($str);  
	$str = html_entity_decode($str, ENT_QUOTES, $encode);  
	$str = preg_replace("/\&\#.*?\;/i", "", $str);          

	return $str;
 }

function randimg($i){
	return rand(1,$i);
}
?>