
DROP TABLE IF EXISTS toa_ads;

CREATE TABLE toa_ads (
  id int(10) NOT NULL auto_increment,
  title varchar(255) default NULL,
  date datetime default NULL,
  adsurl text,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_app;

CREATE TABLE toa_app (
  id int(10) NOT NULL auto_increment,
  title varchar(255) default NULL,
  content text,
  user text,
  number varchar(20) default NULL,
  untildate datetime default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_app_log;

CREATE TABLE toa_app_log (
  id int(10) NOT NULL auto_increment,
  app_id varchar(20) default NULL,
  app_option_id varchar(20) default NULL,
  user varchar(20) default NULL,
  date datetime default NULL,
  content varchar(255) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_app_option;

CREATE TABLE toa_app_option (
  id int(10) NOT NULL auto_increment,
  app_id varchar(20) default NULL,
  title varchar(255) default NULL,
  number varchar(20) default NULL,
  type varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_bbs;

CREATE TABLE toa_bbs (
  id int(10) NOT NULL auto_increment,
  bbsclass varchar(255) default NULL,
  title varchar(255) default NULL,
  author varchar(60) default NULL,
  origin varchar(255) default NULL,
  content text,
  issuedate datetime default NULL,
  readnum varchar(60) default NULL,
  enddate datetime default NULL,
  type varchar(10) default NULL,
  uid varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_bbs_log;

CREATE TABLE toa_bbs_log (
  id int(10) NOT NULL auto_increment,
  bbsid varchar(20) default NULL,
  title varchar(255) default NULL,
  author varchar(60) default NULL,
  content text,
  enddate datetime default NULL,
  uid varchar(20) default NULL,
  type varchar(2) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_bbsclass;

CREATE TABLE toa_bbsclass (
  id int(10) NOT NULL auto_increment,
  name varchar(255) default NULL,
  classadmin varchar(255) default NULL,
  type varchar(20) default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_blog;

CREATE TABLE toa_blog (
  id int(10) NOT NULL auto_increment,
  title varchar(80) default NULL,
  content text,
  number int(10) default NULL,
  categoryid varchar(10) default NULL,
  type varchar(10) default NULL,
  date date default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_communication;

CREATE TABLE toa_communication (
  id int(8) NOT NULL auto_increment,
  person varchar(20) default NULL,
  tel varchar(80) default NULL,
  phone varchar(40) default NULL,
  fax varchar(40) default NULL,
  mail varchar(80) default NULL,
  zipcode varchar(10) default NULL,
  address varchar(40) default NULL,
  position varchar(20) default NULL,
  sex varchar(10) default NULL,
  msn varchar(50) default NULL,
  type varchar(10) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  company varchar(60) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS toa_config;

CREATE TABLE toa_config (
  id int(10) NOT NULL auto_increment,
  value text,
  name varchar(50) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_business;

CREATE TABLE toa_crm_business (
  id int(10) NOT NULL auto_increment,
  workuser varchar(255) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  number varchar(255) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_company;

CREATE TABLE toa_crm_company (
  id int(10) NOT NULL auto_increment,
  workuser varchar(255) default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  number varchar(255) default NULL,
  servicedate varchar(60) default NULL,
  type varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_contact;

CREATE TABLE toa_crm_contact (
  id int(10) NOT NULL auto_increment,
  companyid varchar(20) default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_contract;

CREATE TABLE toa_crm_contract (
  id int(10) NOT NULL auto_increment,
  number varchar(255) default NULL,
  companyid varchar(20) default NULL,
  orderid varchar(20) default NULL,
  workuser varchar(255) default NULL,
  examination varchar(255) default NULL,
  type varchar(10) default NULL,
  price varchar(255) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_db;

CREATE TABLE toa_crm_db (
  id int(10) NOT NULL auto_increment,
  formname varchar(255) default NULL,
  inputname varchar(255) default NULL,
  inputvalue text,
  type varchar(20) default NULL,
  inputtype varchar(20) default NULL,
  inputvaluenum text,
  confirmation varchar(10) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  type1 varchar(10) default NULL,
  typeid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_form;

CREATE TABLE toa_crm_form (
  id int(10) NOT NULL auto_increment,
  formname varchar(255) default NULL,
  inputname varchar(255) default NULL,
  type varchar(20) default NULL,
  inputvalue varchar(255) default NULL,
  inputtype varchar(20) default NULL,
  inputvaluenum text,
  confirmation varchar(10) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  type1 varchar(10) default NULL,
  key1 varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_order;

CREATE TABLE toa_crm_order (
  id int(10) NOT NULL auto_increment,
  number varchar(255) default NULL,
  companyid varchar(20) default NULL,
  workuser varchar(20) default NULL,
  examination varchar(20) default NULL,
  type varchar(20) default NULL,
  price varchar(60) default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  productid varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_pord_type;

CREATE TABLE toa_crm_pord_type (
  id int(10) NOT NULL auto_increment,
  title varchar(255) default NULL,
  father varchar(20) default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_price;

CREATE TABLE toa_crm_price (
  id int(10) NOT NULL auto_increment,
  number varchar(255) default NULL,
  companyid varchar(20) default NULL,
  orderid varchar(20) default NULL,
  workuser varchar(255) default NULL,
  price varchar(255) default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  examination varchar(255) default NULL,
  type varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_product;

CREATE TABLE toa_crm_product (
  id int(10) NOT NULL auto_increment,
  number varchar(255) default NULL,
  title varchar(255) default NULL,
  price varchar(255) default NULL,
  type varchar(255) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_purchase;

CREATE TABLE toa_crm_purchase (
  id int(10) NOT NULL auto_increment,
  number varchar(255) default NULL,
  product varchar(255) default NULL,
  application varchar(255) default NULL,
  startdate varchar(255) default NULL,
  price varchar(255) default NULL,
  pricenum varchar(255) default NULL,
  examination varchar(20) default NULL,
  keydate varchar(60) default NULL,
  purchase varchar(60) default NULL,
  stockuser varchar(60) default NULL,
  key1 varchar(10) default NULL,
  uid varchar(10) default NULL,
  productnum varchar(20) default NULL,
  supplierid varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_service;

CREATE TABLE toa_crm_service (
  id int(10) NOT NULL auto_increment,
  companyid varchar(255) default NULL,
  startdate varchar(60) default NULL,
  enddate varchar(60) default NULL,
  workuser varchar(20) default NULL,
  assignmentdate varchar(20) default NULL,
  uid varchar(20) default NULL,
  phone varchar(10) default NULL,
  smsinfo varchar(10) default NULL,
  type varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_stock;

CREATE TABLE toa_crm_stock (
  id int(10) NOT NULL auto_increment,
  product varchar(20) default NULL,
  purchase varchar(60) default NULL,
  unit varchar(255) default NULL,
  type varchar(20) default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_crm_supplier;

CREATE TABLE toa_crm_supplier (
  id int(10) NOT NULL auto_increment,
  workuser varchar(255) default NULL,
  date datetime default NULL,
  uid varchar(20) default NULL,
  number varchar(255) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_department;

CREATE TABLE toa_department (
  id int(11) NOT NULL auto_increment,
  persno varchar(40) default NULL,
  name varchar(40) default NULL,
  date datetime default NULL,
  father varchar(10) default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_document;

CREATE TABLE toa_document (
  id int(10) NOT NULL auto_increment,
  title varchar(255) default NULL,
  content text,
  documentid varchar(50) default NULL,
  annex varchar(255) default NULL,
  type varchar(10) default NULL,
  uid varchar(10) default NULL,
  `key` varchar(10) default NULL,
  date datetime default NULL,
  readuser text,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_document_type;

CREATE TABLE toa_document_type (
  id int(10) NOT NULL auto_increment,
  father varchar(10) default NULL,
  title varchar(255) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  type varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS toa_keytable;

CREATE TABLE toa_keytable (
  id int(10) NOT NULL auto_increment,
  name varchar(255) default NULL,
  inputname varchar(255) default NULL,
  inputvalue varchar(255) default NULL,
  inputchecked varchar(5) default NULL,
  type varchar(5) default NULL,
  number int(10) default NULL,
  fatherid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_knowledge;

CREATE TABLE toa_knowledge (
  id int(10) NOT NULL auto_increment,
  title varchar(80) default NULL,
  content text,
  number int(10) default NULL,
  categoryid varchar(10) default NULL,
  type varchar(10) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_loginlog;

CREATE TABLE toa_loginlog (
  id int(10) NOT NULL auto_increment,
  uid int(10) default NULL,
  name varchar(20) default NULL,
  ip varchar(50) default NULL,
  logindate datetime default NULL,
  enddate datetime default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_menu;

CREATE TABLE toa_menu (
  menuid int(10) NOT NULL auto_increment,
  menuname varchar(255) default NULL,
  menuurl varchar(255) default NULL,
  fatherid varchar(10) default NULL,
  menutype varchar(10) default NULL,
  menunum int(25) default '9999',
  menukey varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (menuid)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_news;

CREATE TABLE toa_news (
  id int(10) NOT NULL auto_increment,
  category varchar(10) default NULL,
  receive text,
  phonereceive varchar(200) default NULL,
  subject varchar(120) default NULL,
  content text,
  appendix varchar(120) default NULL,
  type varchar(10) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  pic varchar(120) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_news_read;

CREATE TABLE toa_news_read (
  rid int(10) NOT NULL auto_increment,
  uid varchar(30) default NULL,
  disdate datetime default NULL,
  viewdate datetime default NULL,
  evaluation varchar(200) default NULL,
  dkey varchar(10) default NULL,
  newsid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (rid)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_news_type;

CREATE TABLE toa_news_type (
  nid int(10) NOT NULL auto_increment,
  ntitle varchar(60) default NULL,
  uid varchar(10) default NULL,
  ntype varchar(10) default NULL,
  ndate datetime default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (nid)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_oalog;

CREATE TABLE toa_oalog (
  id int(10) NOT NULL auto_increment,
  uid varchar(20) default NULL,
  content text,
  title varchar(255) default NULL,
  startdate datetime default NULL,
  contentid varchar(20) default NULL,
  type varchar(5) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS toa_office_type;

CREATE TABLE toa_office_type (
  oid int(10) NOT NULL auto_increment,
  oname varchar(255) default NULL,
  otype varchar(10) default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (oid)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_online;

CREATE TABLE toa_online (
  id int(10) NOT NULL auto_increment,
  startdate datetime default NULL,
  uid varchar(20) default NULL,
  enddate datetime default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_phone_channel;

CREATE TABLE toa_phone_channel (
  id int(10) NOT NULL auto_increment,
  company varchar(255) default NULL,
  price varchar(255) default NULL,
  content varchar(255) default NULL,
  `connection` text,
  remainsum varchar(30) default NULL,
  type varchar(5) default NULL,
  connectionid varchar(255) default NULL,
  pkey varchar(5) default NULL,
  username varchar(255) default NULL,
  password varchar(255) default NULL,
  toaid varchar(255) default NULL,
  date datetime default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_phone_receive;

CREATE TABLE toa_phone_receive (
  id int(8) NOT NULL auto_increment,
  content varchar(500) default NULL,
  sendphone varchar(30) default NULL,
  date varchar(30) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_phone_send;

CREATE TABLE toa_phone_send (
  id int(10) NOT NULL auto_increment,
  content varchar(500) default NULL,
  receivephone varchar(30) default NULL,
  sendperson varchar(10) default NULL,
  receiveperson varchar(30) default NULL,
  date datetime default NULL,
  type varchar(5) default NULL,
  channelid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS toa_position;

CREATE TABLE toa_position (
  id int(10) NOT NULL auto_increment,
  name varchar(255) default NULL,
  content text,
  father varchar(20) default NULL,
  date datetime default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_registration;

CREATE TABLE toa_registration (
  id int(10) NOT NULL auto_increment,
  name varchar(20) default NULL,
  startdate datetime default NULL,
  enddate datetime default NULL,
  startnote varchar(400) default NULL,
  endnote varchar(400) default NULL,
  uid varchar(10) default NULL,
  startyype varchar(10) default NULL,
  endtype varchar(10) default NULL,
  date date default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_session;

CREATE TABLE toa_session (
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL,
  password varchar(32) NOT NULL default '',
  groupid smallint(5) unsigned NOT NULL default '3',
  ip int(11) NOT NULL default '0',
  unionid varchar(10) default NULL,
  PRIMARY KEY  (uid)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_sms_receive;

CREATE TABLE toa_sms_receive (
  id int(10) NOT NULL auto_increment,
  sendperson varchar(20) default NULL,
  date datetime default NULL,
  content text,
  receiveperson varchar(10) default NULL,
  type varchar(10) default NULL,
  smskey varchar(10) default NULL,
  readdate datetime default NULL,
  sendid varchar(10) default NULL,
  online varchar(5) default '0',
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_sms_send;

CREATE TABLE toa_sms_send (
  id int(10) NOT NULL auto_increment,
  receiveperson text,
  content text,
  uid varchar(20) default NULL,
  date datetime default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS toa_upload;

CREATE TABLE toa_upload (
  id int(10) unsigned NOT NULL auto_increment,
  aid int(10) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  username varchar(20) NOT NULL default '',
  originalname varchar(100) NOT NULL default '',
  filepath varchar(255) NOT NULL default '',
  thumb varchar(255) NOT NULL default '',
  filesize int(10) unsigned NOT NULL default '0',
  filetype varchar(50) NOT NULL default '',
  fileext char(10) NOT NULL default '',
  dateline int(10) unsigned NOT NULL default '0',
  downloads mediumint(8) unsigned NOT NULL default '0',
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id),
  KEY aid (aid)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_user;

CREATE TABLE toa_user (
  id int(11) NOT NULL auto_increment,
  username varchar(40) default NULL,
  password varchar(40) default NULL,
  departmentid varchar(10) default NULL,
  flag varchar(2) default NULL,
  date datetime default NULL,
  ischeck varchar(2) default NULL,
  userkey varchar(20) default NULL,
  groupid varchar(2) default NULL,
  positionid varchar(20) default NULL,
  loginip text,
  online varchar(2) default '0',
  keytype varchar(2) default NULL,
  keytypeuser text,
  unionflag varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_user_view;

CREATE TABLE toa_user_view (
  vid int(10) NOT NULL auto_increment,
  name varchar(255) default NULL,
  uid varchar(10) default NULL,
  number varchar(60) default NULL,
  sex varchar(20) default NULL,
  birthdate date default NULL,
  participationwork varchar(60) default NULL,
  tel varchar(60) default NULL,
  phone varchar(60) default NULL,
  fax varchar(60) default NULL,
  email varchar(255) default NULL,
  address varchar(255) default NULL,
  qq varchar(255) default NULL,
  contact varchar(255) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (vid)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_usergroup;

CREATE TABLE toa_usergroup (
  id smallint(5) unsigned NOT NULL auto_increment,
  groupname varchar(100) NOT NULL,
  purview text NOT NULL,
  type enum('system','user') NOT NULL default 'user',
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS toa_web;

CREATE TABLE toa_web (
  id int(10) NOT NULL auto_increment,
  title varchar(60) default NULL,
  weburl varchar(120) default NULL,
  content varchar(120) default NULL,
  date datetime default NULL,
  uid varchar(10) default NULL,
  unionid varchar(10) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS toa_union;
CREATE TABLE toa_union (
  id int(10) NOT NULL auto_increment,
  name varchar(255) default NULL,
  number varchar(10) default NULL,
  logo varchar(255) default NULL,
  ctype varchar(5) default NULL,
  username varchar(50) default NULL,
  password varchar(50) default NULL,
  unconfig varchar(5) default NULL,
  uncache varchar(5) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS toa_user_union;
CREATE TABLE toa_user_union (
  id int(10) NOT NULL auto_increment,
  usertype varchar(5) default NULL,
  unionid varchar(20) default NULL,
  uid varchar(20) default NULL,
  PRIMARY KEY  (id)
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;