<?php

	require 'config.php';

	$ip = isset($_REQUEST['ip']) ? trim($_REQUEST['ip']) : '';
	!preg_match('~^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$~', $ip) && exit('bad ip');

	$json = array(
		'ping' => '', 
		'country' => '', 
		'local' => '', 
		'error' => ''
	);
	
	// fsockopen method
	// =============================================================================
	$times = array();
	for ($i = 0; $i < 3; $i++) { 
		if ($time = ping($ip))
			$times[] = $time;
		else
			break;
	}
	if (!empty($times)) {
		$time = ceil(array_sum($times) / count($times));
	}

	// Shell Method
	// =============================================================================
	// define('IS_WIN', strtoupper(substr(PHP_OS, 0, 3)) === 'WIN');
	// // ping
	// if (IS_WIN) {
	// 	$cmd = 'ping -n 3 -w 3 '.$ip;
	// }
	// else {
	// 	$cmd = 'ping -c 3 -w 3 '.$ip;
	// }
	// $r = shell_exec($cmd);
	// IS_WIN && $r = mb_convert_encoding($r, 'UTF-8', 'GBK');
	// if ( false !== strpos($r, '100% packet loss') || false !== strpos($r, '100% 丢失') ) {
	// 	$json['ping'] = '<em>100% LOST</em>';
	// }
	// elseif ( preg_match('~平均 = ([0-9]+)ms~', $r, $tmp) ) {
	// 	$time = $tmp[1];
	// }
	// elseif ( preg_match('~rtt min/avg/max/mdev = ([0-9\.]+)/~', $r, $tmp) ) {
	// 	$time = ceil($tmp[1]);
	// }

	if ($time) {
		if ($time < 100) {
			$json['ping'] = "<strong>$time</strong>";
		}
		elseif ($time < 200) {
			$json['ping'] = "<b>$time</b>";
		}
		else {
			$json['ping'] = "<span>$time</span>";
		}		
	}
	else {
		$json['ping'] = '<em>100% LOST</em>';		
	}

	// GeoIP Method
	if (function_exists('geoip_record_by_name')) {
		$geo = geoip_record_by_name($ip);
		$json['country'] = defined('GEO_COUNTRY_NAME') ? $geo[GEO_COUNTRY_NAME] : $geo['country_name']; // country_name country_code
		$json['local'] = defined('GEO_CITY_NAME') ? $geo[GEO_CITY_NAME] : $geo['city']; // city region
	}
	// QQWry Method
	else {
		include(dirname(__FILE__).'/class_ip.php');
		$qqwry = new QQWry;
		$qqwry->QQWry($ip);
		$json['country'] = mb_convert_encoding($qqwry->Country, 'UTF-8', 'GBK');
		$json['local'] = mb_convert_encoding($qqwry->Local, 'UTF-8', 'GBK');
	}

	// output
	header( "Content-Type: application/json; charset=utf-8" );	
	echo json_encode($json);

	// save txt
	if (is_numeric($time)) {
		$pad_len = GEO_COUNTRY_NAME == 'country_name' ? 20 : 10;
		$data = str_pad($json['country'], $pad_len, ' ').str_pad($ip, 18, ' ').$time."\n";
		$sections = array(100, 150, 200, 250);
		defined('TIME_SECTIONS') && $sections = array_map('trim', explode(',', TIME_SECTIONS));
		foreach ($sections AS $section) {
			if ($time < $section) {
				$file = dirname(__FILE__)."/vpn_$section.txt";
				!file_exists($file) && touch($file);
				if ( false === strpos(file_get_contents($file), $ip) )
					file_put_contents($file, $data, FILE_APPEND);
				break;
			}
		}
	}

	function ping($ip) {
		$time_start = microtime(true);
		$timeout = 1;
		$port = 80;
		defined('PING_PORT') && PING_PORT && $port = PING_PORT;
		defined('PING_TIME_OUT') && PING_TIME_OUT && $timeout = PING_TIME_OUT;
		$fp = @fsockopen($ip, $port, $errno, $errstr, $timeout); 
		if (!$fp) return;
		$time_end = microtime(true); 
		return round((($time_end - $time_start) * 1000), 0);
	}
