<?php
/**
 * 仅用于本插件的安装程序类：admin用户校验
 * @author yaoying
 * @version $Id: adminVerifier.class.php 992 2012-06-05 04:02:42Z yaoying $
 */
class adminVerifier{
	
	function adminVerifier(){
		
	}
	
	/**
	 * 仅用于本插件的安装程序
	 * @param string 安装类型标识，用于安装session校验
	 * @uses siteUserVerifier
	 * 
	 */
	function verifyForInstall($id='xwb_default_id'){
		
		$this->_robot_reject();
		$this->_verifyForInstall_bruceForceCheck($id);
		
		$verified = false;
		$msg = $username = $userpass = $questionid = $questionanswer = '';
		
		$ipCounter =& XWB_Plugin::O('xwbIpCount');
		$ipCounter->use_remote_ip = true;
		
		$sess = XWB_plugin::getUser();
		
		$XWB_INSTALL_AUTH = $sess->getInfo('XWB_INSTALL_AUTH');
		
		if (!empty($XWB_INSTALL_AUTH) ) {
			$verify = md5 ( XWB_CLIENT_SESSION . XWB_S_CHARSET. XWB_P_ROOT .$id );
			if ( $XWB_INSTALL_AUTH != $verify) {
				$sess->delInfo('XWB_INSTALL_AUTH');
				//$msg = 'session验证失效，请重新验证！';
			} else {
				$verified = true;
			}
		
		} else {
			
				$inputcount = $ipCounter->get('regInput');
				$total_input_count = $ipCounter->get_admin_lock();
			
				$sess->delInfo('XWB_INSTALL_AUTH');
				$username = ( string ) XWB_plugin::V ( 'p:username' );
				$userpass = ( string ) XWB_plugin::V ( 'p:userpass' );
				$questionid = ( int ) XWB_plugin::V ( 'p:questionid' );
				$questionanswer = ( string ) XWB_plugin::V ( 'p:questionanswer' );
			
				if ($username && $userpass) {
					$username = XWB_plugin::convertEncoding ( $username, 'UTF-8', XWB_S_CHARSET );
					$userpass = XWB_plugin::convertEncoding ( $userpass, 'UTF-8', XWB_S_CHARSET );
					$questionanswer = XWB_plugin::convertEncoding ( $questionanswer, 'UTF-8', XWB_S_CHARSET );
				
					$verify = XWB_plugin::O('siteUserVerifier');
					$verifyresult = $verify->verify ( $username, $userpass, $questionid, $questionanswer );
				
					$result = $verifyresult[0];
					if( $verifyresult[0] > 0 && $verifyresult[1] != 1 ){
						$result = -5;
					}
					
					if ($result < 1) {
						$ipCounter->set_admin_lock($total_input_count + 1);
						$ipCounter->set('regInput', $inputcount + 1);
						switch ($result){
							case '-1':
								$msg = '用户不存在，请重新输入！';
								break;
							case '-2':
								$msg = '密码错误，请重新输入！';
								break;
							case '-3':
								$msg = '安全提问验证失败，请重新输入！';
								break;
							case '-4':
								$msg = '用户在论坛没有注册，请重新输入！';
								break;
							case '-5':
								$msg = '不是管理员帐号，请重新输入！';
								break;
							default:
								$msg = '验证错误，请重新输入！';
								break;	
						}
				
					} else {
						$XWB_INSTALL_AUTH  = md5 ( XWB_CLIENT_SESSION . XWB_S_CHARSET. XWB_P_ROOT .$id );
						$sess->setInfo('XWB_INSTALL_AUTH', $XWB_INSTALL_AUTH);
						$verified = true;
					}
				}
		}
		
		if ($verified === false) {
			include dirname(__FILE__) . '/tpl/pwdverify.php';
			exit();
		}
		
		
	}
	
	function _verifyForInstall_bruceForceCheck($id='xwb_default_id'){
		$ipCounter =& XWB_Plugin::O('xwbIpCount');
		$ipCounter->use_remote_ip = true;
		
		$inputcount = $ipCounter->get('regInput');
		$total_input_count = $ipCounter->get_admin_lock();
		
		$msg = '';
		if($total_input_count >= 10){
			$msg = '超过10次输入错误的管理员账号和密码次数，为防止被暴力破解论坛账号，安装已被锁定。<br />您需要到数据库中找到"[论坛表前缀_]caches"表，然后删除xwb_admin_lock，才可继续安装。';	
		}elseif($inputcount >= 5){
			$msg = '连续输错5次密码，请15分钟后重试！';		
		}
		
		if($inputcount < 0 || $total_input_count < 0){
			$msg = '数据库存在异常。<br />请查看"[论坛表前缀_]caches"表中以xwb_和xipct_开头的cachename是否为负数，若为是，请排查是否被入侵';
		}
		
		if(!empty($msg)){
			include dirname(__FILE__) . '/tpl/pwdverify.php';
			exit();
		}
		
	}
	
	function _getIpInputCount(){
		$o =& XWB_Plugin::O('xwbIpCount');
		$o->use_remote_ip = true;
		return $o->get('regInput');
	}
	
	function _setIpInputCount($count){
		$o =& XWB_Plugin::O('xwbIpCount');
		$o->use_remote_ip = true;
		$o->set('regInput', $count);
	}
	
	
	function _robot_reject(){
		$is_robot = false;
		$robotlist = 'bot|spider|crawl|nutch|lycos|robozilla|slurp|search|seek|archive';
		if(!isset($_SERVER['HTTP_USER_AGENT']) || isset($_SERVER['HTTP_USER_AGENT']) && preg_match("/{$robotlist}/i", $_SERVER['HTTP_USER_AGENT']) ){
			$is_robot = true;
		}
		if($is_robot){
			@header('HTTP/1.1 404 Not Found');
			exit();
		}
	}
	
	
}