<?php
/**
 * 创建文件控制类
 * @author yaoying
 * @version $Id: xwb_createDoc.class.php 377 2010-12-08 06:14:11Z yaoying $
 */
class xwb_createDoc {
	var $tpl_dir	= '';
	var $v			= array();
	var $hack_files = array();
	function xwb_createDoc(){
		global $_xwb_install;
		
		$this->tpl_dir = dirname(__FILE__).'/tpl';
		$this->v = $_xwb_install;
	}
	
	function install($st){
		$st*=1;
		if (!in_array($st,array(0,1,2,3))){
			$this->error('步骤参数错误！');
		}
		$func = 'step'.$st;
		$this->$func();
	}
	
	// 欢迎页
	function step0(){
		include $this->tpl_dir.'/createDoc_step0.php';
	}
	
	// 步骤1 生成文档预览
	function step1(){
		$createLink = true;
		$modifyList = $this->_getModifyList();
		include $this->tpl_dir.'/createDoc_step1.php';
	}
	
	// 步骤2 生成文档到install目录
	function step2(){
		$createLink = false;
		$modifyList = $this->_getModifyList();
		
		ob_start();
		include $this->tpl_dir.'/createDoc_step1.php';
		$content = ob_get_contents();
		ob_end_clean();
		
		$modifyDocFileName = 'ModifyDoc_Discuz_'. XWB_S_VERSION. '_XWB_'. XWB_P_VERSION. '.html';
		$modifyDocFilePath = dirname(__FILE__). DIRECTORY_SEPARATOR. $modifyDocFileName;
		if( file_exists($modifyDocFilePath) ){
			unlink($modifyDocFilePath);
		}
		file_put_contents( $modifyDocFilePath, $content );
		
		$msg = "MODIFY_DOCUMENT_CREATE_SUCCESS_IN:\r\n". $modifyDocFilePath;
		$msg = "<script>var msg = unescape('" . urlencode( $msg ) . "');alert(msg);</script>";
		$content .= $msg;
		echo $content;
	}
	
	
	/**
	 * 弹出错误提示
	 * @param string $msg 错误信息
	 */
	function error($msg){
		include $this->tpl_dir.'/error.php';
		exit;
	}

	/**
	 * 获取修改的文件列表和修改信息
	 * @return array
	 */
	function _getModifyList(){
		$return = array();
		
		$tokenInfo = $this->_tokenHackFile();
		
		require_once 'xwb_hackFiles.class.php';
		$siteFileHack = new xwb_hackFiles;
		foreach ( $siteFileHack->hc['hack_file'] as $key => $modify){
			$return[$key]['file'] = $modify[0];
			
			//在哪个位置修改？返回数组格式：（找到第几个标识（0表示所有标识），该标识的什么位置？）
			$modify[1] = trim($modify[1]);
			$m = array();
			if (preg_match("/^(\d+):(next|prev)$/",$modify[1] ,$m) ){
				$return[$key]['to'] = array( $m[1], $m[2] );
			}else{
				$return[$key]['to'] = array( 0, $modify[1] );
			}
			$return[$key]['to'][2] = $this->_optDescribe( $return[$key]['to'][1] );
			
			$return[$key]['content'] = $modify[2];
			$return[$key]['mark'] = $modify[3];
			$return[$key]['id'] = substr( md5($modify[0]), 0 ,16);
			$return[$key]['tokenInfo'] = isset($tokenInfo[$modify[4]]) ? $tokenInfo[$modify[4]] : array();
		}
		
		return $return;
		
	}
	
	/**
	 * "在哪个位置修改？"的中文翻译
	 * @param string $opt
	 */
	function _optDescribe( $opt ){
		switch ($opt){
			case 'start'	: 
				return '文件内容的最前面';
			case 'end'		: 
				return '文件内容的最后面';
			case 'before'	:
				return '标识的前面';
			case 'after'	:
				return '标识的后面';
			case 'next'	:
				return '标识所在行的最后面另起一行';
			case 'prev'	:
				return '标识所在行的最前面另起一行';
			default:
				return '___标识错误，请排查程序！___';
		}
	}
	

	/**
	 * token文件xwb_hackFiles.class.php，以获取需要的修改文件作用和目的等注释
	 * @return array token结果
	 */
	function _tokenHackFile(){
		
		$result = $m = array();
		
		/*
		 * T_ML_COMMENT does not exist in PHP 5.
		 * The following three lines define it in order to
		 * preserve backwards compatibility.
		 *
		 * The next two lines define the PHP 5 only T_DOC_COMMENT,
		 * which we will mask as T_ML_COMMENT for PHP 4.
		 */
		if (!defined('T_ML_COMMENT')) {
			define('T_ML_COMMENT', T_COMMENT);
		} else {
			define('T_DOC_COMMENT', T_ML_COMMENT);
		}

		//token文件
		$source = file_get_contents('xwb_hackFiles.class.php');
		$tokens = token_get_all($source);

		$strPattern = "/@(abstract|type|name)[ ]+(\S+)/";
		foreach ($tokens as $token) {
			
			//print_r($token);
			//ECHO '<BR /><BR />';
			
			if ( is_array($token) && ($token[0] == T_DOC_COMMENT || $token[0] == T_COMMENT) ) {
				//将我们所需要的文件注释提取出来
				preg_match_all( $strPattern, $token[1], $m );
				
				if(empty($m)){
					continue;
				}
				
				//合并结果，使每个注释都含有key
				$temp = array_combine ( $m[1] , $m[2] );
				$temp['name'] = isset($temp['name']) ? explode(',', $temp['name']) : array();
				
				//分配注释信息给修改数组标识
				foreach ( $temp['name'] as $k => $file ){
					$file = trim($file);
					$result[$file] = $temp;
				}
			}
		}
		
		return $result;
		
	}
	

}
?>