<?php
/*
 * @version $Id: xwb_uninstall.class.php 613 2011-02-09 10:09:51Z yaoying $
 */
class xwb_uninstall {
	var $v = array();
	var $tpl_dir = "";
	var $error = false;
	var $tips = array();
	var $_sess = null;
	
	function xwb_uninstall(){
		global $_xwb_install;
		$this->tpl_dir = dirname(__FILE__).'/tpl';
		$this->v = $_xwb_install;
		$this->_sess = XWB_plugin::getUser();
		$this->_chkIsAdmin();
	}
	
	function _getDirNames($dir){
		$d = dir($dir."/");
		$dn	= array();
		while (false !== ($f = $d->read())) {
		   if(is_dir($dir."/".$f) && $f!='.' && $f!='..') $dn[]=$f;
		}
		$d->close();
		return $dn;
	}
	
	function getCfg(){
		$cfg = array();
		$ver = substr(XWB_S_VERSION,0,3);
		if(!in_array($ver, array('6.0', '6.1', '7.0', '7.1', '7.2'))){
			$this->error('不支持的站点版本： '.XWB_S_VERSION);
		}
		
		$cfg['delete_data']		= array();
		$cfg['delete_data'][]	= 'xwb.php';
		
		require_once dirname(__FILE__). '/xwb_hackFiles.class.php';
		$hackFiles =& new xwb_hackFiles();
		foreach($hackFiles->hc['hack_file'] as $k => $file){
			$cfg['rervert_data'][] = $file[0];
		}
		
		$cfg['db_data'] = array();
		$cfg['db_data']['xwb_bind_thread']	= "DROP TABLE IF EXISTS `%s`";
		$cfg['db_data']['xwb_bind_info'] 	= "DROP TABLE IF EXISTS `%s`";
		$cfg['db_data']['xwb_session'] 	= "DROP TABLE IF EXISTS `%s`";
		
		return $cfg ;
		
	}
	
	
	function uninstall($st){
		$st*=1;
		if (!in_array($st,array(0,1))){
			$this->error('非法操作，步骤参数错误！');
		}
		
		$func = 'step'.$st;
		$this->$func();
	}
	
	function step0(){
		$image_file = "icon.gif";
		$showTab = 'info';
		$btn_enable = 'class="btn"';
		$btn_name = '确定卸载';
		$link = '?step=1&delete_data=0';
		include $this->tpl_dir.'/uninstall.php';
		exit;
	}
	
	function step1(){
		
		$cfg = $this->getCfg();
		
		//print_r($cfg);exit;
		$tips = array();
		$st = true;
		//delete file 
		foreach ($cfg['delete_data'] as $df){
			$f = XWB_S_ROOT.'/'.$df;
			if (file_exists($f)){
				if (!@unlink($f)){
					$st = false;
					//删除不了就清空文件
					@file_put_contents($f, 'FILE CANNOT DEL, PLEASE DEL IT MANUALLY!');
					$tips[] = array(0, '删除文件 '.$df.' 失败，检查权限后重试，或者手工删除');
				}else{
					$tips[] = array(1, '删除文件 '.$df.' 成功');
				}
			}
		}
		
		//revert file
		foreach ($cfg['rervert_data'] as $hf){
			$f = XWB_S_ROOT.'/'.$hf;
			if (file_exists($f)){
				$s = file_get_contents($f);
				$s = preg_replace($this->v['hack_flag']['pc'], '', $s);
				$s = preg_replace($this->v['hack_flag']['hc'], '', $s);
				if (!file_put_contents($f,$s)){
					$st = false;
					$tips[] = array(0, '还原文件 '.$hf.' 失败，检查权限后重试');
				}else{
					$tips[] = array(1, '还原文件 '.$hf.' 成功');
				}
			}
		}
		
		$db = XWB_plugin::getDB();
		if (!empty($_GET['delete_data'])){
			//delete db data
			foreach ($cfg['db_data'] as $name=>$format){
				$tbSql = sprintf($format,XWB_S_TBPRE.$name);
				$db->query($tbSql);
				$tips[] = array(1, "删除数据表 [PRE_]$name 成功");
			}
			$_GET['delete_data'] = 1;
		}else{
			$tips[] = array(1, "已保留微博插件数据");
			$_GET['delete_data'] = 0;
		}
		
		//删除植入式设置
		$db->query("DELETE FROM ". XWB_S_TBPRE. "settings WHERE `variable` IN ('sina_is_display_login_button', 'sina_bind_btn_usernav')");
		@unlink(XWB_S_ROOT. '/forumdata/cache/cache_settings.php');
		
		$showTab	= 'uninstall';
		$btn_enable = 'class="btn"';
		$btn_name	= $st ? '完 成' : '重试';
		$link		= $st ? '../../index.php' : 'uninstall.php?step=1&delete_data='.$_GET['delete_data'] ;
		$image_file = $st ? 'sucess.png':"icon.gif";
		if($st){
			$this->_sess->delInfo('XWB_INSTALL_AUTH');
		}
		
		require_once XWB_P_ROOT. '/lib/xwbSite.inc.php';
		xwb_updateSiteCache();
		
		@unlink($GLOBALS['_xwb_install']['lock_file']);
		
		include $this->tpl_dir.'/uninstall.php';
		exit;
	}
	
	function error($msg){
		$image_file = "icon.gif";
		$showTab = 'error';
		$errorMsg = $msg;
		$btn_enable = 'class="btn"';
		$btn_name = '重试';
		$link = '?step=1';
		include $this->tpl_dir.'/uninstall.php';
		exit;
	}
	
	
	
	function _chkIsAdmin(){
			require_once 'adminVerifier.class.php';
			$verify = new adminVerifier ();
			$verify->verifyForInstall('xwb_plugin_uninstall');
	}
	
}
?>