<?php
/**
 * 评论回推设置和运行模块。
 * 
 * @author yaoying
 * @since 2010-12-22
 * @version $Id: pushbackInterface.mod.php 946 2011-08-08 06:18:23Z yaoying $
 *
 */
class pushbackInterface{

	/**
	 * 评论回推设置页面
	 */
	function cfgPage(){
		if (!defined('XWB_S_IS_ADMIN') || !XWB_S_IS_ADMIN){
			XWB_plugin::deny('');
		}
		
		$pushKey = strval(XWB_Plugin::pCfg('pushback_authkey'));
		if( empty($pushKey) ){
			$isOpen = 0;
		}else{
			$isOpen = 1;
		}
		
		$db = XWB_plugin::getDB();
		$query = $db->query('SELECT `cachename`,`data` FROM '. XWB_S_TBPRE. "caches WHERE `cachename` IN ('xwb_pushback_nexttime', 'xwb_pushback_lasttime')");
		$res = array();
		while( $row = $db->fetch_array($query) ){
			$res[$row['cachename']] = $row['data'];
		}
		
		$lastUpdateTime = isset($res['xwb_pushback_lasttime']) ? (int)$res['xwb_pushback_lasttime'] : 0;
		$nextUpdateTime = isset($res['xwb_pushback_nexttime']) ? (int)$res['xwb_pushback_nexttime'] : 0;
		$fromid = (float)XWB_Plugin::pCfg('pushback_fromid');
		
		$tokenhash = xwb_token::make('pushback', true);
		include XWB_P_ROOT.'/tpl/plugin_cfg_pushback.tpl.php';
	}
	
	
	/**
	 * 评论回推设置：设置评论回推通讯密钥
	 */
	function doCfg4setAuthKey(){
		if (!defined('XWB_S_IS_ADMIN') || !XWB_S_IS_ADMIN || !XWB_plugin::isRequestBy('POST')){
			XWB_plugin::deny('');
		}elseif(!xwb_token::checkInput('p','pushback', true)){
			$ret = array(0,'令牌验证失败，请返回重试');
			echo json_encode($ret);
			exit();
		}
		$pushInstance = XWB_Plugin::O('pushbackCommunicator');
		$res = $pushInstance->getAuthKey();
		if( $res['httpcode'] != 200 || !isset($res['data']['code'])  ){
			$ret = array(0,'向评论回推服务器请求通讯密钥失败，请重试或者向Xweibo求助。');
			echo json_encode($ret);
		}else{
			//注册虚拟账户
			$username = '微博评论';
			$username_site = XWB_plugin::convertEncoding('微博评论', 'UTF-8', XWB_S_CHARSET);
			$uid = $this->_setPushbackSiteAccount($username_site);
			if( $uid > 0 ){
				XWB_Plugin::setPCfg( array( 'pushback_authkey' => strval($res['data']['code']), 'pushback_username' => $username, 'pushback_uid' => $uid,) );
			}else{
				XWB_Plugin::setPCfg( 'pushback_authkey', strval($res['data']['code']) );
			}
			
			//根据以前的评论回推设置，进行评论回推服务器定制通知
			$pushInstance->changePushbackAuthKey($res['data']['code']);
			$pushback_to_thread = (int)XWB_plugin::pCfg('pushback_to_thread');
			if( 1 == $pushback_to_thread ){
				$pushInstance->setPushback('comment');
			}else{
				$pushInstance->cancelPushback();
			}
			
			$ret = array(1,'开启成功！');
			echo json_encode($ret);
		}
	}
	
	/**
	 * 评论回推设置：设置和开启评论回推选项
	 */
	function doCfg4pushback(){
		if (!defined('XWB_S_IS_ADMIN') || !XWB_S_IS_ADMIN || !XWB_plugin::isRequestBy('POST')){
			XWB_plugin::deny('');
		}elseif(!xwb_token::checkInput('p','pushback', true)){
			XWB_plugin::showError('令牌验证失败，请返回重试');
		}
		
		$pushback_to_thread = (int)XWB_plugin::V('p:pushback_to_thread');
		if( $pushback_to_thread != 1 ){
			$pushback_to_thread = 0;
		}
				
		$res = XWB_Plugin::setPCfg( 'pushback_to_thread', $pushback_to_thread );
		
		if( true == $res ){
			$ret = array(1,'设置保存成功。');
		}else{
			$ret = array(0,'设置保存失败，请检查配置文件app.cfg.php是否具有可写权限？');
		}
		$this->_oScript('xwbSetTips',$ret);
		
		$pushInstance = XWB_Plugin::O('pushbackCommunicator');
		if( 1 == $pushback_to_thread ){
			$pushInstance->setPushback('comment');
		}else{
			$pushInstance->cancelPushback();
		}
		
	}
	
	/**
	 * 运行评论回推
	 */
	function forcePushback(){
		exit('NOT ALLOW YET.');
		/*
		if (!defined('XWB_S_IS_ADMIN') || !XWB_S_IS_ADMIN || !XWB_plugin::isRequestBy('POST')){
			XWB_plugin::deny('');
		}
		*/
		$pushInstance = XWB_Plugin::O('pushbackDispatcher');
		if ( true == $pushInstance->prepare(false) ){
			$pushInstance->processMain();
			echo 'var xwb_pushback_success = 1;';
		}else{
			echo 'var xwb_pushback_success = 0;';
		}
		
	}
	
	function _oScript($func,$ret){
		echo '<script>';
		echo "parent.".$func."(".json_encode($ret).");";
		echo '</script>';
	}
	
	
	/**
	 * 设置评论回推用户
	 * @param string $username 用户名，请传参前自行转码到论坛用户的编码
	 * @return int 用户uid
	 */
	function _setPushbackSiteAccount($username){
		if( !defined('UC_API') ){
			require_once XWB_P_ROOT.'/lib/compatDZ6.inc.php';
		}else{
			require_once XWB_S_ROOT.'/uc_client/client.php';
		}
		
		$userInfo = uc_get_user($username);
		if( is_array($userInfo) && $userInfo[0] > 0 ){
			$this->_importUserFromUC($userInfo);
			return $userInfo[0];
		}
		
		$email = 'xweibo_user'. rand(1,99999). '@sina.com';
		$siteRegister = XWB_plugin::O('xwbSiteUserRegister');
		$uid = $siteRegister->reg($username, $email);
		return $uid > 0 ? $uid : 0;
	}
	
	/**
	 * 将用户帐号导入（主要应对用了UC的多论坛）
	 * 本函数主要供_setPushbackSiteAccount方法使用
	 * @param array $userInfo uc_get_user返回的数据
	 */
	function _importUserFromUC($userInfo){
		if( !defined('UC_API') ){
			return false;
		}
		
		$uid = (int)$userInfo[0];
		
		$db = XWB_plugin::getDB();
		$exist_uid = intval($db->result_first("SELECT uid FROM ". XWB_S_TBPRE. "members WHERE uid='{$userInfo[0]}' LIMIT 0,1 "));
		if($exist_uid > 0){
			return true;
		}
		
		$username = mysql_real_escape_string($userInfo[1]);
		$email = mysql_real_escape_string($userInfo[2]);
		$password = md5( rand(1,10000) );
		
		$db->query("INSERT IGNORE INTO ". XWB_S_TBPRE. "members (uid, username, password, adminid, groupid, email)
			VALUES ('{$uid}', '{$username}', '{$password}', '0', '10', '{$email}')");
		$db->query("INSERT IGNORE INTO ". XWB_S_TBPRE. "memberfields (uid)
			VALUES ('$uid')");
		return true;
	}
	
	
}