<?php
/**
 * mapper映射管理器，用于存储各类mid,tid,fid之间的绑定和映射关系
 * 
 * @author yaoying
 * @since 2010-12-22
 * @version $Id: siteBindMapper.class.php 649 2011-03-23 06:02:44Z yaoying $
 *
 */
class siteBindMapper{
	
	/**
	 * db实例。由于本类使用非常多的db操作，故干脆用一个属性保存
	 */
	var $_db;
	
	/**
	 * mid数组地图for tid，方便循环的时候记住哪些mid已经查询到绑定了tid
	 * @var array
	 */
	var $midMap2tid = array();
	
	/**
	 * tid数组地图，方便循环的时候记住哪些tid已经查询过了，以及该tid的信息
	 * @var array
	 */
	var $tidMap = array();
	
	/**
	 * fid数组地图，方便循环的时候记住哪些fid已经查询过了，以及该fid的信息
	 * @var array
	 */
	var $fidMap = array();
	
	/**
	 * 构造函数
	 */
	function siteBindMapper(){
		$this->_db = XWB_plugin::getDB();
	}
	
	/**
	 * 对mid进行tid映射
	 * @param array $mids 要映射的mid集合
	 * @return array 映射结果：mid值 => tid值
	 */
	function midMapper2tid( $mids ){
		$mids = array_unique( $mids );
		$query = $this->_db->query('SELECT `mid`, `tid` FROM '. XWB_S_TBPRE. "xwb_bind_thread WHERE `mid` IN (". implode(',', $mids). ")");
		while( $row = $this->_db->fetch_array($query) ){
			$mid = (string)$row['mid'];
			$this->midMap2tid[$mid] = (int)$row['tid'];
		}
		
		return $this->midMap2tid;
	}
	
	
	/**
	 * 对tid进行tid和fid信息映射
	 * @param array $tids 要映射的tid集合
	 * @return array tid=>tid信息映射结果。
	 */
	function tidMapper($tids){
		$tids = array_unique( $tids );
		$fidMap = array();
		$query = $this->_db->query('SELECT * FROM '. XWB_S_TBPRE. "threads WHERE `tid` IN (". implode(',', $tids). ')');
		while( $row = $this->_db->fetch_array($query) ){
			$this->tidMap[$row['tid']] = $row;
			$fidMap[$row['fid']] = (int)$row['fid'];
		}
		if( !empty($fidMap) ){
			$this->fidMapper($fidMap);
		}
		return $this->tidMap;
	}
	
	
	/**
	 * 对fid进行fid信息映射
	 * @param array $fids 要映射的fid集合
	 * @return array 映射结果：fid => fid信息映射
	 */
	function fidMapper( $fids ){
		$fids = array_unique( $fids );
		$query = $this->_db->query('SELECT * FROM '. XWB_S_TBPRE. "forums WHERE `fid` IN (". implode(',', $fids). ')');
		while( $row = $this->_db->fetch_array($query) ){
			$this->fidMap[$row['fid']] = $row;
		}
		
		return $this->fidMap;
	}
	
	/**
	 * 删除一个tidMap
	 * @param int $tid
	 */
	function tidMapDelete($tid){
		unset($this->tidMap[$tid]);
	}
	
	/**
	 * 获取一个midMap
	 * @param float $mid
	 * @return integer tid
	 */
	function midMapGet($mid){
		
		if( isset($this->midMap2tid[(string)$mid]) ){
			return $this->midMap2tid[(string)$mid];
		}elseif( $this->midMap2tid[(float)$mid] ){
			return $this->midMap2tid[(float)$mid];
		}else{
			return 0;
		}
	}
	
	/**
	 * 获取一个tidMap
	 * @param int $tid
	 * @return array
	 */
	function tidMapGet($tid){
		return isset($this->tidMap[$tid]) ? $this->tidMap[$tid] : array();
	}
	
	/**
	 * 获取一个fidMap
	 * @param int $fid
	 * @return array
	 */
	function fidMapGet($fid){
		return isset($this->fidMap[$fid]) ? $this->fidMap[$fid] : array();
	}
	
}