<?php
/**
 * 普通用户校验（For DZ6.0-7.2）
 * 请保证传参所用字符集和论坛字符集一致，否则请先自行转换再传参
 * 返回值有两个array( 0 => UID, 1 => ADMINID )
 * 第一个数组下标（$return[0]）若大于0，则表示验证成功的登录uid。否则为错误信息：
 *  -1:UC用户不存在，或者被删除
 *  -2:密码错
 *  -3:安全提问错
 *  -4:用户没有在dz注册
 * 第二个数组下标（$return[1]）若大于等于0，则表示验证成功的adminid；
 * 否则为-1，表示验证失败
 * @author yaoying
 * @version $Id: siteUserVerifier.class.php 374 2010-12-08 05:54:41Z yaoying $
 */
class siteUserVerifier{
	
	var $db;
	
	function siteUserVerifier(){
		$this->db = XWB_plugin::getDB();
	}
	
	/**
	 * 实在不清楚用哪个进行身份验证的话，就用这个方法统一验证
	 * 请保证传参所用字符集和论坛字符集一致，否则请先自行转换再传参
	 * @param string $username
	 * @param string $password
	 * @param int $questionid
	 * @param string $answer
	 * @param boolen $isuid 使用UID验证么？
	 * @return array
	 *    第一个数组下标（$return[0]）若大于0，则表示验证成功的登录uid。否则为错误信息：
	 *      -1:UC用户不存在，或者被删除
	 *      -2:密码错
	 *      -3:安全提问错
	 *      -4:用户没有在dz注册
	 *    第二个数组下标（$return[1]）若大于等于0，则表示验证成功的adminid；
	 *    否则为-1，表示验证失败
	 */
	function verify( $username, $password, $questionid = '', $answer = '',$isuid = 0 ){
		if ( defined('UC_API') ){
			return $this->verifyUCDZ( $username, $password, $questionid, $answer, $isuid );
		}else{
			return $this->verifyDZ( $username, $password, $questionid, $answer, $isuid );
		}
	}
	
	/**
	 * 没有UC的情况下进行身份验证
	 * @param string $username
	 * @param string $password
	 * @param int $questionid
	 * @param string $answer
	 * @param boolen $isuid 使用UID验证么？
	 * @return array
	 *    第一个数组下标（$return[0]）若大于0，则表示验证成功的登录uid。否则为错误信息：
	 *    	 -1:用户不存在，或者被删除
	 *   	 -2:密码错
	 *   	 -3:安全提问错
	 *    第二个数组下标（$return[1]）若大于等于0，则表示验证成功的adminid；
	 *   	 否则为-1，表示验证失败
	 */
	function verifyDZ( $username, $password, $questionid = '', $answer = '',$isuid = 0 ){
		
		$return = array( 0 => -1, 1 => -1);
		
		if($isuid) {
			$field = 'uid';
		} else {
			$field = 'username';
		}
		$username = mysql_real_escape_string($username);
		$md5_password = md5($password);
		$secques = $this->quescrypt($questionid, $answer);
		$member =$this->db->fetch_first("SELECT uid, username, adminid, password, secques
												FROM ". XWB_S_TBPRE. "members
												WHERE {$field} ='{$username}'");
		
		if( !$member ){
			$return[0] = -1;
		}elseif( $member['password'] !== $md5_password ){
			$return[0] = -2;
		}elseif( $member['secques'] !== $secques ){
			$return[0] = -3;
		}else{
			$return[0] = (int)$member['uid'];
			$return[1] = (int)$member['adminid'];
		}
		
		return $return;
		
	}
	
	/**
	 * 有UC的情况下进行身份验证
	 * @param string $username
	 * @param string $password
	 * @param int $questionid
	 * @param string $answer
	 * @param boolen $isuid 使用UID验证么？
	 * @return array
	 *    第一个数组下标（$return[0]）若大于0，则表示验证成功的登录uid。否则为错误信息：
	 *   	 -1:UC用户不存在，或者被删除
	 *    	 -2:密码错
	 *   	 -3:安全提问错
	 *   	 -4:用户没有在dz注册
	 *    第二个数组下标（$return[1]）若大于等于0，则表示验证成功的adminid；
	 *   	 否则为-1，表示验证失败
	 */
	function verifyUCDZ( $username, $password, $questionid = '', $answer = '',$isuid = 0 ){
		
		$return = array( 0 => -1, 1 => -1);
		
		require_once XWB_S_ROOT. '/uc_client/client.php';
		$ucresult = uc_user_login ($username, $password, $isuid, 1, $questionid, $answer );
		if( $ucresult[0] < 1 ){
			$return[0] = $ucresult[0];
			
		}else{
			$uid = (int)$ucresult[0];
			$member =$this->db->fetch_first("SELECT uid, username, adminid
												FROM ". XWB_S_TBPRE. "members
												WHERE uid='{$uid}'");
			
			if( !$member ){
				$return[0] = -4;
			}else{
				$return[0] = (int)$member['uid'];
				$return[1] = (int)$member['adminid'];
			}
			
		}
		
		return $return;
		
	}
	
	
	/**
	 * 根据安全提问和答案生成安全提问相关验证字段
	 * @param int $questionid
	 * @param string $answer
	 * @return string
	 */
	function quescrypt($questionid, $answer) {
		return $questionid > 0 && $answer != '' ? substr ( md5 ( $answer . md5 ( $questionid ) ), 16, 8 ) : '';
	}
	
	
	
}