<?php

/**
 * 模块：各类xwb用户操作
 * @author xionghui<xionghui1@staff.sina.com.cn>
 * @since 2010-06-08
 * @copyright Xweibo (C)1996-2099 SINA Inc.
 * @version $Id: xwbSiteInterface.mod.php 1030 2012-10-09 10:18:35Z yaoying $
 *
 */
class xwbSiteInterface {
	function xwbSiteInterface(){}
	
	function default_action(){
		echo 'OK!';
	}
	
	function signer(){
		if( !XWB_plugin::pCfg('is_signature_display') ){
			XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博签名”。请稍后再试。');
		}
		
		$myid = XWB_plugin::getBindInfo('sina_uid');
		$myKeyStr = '';
		if (!empty($myid)){
			$wbApi = XWB_plugin::getWB();
			$wbApi->is_exit_error = false;
			$ret = $wbApi->getUserShow($myid);
			if ( isset($ret['created_at']) ){
				$t = @strtotime($ret['created_at']);
				if( $t === false || $t == '-1' ){
					$ret['created_at'] = str_replace('+0800', '', $ret['created_at']);
					$t = @strtotime($ret['created_at']);
					$t = ( $t === false || $t == '-1' ) ? time() : $t;
				}
				$myKeyStr = substr(md5(date('Ymd', $t)),0,8);
			}
			include XWB_P_ROOT.'/tpl/signer.tpl.php';
		}else{
			XWB_plugin::redirect('xwbSiteInterface.bind', 2);
		}
		
	}
	
	function getTips(){
//		if( !XWB_plugin::pCfg('is_tips_display') ){
//			$this->ajaxOut('99999', '新浪微博资料页功能已经关闭！');
//		}
		
		$view_id = strval(XWB_plugin::V('g:view_id'));
		if (!is_numeric($view_id) || empty($view_id)) {$this->ajaxOut('10001', '查看目标ID不能为空.');}

        $wbApi  = XWB_plugin::getWB();
        $keys	= $this->_getTockenFromDB($view_id);
        if (empty($keys))  {$this->ajaxOut('10002', '无法从数据库中获取对方绑定信息，可能是未绑定用户，不能查看其信息.');}
        $wbApi->setTempToken($keys['oauth_token'], $keys['oauth_token_secret']);
        $wbApi->is_exit_error = false;

        /* 获取数据库缓存的用户资料 2010-09-09 */
        $data = $this->_getUserInfoFromDB($view_id);
        /* 结束 */

        if ( ! $data || ! isset($data['timestamp']) || intval(XWB_plugin::pCfg('wbx_medal_update_time')) < time() - $data['timestamp']) // 判断是否更新缓存数据 2010-09-09
        {
            $rst = $wbApi->getUserShow($view_id);

            if (!is_array($rst) || isset($rst['error']) || empty($rst['id'])){
                $this->ajaxOut('10003', '无法从接口中用户信息,['.$rst['error_code'].":".$rst['error'].']');
            }

            $data = array(
                'sina_uid'=>$rst['id'].'','sina_name'=>$rst['screen_name'],'location'=>$rst['location'],
                'gender'=>$rst['gender'],'profile_image_url'=>$rst['profile_image_url'],
                'followers_count'=>$rst['followers_count'],'friends_count'=>$rst['friends_count'],'statuses_count'=>$rst['statuses_count'],
                'description'=>$rst['description'],'last_blog'=>$rst['status']['text'],'last_blog_id'=>$rst['status']['id'].'',
                'timestamp'=>time()
            );
		
            /* 用户资料写入数据库 */
            $this->_setUserInfoFromDB($view_id, $data);
            /* 结束 */
        }

        $isFriend	= 0;
        $mySinaUid	= XWB_plugin::getBindInfo('sina_uid','');
        if ( !empty($mySinaUid) ){
            if( $mySinaUid == $view_id ){
                $isFriend	= 1;
            }else{
                $isFriend	= $wbApi->existsFriendship($mySinaUid,$view_id);
                $isFriend	= $isFriend['friends']==true ? 1 : 0;
            }
            $data['isFriend'] = $isFriend;
        }

		$this->ajaxOut(0,$data);		
	}
	
	function ajaxOut($code, $rst=''){
		echo json_encode(array($code, $rst));exit;
	}
	
	/// 从数据库中获取 OAUTH KEYS 
	function _getTockenFromDB($sina_uid){
		$r = XWB_plugin::getBindUser($sina_uid, 'sina_uid'); //远程API
        if (empty($r)){
        	return false;
        }
		return array('oauth_token'=>$r['token'],
					 'oauth_token_secret'=>$r['tsecret'],
					 'uid'=>$r['uid'],
					 'sina_uid'=>$r['sina_uid']);
	}
	
    /**
     * 将用户资料写入数据库 2010-09-09
     *
     * @param array $dataset 要写入的数据
     */
    function _setUserInfoFromDB($sina_uid, $dataset)
    {
        $profile = XWB_plugin::O('xwbUserProfile');
        return $profile->set4Tip($sina_uid, 'tipUserInfo', $dataset);
    }

    /**
     * 从数据库中获取用户资料 2010-09-09
     */
    function _getUserInfoFromDB($sina_uid)
    {
        $profile = XWB_plugin::O('xwbUserProfile');
        return $profile->get4Tip($sina_uid, 'tipUserInfo', FALSE);
    }

	function attention(){
		$att_id = strval(XWB_plugin::V('g:att_id'));
		if(!is_numeric($att_id)){
			XWB_plugin::showError('要关注的用户参数错误！');
		}
				
		if( !XWB_plugin::pCfg('is_tips_display') ){
			XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博资料页”。请稍后再试。');
		}
		if(!xwb_token::checkSecFormhash('g')){
			XWB_plugin::showError('令牌验算错误，请求非法。');
		}
		if(xwb_token::checkReferer() < 0){
			XWB_plugin::showError('请求来源失效，请重试！');
		}		
				
		$wbApi  = XWB_plugin::getWB();
		$wbApi->is_exit_error = false;
		$mySinaUid	= XWB_plugin::getBindInfo('sina_uid','');
		if (empty($mySinaUid)){
			XWB_plugin::showError('你不是绑定用户，不能关注其它用户');
		}
		
		$rst = $wbApi->createFriendship($att_id);
		$url = XWB_plugin::getWeiboProfileLink($att_id);
		XWB_plugin::redirect($url, 3);
	}
	
	
	function pluginCfg(){
		global $_DCACHE;
		if (!defined('XWB_S_IS_ADMIN') || !XWB_S_IS_ADMIN){
			XWB_plugin::deny('');
		}
		$tokenhash = xwb_token::make('pluginCfg', true);
		include XWB_P_ROOT.'/tpl/plugin_cfg.tpl.php';
	}

	function doPluginCfg(){
		if (!defined('XWB_S_IS_ADMIN') || !XWB_S_IS_ADMIN || !XWB_plugin::isRequestBy('POST')){
			XWB_plugin::deny('');
		}elseif(!xwb_token::checkInput('p','pluginCfg', true)){
			XWB_plugin::showError('令牌验证失败，请返回重试');
		}
		
		$ret = array(1,'插件设置保存成功');
		
		$set = (array)XWB_plugin::V('p:pluginCfg');
		
		$inputCheck = array(
							'wb_addr_display' => array(0,1),
							'reg_pwd_display' => array(0,1),
							'is_account_binding' => array(0,1),
							'is_synctopic_toweibo' => array(0,1),
							'is_syncreply_toweibo' => array(0,1),
							'is_rebutton_display' => array(0,1),
							'is_tips_display' => array(0,1),
							'is_signature_display' => array(0,1),
							'is_sync_face' => array(0,1),
							'is_upload_image' => array(0,1),
							'wbx_is_title' => array(0,1),
							'wbx_is_blog' => array(0,1),
							'wbx_is_fans' => array(0,1),
							'wbx_width' => array(190,300),
							'wbx_height' => array(75,500),
							'wbx_style' => array(1,5),
							'wbx_line' => array(1,7),
							'is_wbx_display' => array(0,1),
							);
		
		foreach ( $inputCheck as $key => $value ){
			if (!isset($set[$key])|| !is_scalar($set[$key]) || (int)$set[$key] < $value[0] || (int)$set[$key] > $value[1] ){
				$set[$key] = $value[0];
			}else{
				$set[$key] = (int)$set[$key];
			}
		}
		
        /* 新增新浪勋章更新时间间隔 2010-09-09 */
        $set['wbx_medal_update_time'] = intval($set['wbx_medal_update_time']);

        /* 新增微博转发间隔 2010-10-08 */
        $set['wbx_share_time'] = intval($set['wbx_share_time']);

		if (!XWB_plugin::setPCfg($set)){
			$ret = array(0,'设置保存失败，请检查插件目录是否可写。');
		}else{
			$this->_doPluginCfgInDz();
			@unlink(XWB_S_ROOT. '/forumdata/cache/cache_settings.php');
			require_once XWB_S_ROOT. '/include/cache.func.php';
			updatecache('settings');
		}
		
		$this->_oScript('xwbSetTips',$ret);
	}
	
	function _doPluginCfgInDz(){
		$set = (array)XWB_plugin::V('p:dcache');
		
		$newset = array();
		
		$inputCheck = array(
							'sina_is_display_login_button' => array(0,1),
							'sina_bind_btn_usernav' => array(0,1),
							);
		
		foreach ( $inputCheck as $key => $value ){
			if (!isset($set[$key])|| !is_scalar($set[$key]) || (int)$set[$key] < $value[0] || (int)$set[$key] > $value[1] ){
				$newset[$key] = $value[0];
			}else{
				$newset[$key] = (int)$set[$key];
			}
		}
		
		$db = XWB_plugin::getDB();
		foreach($newset as $name => $value){
			$name = mysql_real_escape_string($name);
			$value = (int)$value;
			$db->query("REPLACE INTO ". XWB_S_TBPRE. "settings (`variable`, `value`) VALUES ('{$name}', '{$value}')");
		}
		
	}
	
	function reg(){
		if( !XWB_plugin::pCfg('is_account_binding') ){
			XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博绑定”。请稍后再试。');
		}
		
		$this->_chkIsWaitingForReg();
		$xwb_user = XWB_plugin::getUser();
		$sina_id = $xwb_user->getInfo('sina_uid');
		$wb = XWB_plugin::getWB();
		
		$sina_user_info = $wb->getUserShow($sina_id);
		
		//$screen_name = $sina_user_info['screen_name'];
			
		include XWB_P_ROOT.'/tpl/register.tpl.php';
	}
	
	function doReg(){
		if( !XWB_plugin::pCfg('is_account_binding') || !XWB_plugin::isRequestBy('POST') ){
			XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博绑定”。请稍后再试。');
		}
		
		$this->_chkIsWaitingForReg();
		$usernameS	= trim( (string)(XWB_plugin::V('p:siteRegName')) );
		$emailS		= trim( (string)(XWB_plugin::V('p:siteRegEmail')) );
		$regPwdS	= trim( (string)(XWB_plugin::V('p:regPwd')) );
		
		//转换成论坛编码，方便进行UC和论坛的注册数据库操作
		$username	= XWB_plugin::convertEncoding($usernameS, "UTF8", XWB_S_CHARSET);
		$email		= XWB_plugin::convertEncoding($emailS, "UTF8", XWB_S_CHARSET);
		$password = $regPwdS;
		
		$uid = 0;
		if (empty($username))				{$uid = -102;}
		if (empty($email))	{$uid = -101;}
		if (empty($password))	{$uid = -103;}
		
		$db	 = XWB_plugin::getDB();
		
		if (empty($uid)){
			$wbApi	= XWB_plugin::getWB();
			$api_uid = $wbApi->get_uid();
			$uInfo	= $wbApi->verifyCredentials($api_uid['uid']);
			
			//验证微博帐号是否已经在当前站点中绑定，防止用户通过多个浏览器恶意注册用户
			$bInfo = XWB_plugin::getBindUser($uInfo['id'], 'sina_uid'); //远程API
			if ( !empty($bInfo) && is_array($bInfo) ){
				$uid = -201;
			}else{
				$regInstance = XWB_plugin::O('xwbSiteUserRegister');
				$uid = $regInstance->reg($username, $email, $password);
			}
			unset($bInfo);
		}
		
		$msg = '';
		
		if ($uid<1){
			$msg = $this->_getRegTip($uid);
		}else{
			$sess = XWB_plugin::getUser();
			$sess->setInfo('sina_uid', $uInfo['id']);
			$last_key = $sess->getOAuthKey(true);
			
			
			$rst = XWB_plugin::addBindUser($uid, $uInfo['id'], (string)$last_key['oauth_token'], (string)$last_key['oauth_token_secret'], $uInfo['screen_name']); //远程API
			
			require_once XWB_P_ROOT. '/lib/xwbSite.inc.php';
			xwb_setSiteUserLogin($uid);
			
            //更新expire值
            $userProfile_obj =& XWB_plugin::N('xwbUserProfile');
            $userProfile_obj->uid = $uid;
            $oauth2_expiretime = $sess->getInfo('oauth2_expiretime');
            if($oauth2_expiretime < time()){
            	$oauth2_expiretime = time() + 604800;
            }
            $userProfile_obj->set('oauth2_expiretime', $oauth2_expiretime);
            unset($userProfile_obj);			
			
			if( XWB_plugin::pCfg('is_sync_face') ){
				//同步新浪头像（放到脚本结束时进行）
				$faceSync = XWB_plugin::N('sinaFaceSync');
				register_shutdown_function(array(&$faceSync, 'sync'), $uid);
			}
			
			dsetcookie($this->_getBindCookiesName($uid), (string)$uInfo['id'], 604800);
			setcookie('xwb_tips_type','',0);
			$sess->setInfo('waiting_site_reg', '0');
			
			$displayWindow = (int)XWB_plugin::pCfg('reg_pwd_display');
			
			$msg = "已为你创建了" . XWB_S_TITLE .  "论坛的帐号，并与你的新浪微博帐号进行绑定。下次你可以继续使用新浪微博帐号登录使用" . XWB_S_TITLE . "论坛。";
			
			//人工审核
			if( $GLOBALS['regverify'] == 2  ) {
				$displayWindow = 1;
				$msg .= '<br /><em>请等待管理员审核你的帐号 '. htmlspecialchars($usernameS). '</em><br />在完成审核之前，根据管理员设置，你将只能以待验证会员的身份访问论坛，你可能不能进行发帖等操作。审核成功后，上述限制将自动取消。';
			//EMAIL验证
			}elseif( $GLOBALS['regverify'] == 1 ){
				$displayWindow = 1;
				$msg .= '<br /><em>你的帐号 '. htmlspecialchars($usernameS). ' 处于非激活状态，请收取邮件激活你的帐号</em>'.
						'<br />如果你没有收到我们发送的系统邮件，请进入个人中心点击“重新验证 Email”或在“密码和安全问题”中更换另外一个 Email 地址。注意：在完成激活之前，根据管理员设置，你将只能以待验证会员的身份访问论坛。';
				$msg .= "<br />邮箱:  <em>".htmlspecialchars($emailS)."</em>  ";
			}else{
				$msg.="<br>帐号:  <em>".htmlspecialchars($usernameS)."</em>  ";
			}
			
			//反向绑定统计上报
			$sess->appendStat('bind', array( 'uid' => $uInfo['id'], 'type' => 2 ));
			
			if( defined('UC_API') && $GLOBALS['allowsynlogin'] ){
				require_once XWB_S_ROOT.'/uc_client/client.php';
				$this->_outputUJ(uc_user_synlogin($uid));
			}
			
		}
		$this->_oScript('xwbSetTips',array($uid,$msg, $displayWindow));
	}
	
	
	function doBindAtNotLog(){
		if( !XWB_plugin::pCfg('is_account_binding') || !XWB_plugin::isRequestBy('POST')){
			XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博绑定”。请稍后再试。');
		}
		
		$this->_chkIsWaitingForReg();
		
		$ipCountInstance =& XWB_Plugin::O('xwbIpCount');
		$ipInputCount = $ipCountInstance->get('regInput');
		if($ipInputCount >= 5){
			$this->_oScript('xwbSetTips',array('-2001', '密码错误输入次数超出限制，请15分钟后重试', 1));
			exit();
		}
		
		$usernameS	= trim( (string)(XWB_plugin::V('p:siteBindName')) );
		$password	= trim( (string)(XWB_plugin::V('p:bindPwd')) );
		$questionid	= (int)(XWB_plugin::V('p:questionid'));
		$questionanswerS	= trim( (string)(XWB_plugin::V('p:questionanswer')) );
		
		$username	= XWB_plugin::convertEncoding($usernameS, "UTF8", XWB_S_CHARSET);
		if( !empty($questionanswerS) ){
			$questionanswer		= XWB_plugin::convertEncoding($questionanswerS, "UTF8", XWB_S_CHARSET);
		}else{
			$questionanswer = '';
		}
		
		$uid = 0;
		//第1关：数据输入验证关
		if (empty($username))				{$uid = -102;}
		if (empty($password))				{$uid = -103;}
		
		$msg = '';
		//第2关：用户身份验证关
		if( $uid == 0  ){
			$verify = XWB_plugin::O('siteUserVerifier');
			$verifyresult = $verify->verify ( $username, $password, $questionid, $questionanswer );
			$uid = $verifyresult[0];
			if($uid < 1){
				$ipCountInstance->set('regInput', $ipInputCount + 1);
			}
		}
		
		if( $uid > 0 ){
			$wbApi	= XWB_plugin::getWB();
			$api_uid = $wbApi->get_uid();
			$uInfo	= $wbApi->verifyCredentials($api_uid['uid']);
			
			$db	 = XWB_plugin::getDB();
			//第3关：验证微博帐号是否已经在当前站点中绑定，防止用户通过多个浏览器恶意注册用户
			$bInfo = XWB_plugin::getBUById($uid, $uInfo['id']); //远程API
			if ( !empty($bInfo) && is_array($bInfo) ){
				$uid = -201;
			}else{
				$sess = XWB_plugin::getUser();
				$sess->setInfo('sina_uid', $uInfo['id']);
				$last_key = $sess->getOAuthKey(true);
			
				$rst = XWB_plugin::addBindUser($uid, $uInfo['id'], (string)$last_key['oauth_token'], (string)$last_key['oauth_token_secret'], $uInfo['screen_name']); //远程API
			
				require_once XWB_P_ROOT. '/lib/xwbSite.inc.php';
				xwb_setSiteUserLogin($uid);
			
        	    //更新expire值
          	 	$userProfile_obj =& XWB_plugin::N('xwbUserProfile');
           		$userProfile_obj->uid = $uid;
            	$oauth2_expiretime = $sess->getInfo('oauth2_expiretime');
            	if($oauth2_expiretime < time()){
            		$oauth2_expiretime = time() + 604800;
            	}
            	$userProfile_obj->set('oauth2_expiretime', $oauth2_expiretime);
            	unset($userProfile_obj);
				
				dsetcookie($this->_getBindCookiesName($uid), (string)$uInfo['id'], 604800);
				dsetcookie('xwb_tips_type','',0);
				$sess->setInfo('waiting_site_reg', '0');
			
				$msg = "绑定论坛帐号成功。下次你可以继续使用新浪微博帐号登录使用" . XWB_S_TITLE . "论坛。";
				$msg.="<br>绑定帐号:  <em>".htmlspecialchars($usernameS)."</em>  ";
				
				//正向绑定（在未登录论坛帐号已登录新浪微博帐号的绑定页面）统计上报
				$sess->appendStat('bind', array( 'uid' => $uInfo['id'], 'type' => 1 ));
				
				if( defined('UC_API') && $GLOBALS['allowsynlogin'] ){
					require_once XWB_S_ROOT.'/uc_client/client.php';
					$this->_outputUJ(uc_user_synlogin($uid));
				}
				
			}
		}
		
		if( $uid <= 0 ){
			$msg = $this->_getBindTip($uid);
		}
		
		$this->_oScript('xwbSetTips',array($uid, $msg, 1));
		
		
	}
	
	
	function _getRegTip( $code ){
		$tips = array(
			'-1' => '用户名太长',
			'-2' => '用户名包含敏感字符',
			'-3' => '此账户已被使用',
			'-4' => '邮箱格式错误或已被使用',
			'-5' => '邮箱格式错误或已被使用',
			'-6' => '邮箱格式错误或已被使用',

			'-101' => '用户邮箱不能为空',
			'-102' => '用户帐号不能为空',
			'-103' => '密码不能为空',
			'-104' => '密码不一致',
		
			'-1001' => '24 小时注册次数超限，请稍后重试',
			'-1002' => 'IP 注册间隔超限，请稍后重试',
			'-1003' => '特殊 IP 注册限制（每 72 小时将至多只允许注册一个帐号），请稍后重试',
		
			'-201' => '微博帐号已绑定',
		);
		
		$code = (string)$code;
		return isset($tips[$code]) ? $tips[$code] : '未知错误';
	}
	
	
	function _getBindTip( $code ){
		$tips = array(
			'-1' => '用户不存在',
			'-2' => '密码错误',
			'-3' => '安全提问错误',
			'-4' => '用户在论坛未激活',
		
			'-102' => '用户帐号不能为空',
			'-103' => '密码不能为空',
			
			'-201' => '微博帐号已绑定',
		);
		
		$code = (string)$code;
		return isset($tips[$code]) ? $tips[$code] : '未知错误';
	}
	
	function _oScript($func,$ret){
		echo '<script>';
		echo "parent.".$func."(".json_encode($ret).");";
		echo '</script>';
		exit;
	}
	
    ///输出UCenter同步JS
	function _outputUJ($js) {
        echo $js;
    }	
	
	/// 检查是否 等待注册并绑定用户
	function _chkIsWaitingForReg(){
		$sess = XWB_plugin::getUser ();
		$isReg = $sess->getInfo ( 'waiting_site_reg' );
		if ( XWB_S_UID || empty ( $isReg )) {
			$sess->clearToken();
			$this->_oScript ( 'parent.XWBcontrol.close', 'reg' );
		}
	}
	
	/// 找开绑定设置或者绑定提示页面
	function bind(){
		if( !XWB_plugin::pCfg('is_account_binding') ){
			XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博绑定”。请稍后再试。');
		}
		
		$sync_tokenhash = xwb_token::make('sync', true);
		$unbind_tokenhash = xwb_token::make('unbind', true);		
		
		if ( XWB_S_UID > 0 && XWB_plugin::isUserBinded() ) {
			$xwb_user = XWB_plugin::getUser();
			$sina_id = $xwb_user->getInfo('sina_uid');
			$wb = XWB_plugin::getWB();
			$wb->is_exit_error = false;
			$sina_user_info = $wb->getUserShow($sina_id);
			dsetcookie($this->_getBindCookiesName(XWB_S_UID), $sina_id, 604800);
			
			if( isset($sina_user_info['error_code']) || isset($sina_user_info['error']) ){
				include XWB_P_ROOT.'/tpl/xwb_cenbind_error.tpl.php';
				
			}else{
				$screen_name = $sina_user_info['screen_name'];
				$profile = XWB_plugin::O('xwbUserProfile');
				$setting = $profile->get('bind_setting', 1);
				$myExpireTime = $profile->get('oauth2_expiretime', null);
				include XWB_P_ROOT.'/tpl/xwb_cenbind_on.tpl.php';
			}
		} else {
			$sess = XWB_plugin::getUser();
			$sess->logReferer();
			dsetcookie($this->_getBindCookiesName(XWB_S_UID), -1, 604800);
			include XWB_P_ROOT.'/tpl/xwb_cenbind_off.tpl.php';
		}
	}

	/**
	 * 解除绑定
	 */
	function unbind() {
		if(  XWB_S_UID < 1 || !XWB_plugin::pCfg('is_account_binding') ){
			XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博绑定”。请稍后再试。');
		}elseif(!xwb_token::checkInput('p','unbind', true)){
			XWB_plugin::showError('令牌验证失败，请返回重试');
		}
		
		XWB_plugin::delBindUser(XWB_S_UID); //远程API
		$sess = XWB_plugin::getUser();
		$sess->clearInfo();
		dsetcookie($this->_getBindCookiesName(XWB_S_UID), -1, 604800);
		echo '1';
	}
	
	/**
	 * 设置发帖同步
	 */
	function bindTopic() {
		if( XWB_S_UID < 1 || !XWB_plugin::pCfg('is_account_binding') || !XWB_plugin::isRequestBy('POST') ){
			XWB_plugin::showError('新浪微博绑定功能已经关闭！');
		}elseif(!xwb_token::checkInput('p','sync', true)){
			XWB_plugin::showError('令牌验证失败，请返回重试');
		}
		
		$setting = (int)XWB_plugin::V('p:setting');
		$profile = XWB_plugin::O('xwbUserProfile');
		$profile->set('bind_setting', $setting);
		echo '<script>parent.tips();</script>';
	}
	
    /**
     * 获取转发帖子内容
     */
    function share()
    {
        if( ! XWB_plugin::pCfg('is_rebutton_display')){
        	XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博分享”。请稍后再试。');
        }

        /* 获取用户信息 */
        $rst = $this->_getUserInfo();
        if (isset($rst['error_no']) && 0 < $rst['error_no']) $this->_showTip($rst['error']);

        /* 获取主题ID */
		$tid = intval(XWB_plugin::V('g:tid'));
		if (empty($tid)) $this->_showTip('错误:查看帖子ID不能为空.', $rst);

        /* 获取主题信息 */
        $xp_publish = XWB_plugin::N('xwb_plugins_publish');
        $shareData = $xp_publish->forShare($tid);
        if (empty($shareData)) $this->_showTip('错误:无法获取主题信息.', $rst);

        /* 销毁 SESSION['forshare'] 变量*/
        $sess = XWB_plugin::getUser();
        $sess->delInfo('forshare');

        /* 写入 SESSION，防止外部转发 */
        $sess->setInfo('forshare', 1);
        
        include XWB_P_ROOT.'/tpl/share.tpl.php';
    }

    /**
     * 帖子转发
     */
    function doShare()
    {
        if( ! XWB_plugin::pCfg('is_rebutton_display') || !XWB_plugin::isRequestBy('POST')){
        	XWB_plugin::showError('网站管理员关闭了插件功能“新浪微博分享”。请稍后再试。');
        }

        $sess = XWB_plugin::getUser();
        /* 判断是否外部转发 */
        if ( 1 != $sess->getInfo('forshare')) XWB_plugin::showError('禁止外部转发');
        
        /* 销毁 SESSION['forshare'] 变量*/
        $sess->delInfo('forshare');

        /* 判断转发时间间隔 */
        $shareTime = intval(XWB_plugin::pCfg('wbx_share_time'));
        if ($shareTime >= time() - intval($sess->getInfo('sharetime'))) XWB_plugin::showError("转发过快，转发间隔为 {$shareTime} 秒");
        
        /* 获取用户信息 */
        $rst = $this->_getUserInfo();
        if (isset($rst['error_no']) && 0 < $rst['error_no']) $this->_showTip($rst['error']);

        /* 获取传递信息 */
        $message = trim(strval(XWB_plugin::V('p:message')));
        $pic = trim(strval(XWB_plugin::V('p:share_pic')));
		if (empty($message)) $this->_showTip('错误:转发信息不能为空.', $rst);

        /* 转发主题 */
        $xp_publish = XWB_plugin::N('xwb_plugins_publish');
        $ret = $xp_publish->sendShare($message, $pic);

        /* 写入 SESSION 发布时间 */
        $sess->setInfo('sharetime', time());
        
        /* 错误处理 */
        if ($ret === false || $ret === null) $this->_showTip('错误:系统错误!', $rst);
        if (isset($ret['error_code']) && isset($ret['error']))
        {
            $error_code_se = substr($ret['error'], 0, 5);
            if ('20017' == $ret['error_code'] || '20017' == $error_code_se){
                $ret['error'] = '错误:不能发布相同的微博!';
            }else{
                $ret['error'] = '错误:系统错误!('. $ret['error']. ')';
            }
            $this->_showTip($ret['error'], $rst);
        }

        $this->_showTip('转发成功！', $rst);
    }
    
    /**
     * 获取用户信息
     * @return array $rst 用户信息
     */
    function _getUserInfo()
    {
        /* 获取绑定信息 */
		$sina_id = XWB_plugin::getBindInfo('sina_uid');
        if ( ! $sina_id)
            return array('error_no' => '10001', 'error' => '错误:用户未绑定.');

        /* 获取用户资料 */
        $wbApi = XWB_plugin::getWB();
        $keys = $this->_getTockenFromDB($sina_id);
        if (empty($keys))
            return array('error_no' => '10002', 'error' => '错误:无法获取绑定信息.');

        $wbApi->setTempToken($keys['oauth_token'], $keys['oauth_token_secret']);
        $wbApi->is_exit_error = false;
        $rst = $wbApi->getUserShow($sina_id);

        if ( ! is_array($rst) || isset($rst['error']) || empty($rst['id']))
            return array('error_no' => '10003', 'error' => "错误:无法从接口中获取用户信息.");

        return $rst;
    }

    /**
     * 显示信息
     * @param string $tipMsg 显示信息
     * @param array $rst 用户信息
     */
    function _showTip($tipMsg, $rst = array())
    {
        include XWB_P_ROOT.'/tpl/share_msg.tpl.php';
        exit;
    }

    /**
     * 输出错误
     * @param string $errMsg 错误信息
     */
    function _showErr($errMsg)
    {
        header('Content-Type: text/html;charset=utf-8');
        exit($errMsg);
    }
    
    /**
     * 跳转到标准版
     */
    function redirectToStd(){
    	$xweibourl = rtrim(XWB_plugin::pCfg('baseurl_to_xweibo'), '/');
		if(XWB_plugin::pCfg('switch_to_xweibo') && !empty($xweibourl)){
			$param = $_GET;
			$param['m'] = isset($param['std_m']) ? $param['std_m'] : '';
			unset($param['std_m']);
			XWB_plugin::redirect($xweibourl. '/index.php?'. http_build_query($param), 3);
		}else{
			XWB_plugin::showError('没有开启与标准版通讯，故无法跳转');
		}
    }

    /**
     * 获取未读取数目
     * 只有开启了标准版对接功能之后，才有此功能
     */
    function setUnreadCookie(){
    	$result = array(
    		'errno' => 0, 
    		'uid' => XWB_S_UID,
    		'followers' => 0,
    		'dm' => 0,
    		'mentions' => 0,
    		'comments' => 0,
    		'allsum' => 0
    	);
    	
    	if(!$this->_checkNextUnreadTime()){
    		$result['errno'] = -1;
    	}elseif(!XWB_plugin::pCfg('switch_to_xweibo')){
    		$this->_setNextUnreadCheckTime();
    		$result['errno'] = -3;
    	}elseif(!XWB_S_UID || !XWB_Plugin::isUserBinded()){
    		$this->_setNextUnreadCheckTime();
    		$result['errno'] = -2;
    	}else{
    		$wb = XWB_plugin::getWB();
    		$wb->is_exit_error = false;
    		$respond = $wb->getUnread();
    		if(!is_array($respond) || isset($respond['error'])){
    			$result['errno'] = isset($respond['error']) ? (int)$respond['error'] : -3;
    		}else{
    			$result = array_merge($result, $respond);
    			$this->_setUnreadCookie($result);
    		}
    		
    		$this->_setNextUnreadCheckTime();
    	}
    	
		if($result['errno'] != 0){
    		header("HTTP/1.1 403 Forbidden");
    	}
    	
    	echo 'var _xwb_unread_new = '. json_encode($result). ';';
    	
    	exit;
    	
    }
    
    /**
     * 设置下一次检查unread的时间
     */
    function _setNextUnreadCheckTime(){
    	$expire = 60;    //60秒读取1次
    	$nexttime = time() + $expire;
    	$sess = XWB_Plugin::getUser();
    	$sess->setInfo('xwb_nextunread_'. XWB_S_UID, $nexttime );
    	dsetcookie('xwb_nextunread_'. XWB_S_UID, $nexttime, $expire);
    }
    
    /**
     * 检查下一次检查unread的时间是否到达
     * @return bool
     */
    function _checkNextUnreadTime(){
    	if(XWB_S_UID < 1){
    		return false;
    	}
    	$sess = XWB_Plugin::getUser();
    	$nexttime = intval($sess->getInfo('xwb_nextunread_'. XWB_S_UID));
    	//return true;
    	return ($nexttime == 0 || time() >= $nexttime );
    }
    
    /**
     * 根据已有的未读结果，将结果写入cookies
     * @param array $result
     */
    function _setUnreadCookie($result){
    	$_cookieResult = array(
    		'followers' => 0,
    		'dm' => 0,
    		'mentions' => 0,
    		'comments' => 0,
    	);
    	
    	$expire = 0;    //cookie-session
    	
    	foreach($_cookieResult as $name => $value){
    		$_cookieResult[$name] = isset($result[$name]) ? (int)$result[$name] : 0;
    		dsetcookie("xwb_{$name}_". XWB_S_UID, $_cookieResult[$name], $expire);
    	}
    	
    }
    
    /**
     * 发送绑定状态的Cookies
     */
    function sendBindStatusCookie(){
    	global $_DCOOKIE;
    	$bind_status_cookiename = $this->_getBindCookiesName(XWB_S_UID);
    	if(XWB_S_UID < 0 || isset($_DCOOKIE[$bind_status_cookiename])){
    		echo 'var kkk = 0;';
    		exit();
    	}
    	$db = XWB_Plugin::getDB();
    	$sina_uid = $db->result_first('SELECT `sina_uid` FROM '. XWB_S_TBPRE. 'xwb_bind_info WHERE `uid` = '. XWB_S_UID );
    	if( !is_numeric($sina_uid) && $sina_uid < 1 ){
    		$sina_uid = -1;	//-1未绑定状态、大于0表示绑定的用户
    	}
    	dsetcookie($bind_status_cookiename, (string)$sina_uid, 604800);
    	echo 'var kkk = 1;';
    }
    
 	/**
	 * 获取Bind cookies名称
	 * @param integer $uid
	 * @return string
	 */
	function _getBindCookiesName($uid){
		return 'sina_bind_'. $uid;
	}
	
}


?>
