<?php

/**
 * 在附属站点注册新用户（根据代码register.php进行重写和类封装）
 * For Discuz! 6.0-7.2
 * 
 * @author yaoying<yaoying@staff.sina.com.cn>
 * @copyright Xweibo (C)1996-2099 SINA Inc.
 * $Id: xwbSiteUserRegister.class.php 486 2010-12-28 07:15:33Z yaoying $
 *
 */
class xwbSiteUserRegister{
	
	var $uid = -999;
	var $username = '';
	var $password = '';
	var $email = '';
	var $question = '';
	var $answer = '';
	var $groupid = -999;
	var $ip;
	var $timestamp = 0;
	
	var $db;
	
	/**
	 * 24 小时注册尝试次数限制（regfloodctrl）专用判断属性，系统在运行时自动调整
	 * -1：系统没有使用regfloodctrl
	 * 0：系统使用了regfloodctrl，但本ip暂没有记录，需要准备记录
	 * 大于0：系统使用了regfloodctrl，数值为本ip的记录次数
	 *
	 * @var integer
	 */
	var $regfloodcount = -1;
	
	
	/**
	 * 资源初始化
	 * @access public
	 * @return xwbSiteUserRegister
	 */
	function xwbSiteUserRegister(){
		$this->db = XWB_plugin::getDB();
		$this->ip = (string)$GLOBALS['onlineip'];
		$this->timestamp = $GLOBALS['timestamp'];
	}
	
	
	/**
	 * 注册一个新帐户
	 * @access public
	 * @param string $name 和论坛编码相符合的用户名
	 * @param string $email 和论坛编码相符合的Email
	 * @param mixed $pwd
	 * @return integer
	 */
	function reg( $name, $email, $pwd= false ){
		$this->username = mysql_escape_string(trim($name));
		$this->email = mysql_escape_string(trim($email));
		$this->password = $pwd ? mysql_escape_string($pwd) : rand(100000,999999);
		
		$checkRegCTRL = $this->_checkRegCTR();
		if( $checkRegCTRL < 0 ){
			return $checkRegCTRL;
		}
		
		$this->_initGroupid();
		//直接用UC_API进行判断，省得switch一大堆版本
		if( !defined('UC_API') ){
			$this->_regToDZOnly();
		}else{
			$this->_regToUCDZ();
		}
		
		if( $this->uid > 0 ){
			$this->_updateRegCTR();
			$this->_updateSiteUserCount();
			$this->_updateUserRegVerify();
		}
		
		return $this->uid;
		
	}
	
	/**
	 * 在UC和DZ进行用户初始化注册
	 * @access protected
	 * @return boolen
	 */
	function _regToUCDZ(){
		require_once XWB_S_ROOT.'/uc_client/client.php';
		$this->uid = (int)uc_user_register($this->username, $this->password, $this->email, $this->questionid, $this->answer);
		if ($this->uid > 0){
			//在有UC的情况下，附属论坛的members表password列并不存储真实密码，只是用于cookies登陆状态校样。
			$sql_password	= md5(rand(100000,999999));
			$secques = '';
			
			$this->db->query("INSERT INTO ". XWB_S_TBPRE. "members (uid, username, password, secques, adminid, groupid, regip, regdate, lastip, lastvisit, lastactivity, posts, credits, extcredits1, extcredits2, extcredits3, extcredits4, extcredits5, extcredits6, extcredits7, extcredits8, email, showemail, timeoffset, pmsound, invisible, newsletter)
					VALUES ('$this->uid', '$this->username', '$sql_password', '$secques', '0', '{$this->groupid}', '$this->ip', '$this->timestamp', '$this->ip', '$this->timestamp', '$this->timestamp', '0', {$GLOBALS['initcredits']}, '{$this->email}', '0', '9999', '1', '0', '1')");
			$this->db->query("INSERT INTO ". XWB_S_TBPRE. "memberfields (uid)
					VALUES ('$this->uid')");
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * 在没有UC的DZ进行初始化用户注册
	 * @access protected
	 * @return boolen
	 */
	function _regToDZOnly(){
		require_once XWB_P_ROOT.'/lib/compatDZ6.inc.php';
		$this->uid = (int)uc_user_register($this->username, $this->password, $this->email, $this->questionid, $this->answer);
		if ( $this->uid > 0  && $this->groupid != 10 ){
			$this->db->query( "UPDATE  ". XWB_S_TBPRE. "members SET groupid='{$this->groupid}' WHERE uid = '{$this->uid}' " );
		}
		return $this->uid > 0 ? true : false;
	}
	
	
	/**
	 * 更新用户数
	 * @access protected
	 * @return bool
	 */
	function _updateSiteUserCount(){
		if( $this->uid < 0 ){
			return false;
		}
		
		$GLOBALS['_DCACHE']['settings']['totalmembers']++;
		if( version_compare( XWB_S_VERSION, '7.0.0', '<') ){
			$GLOBALS['_DCACHE']['settings']['lastmember'] = dhtmlspecialchars($this->username);
		}
		require_once DISCUZ_ROOT.'./include/cache.func.php';
		updatesettings();
		return true;
	}
	
	
	/**
	 * 根据附属站点注册控制设置进行对应更新操作
	 * @access protected
	 * @return bool
	 */
	function _updateRegCTR(){
		if( $this->uid < 0 ){
			return false;
		}
		
		//ip控制更新
		if( $this->regfloodcount == 0 ){
			$this->db->query("INSERT INTO ". XWB_S_TBPRE. "regips (ip, count, dateline)
				VALUES ('{$this->ip}', '1', '{$this->timestamp}')");
		}elseif( $this->regfloodcount > 0 ){
			$this->db->query("UPDATE ". XWB_S_TBPRE. "regips SET count=count+1 WHERE ip='{$this->ip}' AND count>'0'");
		}
		if($GLOBALS['regctrl'] || $GLOBALS['regfloodctrl']) {
			$this->db->query("DELETE FROM ". XWB_S_TBPRE. "regips WHERE dateline<='{$this->timestamp}'-".($GLOBALS['regctrl'] > 72 ? $GLOBALS['regctrl'] : 72)."*3600", 'UNBUFFERED');
			if($GLOBALS['regctrl']) {
				$this->db->query("INSERT INTO ". XWB_S_TBPRE. "regips (ip, count, dateline)
					VALUES ('{$this->ip}', '-1', '{$this->timestamp}')");
			}
		}
	}
	
	/**
	 * 更新用户的注册审核信息（包括发邮件）
	 * @access protected
	 * @return bool
	 */
	function _updateUserRegVerify(){
		if( $this->uid < 0 ){
			return false;
		}
		//人工审核
		if( $GLOBALS['regverify'] == 2  ) {
			$regmessage = 'SINA_WEIBO_API_REGISTER';
			$this->db->query("REPLACE INTO ". XWB_S_TBPRE. "validating (uid, submitdate, moddate, admin, submittimes, status, message, remark)
				VALUES ('$this->uid', '$this->timestamp', '0', '', '1', '0', '$regmessage', '')");
		
		//EMAIL验证
		}elseif( $GLOBALS['regverify'] == 1 ){
			$idstring = random(6);
			$authstr = "{$this->timestamp}\t2\t$idstring";
			$this->db->query( "UPDATE  ". XWB_S_TBPRE. "memberfields SET authstr='{$authstr}' WHERE uid = '{$this->uid}' " );
			
			$GLOBALS['idstring'] = $idstring;			
			$GLOBALS['discuz_uid'] = $this->uid;
			$GLOBALS['discuz_user'] = $this->username;
			$GLOBALS['discuz_userss'] = stripslashes($this->username);
			$email = htmlspecialchars($this->email);
			sendmail("{$GLOBALS['discuz_user']} <{$email}>", 'email_verify_subject', 'email_verify_message');
		}
		
		return true;
	}
	
	/**
	 * 初始化注册用户组
	 * @access protected
	 */
	function _initGroupid(){
		$groupinfo = $this->db->fetch_first("SELECT groupid, allownickname, allowcstatus, allowcusbbcode, allowsigbbcode, allowsigimgcode, maxsigsize FROM ". XWB_S_TBPRE. "usergroups WHERE ".($GLOBALS['regverify'] ? "groupid='8'" : "creditshigher<=".intval($GLOBALS['initcredits'])." AND ".intval($GLOBALS['initcredits'])."<creditslower LIMIT 1"));
		$this->groupid = (int)$groupinfo['groupid'];
	}
	
	
	/**
	 * 根据附属站点注册控制设置进行控制性检查
	 * @access protected
	 * @return integer
	 */
	function _checkRegCTR(){
		$checkRegIP = $this->_checkRegIP();
		if (  $checkRegIP < 0 ){
			return $checkRegIP;
		}
		
		return 0;
	}
	
	
	/**
	 * 检查ip是否允许注册
	 * @access protected
	 * @return integer 检查结果
	 * 0：正常
	 * -1001：regfloodctrl 24 小时注册尝试次数限制
	 * -1002：regctrl IP 注册间隔限制(小时)
	 * -1003：ipregctrl 特殊 IP 注册限制（每 72 小时将至多只允许注册一个帐号）
	 */
	function _checkRegIP(){
		$GLOBALS['regctrl'] = (int)$GLOBALS['regctrl'];
		if($GLOBALS['ipregctrl']) {
			foreach(explode("\n", $GLOBALS['ipregctrl']) as $ctrlip) {
				if( preg_match("/^(".preg_quote(($ctrlip = trim($ctrlip)), '/').")/", $this->ip) ) {
					$ctrlip = $ctrlip.'%';
					$GLOBALS['regctrl'] = 72;
					break;
				} else {
					$ctrlip = $this->ip;
				}
			}
		} else {
			$ctrlip = $this->ip;
		}
		
		if( $GLOBALS['regctrl'] ){
			$result = $this->db->result_first("SELECT ip FROM ". XWB_S_TBPRE. "regips WHERE ip LIKE '{$ctrlip}' AND count='-1' AND dateline>{$this->timestamp} - '{$GLOBALS['regctrl']}'*3600 LIMIT 1");
			if( !empty($result)  )  {
				if($GLOBALS['ipregctrl']) {
					return -1003;
				}else{
					return -1002;
					
				}
			}
		}
		
		if($GLOBALS['regfloodctrl']) {
			$regcount = $this->db->result_first("SELECT count FROM ". XWB_S_TBPRE. "regips WHERE ip='{$this->ip}' AND count>'0' AND dateline>'{$this->timestamp}'-86400");
			if( !empty($regcount) ) {
				if( (int)$regcount >= $GLOBALS['regfloodctrl']) {
					return -1001;
				} else {
					$this->regfloodcount = (int)$regcount;
				}
			} else {
				$this->regfloodcount = 0;
			}
		}
		
		return 0;

	}
	
}