/*
 * Decompiled with CFR 0.152.
 */
package jspgen.filter;

import grapes.Captcha;
import grapes.image.Images;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jspgen.config.CaptchaConfig;
import jspgen.config.JSPGenConfig;

public class CaptchaFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.addHeader(JSPGenConfig.POWERED_BY, JSPGenConfig.URL);
        if (httpServletRequest.getProtocol().compareTo("HTTP/1.0") == 0) {
            httpServletResponse.setHeader("Pragma", "no-cache");
        } else {
            httpServletResponse.setHeader("Cache-Control", "no-store");
        }
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("image/jpeg");
        HttpSession httpSession = httpServletRequest.getSession(true);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        BufferedImage bufferedImage = null;
        try {
            try {
                String string = "";
                Captcha captcha = new Captcha();
                bufferedImage = captcha.getBufferedImage(Captcha.CaptchaType.english);
                string = captcha.getCaptcha();
                httpSession.removeAttribute(CaptchaConfig.SESSION_CAPTCHA_KEY);
                httpSession.setAttribute(CaptchaConfig.SESSION_CAPTCHA_KEY, (Object)string);
                httpSession.removeAttribute(CaptchaConfig.SESSION_CAPTCHA_STAT);
                httpSession.setAttribute(CaptchaConfig.SESSION_CAPTCHA_STAT, (Object)0);
                Images.writeImage((BufferedImage)bufferedImage, (Object)servletOutputStream);
                bufferedImage = null;
                servletOutputStream.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                servletOutputStream.close();
            }
        }
        finally {
            servletOutputStream.close();
        }
    }

    public void destroy() {
    }
}

