/*
 * Decompiled with CFR 0.152.
 */
package grapes;

import grapes.Dates;
import grapes.FilesFilter;
import grapes.Grapes;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Files {
    private static String o00000 = "/";

    public static String format(String string) {
        if (Grapes.isNotEmpty(string)) {
            string = string.trim().replaceAll("\\\\+", o00000).replaceAll("\\\\+|/+", o00000);
        }
        return string;
    }

    public static String getParentName(String string) {
        if (Grapes.isNotEmpty(string)) {
            if ((string = Files.format(string)).indexOf(o00000) == -1) {
                return "";
            }
            return Grapes.substring(string, Grapes.lastOrdinalIndexOf(string, o00000, 2) + 1, Grapes.lastOrdinalIndexOf(string, o00000, 1));
        }
        return string;
    }

    public static String getFileName(String string, boolean bl) {
        if (Grapes.isNotEmpty(string)) {
            string = Files.format(string);
            string = bl ? Grapes.substringAfterLast(string, o00000, false) : Grapes.substringBeforeLast(Grapes.substringAfterLast(string, o00000, false), "?", false);
        }
        return string;
    }

    public static String getFileName(String string) {
        return Files.getFileName(string, false);
    }

    public static String getName(String string) {
        return Grapes.substringBeforeLast(Files.getFileName(string, false), ".", false);
    }

    public static String getExte(String string) {
        if (Grapes.isNotEmpty(string)) {
            string = Files.format(string);
            string = Grapes.substringBeforeLast(string, "?", false);
            if (Grapes.isNotEmpty(string = Grapes.substringAfterLast(string, "."))) {
                return string.toLowerCase();
            }
        }
        return null;
    }

    public static File getFile(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        File file = new File(Files.format(string));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getURLText(String string, String string2) {
        string2 = Grapes.isEmpty(string2) ? Grapes.CHARSET : string2;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), string2));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(String.valueOf(string3) + "\n");
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return null;
    }

    public static String getURLText(String string) {
        return Files.getURLText(string, null);
    }

    public static boolean serialize(String string, Object object) {
        if (Grapes.isEmpty(string)) {
            return false;
        }
        try {
            File file = new File(Files.format(string));
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static Object unserialize(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        File file = new File(Files.format(string));
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
                return object;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return null;
    }

    public static boolean writeFile(File file, String string, String string2) {
        return Files.writeFile(file, string, string2, false);
    }

    public static boolean writeFile(String string, String string2, String string3) {
        File file = new File(Files.format(string));
        return Files.writeFile(file, string2, string3, false);
    }

    public static boolean writeFile(File file, String string) {
        return Files.writeFile(file, string, "", false);
    }

    public static boolean writeFile(String string, String string2) {
        File file = new File(Files.format(string));
        return Files.writeFile(file, string2, "", false);
    }

    public static boolean writeFile(File file, String string, String string2, boolean bl) {
        string2 = Grapes.isEmpty(string2) ? Grapes.CHARSET : string2;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            FileLock fileLock = fileOutputStream.getChannel().tryLock();
            if (fileLock.isValid()) {
                bufferedWriter.write(string);
                fileLock.release();
            }
            bufferedWriter.flush();
            outputStreamWriter.flush();
            fileOutputStream.flush();
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
            bufferedWriter = null;
            outputStreamWriter = null;
            fileOutputStream = null;
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return false;
        }
    }

    public static boolean writeFile(String string, String string2, String string3, boolean bl) {
        File file = new File(Files.format(string));
        return Files.writeFile(file, string2, string3, bl);
    }

    public static boolean writeFile(File file, String string, boolean bl) {
        return Files.writeFile(file, string, "", bl);
    }

    public static boolean writeFile(String string, String string2, boolean bl) {
        File file = new File(Files.format(string));
        return Files.writeFile(file, string2, "", bl);
    }

    public static String readFile(File file, String string) {
        StringBuffer stringBuffer;
        block22: {
            string = Grapes.isEmpty(string) ? Grapes.CHARSET : string;
            stringBuffer = new StringBuffer();
            if (file != null && file.exists()) {
                FileInputStream fileInputStream = null;
                InputStreamReader inputStreamReader = null;
                BufferedReader bufferedReader = null;
                try {
                    try {
                        fileInputStream = new FileInputStream(file);
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        String string2 = null;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            stringBuffer.append(string2);
                            stringBuffer.append("\n");
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            if (inputStreamReader != null) {
                                inputStreamReader.close();
                            }
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException2) {
                            System.err.println(iOException2);
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                    }
                    throw throwable;
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String readFile(String string, String string2) {
        File file = new File(Files.format(string));
        return Files.readFile(file, string2);
    }

    public static String readFile(File file) {
        return Files.readFile(file, "");
    }

    public static String readFile(String string) {
        File file = new File(Files.format(string));
        return Files.readFile(file, "");
    }

    public static String readFile(File file, String string, int n) {
        string = Grapes.isEmpty(string) ? Grapes.CHARSET : string;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[n];
            bufferedInputStream.read(byArray, 0, n);
            String string2 = new String(byArray, string);
            return string2;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        return null;
    }

    public static String readFile(String string, String string2, int n) {
        File file = new File(Files.format(string));
        return Files.readFile(file, string2, n);
    }

    public static List<String> readFileList(File file, String string) {
        string = Grapes.isEmpty(string) ? Grapes.CHARSET : string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file != null && file.exists()) {
            FileInputStream fileInputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        arrayList.add(string2);
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        System.err.println(iOException2);
                    }
                }
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
        return arrayList;
    }

    public static List<String> readFileList(String string, String string2) {
        File file = new File(Files.format(string));
        return Files.readFileList(file, string2);
    }

    public static InputStream getResourceAsStream(String string) {
        String string2 = string.startsWith(o00000) ? string.substring(1) : string;
        InputStream inputStream = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string2);
            }
            if (inputStream == null) {
                throw new FileNotFoundException(String.valueOf(string) + " not found");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
        }
        return inputStream;
    }

    public static Map<String, Object> getAttr(String string) {
        string = Files.format(string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long l = Files.getFileSize(string);
        hashMap.put("length", l);
        hashMap.put("size", Files.getFileSizeUnit(l));
        try {
            File file = new File(string);
            hashMap.put("isExists", file.exists());
            hashMap.put("isRead", file.canRead());
            hashMap.put("isWrite", file.canWrite());
            hashMap.put("isDirectory", file.isDirectory());
            hashMap.put("isFile", file.isFile());
            hashMap.put("isHidden", file.isHidden());
            hashMap.put("isAbsolute", file.isAbsolute());
            hashMap.put("name", file.getName());
            hashMap.put("path", file.getPath());
            hashMap.put("absolutePath", file.getAbsolutePath());
            hashMap.put("parent", file.getParent());
            hashMap.put("lastTime", Dates.parseString(file.lastModified()));
            if (((Boolean)hashMap.get("isDirectory")).booleanValue()) {
                hashMap.put("list", Files.getList(string));
                hashMap.put("exte", "dir");
            }
            if (((Boolean)hashMap.get("isFile")).booleanValue()) {
                String string2 = Grapes.substringAfterLast(file.getName(), ".", false);
                if (Grapes.isEmpty(string2)) {
                    string2 = "";
                }
                hashMap.put("exte", string2);
            }
            hashMap.put("type", Files.getFileType((String)hashMap.get("exte")));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return hashMap;
    }

    public static List<Map<String, Object>> getFileList(String string, String string2, Long l, String string3, String string4, int n, int n2) {
        string = Files.format(string);
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try {
            File file = new File(string);
            if (file.exists()) {
                File[] fileArray = file.listFiles(new FilesFilter(string2, l, string3));
                if (Grapes.isNotEmpty(string4)) {
                    string4 = string4.trim();
                }
                if (string4.startsWith("name")) {
                    if (string4.endsWith("asc")) {
                        Arrays.sort(fileArray, new Comparator<File>(){

                            @Override
                            public int compare(File file, File file2) {
                                if (file.isDirectory() && file2.isFile()) {
                                    return -1;
                                }
                                if (file.isFile() && file2.isDirectory()) {
                                    return 1;
                                }
                                return file.getName().compareTo(file2.getName());
                            }
                        });
                    } else {
                        Arrays.sort(fileArray, new Comparator<File>(){

                            @Override
                            public int compare(File file, File file2) {
                                if (file.isDirectory() && file2.isFile()) {
                                    return -1;
                                }
                                if (file.isFile() && file2.isDirectory()) {
                                    return 1;
                                }
                                return file2.getName().compareTo(file.getName());
                            }
                        });
                    }
                } else if (string4.startsWith("size")) {
                    if (string4.endsWith("asc")) {
                        Arrays.sort(fileArray, new Comparator<File>(){

                            @Override
                            public int compare(File file, File file2) {
                                if (file.isDirectory() && file2.isFile()) {
                                    return -1;
                                }
                                if (file.isFile() && file2.isDirectory()) {
                                    return 1;
                                }
                                return Long.valueOf(file.length()).compareTo(file2.length());
                            }
                        });
                    } else {
                        Arrays.sort(fileArray, new Comparator<File>(){

                            @Override
                            public int compare(File file, File file2) {
                                if (file.isDirectory() && file2.isFile()) {
                                    return -1;
                                }
                                if (file.isFile() && file2.isDirectory()) {
                                    return 1;
                                }
                                return Long.valueOf(file2.length()).compareTo(file.length());
                            }
                        });
                    }
                } else if (string4.endsWith("asc")) {
                    Arrays.sort(fileArray, new Comparator<File>(){

                        @Override
                        public int compare(File file, File file2) {
                            if (file.isDirectory() && file2.isFile()) {
                                return -1;
                            }
                            if (file.isFile() && file2.isDirectory()) {
                                return 1;
                            }
                            return Long.valueOf(file.lastModified()).compareTo(file2.lastModified());
                        }
                    });
                } else {
                    Arrays.sort(fileArray, new Comparator<File>(){

                        @Override
                        public int compare(File file, File file2) {
                            if (file.isDirectory() && file2.isFile()) {
                                return -1;
                            }
                            if (file.isFile() && file2.isDirectory()) {
                                return 1;
                            }
                            return Long.valueOf(file2.lastModified()).compareTo(file.lastModified());
                        }
                    });
                }
                int n3 = 0;
                int n4 = fileArray.length;
                if (n2 > n) {
                    if (n > 0) {
                        n3 = n - 1;
                    }
                    if (n2 < n4) {
                        n4 = n2;
                    }
                }
                while (n3 < n4) {
                    arrayList.add(Files.getAttr(String.valueOf(string) + o00000 + fileArray[n3].getName()));
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return arrayList;
    }

    public static List<Map<String, Object>> getFileList(String string, String string2, String string3, int n, int n2) {
        return Files.getFileList(string, string2, null, "all", string3, n, n2);
    }

    public static List<Map<String, Object>> getFileList(String string, String string2) {
        return Files.getFileList(string, string2, "time desc", 0, 20);
    }

    public static String[] getList(String string) {
        File file = new File(string = Files.format(string));
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        return file.list();
    }

    public static Long getFileSize(String string) {
        string = Files.format(string);
        long l = 0L;
        File file = new File(string);
        if (!file.exists()) {
            return new Long(0L);
        }
        if (!file.isDirectory()) {
            return Math.abs(file.length());
        }
        String[] stringArray = file.list();
        File file2 = null;
        int n = 0;
        while (n < stringArray.length) {
            file2 = string.endsWith(o00000) ? new File(String.valueOf(string) + stringArray[n]) : new File(String.valueOf(string) + o00000 + stringArray[n]);
            if (file2.isFile()) {
                l += Math.abs(file2.length());
            }
            if (file2.isDirectory()) {
                l += Files.getFileSize(String.valueOf(string) + o00000 + stringArray[n]).longValue();
            }
            ++n;
        }
        return l;
    }

    public static String getFileSizeUnit(Long l) {
        String string = "";
        if (Grapes.isEmpty(l)) {
            return string;
        }
        string = (double)l.longValue() >= 1.099511627776E12 ? String.valueOf((double)Math.round((double)l.longValue() / 1.099511627776E12 * 100.0) / 100.0) + "T" : (l >= 0x40000000L ? String.valueOf((double)Math.round((double)l.longValue() / 1.073741824E9 * 100.0) / 100.0) + "G" : (l >= 0x100000L ? String.valueOf((double)Math.round((double)l.longValue() / 1048576.0 * 100.0) / 100.0) + "M" : (l >= 1024L ? String.valueOf((double)Math.round((double)l.longValue() / 1024.0 * 100.0) / 100.0) + "K" : (l > 0L ? l + "B" : l + "B"))));
        return string;
    }

    public static long getFileSizeByte(String string) {
        long l = 0L;
        if (Grapes.isEmpty(string)) {
            return l;
        }
        string = string.toUpperCase();
        Matcher matcher = Pattern.compile("\\d+([BKMGT]?)").matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = string.replaceAll(string2, "");
            l = string2.equals("T") ? Long.valueOf(string3) * 1024L * 1024L * 1024L * 1024L : (string2.equals("G") ? Long.valueOf(string3) * 1024L * 1024L * 1024L : (string2.equals("M") ? Long.valueOf(string3) * 1024L * 1024L : (string2.equals("K") ? Long.valueOf(string3) * 1024L : (string2.equals("B") ? Long.valueOf(string3).longValue() : Long.valueOf(string3).longValue()))));
        }
        return l;
    }

    public static String getFileType(String string) {
        if (string.equalsIgnoreCase("dir")) {
            return "\u76ee\u5f55";
        }
        if (string.equalsIgnoreCase("gif")) {
            return "GIF \u56fe\u50cf";
        }
        if (string.equalsIgnoreCase("htm")) {
            return "HTML \u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("html")) {
            return "HTML \u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("shtml")) {
            return "SHTML \u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("jsp")) {
            return "JSP \u811a\u672c";
        }
        if (string.equalsIgnoreCase("php")) {
            return "PHP \u811a\u672c";
        }
        if (string.equalsIgnoreCase("asp")) {
            return "ASP \u811a\u672c";
        }
        if (string.equalsIgnoreCase("cgi")) {
            return "CGI \u811a\u672c";
        }
        if (string.equalsIgnoreCase("do")) {
            return "DO \u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("swf")) {
            return "Flash \u52a8\u753b";
        }
        if (string.equalsIgnoreCase("xml")) {
            return "XML \u6587\u6863";
        }
        if (string.equalsIgnoreCase("jpg")) {
            return "JPEG \u56fe\u50cf";
        }
        if (string.equalsIgnoreCase("jpeg")) {
            return "JPEG \u56fe\u50cf";
        }
        if (string.equalsIgnoreCase("bmp")) {
            return "BMP \u56fe\u50cf";
        }
        if (string.equalsIgnoreCase("tif")) {
            return "TIF \u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("js")) {
            return "JavaScript \u5ba2\u6237\u7aef\u811a\u672c";
        }
        if (string.equalsIgnoreCase("doc")) {
            return "Word \u6587\u6863";
        }
        if (string.equalsIgnoreCase("mp3")) {
            return "MP3 \u683c\u5f0f\u58f0\u97f3";
        }
        if (string.equalsIgnoreCase("rar")) {
            return "WinRAR \u538b\u7f29\u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("psd")) {
            return "Photoshop \u6587\u6863";
        }
        if (string.equalsIgnoreCase("png")) {
            return "Firewords \u6587\u6863";
        }
        if (string.equalsIgnoreCase("pdf")) {
            return "Acrobat \u6587\u6863";
        }
        if (string.equalsIgnoreCase("zip")) {
            return "ZIP \u538b\u7f29\u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("7z")) {
            return "7-ZIP \u538b\u7f29\u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("rar")) {
            return "WinRAR \u538b\u7f29\u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("rm")) {
            return "RealMedia";
        }
        if (string.equalsIgnoreCase("rmvb")) {
            return "RealVideo VBR";
        }
        if (string.equalsIgnoreCase("wav")) {
            return "\u6ce2\u5f62\u58f0\u97f3";
        }
        if (string.equalsIgnoreCase("mid")) {
            return "MIDI \u5e8f\u5217";
        }
        if (string.equalsIgnoreCase("midi")) {
            return "MIDI \u5e8f\u5217";
        }
        if (string.equalsIgnoreCase("mpg")) {
            return "\u7535\u5f71\u526a\u8f91";
        }
        if (string.equalsIgnoreCase("mpeg")) {
            return "\u7535\u5f71\u526a\u8f91";
        }
        if (string.equalsIgnoreCase("asf")) {
            return "Windows Media \u97f3\u9891/\u89c6\u9891\u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("asx")) {
            return "Windows Media \u97f3\u9891/\u89c6\u9891\u64ad\u653e\u5217\u8868";
        }
        if (string.equalsIgnoreCase("mov")) {
            return "QuickTime \u5f71\u7247";
        }
        if (string.equalsIgnoreCase("xls")) {
            return "Excel \u5de5\u4f5c\u8868";
        }
        if (string.equalsIgnoreCase("chm")) {
            return "\u5df2\u7f16\u8bd1\u7684 HTML \u5e2e\u52a9\u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("hlp")) {
            return "\u5e2e\u52a9\u6587\u4ef6";
        }
        if (string.equalsIgnoreCase("class")) {
            return "Java \u7c7b";
        }
        if (string.equalsIgnoreCase("jar")) {
            return "Java \u5e94\u7528\u7a0b\u5e8f";
        }
        if (string.equalsIgnoreCase("exe")) {
            return "Win \u5e94\u7528\u7a0b\u5e8f";
        }
        if (string.equalsIgnoreCase("txt")) {
            return "\u6587\u672c\u6587\u6863";
        }
        return "\u672a\u77e5";
    }

    public static File createFolder(String string) {
        File file = null;
        string = Files.format(string);
        try {
            file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            file = null;
            System.err.println(exception);
        }
        return file;
    }

    public static File createFile(String string) {
        File file = null;
        string = Files.format(string);
        try {
            file = new File(string);
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            file.createNewFile();
        }
        catch (Exception exception) {
            file = null;
            System.err.println(exception);
        }
        return file;
    }

    public static boolean isCreateFolder(String string) {
        File file = Files.createFolder(string);
        return file != null;
    }

    public static boolean isCreateFile(String string) {
        File file = Files.createFile(string);
        return file != null;
    }

    public static boolean rename(String string, String string2) {
        string = Files.format(string);
        try {
            File file = new File(string);
            if (file.exists()) {
                String string3 = file.getParent();
                File file2 = new File(String.valueOf(string3) + o00000 + string2);
                return file.renameTo(file2);
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean move(String string, String string2) {
        File file;
        block5: {
            string = Files.format(string);
            try {
                file = new File(string);
                if (file.exists()) break block5;
                return false;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        if (file.isFile()) {
            Files.copyFile(string, string2);
        }
        if (file.isDirectory()) {
            Files.copyFolder(string, string2);
        }
        return Files.delete(string);
    }

    public static boolean copy(String string, String string2) {
        File file;
        block5: {
            string = Files.format(string);
            try {
                file = new File(string);
                if (file.exists()) break block5;
                return false;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        if (file.isFile()) {
            return Files.copyFile(string, string2);
        }
        if (file.isDirectory()) {
            return Files.copyFolder(string, string2);
        }
        return true;
    }

    public static boolean copyFile(String string, String string2) {
        File file;
        block9: {
            File file2;
            block8: {
                block7: {
                    string = Files.format(string);
                    string2 = Files.format(string2);
                    file2 = new File(string);
                    if (file2.exists()) break block7;
                    return false;
                }
                if (file2.isFile()) break block8;
                return false;
            }
            file = new File(string2);
            if (!file2.getCanonicalPath().equals(file.getCanonicalPath())) break block9;
            return true;
        }
        try {
            if (!file.exists()) {
                Files.isCreateFile(string2);
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            int n = 0;
            byte[] byArray = new byte[1444];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            ((InputStream)fileInputStream).close();
            fileOutputStream = null;
            fileInputStream = null;
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean copyFolder(String string, String string2) {
        File file;
        File file2;
        block11: {
            block10: {
                block9: {
                    string = Files.format(string);
                    file2 = new File(string);
                    if (file2.exists()) break block9;
                    return false;
                }
                if (file2.isDirectory()) break block10;
                return false;
            }
            file = new File(string2);
            if (!file2.getCanonicalPath().equals(file.getCanonicalPath())) break block11;
            return true;
        }
        try {
            if (!file.exists()) {
                Files.isCreateFolder(string2);
            }
            String[] stringArray = file2.list();
            File file3 = null;
            int n = 0;
            while (n < stringArray.length) {
                file3 = new File(String.valueOf(string = Grapes.addEnd(string, o00000)) + stringArray[n]);
                if (file3.isFile()) {
                    Files.copyFile(file3.getPath(), String.valueOf(string2) + o00000 + file3.getName());
                }
                if (file3.isDirectory()) {
                    Files.copyFolder(String.valueOf(string) + stringArray[n], String.valueOf(string2) + o00000 + stringArray[n]);
                }
                ++n;
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean delete(File file) {
        boolean bl;
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            Files.clear(file);
        }
        if (!(bl = file.delete())) {
            System.gc();
            bl = file.delete();
        }
        return bl;
    }

    public static boolean delete(String string) {
        string = Files.format(string);
        return Files.delete(new File(string));
    }

    public static void clear(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                Files.delete(fileArray[n]);
            }
            if (fileArray[n].isDirectory()) {
                Files.clear(fileArray[n]);
                Files.delete(fileArray[n]);
            }
            ++n;
        }
    }

    public static void clear(String string) {
        string = Files.format(string);
        Files.clear(new File(string));
    }

    public static boolean delete(String string, long l, String string2) {
        string = Files.format(string);
        try {
            File file = new File(string);
            if (file.exists()) {
                Files.clear(string, l, string2);
                if (Grapes.isNotEmpty(string2)) {
                    if ("before".equalsIgnoreCase(string2)) {
                        if (file.lastModified() < l) {
                            Files.delete(file);
                        }
                    } else if ("after".equalsIgnoreCase(string2)) {
                        if (file.lastModified() < l) {
                            Files.delete(file);
                        }
                    } else if ("current".equalsIgnoreCase(string2)) {
                        if (file.lastModified() == l) {
                            Files.delete(file);
                        }
                    } else {
                        Files.delete(file);
                    }
                } else {
                    Files.delete(file);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static void clear(String string, long l, String string2) {
        File file = new File(string = Files.format(string));
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FilesFilter("*", l, string2));
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                Files.delete(fileArray[n]);
            }
            if (fileArray[n].isDirectory()) {
                Files.clear(fileArray[n].getAbsolutePath(), l, string2);
                Files.delete(fileArray[n].getAbsolutePath(), l, string2);
            }
            ++n;
        }
    }

    public static boolean delete(String string, long l, long l2) {
        string = Files.format(string);
        try {
            File file = new File(string);
            if (file.exists()) {
                Files.clear(string, l, l2);
                if (file.lastModified() > l && file.lastModified() < l2) {
                    Files.delete(file);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static void clear(String string, long l, long l2) {
        File file = new File(string = Files.format(string));
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && fileArray[n].lastModified() > l && fileArray[n].lastModified() < l2) {
                Files.delete(fileArray[n]);
            }
            if (fileArray[n].isDirectory()) {
                Files.clear(fileArray[n].getAbsolutePath(), l, l2);
                Files.delete(fileArray[n].getAbsolutePath(), l, l2);
            }
            ++n;
        }
    }

    public static boolean zip(String string, String string2, String string3) {
        string = Files.format(string);
        try {
            File file = new File(string);
            if (file.exists()) {
                Object object;
                if (Grapes.isEmpty(string2)) {
                    string2 = String.valueOf(file.getParent()) + o00000;
                    object = Files.getName(file.getName());
                    string2 = Grapes.isEmpty(object) ? String.valueOf(string2) + file.getName() + ".zip" : String.valueOf(string2) + (String)object + ".zip";
                }
                object = new ZipOutputStream((OutputStream)new FileOutputStream(string2));
                if (Grapes.isNotEmpty(string3)) {
                    object.setComment(string3);
                }
                Files.zipFile(file, object, "");
                object.close();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean zip(String string, String string2) {
        return Files.zip(string, string2, "");
    }

    public static boolean zip(String string) {
        return Files.zip(string, "", "");
    }

    public static void zipFile(File file, ZipOutputStream zipOutputStream, String string) {
        string = Grapes.isEmpty(string = Files.format(string)) ? "" : String.valueOf(string) + o00000;
        try {
            if (file.isDirectory()) {
                File[] fileArray;
                File[] fileArray2 = fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    Files.zipFile(file2, zipOutputStream, String.valueOf(string) + file.getName());
                    ++n2;
                }
            } else {
                String string2 = String.valueOf(string) + file.getName();
                ZipEntry zipEntry = new ZipEntry(string2);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(file);
                int n = 0;
                while ((n = ((InputStream)fileInputStream).read()) != -1) {
                    zipOutputStream.write(n);
                }
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static boolean unzip(String string, String string2) {
        string = Files.format(string);
        string2 = Files.format(string2);
        try {
            File file = new File(string);
            if (file.exists()) {
                if (Grapes.isEmpty(string2)) {
                    string2 = String.valueOf(file.getParent()) + o00000;
                }
                ZipFile zipFile = new ZipFile(file);
                Files.unzipFile(zipFile, string2);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean unzip(String string) {
        return Files.unzip(string, "");
    }

    public static void unzipFile(ZipFile zipFile, String string) {
        string = Files.format(string);
        try {
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string2 = zipEntry.getName();
                File file = new File(String.valueOf(string) + o00000 + string2);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                int n = 0;
                while ((n = inputStream.read()) != -1) {
                    ((OutputStream)fileOutputStream).write(n);
                }
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

