/*
 * Decompiled with CFR 0.152.
 */
package grapes.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import grapes.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class Images {
    public static final String IMAGES = ".jpg.jpeg.gif.bmp.png";
    public static final int QUALITY = 85;

    public static ImagesDatum getImagesDatum(String string) {
        if ("width".equalsIgnoreCase(string)) {
            return ImagesDatum.width;
        }
        if ("height".equalsIgnoreCase(string)) {
            return ImagesDatum.height;
        }
        return ImagesDatum.auto;
    }

    public static ImagesNameGenre getImagesNameGenre(String string) {
        if ("save".equalsIgnoreCase(string)) {
            return ImagesNameGenre.save;
        }
        if ("unchange".equalsIgnoreCase(string)) {
            return ImagesNameGenre.unchange;
        }
        return ImagesNameGenre.rename;
    }

    public static String getFormatName(Object object) {
        File file;
        String string;
        block19: {
            string = null;
            file = null;
            if (object instanceof String) {
                file = Files.getFile(Files.format((String)object));
            } else if (object instanceof File) {
                file = (File)object;
            }
            if (file != null && file.exists()) break block19;
            return null;
        }
        try {
            ImageInputStream imageInputStream = null;
            try {
                try {
                    imageInputStream = ImageIO.createImageInputStream(file);
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                    if (iterator.hasNext()) {
                        ImageReader imageReader = iterator.next();
                        if (imageReader instanceof JPEGImageReader) {
                            string = "jpg";
                        } else if (imageReader instanceof GIFImageReader) {
                            string = "gif";
                        } else if (imageReader instanceof BMPImageReader) {
                            string = "bmp";
                        } else if (imageReader instanceof PNGImageReader) {
                            string = "png";
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    imageInputStream.close();
                }
            }
            finally {
                imageInputStream.close();
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeImage(BufferedImage bufferedImage, Object object, int n) {
        OutputStream outputStream = null;
        try {
            if (object instanceof String) {
                outputStream = new FileOutputStream(Files.format((String)object));
            } else if (object instanceof File) {
                outputStream = new FileOutputStream((File)object);
            } else if (object instanceof OutputStream) {
                outputStream = (OutputStream)object;
            }
            if (outputStream == null) {
                return false;
            }
            try {
                int n2 = bufferedImage.getColorModel().getTransparency();
                if (n2 == 2 || n2 == 3 || n2 == 6 || n2 == 7) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                    return true;
                }
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setQuality((float)n / 100.0f, true);
                jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
                return true;
            }
            finally {
                bufferedImage.flush();
                bufferedImage = null;
                outputStream.flush();
                outputStream.close();
                outputStream = null;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean writeImage(BufferedImage bufferedImage, Object object) {
        return Images.writeImage(bufferedImage, object, 85);
    }

    public static enum ImagesDatum {
        auto,
        width,
        height;

    }

    public static enum ImagesNameGenre {
        save,
        unchange,
        rename;

    }
}

