/*
 * Decompiled with CFR 0.152.
 */
package grapes.pack.xml;

import grapes.Files;
import grapes.Grapes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XMLOperate
implements Serializable {
    private static final long new = 1L;
    private Document o00000 = null;

    public XMLOperate() {
    }

    public XMLOperate(Object object) {
        if (Grapes.isEmpty(object)) {
            return;
        }
        if (object instanceof InputStream) {
            this.o00000 = this.readStream((InputStream)object);
        } else if (object instanceof File) {
            this.o00000 = this.readFile((File)object);
        } else if (object instanceof String) {
            this.o00000 = Grapes.startsWithIgnoreCase((String)object, "http://") || Grapes.startsWithIgnoreCase((String)object, "https://") ? this.readURL((String)object) : this.readText((String)object);
        }
        if (Grapes.isEmpty(this.o00000)) {
            System.err.println("XML Error.");
        }
    }

    public void setDocument(Document document) {
        this.o00000 = document;
    }

    public Document getDocument() {
        return this.o00000;
    }

    public Element getRoot() {
        return this.o00000.getRootElement();
    }

    public Document readURL(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        try {
            SAXReader sAXReader = new SAXReader();
            return sAXReader.read(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
        }
        catch (DocumentException documentException) {
            System.err.println((Object)documentException);
        }
        return null;
    }

    public Document readText(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        try {
            return DocumentHelper.parseText((String)string);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public Document readFile(File file) {
        if (file.exists()) {
            try {
                SAXReader sAXReader = new SAXReader();
                return sAXReader.read(file);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        } else {
            System.err.println("This file is not exist[" + file.getAbsolutePath() + "]");
        }
        return null;
    }

    public Document readStream(InputStream inputStream) {
        if (Grapes.isEmpty(inputStream)) {
            return null;
        }
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(inputStream);
            return document;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        return null;
    }

    public Document create(String string) {
        string = Grapes.isEmpty(string) ? "jspgen" : string;
        try {
            this.o00000 = DocumentHelper.createDocument();
            this.o00000.addElement(string);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return this.o00000;
    }

    public Document create() {
        return this.create(null);
    }

    public boolean save(Document document, File file, String string) {
        if (Grapes.isEmpty(string)) {
            string = Grapes.CHARSET;
        }
        try {
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setEncoding(string);
            XMLWriter xMLWriter = new XMLWriter((Writer)new FileWriter(file), outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public boolean save(Document document, String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            Files.isCreateFile(string);
        }
        return this.save(document, file, string2);
    }

    public boolean save(File file, String string) {
        return this.save(this.o00000, file, string);
    }

    public boolean save(String string, String string2) {
        return this.save(this.o00000, string, string2);
    }

    public boolean save(File file) {
        return this.save(this.o00000, file, null);
    }

    public boolean save(String string) {
        return this.save(this.o00000, string, null);
    }

    public String print(Document document, String string) {
        if (Grapes.isEmpty(string)) {
            string = Grapes.CHARSET;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setEncoding(string);
            XMLWriter xMLWriter = new XMLWriter((OutputStream)byteArrayOutputStream, outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public String print(String string) {
        return this.print(this.o00000, string);
    }

    public String print() {
        return this.print(this.o00000, null);
    }

    public Document getDocument(String string) {
        try {
            return DocumentHelper.parseText((String)string);
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
            return null;
        }
    }

    public List<Object> selectNodes(String string) {
        try {
            return this.o00000.selectNodes(string);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public Object selectNode(String string) {
        try {
            List<Object> list = this.selectNodes(string);
            Iterator<Object> iterator = list.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return null;
    }

    public String getValue(Object object) {
        block9: {
            try {
                if (object instanceof Element) {
                    return ((Element)object).getText();
                }
                if (object instanceof Attribute) {
                    return ((Attribute)object).getValue();
                }
                if (!(object instanceof String)) break block9;
                ArrayList<String> arrayList = null;
                List<Object> list = this.selectNodes((String)object);
                Iterator<Object> iterator = list.iterator();
                if (Grapes.contains((String)object, "/@")) {
                    arrayList = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        Attribute attribute = (Attribute)iterator.next();
                        arrayList.add(String.valueOf(attribute.getName()) + "=" + attribute.getValue());
                    }
                } else {
                    arrayList = new ArrayList();
                    while (iterator.hasNext()) {
                        Element element = (Element)iterator.next();
                        if (this.getChildNodes(element).size() <= 0) {
                            arrayList.add(String.valueOf(element.getName()) + "=" + element.getText());
                            continue;
                        }
                        break;
                    }
                }
                return ((Object)arrayList).toString();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return null;
    }

    public List<Element> getChildNodes(Element element, String string) {
        try {
            if (Grapes.isNotEmpty(string)) {
                return element.elements(string);
            }
            return element.elements();
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public List<Element> getChildNodes(Element element) {
        try {
            return this.getChildNodes(element, null);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public List<Attribute> getAttributes(Element element) {
        try {
            return element.attributes();
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public Element addNode(Element element, String string, String string2, boolean bl) {
        try {
            if (Grapes.isEmpty(string)) {
                return element;
            }
            Element element2 = element.addElement(string);
            if (Grapes.isNotEmpty(string2)) {
                if (bl) {
                    element2.addCDATA(string2);
                } else {
                    element2.addText(string2);
                }
            }
            return element;
        }
        catch (Exception exception) {
            return element;
        }
    }

    public Element addNode(Element element, String string, String string2) {
        return this.addNode(element, string, string2, false);
    }

    public Element addNode(String string, String string2, String string3) {
        return this.addNode((Element)this.selectNode(string), string2, string3, false);
    }

    public Element setNode(Element element, String string) {
        try {
            if (element.elements().size() > 0) {
                return element;
            }
            if (Grapes.isNotEmpty(string)) {
                element.setText(string);
            }
            return element;
        }
        catch (Exception exception) {
            return element;
        }
    }

    public Element setNode(String string, String string2) {
        return this.setNode((Element)this.selectNode(string), string2);
    }

    public static Element delNode(Element element) {
        try {
            Element element2 = element.getParent();
            element2.remove(element);
            return element2;
        }
        catch (Exception exception) {
            return element;
        }
    }

    public Element delNode(String string) {
        return XMLOperate.delNode((Element)this.selectNode(string));
    }

    public Element addAttribute(Element element, String string, String string2) {
        try {
            if (Grapes.isEmpty(string)) {
                return element;
            }
            element.addAttribute(string, string2);
            return element;
        }
        catch (Exception exception) {
            return element;
        }
    }

    public Element addAttribute(String string, String string2, String string3) {
        return this.addAttribute((Element)this.selectNode(string), string2, string3);
    }

    public Element setAttribute(Element element, String string, String string2) {
        try {
            Attribute attribute = element.attribute(string);
            attribute.setValue(string2);
            return element;
        }
        catch (Exception exception) {
            return element;
        }
    }

    public Element setAttribute(String string, String string2, String string3) {
        return this.setAttribute((Element)this.selectNode(string), string2, string3);
    }

    public Element delAttribute(Element element, String string) {
        try {
            element.remove(element.attribute(string));
            return element;
        }
        catch (Exception exception) {
            return element;
        }
    }

    public Element delAttribute(String string, String string2) {
        return this.delAttribute((Element)this.selectNode(string), string2);
    }

    public Element delAllAttribute(Element element) {
        try {
            Iterator iterator = element.attributeIterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                element.remove(attribute);
            }
            return element;
        }
        catch (Exception exception) {
            return element;
        }
    }

    public Element delAllAttribute(String string, String string2) {
        return this.delAllAttribute((Element)this.selectNode(string));
    }
}

