/*
 * Decompiled with CFR 0.152.
 */
package grapes.tools;

import grapes.Dates;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IDCard {
    public static final int CHINA_ID_MIN_LENGTH = 15;
    public static final int CHINA_ID_MAX_LENGTH = 18;
    public static final String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    public static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    public static final String[] verifyCode = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    public static final int MIN = 1930;
    public static Map<String, String> cityCodes = new HashMap<String, String>();
    public static Map<String, Integer> twFirstCode = new HashMap<String, Integer>();
    public static Map<String, Integer> hkFirstCode = new HashMap<String, Integer>();

    static {
        cityCodes.put("11", "\u5317\u4eac");
        cityCodes.put("12", "\u5929\u6d25");
        cityCodes.put("13", "\u6cb3\u5317");
        cityCodes.put("14", "\u5c71\u897f");
        cityCodes.put("15", "\u5185\u8499\u53e4");
        cityCodes.put("21", "\u8fbd\u5b81");
        cityCodes.put("22", "\u5409\u6797");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f");
        cityCodes.put("31", "\u4e0a\u6d77");
        cityCodes.put("32", "\u6c5f\u82cf");
        cityCodes.put("33", "\u6d59\u6c5f");
        cityCodes.put("34", "\u5b89\u5fbd");
        cityCodes.put("35", "\u798f\u5efa");
        cityCodes.put("36", "\u6c5f\u897f");
        cityCodes.put("37", "\u5c71\u4e1c");
        cityCodes.put("41", "\u6cb3\u5357");
        cityCodes.put("42", "\u6e56\u5317");
        cityCodes.put("43", "\u6e56\u5357");
        cityCodes.put("44", "\u5e7f\u4e1c");
        cityCodes.put("45", "\u5e7f\u897f");
        cityCodes.put("46", "\u6d77\u5357");
        cityCodes.put("50", "\u91cd\u5e86");
        cityCodes.put("51", "\u56db\u5ddd");
        cityCodes.put("52", "\u8d35\u5dde");
        cityCodes.put("53", "\u4e91\u5357");
        cityCodes.put("54", "\u897f\u85cf");
        cityCodes.put("61", "\u9655\u897f");
        cityCodes.put("62", "\u7518\u8083");
        cityCodes.put("63", "\u9752\u6d77");
        cityCodes.put("64", "\u5b81\u590f");
        cityCodes.put("65", "\u65b0\u7586");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
        twFirstCode.put("A", 10);
        twFirstCode.put("B", 11);
        twFirstCode.put("C", 12);
        twFirstCode.put("D", 13);
        twFirstCode.put("E", 14);
        twFirstCode.put("F", 15);
        twFirstCode.put("G", 16);
        twFirstCode.put("H", 17);
        twFirstCode.put("J", 18);
        twFirstCode.put("K", 19);
        twFirstCode.put("L", 20);
        twFirstCode.put("M", 21);
        twFirstCode.put("N", 22);
        twFirstCode.put("P", 23);
        twFirstCode.put("Q", 24);
        twFirstCode.put("R", 25);
        twFirstCode.put("S", 26);
        twFirstCode.put("T", 27);
        twFirstCode.put("U", 28);
        twFirstCode.put("V", 29);
        twFirstCode.put("X", 30);
        twFirstCode.put("Y", 31);
        twFirstCode.put("W", 32);
        twFirstCode.put("Z", 33);
        twFirstCode.put("I", 34);
        twFirstCode.put("O", 35);
        hkFirstCode.put("A", 1);
        hkFirstCode.put("B", 2);
        hkFirstCode.put("C", 3);
        hkFirstCode.put("R", 18);
        hkFirstCode.put("U", 21);
        hkFirstCode.put("Z", 26);
        hkFirstCode.put("X", 24);
        hkFirstCode.put("W", 23);
        hkFirstCode.put("O", 15);
        hkFirstCode.put("N", 14);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String conver15CardTo18(String string) {
        String string2 = "";
        if (string.length() != 15) {
            return null;
        }
        if (!IDCard.isNum(string)) return null;
        String string3 = string.substring(6, 12);
        Date date = Dates.parseDate(string3, "yyMMdd");
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        String string4 = String.valueOf(calendar.get(1));
        string2 = String.valueOf(string.substring(0, 6)) + string4 + string.substring(8);
        char[] cArray = string2.toCharArray();
        if (cArray == null) return string2;
        int[] nArray = IDCard.converCharToInt(cArray);
        int n = IDCard.getPowerSum(nArray);
        String string5 = IDCard.getCheckCode18(n);
        if (string5.length() <= 0) return null;
        return String.valueOf(string2) + string5;
    }

    public static boolean isIDCard(String string) {
        String string2 = string.trim();
        if (IDCard.isIDCard18(string2)) {
            return true;
        }
        if (IDCard.isIDCard15(string2)) {
            return true;
        }
        String[] stringArray = IDCard.isIDCard10(string2);
        return stringArray != null && stringArray[2].equals("true");
    }

    public static boolean isIDCard18(String string) {
        boolean bl = false;
        if (string.length() == 18) {
            int[] nArray;
            int n;
            String string2;
            char[] cArray;
            String string3 = string.substring(0, 17);
            String string4 = string.substring(17, 18);
            if (IDCard.isNum(string3) && (cArray = string3.toCharArray()) != null && (string2 = IDCard.getCheckCode18(n = IDCard.getPowerSum(nArray = IDCard.converCharToInt(cArray)))).length() > 0 && string2.equalsIgnoreCase(string4)) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isIDCard15(String string) {
        if (string.length() != 15) {
            return false;
        }
        if (IDCard.isNum(string)) {
            String string2 = string.substring(0, 2);
            if (cityCodes.get(string2) == null) {
                return false;
            }
            String string3 = string.substring(6, 12);
            Date date = null;
            try {
                date = new SimpleDateFormat("yy").parse(string3.substring(0, 2));
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            Calendar calendar = Calendar.getInstance();
            if (date != null) {
                calendar.setTime(date);
            }
            return IDCard.valiDate(calendar.get(1), Integer.valueOf(string3.substring(2, 4)), Integer.valueOf(string3.substring(4, 6)));
        }
        return false;
    }

    public static String[] isIDCard10(String string) {
        String[] stringArray = new String[3];
        String string2 = string.replaceAll("[\\(|\\)]", "");
        if (string2.length() != 8 && string2.length() != 9 && string.length() != 10) {
            return null;
        }
        if (string.matches("^[a-zA-Z][0-9]{9}$")) {
            stringArray[0] = "\u53f0\u6e7e";
            String string3 = string.substring(1, 2);
            if (string3.equals("1")) {
                stringArray[1] = "M";
            } else if (string3.equals("2")) {
                stringArray[1] = "F";
            } else {
                stringArray[1] = "N";
                stringArray[2] = "false";
                return stringArray;
            }
            stringArray[2] = IDCard.isTWCard(string) ? "true" : "false";
        } else if (string.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            stringArray[0] = "\u6fb3\u95e8";
            stringArray[1] = "N";
        } else if (string.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            stringArray[0] = "\u9999\u6e2f";
            stringArray[1] = "N";
            stringArray[2] = IDCard.isHKCard(string) ? "true" : "false";
        } else {
            return null;
        }
        return stringArray;
    }

    public static boolean isTWCard(String string) {
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 9);
        String string4 = string.substring(9, 10);
        Integer n = twFirstCode.get(string2);
        Integer n2 = n / 10 + n % 10 * 9;
        char[] cArray = string3.toCharArray();
        Integer n3 = 8;
        char[] cArray2 = cArray;
        int n4 = cArray.length;
        int n5 = 0;
        while (n5 < n4) {
            char c = cArray2[n5];
            n2 = n2 + Integer.valueOf(String.valueOf(c)) * n3;
            n3 = n3 - 1;
            ++n5;
        }
        return (n2 % 10 == 0 ? 0 : 10 - n2 % 10) == Integer.valueOf(string4);
    }

    public static boolean isHKCard(String string) {
        String string2 = string.replaceAll("[\\(|\\)]", "");
        Integer n = 0;
        if (string2.length() == 9) {
            n = (Integer.valueOf(string2.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 9 + (Integer.valueOf(string2.substring(1, 2).toUpperCase().toCharArray()[0]) - 55) * 8;
            string2 = string2.substring(1, 9);
        } else {
            n = 522 + (Integer.valueOf(string2.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 8;
        }
        String string3 = string2.substring(1, 7);
        String string4 = string2.substring(7, 8);
        char[] cArray = string3.toCharArray();
        Integer n2 = 7;
        char[] cArray2 = cArray;
        int n3 = cArray.length;
        int n4 = 0;
        while (n4 < n3) {
            char c = cArray2[n4];
            n = n + Integer.valueOf(String.valueOf(c)) * n2;
            n2 = n2 - 1;
            ++n4;
        }
        n = string4.toUpperCase().equals("A") ? Integer.valueOf(n + 10) : Integer.valueOf(n + Integer.valueOf(string4));
        return n % 11 == 0;
    }

    public static int[] converCharToInt(char[] cArray) {
        int n = cArray.length;
        int[] nArray = new int[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = Integer.parseInt(String.valueOf(cArray[n2]));
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return nArray;
    }

    public static int getPowerSum(int[] nArray) {
        int n = 0;
        if (power.length == nArray.length) {
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = 0;
                while (n3 < power.length) {
                    if (n2 == n3) {
                        n += nArray[n2] * power[n3];
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return n;
    }

    public static String getCheckCode18(int n) {
        String string = "";
        switch (n % 11) {
            case 10: {
                string = "2";
                break;
            }
            case 9: {
                string = "3";
                break;
            }
            case 8: {
                string = "4";
                break;
            }
            case 7: {
                string = "5";
                break;
            }
            case 6: {
                string = "6";
                break;
            }
            case 5: {
                string = "7";
                break;
            }
            case 4: {
                string = "8";
                break;
            }
            case 3: {
                string = "9";
                break;
            }
            case 2: {
                string = "x";
                break;
            }
            case 1: {
                string = "0";
                break;
            }
            case 0: {
                string = "1";
            }
        }
        return string;
    }

    public static int getAges(String string) {
        int n = 0;
        if (string.length() == 15) {
            string = IDCard.conver15CardTo18(string);
        }
        String string2 = string.substring(6, 10);
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        n = n2 - Integer.valueOf(string2);
        return n;
    }

    public static String getBirthDay(String string) {
        Integer n = string.length();
        if (n < 15) {
            return null;
        }
        if (n == 15) {
            string = IDCard.conver15CardTo18(string);
        }
        return string.substring(6, 14);
    }

    public static Short getYear(String string) {
        Integer n = string.length();
        if (n < 15) {
            return null;
        }
        if (n == 15) {
            string = IDCard.conver15CardTo18(string);
        }
        return Short.valueOf(string.substring(6, 10));
    }

    public static Short getMonth(String string) {
        Integer n = string.length();
        if (n < 15) {
            return null;
        }
        if (n == 15) {
            string = IDCard.conver15CardTo18(string);
        }
        return Short.valueOf(string.substring(10, 12));
    }

    public static Short getDay(String string) {
        Integer n = string.length();
        if (n < 15) {
            return null;
        }
        if (n == 15) {
            string = IDCard.conver15CardTo18(string);
        }
        return Short.valueOf(string.substring(12, 14));
    }

    public static String getGender(String string) {
        String string2;
        String string3 = "N";
        if (string.length() == 15) {
            string = IDCard.conver15CardTo18(string);
        }
        string3 = Integer.parseInt(string2 = string.substring(16, 17)) % 2 != 0 ? "M" : "F";
        return string3;
    }

    public static String getProvince(String string) {
        int n = string.length();
        String string2 = null;
        String string3 = "";
        if (n == 15 || n == 18) {
            string3 = string.substring(0, 2);
        }
        string2 = cityCodes.get(string3);
        return string2;
    }

    public static boolean isNum(String string) {
        return string == null || "".equals(string) ? false : string.matches("^[0-9]*$");
    }

    public static boolean valiDate(int n, int n2, int n3) {
        int n4;
        Calendar calendar = Calendar.getInstance();
        int n5 = calendar.get(1);
        if (n < 1930 || n >= n5) {
            return false;
        }
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        switch (n2) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n4 = 30;
                break;
            }
            case 2: {
                boolean bl = (n % 4 == 0 && n % 100 != 0 || n % 400 == 0) && n > 1930 && n < n5;
                n4 = bl ? 29 : 28;
                break;
            }
            default: {
                n4 = 31;
            }
        }
        return n3 >= 1 && n3 <= n4;
    }
}

