package demo.action;

import grapes.Dates;
import grapes.Files;
import grapes.Grapes;
import grapes.tools.Browser;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import jspgen.action.Action;

/**
 * Action类：演示
 * 
 * @author JSPGen
 * @copyright (c) JSPGen.com
 * @created 2013年03月
 * @email jspgen@163.com
 * @address www.jspgen.com
 */
public class DemoAction extends Action {
	/**
	Action文件常用方法对象：
	 获取用户端请求对象：HttpServletRequest request = getRequest();
	 获取服务端响应对象：HttpServletResponse response = getResponse();
	 获取用户端IP地址：String ip = Browser.getIP(getRequest());
	 获取用户界面表单值：String name = getParameter("name"); // 接收表单值(表单名称：name) 
	 获取当前系统时间戳：long dateline = Dates.getTimeMillis();
	 
	 向用户界面(模板)赋值：setAttribute("属性名称", 属性值); // 属性值可以是对象或具体数值
	 向用户界面直接输出：response.getWriter().write("<h2>Hello JSPGener!</h2> 这是一个  Action 演示页面…");
	 向日志文件输出：logger.info("日志输出："+ ip);
	 */
	
	/**
	 * 创建
	 */
	@Override
	protected String create() {
		// 先处理父级方法，再处理本类定义
		String result = super.create();
		if (NONE.equalsIgnoreCase(result) || ERROR.equalsIgnoreCase(result) ) return result;
		// --------------------------
		
		// 本类定义
		
		return SUCCESS;
	}
	
	/**
	 * 销毁
	 */
	@Override
	protected void destroy() {
		
		// 本类定义
		
		// --------------------------
		// 先处理本类定义，再处理父级方法
		super.destroy();
	}
	
	// -----------------------------------------------------------------------------------------
	
	/**
	 * 默认方法
	 */
	@Override
	public String execute() {
		String ip = Browser.getIP(getRequest());
		HttpServletResponse response = getResponse();
		try {
			// 资源调用
			String youIp = getMessageValue("global.access_ip", new Object[]{ ip });
			
			// 日志输出
			logger.info("日志输出："+ youIp);
			
			// 直接输出字符串
			response.getWriter().write("<h2>Hello JSPGener!</h2> 这是一个  演示Action中默认方法输出页面…");
			response.getWriter().write(" " + youIp);
			
		} catch (IOException e) {
			throw new IllegalArgumentException(e);
		}
		
		// 跳转页面(若直接输出，则跳转无用，主要与模板结合使用)
		//redirectUrl = "";
		
		return NONE;
	}
	
	/**
	 * 发送邮件
	 */
	public String mail() {
		return "mail";
	}
	
	/**
	 * 发送邮件提交
	 */
	public String mailSubmit() {
		boolean isflag = false;
		Long time = Dates.getTimeMillis();
		String to = getParameter("to"); // 接收表单值(表单名称：to)
		isflag = sendMail(to, getParameter("subject"), getParameter("content"), time); // 发送中
		if(!isflag){
			addActionError("发送失败!");
			return ERROR;
		}
		addActionMessage("发送成功!");
		return SUCCESS;
	}
	
	/**
	 * 文件上传
	 */
	public String upload() {
		return "upload";
	}
	
	/**
	 * 文件上传提交
	 */
	public String uploadSubmit() {
		List<String> files = new ArrayList<String>();
		
		// 判断是否存在文件上传
		if(isUpload()){
			String realPath = getRealPath(); // 项目根目录
			List<Map<String, Object>> list = getUploadFiles(); // 提取上传文件
			if(Grapes.isNotEmpty(list)){
				boolean isflag = false;
				long dateline, srcLength;
				String srcPath, srcName, srcExte, outPath, outRealPath;
				File file;
				for(Map<String, Object> map : list){
					if(Grapes.isEmpty(map)) continue;
					
					srcName = (String) map.get("originalname");	// 文件原名
					file = (File) map.get("file"); 				// 临时文件对象
					srcPath = Files.format(file.getPath());		// 临时文件地址(格式化文件路径，必须要保持格式统一)
					srcExte = Files.getExte(file.getName());	// 临时文件扩展名(无圆点)
					srcLength = file.length();					// 临时文件大小
					dateline = Dates.getTimeMillis();			// 上传时间戳
					
					// 是否符合允许大小
					if(srcLength > Files.getFileSizeByte("2m")) {
						logger.error("The file upload size limit[originalname:"+srcName+" limitSize:2M]");
						continue;
					}
					// 是否符合允许类型
					if(".txt.jpg.gif".indexOf("."+srcExte) == -1) {
						logger.error("The file upload type error[originalname:"+srcName+" alloweType: .txt.jpg.gif]");
						continue;
					}
					
					// 复制文件
					outPath = "/upload/" + dateline + "." + srcExte;
					outRealPath = realPath + outPath;
					isflag = Files.copyFile(srcPath, outRealPath);
					if(!isflag) {
						// 上传失败: 目标路径不可写
						logger.error(getMessageValue("global.upload_error") + " File:" + outRealPath);
						continue;
					}
					
					// 上传成功
					logger.info(getMessageValue("global.upload_success") + " File:" + outPath);
					files.add(outPath);	// 收集上传资料
				}
			}
		}
		
		// 输出(给页面模板传值)
		setAttribute("files", files);
		
		return LIST;
	}
	
	/**
	 * 文件下载 (服务端)
	 */
	public String download() {
		URL url;
		try {
			url = new URL("http://www.xxx.com/file/0223.pdf");	// 创建URL对象
			// System.out.println("url: "+url.toString());
			
			logger.info("开始下载…"); 
			file(url, "说明.pdf", "key");
			logger.info("下载完成，保存在：" + getDownloadUri() + "目录下."); 
			
		} catch (MalformedURLException e) {
			addActionError(e.getMessage());	// e.printStackTrace();
			return ERROR;
		}
		
		addActionMessage("下载完成，保存在：" + getDownloadUri() + "目录下.");
		return SUCCESS;
	}
}