﻿/*!
 * 前端常用工具包
 * @copyright (c) JSPGen.com
 * @version 4.0
 */

// 浏览器属性
var browser = {};
var browserVersion;
browser.useragent = navigator.userAgent;
browser.language = (navigator.browserLanguage || navigator.language); // zh-cn

// 判断浏览器	
(browserVersion = ((browser.useragent).toLowerCase()).match(/msie ([\d.]+)/)) ? browser.ie = browserVersion[1] :
(browserVersion = ((browser.useragent).toLowerCase()).match(/firefox\/([\d.]+)/)) ? browser.firefox = browserVersion[1] :
(browserVersion = ((browser.useragent).toLowerCase()).match(/chrome\/([\d.]+)/)) ? browser.chrome = browserVersion[1] :
(browserVersion = ((browser.useragent).toLowerCase()).match(/opera.([\d.]+)/)) ? browser.opera = browserVersion[1] :
(browserVersion = ((browser.useragent).toLowerCase()).match(/version\/([\d.]+).*safari/)) ? browser.safari = browserVersion[1] : 0;

// 浏览器判断
// if(browser.ie) 或 if(browser.firefox)
// 浏览器版本获取
// if(browser.ie == '8.0') 或 if(browser.firefox == '3.0')

// 判断移动端
browser.gecko = (((browser.useragent).toLowerCase()).indexOf('gecko') > -1 && ((browser.useragent).toLowerCase()).indexOf('khtml') == -1); 				// 火狐内核
browser.mobile = (!!((browser.useragent).toLowerCase()).match(/applewebkit.*mobile.*/) || !!((browser.useragent).toLowerCase()).match(/applewebkit/)); 	// 是否为移动终端
browser.ios = (!!((browser.useragent).toLowerCase()).match(/\(i[^;]+;( U;)? cpu.+mac os x/));  															// iOS终端
browser.android = (((browser.useragent).toLowerCase()).indexOf('android') > -1 || ((browser.useragent).toLowerCase()).indexOf('linux') > -1);			// android终端或uc浏览器
browser.iphone = (((browser.useragent).toLowerCase()).indexOf('iphone') > -1 || ((browser.useragent).toLowerCase()).indexOf('mac') > -1); 				// iPhone终端或QQHD浏览器
browser.ipad = (((browser.useragent).toLowerCase()).indexOf('ipad') > -1); 																				// iPad终端
browser.webApp = (((browser.useragent).toLowerCase()).indexOf('safari') == -1); 																		// web应该程序，没有头部与底部

/**
 * 常用工具包
 */
var jspgen = {
	/**
 	 * Cookie操作
	 */
	'setCookie':function(name, value){	// name, value, expire, domain 自适应4参数
		var expires = (arguments.length > 2) ? arguments[2] : null;
		var domain = (arguments.length > 3) ? arguments[3] : null;
		document.cookie = name + '=' + encodeURIComponent(value) + ((expires == null) ? '' : ('; expires=' + expires.toGMTString())) + ';path=' + ((domain == null) ? '/' : domain);
	}
	,'getCookie':function(name) {
		var value = document.cookie.match(new RegExp('(^| )' + name + '=([^;]*)(;|$)'));
		if (value != null) {
			return decodeURIComponent(value[2]);
    	} else {
			return null;
		}
	}
	,'removeCookie':function(name) {
		var expires = new Date();
		expires.setTime(expires.getTime() - 1000 * 60);
		jspgen.setCookie(name, '', expires);
	}
	
	/**
 	 * 数据操作(浮点数运算对应Java中的BigDecimal运算)
	 */
	 // 数据共享
	,'setShare':function(name, value){
		var top = window.top, cache = top['_CACHE'] || {};	top['_CACHE'] = cache;
		cache[name] = value;	return ;
		// return value !== undefined ? cache[name] = value : cache[name];
	}
	,'getShare':function(name){
		var top = window.top, cache = top['_CACHE'] || {};	top['_CACHE'] = cache;
		return cache[name];
	}
	,'removeShare':function (name) {
		var cache = window.top['_CACHE'];
		if (cache && cache[name]) delete cache[name];	return ;
	}
	// 获取随机数
	,'random':function(mi, ma){
		var range = ma - mi;
		var rand = Math.random();
		return (mi + Math.round(rand * range));
	} 
	// 对数运算
	,'log':function(arg1, arg2){
		var arg = (Math.log(arg2))/(Math.log(arg1));
		return Math.round(10000000000000*arg)/10000000000000;
	}
	 // 浮点数加法运算
	,'floatAdd':function(arg1, arg2){
		var r1, r2, m;
		try{
			r1 = arg1.toString().split('.')[1].length;
		} catch(e) {
			r1 = 0;
		}
		try {
			r2 = arg2.toString().split('.')[1].length;
		} catch(e) {
			r2 = 0;
		}
		m = Math.pow(10, Math.max(r1, r2));
		return (arg1 * m + arg2 * m) / m;
	}
	// 浮点数减法运算
	,'floatSub':function(arg1, arg2) {
		var r1, r2, m, n;
		try {
			r1 = arg1.toString().split('.')[1].length;
		} catch(e) {
			r1 = 0
		}
		try {
			r2 = arg2.toString().split('.')[1].length;
		} catch(e) {
			r2 = 0
		}
		m = Math.pow(10, Math.max(r1, r2));
		n = (r1 >= r2) ? r1 : r2;
		return ((arg1 * m - arg2 * m) / m).toFixed(n);
	}
	// 浮点数乘法运算
	,'floatMul':function(arg1, arg2) {
		var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
		try {
			m += s1.split('.')[1].length;
		} catch(e) {}
		try {
			m += s2.split('.')[1].length;
		} catch(e) {}
		return Number(s1.replace('.', '')) * Number(s2.replace('.', '')) / Math.pow(10, m);
	}
	// 浮点数除法运算
	,'floatDiv':function(arg1, arg2) {
		var t1 = 0, t2 = 0, r1, r2;    
		try {
			t1 = arg1.toString().split('.')[1].length;
		} catch(e) {}
		try {
			t2 = arg2.toString().split('.')[1].length;
		} catch(e) {}
		with(Math) {
			r1 = Number(arg1.toString().replace('.', ''));
			r2 = Number(arg2.toString().replace('.', ''));
			return (r1 / r2) * pow(10, t2 - t1);
		}
	}
	// 设置数值精度
	,'scale':function(value, scale, roundType) {
		var price;
		if (roundType == 'roundHalfUp') {
			price = (Math.round(value * Math.pow(10, scale)) / Math.pow(10, scale)).toFixed(scale);
		} else if (roundType == 'roundUp') {
			price = (Math.ceil(value * Math.pow(10, scale)) / Math.pow(10, scale)).toFixed(scale);
		} else {
			price = (Math.floor(value * Math.pow(10, scale)) / Math.pow(10, scale)).toFixed(scale);
		}
		return price;
	}
	
	/**
	 * 表单操作
	 */
	// 全选/全不选
	,'check':function(e, name){
		$('input[name="'+name+'"]').prop('checked', $(e).prop('checked'));
	}
	// 全选*/
	,'checkAll':function(name){
		$('input[name="'+name+'"]').prop('checked', true);
	},
	// 反选*/
	'recheck':function(name){
		$('input[name="'+name+'"]').each(function() { 
			this.checked = !this.checked;
        });
	}
	// 全不选*/
	,'uncheck':function(name){
		$('input[name="'+name+'"]').prop('checked', false);
	}
	// 获取单选框 多选框的值*/
	,'values':function(name, separator){
		var val = '';
		$('input[name="'+name+'"]').filter(':checked').each(function(){
			// window.alert(this.value);
			val += (val == '' ? this.value : separator + this.value);
        });
		// window.alert(this.val);
		return val;	
    }
	// 检查表单的一组选项是否已经有一个被选中 name选项对象
    ,'checked':function(name){
		$('input[name="'+name+'"]').each(function() { 
			if(this.checked)	return true;
        });
        return false;
    }
	// 某值是否属于数组元素
	,'inArray':function(value, arr){
		// 确定第一个参数在数组中的位置，从0开始计数(如果没有找到则返回 -1)
    	if($.inArray(value ,arr) == -1)	return false;
    	return true;
	}
	
	/**
 	 * 常用方法
	 */
	,'trim':function(str){
		return str.replace(/(^\s*)|(\s*$)/g,'');
	}
	// 一个中文两个字节
	,'length':function(str){
		return str.replace(/[^\x00-\xff]/g,'**').length;
	}
	// 获取文件扩展名*/
	,'exte':function(filename){
		var temp = filename.split('.');
		return temp[temp.length-1].toLowerCase();
	}
	// 将文本换行符转为html换行符
	,'nrbr':function(str){
		return str.replace(/\n|\r|(\r\n)|(\u0085)|(\u2028)|(\u2029)/g, '<br/>');
	}
	// 将html换行符转为文本换行符
	,'brnr':function(str){
		return str.replace(/(<br>|<br >|<br\/>|<br \/>)/g, '\r\n');
	}
	// 获取当前页地址栏地址
	,'text':function(str, isflag){
		str = str.replace(/<\/?[^>]*>/g,''); 				 // 去除htmlTag
		str = str.replace(/[ | ]*\n/g,'\n'); 				 // 去除行尾空白
		if(isflag) str = str.replace(/\n[\s| | ]*\r/g,'\n'); // 去除多余空行
		str=str.replace(/\u3000| |null|&nbsp;/ig,'');		 // 中文、英文、null、字符空格
		return str;
	}
	// 获取当前页地址栏地址
	,'location':function(){
		return window.location;
	}
	// 获取地址栏参数
	,'param':function(name){	// name, url
		var value;
		var url = (arguments.length > 1) ? arguments[1] : null;
		var params = ((url == null) ? document.location : url).search.match(new RegExp('[\?\&]'+name+'=([^\&]*)(\&?)','i'));
		value = params ? params[1] : params;
		return decodeURIComponent(value); // encodeURIComponent()
	}
	// 获取地址栏所有参数集合(对象)
	,'params':function(){	// url
		var params = new Object();
		var url = (arguments.length > 0) ? arguments[0] : null;
		var query = ((url == null) ? document.location : url).search.substring(1);
		var param = query.split('&');
		for(var i=0; i<param.length; i++) {   
			var pos = param[i].indexOf('=');
			if(pos == -1) continue;
			var name = param[i].substring(0, pos);
			var value = param[i].substring(pos+1);
			params[name] = decodeURIComponent(value);
		}
		return pares;
	}
	// CSS或JS文件加载
	,'load':function (file){
		// jspgen.load(['js/jquery.js', 'css/css.css']);
		var files = typeof file == 'string' ? [file] : file;
        for(var i=0; i<files.length; i++){
            var name = files[i].replace(/^\s|\s$/g, '');
            var ext = jspgen.exte(name);
            var isCSS = ext == 'css';
            var tag = isCSS ? 'link' : 'script';
            var attr = isCSS ? ' type=\'text\/css\' rel=\'stylesheet\' ' : ' type=\'text\/javascript\"';
            var links = (isCSS ? 'href' : 'src') + '=\"' + name + '\"';
            if ($(tag + '[' + links + ']').length == 0) document.write('<' + tag + attr + links + '><\/' + tag + '>');
        }
	}
	// 截取固定长度字符串:中文2字节,英文1字
	,'substring':function (str, len, postfix) {
		if(!str) return '';
		var a=0, i=0;	// 循环计数
		var temp = '';	// 临时字串
		for (i=0; i<str.length; i++) {
			if (str.charCodeAt(i)>255) {
				a+=2;	// 按照预期计数增加2
			}else{
				a++;
			}
			if(a>len) return temp+postfix;	// 直接返回临时字符串
			temp += str.charAt(i);			// 将当前内容加到临时字符串
		}
		// 返回源字符串
		return str;
	}
	// 返回
	,'go':function(i) {
		window.history.go(i);	// go(-1) // 后退  go(1) // 前进
	}
	// 后退
	,'back':function() {
		window.history.back();
	}
	// 向前
	,'forward':function() {
		window.history.forward();
	}
	// 刷新
	,'reload':function(){
		window.location.reload();
	}
	// 加入收藏夹
	,'addFavorite':function (title, url){
		var ctrl = (((browser.useragent).toLowerCase()).indexOf('mac') > -1) ? 'Command/Cmd': 'Ctrl';
		if(!url) url = jspgen.location();
		if(browser.ie){
			window.external.addFavorite(url, title);
		}else if(browser.firefox){
			window.sidebar.addPanel(title, url,''); 
		}else{
			alert('此操作被浏览器拒绝！请在键盘 '+ ctrl +'+D 来操作…');
		}
		return true;
	}
	// 设为主页
	,'setHomepage':function (url){
		if(!url) url = jspgen.location();
		if(browser.ie){
			document.body.style.behavior='url(#default#homepage)';
			document.body.setHomePage(url);
		}else if(browser.firefox){
			if(window.netscape){
				try{
					netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect'); // 解决执行命令的问题
					alert('操作成功');
				}catch(e){
					alert('此操作被浏览器拒绝！请在浏览器地址栏输入 about:config 并回车\n然后将 [signed.applets.codebase_principal_support] 设置为 true');
					return false;
				}
			}
			var charPref = Components.classes['@mozilla.org/preferences-service;1'].getService(Components. interfaces.nsIPrefBranch); 
			charPref.setCharPref('browser.startup.homepage', url);
		}
		return true;
	}
	// 复制内容
	,'copyText':function (str){
		if(browser.ie){
		// if(window.clipboardData){
			window.clipboardData.clearData();   
        	window.clipboardData.setData('Text', str);
			alert('操作成功');
		}else if(browser.firefox){
			if(window.netscape){
				try{
					netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect'); // 解决执行命令的问题
					alert('操作成功');
				}catch(e){
					alert('此操作被浏览器拒绝！请在浏览器地址栏输入 about:config 并回车\n然后将 [signed.applets.codebase_principal_support] 设置为 true');
					return false;
				}
			}
			var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);   
        	if(!clip) return;   
        	var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);   
        	if(!trans) return;   
        	trans.addDataFlavor('text/unicode');
			var text = Components.classes['@mozilla.org/supports-string;1'].createInstance(Components.interfaces.nsISupportsString);    
        	text.data = str;
        	trans.setTransferData('text/unicode', text, str.length*2);
        	var clipId = Components.interfaces.nsIClipboard;
        	clip.setData(trans, null, clipId.kGlobalClipboard);
		}
		return true;
	}
	
	/**
 	 * 常用判断
	 */
	,'isEmpty':function(str){
		if(str == null || str == 'null' || str == '' || str == '') return true;
		return new RegExp('^[ ]+$').test(str); 
	}
	,'isNotEmpty':function(str){
		return !jspgen.isEmpty(str); 
	}
	// 是否是数字
	,'isNumber':function(str){
		if(jspgen.isEmpty(str))	return false;
    	return (/[\d|\.|,]+/).test(str);
	}
	// 是否是正整数
	,'isDigits':function(str){
		if(jspgen.isEmpty(str))	return false;
    	return (/\d+/).test(str);
	}
	,'isDoubleByte':function(str){
		if(jspgen.isEmpty(str))	return false;
		var result = str.match(/[\x00-\xff]/);
		if(result == null) return false;
		return true;
	}
	,'isChinese':function(str){
		if(jspgen.isEmpty(str))	return false;
		var result = str.match(/[\u4e00-\u9fa5]/);
		if(result == null) return false;
		return true;
	}
	,'isEnglish':function(str){
		if(jspgen.isEmpty(str))	return false;
		var result = str.match(/[a-zA-Z]/);
		if(result == null) return false;
		return true;
	}
	// 是否是字母加数字或者下划线，长度为3-20字节
	,'isUsername':function (str){
		if(jspgen.isEmpty(str))	return false;
		var result = str.match(/^[a-zA-Z]{1}[a-zA-Z0-9_]{2,19}$/);
		if(result == null) return false;
		return true;
	}
	,'isEmail':function(str){
		if(jspgen.isEmpty(str))	return false;
    	var reg = /\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/;
    	return reg.test(str);
	}
	,'isDate':function (str){
		if(jspgen.isEmpty(str))	return false;
   		var result = str.match(/^(\d{4})(-|\/)(\d{1,2})\2(\d{1,2})$/);
   		if(result == null) return false;
   		var d = new Date(result[1], result[3]-1, result[4]);
   		return (d.getFullYear() == result[1] && d.getMonth()+1 == result[3] && d.getDate() == result[4]);
	}
	,'isDateTime':function(str){
		if(jspgen.isEmpty(str))	return false;
		var result = str.match(/^(\d{4})(-|\/)(\d{1,2})\2(\d{1,2}) (\d{1,2}):(\d{1,2}):(\d{1,2})$/);
		if(result == null) return false;
		var d = new Date(result[1], result[3]-1, result[4], result[5], result[6], result[7]);
		return (d.getFullYear() == result[1] && (d.getMonth()+1) == result[3]&&d.getDate() == result[4] && d.getHours() == result[5] && d.getMinutes() == result[6] && d.getSeconds() == result[7]);
	}
	,'isIP':function(str){
		if(jspgen.isEmpty(str))	return false;
		var reg = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/g;// 匹配IP地址的正则表达式
		if(reg.test(str)){ 
			if( RegExp.$1<256 && RegExp.$2<256 && RegExp.$3<256 && RegExp.$4<256) return true; 
		} 
		return false; 
	}
	,'isMobile':function(str){
		if(jspgen.isEmpty(str))	return false;
		var reg = /^(((13[0-9]{1})|(15[0-3,4-9]{1})|(18[0,5-9]{1}))+\d{8})$/g;
		// 130 131 132 133 134 135 136 137 138 139 150 158 159 180 188
		if(new RegExp(reg).test(str)){ 
			return true; 
		}else{ 
			return false; 
		} 
	}
	// 
};